/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.internal.wizards.datatransfer.FileSystemExporter;

public class FileSystemExportOperation
implements IRunnableWithProgress {
    private IPath path;
    private IProgressMonitor monitor;
    private FileSystemExporter exporter = new FileSystemExporter();
    private List<IResource> resourcesToExport;
    private IOverwriteQuery overwriteCallback;
    private IResource resource;
    private List<IStatus> errorTable = new ArrayList<IStatus>(1);
    private static final int OVERWRITE_NOT_SET = 0;
    private static final int OVERWRITE_NONE = 1;
    private static final int OVERWRITE_ALL = 2;
    private int overwriteState = 0;
    private boolean createLeadupStructure = true;
    private boolean createContainerDirectories = true;
    private boolean resolveLinks = false;

    public FileSystemExportOperation(IResource res, String destinationPath, IOverwriteQuery overwriteImplementor) {
        this.resource = res;
        this.path = IPath.fromOSString((String)destinationPath);
        this.overwriteCallback = overwriteImplementor;
    }

    public FileSystemExportOperation(IResource res, List resources, String destinationPath, IOverwriteQuery overwriteImplementor) {
        this(res, destinationPath, overwriteImplementor);
        this.resourcesToExport = resources;
    }

    protected int countChildrenOf(IResource parentResource) throws CoreException {
        if (parentResource.getType() == 1) {
            return 1;
        }
        int count = 0;
        if (parentResource.isAccessible()) {
            IResource[] iResourceArray = ((IContainer)parentResource).members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource child = iResourceArray[n2];
                count += this.countChildrenOf(child);
                ++n2;
            }
        }
        return count;
    }

    protected int countSelectedResources() throws CoreException {
        int result = 0;
        Iterator<IResource> resources = this.resourcesToExport.iterator();
        while (resources.hasNext()) {
            result += this.countChildrenOf(resources.next());
        }
        return result;
    }

    protected void createLeadupDirectoriesFor(IResource childResource) {
        IPath resourcePath = childResource.getFullPath().removeLastSegments(1);
        int i = 0;
        while (i < resourcePath.segmentCount()) {
            this.path = this.path.append(resourcePath.segment(i));
            this.exporter.createFolder(this.path);
            ++i;
        }
    }

    protected void exportAllResources() throws InterruptedException {
        if (this.resource.getType() == 1) {
            this.exportFile((IFile)this.resource, this.path);
        } else {
            try {
                this.exportChildren(((IContainer)this.resource).members(), this.path);
            }
            catch (CoreException e) {
                this.errorTable.add(e.getStatus());
            }
        }
    }

    protected void exportChildren(IResource[] children, IPath currentPath) throws InterruptedException {
        IResource[] iResourceArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IResource child = iResourceArray[n2];
            if (child.isAccessible() && (this.resolveLinks || !child.isLinked())) {
                if (child.getType() == 1) {
                    this.exportFile((IFile)child, currentPath);
                } else {
                    IPath destination = currentPath.append(child.getName());
                    this.exporter.createFolder(destination);
                    try {
                        this.exportChildren(((IContainer)child).members(), destination);
                    }
                    catch (CoreException e) {
                        this.errorTable.add(e.getStatus());
                    }
                }
            }
            ++n2;
        }
    }

    protected void exportFile(IFile file, IPath location) throws InterruptedException {
        IPath fullPath = location.append(file.getName());
        this.monitor.subTask(file.getFullPath().toString());
        String properPathString = fullPath.toOSString();
        File targetFile = new File(properPathString);
        if (targetFile.exists()) {
            if (!targetFile.canWrite()) {
                this.errorTable.add((IStatus)new Status(4, "org.eclipse.ui", 0, NLS.bind((String)DataTransferMessages.DataTransfer_cannotOverwrite, (Object)targetFile.getAbsolutePath()), null));
                this.monitor.worked(1);
                return;
            }
            if (this.overwriteState == 1) {
                return;
            }
            if (this.overwriteState != 2) {
                String overwriteAnswer = this.overwriteCallback.queryOverwrite(properPathString);
                if (overwriteAnswer.equals("CANCEL")) {
                    throw new InterruptedException();
                }
                if (overwriteAnswer.equals("NO")) {
                    this.monitor.worked(1);
                    return;
                }
                if (overwriteAnswer.equals("NOALL")) {
                    this.monitor.worked(1);
                    this.overwriteState = 1;
                    return;
                }
                if (overwriteAnswer.equals("ALL")) {
                    this.overwriteState = 2;
                }
            }
        }
        try {
            this.exporter.write((IResource)file, fullPath);
        }
        catch (IOException | CoreException e) {
            this.errorTable.add((IStatus)new Status(4, "org.eclipse.ui", 0, NLS.bind((String)DataTransferMessages.DataTransfer_errorExporting, (Object)fullPath, (Object)e.getMessage()), e));
        }
        this.monitor.worked(1);
        ModalContext.checkCanceled((IProgressMonitor)this.monitor);
    }

    protected void exportSpecifiedResources() throws InterruptedException {
        Iterator<IResource> resources = this.resourcesToExport.iterator();
        IPath initPath = (IPath)this.path.clone();
        while (resources.hasNext()) {
            IResource currentResource = resources.next();
            if (!currentResource.isAccessible() || !this.resolveLinks && currentResource.isLinked()) continue;
            this.path = initPath;
            if (this.resource == null) {
                if (this.createLeadupStructure) {
                    this.createLeadupDirectoriesFor(currentResource);
                }
            } else {
                IPath containersToCreate = currentResource.getFullPath().removeFirstSegments(this.resource.getFullPath().segmentCount()).removeLastSegments(1);
                int i = 0;
                while (i < containersToCreate.segmentCount()) {
                    this.path = this.path.append(containersToCreate.segment(i));
                    this.exporter.createFolder(this.path);
                    ++i;
                }
            }
            if (currentResource.getType() == 1) {
                this.exportFile((IFile)currentResource, this.path);
                continue;
            }
            if (this.createContainerDirectories) {
                this.path = this.path.append(currentResource.getName());
                this.exporter.createFolder(this.path);
            }
            try {
                this.exportChildren(((IContainer)currentResource).members(), this.path);
            }
            catch (CoreException e) {
                this.errorTable.add(e.getStatus());
            }
        }
    }

    public IStatus getStatus() {
        IStatus[] errors = new IStatus[this.errorTable.size()];
        this.errorTable.toArray(errors);
        return new MultiStatus("org.eclipse.ui", 0, errors, DataTransferMessages.FileSystemExportOperation_problemsExporting, null);
    }

    protected boolean isDescendent(List resources, IResource child) {
        if (child.getType() == 4) {
            return false;
        }
        IContainer parent = child.getParent();
        if (resources.contains(parent)) {
            return true;
        }
        return this.isDescendent(resources, (IResource)parent);
    }

    public void run(IProgressMonitor progressMonitor) throws InterruptedException {
        this.monitor = progressMonitor;
        if (this.resource != null) {
            if (this.createLeadupStructure) {
                this.createLeadupDirectoriesFor(this.resource);
            }
            if (this.createContainerDirectories && this.resource.getType() != 1) {
                this.path = this.path.append(this.resource.getName());
                this.exporter.createFolder(this.path);
            }
        }
        try {
            int totalWork = -1;
            try {
                totalWork = this.resourcesToExport == null ? this.countChildrenOf(this.resource) : this.countSelectedResources();
            }
            catch (CoreException e) {
                this.errorTable.add(e.getStatus());
            }
            this.monitor.beginTask(DataTransferMessages.DataTransfer_exportingTitle, totalWork);
            if (this.resourcesToExport == null) {
                this.exportAllResources();
            } else {
                this.exportSpecifiedResources();
            }
        }
        finally {
            this.monitor.done();
        }
    }

    public void setCreateContainerDirectories(boolean value) {
        this.createContainerDirectories = value;
    }

    public void setCreateLeadupStructure(boolean value) {
        this.createLeadupStructure = value;
    }

    public void setOverwriteFiles(boolean value) {
        if (value) {
            this.overwriteState = 2;
        }
    }

    public void setResolveLinks(boolean value) {
        this.resolveLinks = value;
    }
}

