/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.option;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.utils.ZapLabel;
import org.zaproxy.zap.utils.ZapTextField;
import org.zaproxy.zap.view.LayoutHelper;
import org.zaproxy.zap.view.renderer.SizeBytesStringValue;

public class OptionsJvmPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = -7541236934312940852L;
    private static final Path JVM_PROPERTIES_FILE = Paths.get(Constant.getDefaultHomeDirectory(false), ".ZAP_JVM.properties");
    private static final String NAME = Constant.messages.getString("jvm.options.title");
    private static final SizeBytesStringValue sbsv = new SizeBytesStringValue(false);
    private ZapTextField jvmOptionsField = null;
    private ZapLabel sizeMemoryLabel = null;
    private ZapLabel usedMemoryLabel = null;
    private ZapLabel maxMemoryLabel = null;

    public OptionsJvmPanel() {
        this.setName(NAME);
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        int row = 0;
        JLabel jvmOptionsLabel = new JLabel(Constant.messages.getString("jvm.options.label.jvmoptions"));
        jvmOptionsLabel.setLabelFor(this.getJvmOptionsField());
        panel.add((Component)jvmOptionsLabel, LayoutHelper.getGBC(0, row, 1, 2.0));
        panel.add((Component)this.getJvmOptionsField(), LayoutHelper.getGBC(1, row, 1, 8.0));
        panel.add((Component)new JLabel(Constant.messages.getString("jvm.options.warning.restart")), LayoutHelper.getGBC(0, ++row, 2, 1.0));
        panel.add((Component)new JSeparator(0), LayoutHelper.getGBC(0, ++row, 2, 0.0, 0.0));
        panel.add((Component)this.getSizeMemoryLabel(), LayoutHelper.getGBC(0, ++row, 2, 1.0));
        panel.add((Component)this.getUsedMemoryLabel(), LayoutHelper.getGBC(0, ++row, 2, 1.0));
        panel.add((Component)this.getMaxMemoryLabel(), LayoutHelper.getGBC(0, ++row, 2, 1.0));
        panel.add((Component)new JLabel(), LayoutHelper.getGBC(0, 10, 1, 0.5, 1.0));
        this.add(panel);
    }

    private ZapTextField getJvmOptionsField() {
        if (this.jvmOptionsField == null) {
            this.jvmOptionsField = new ZapTextField();
        }
        return this.jvmOptionsField;
    }

    private ZapLabel getSizeMemoryLabel() {
        if (this.sizeMemoryLabel == null) {
            this.sizeMemoryLabel = new ZapLabel();
        }
        return this.sizeMemoryLabel;
    }

    private ZapLabel getUsedMemoryLabel() {
        if (this.usedMemoryLabel == null) {
            this.usedMemoryLabel = new ZapLabel();
        }
        return this.usedMemoryLabel;
    }

    private ZapLabel getMaxMemoryLabel() {
        if (this.maxMemoryLabel == null) {
            this.maxMemoryLabel = new ZapLabel();
        }
        return this.maxMemoryLabel;
    }

    private void updateMemoryLabel(ZapLabel labelToUpdate, String key, long value) {
        labelToUpdate.setText(Constant.messages.getString(key, sbsv.getString(value)));
    }

    @Override
    public void initParam(Object obj) {
        long size = Runtime.getRuntime().totalMemory();
        this.updateMemoryLabel(this.getSizeMemoryLabel(), "jvm.options.memory.size", size);
        this.updateMemoryLabel(this.getUsedMemoryLabel(), "jvm.options.memory.used", size - Runtime.getRuntime().freeMemory());
        this.updateMemoryLabel(this.getMaxMemoryLabel(), "jvm.options.memory.max", Runtime.getRuntime().maxMemory());
        try {
            List<String> lines;
            if (Files.exists(JVM_PROPERTIES_FILE, new LinkOption[0]) && (lines = Files.readAllLines(JVM_PROPERTIES_FILE, StandardCharsets.UTF_8)).size() > 0) {
                this.getJvmOptionsField().setText(lines.get(0));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void reset() {
        this.getJvmOptionsField().setText("");
        this.saveJvmFile();
    }

    @Override
    public void saveParam(Object obj) throws Exception {
        this.saveJvmFile();
    }

    private void saveJvmFile() {
        try {
            String opts = this.getJvmOptionsField().getText();
            if (opts.length() == 0) {
                Files.deleteIfExists(JVM_PROPERTIES_FILE);
            } else {
                if (!JVM_PROPERTIES_FILE.getParent().toFile().exists()) {
                    JVM_PROPERTIES_FILE.getParent().toFile().mkdirs();
                }
                Files.write(JVM_PROPERTIES_FILE, opts.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
        }
        catch (IOException e) {
            View.getSingleton().showWarningDialog((JPanel)this, Constant.messages.getString("jvm.options.error.writing", JVM_PROPERTIES_FILE.toAbsolutePath(), e.getMessage()));
        }
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.jvm";
    }
}

