/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.request.GenericSolrRequest;
import org.apache.solr.client.solrj.response.SimpleSolrResponse;
import org.apache.solr.common.NavigableObject;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.NodesSysProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;

public class NodesSysPropsCacher
implements NodesSysProps,
AutoCloseable {
    private volatile boolean isClosed = false;
    private final Map<String, Map<String, Object>> nodeVsTagsCache = new ConcurrentHashMap<String, Map<String, Object>>();
    private ZkStateReader zkStateReader;
    private final Http2SolrClient solrClient;

    public NodesSysPropsCacher(Http2SolrClient solrClient, ZkStateReader zkStateReader) {
        this.zkStateReader = zkStateReader;
        this.solrClient = solrClient;
        zkStateReader.registerLiveNodesListener((oldNodes, newNodes) -> {
            for (String n : oldNodes) {
                if (newNodes.contains(n)) continue;
                this.nodeVsTagsCache.remove(n);
            }
            return this.isClosed;
        });
    }

    public Map<String, Object> getSysProps(String nodeName, Collection<String> tags) {
        LinkedHashMap<String, Object> cached = this.nodeVsTagsCache.computeIfAbsent(nodeName, s -> new LinkedHashMap());
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (String tag : tags) {
            if (!cached.containsKey(tag)) {
                Map<String, Object> props = this.fetchProps(nodeName, tags);
                cached = new LinkedHashMap<String, Object>(cached);
                cached.putAll(props);
                this.nodeVsTagsCache.put(nodeName, cached);
                return props;
            }
            result.put(tag, cached.get(tag));
        }
        return result;
    }

    private Map<String, Object> fetchProps(String nodeName, Collection<String> tags) {
        ModifiableSolrParams msp = new ModifiableSolrParams();
        msp.add("omitHeader", new String[]{"true"});
        LinkedHashMap<String, Object> keys = new LinkedHashMap<String, Object>();
        for (String tag2 : tags) {
            String metricsKey = "solr.jvm:system.properties:" + tag2;
            keys.put(tag2, metricsKey);
            msp.add("key", new String[]{metricsKey});
        }
        GenericSolrRequest req = new GenericSolrRequest(SolrRequest.METHOD.GET, "/admin/metrics", (SolrParams)msp);
        try {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            NamedList response = ((SimpleSolrResponse)this.solrClient.requestWithBaseUrl(this.zkStateReader.getBaseUrlForNodeName(nodeName), null, (SolrRequest)req)).getResponse();
            NavigableObject metrics = NavigableObject.wrap((Object)response._get("metrics"));
            keys.forEach((tag, key) -> result.put((String)tag, metrics._get(key)));
            return result;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    @Override
    public void close() {
        this.isClosed = true;
    }
}

