/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.search.CancellableCollector;

public class QueryCancellationComponent
extends SearchComponent {
    public static final String COMPONENT_NAME = "querycancellation";
    private boolean shouldProcess;

    @Override
    public void prepare(ResponseBuilder rb) throws IOException {
        if (rb.isCancellation()) {
            this.shouldProcess = true;
        }
    }

    @Override
    public void process(ResponseBuilder rb) {
        if (!this.shouldProcess) {
            return;
        }
        String cancellationUUID = rb.getCancellationUUID();
        if (cancellationUUID == null) {
            throw new RuntimeException("Null query UUID seen");
        }
        CancellableCollector cancellableTask = rb.req.getCore().getCancellableQueryTracker().getCancellableTask(cancellationUUID);
        if (cancellableTask != null) {
            cancellableTask.cancel();
            rb.rsp.add("cancellationResult", "success");
        } else {
            rb.rsp.add("cancellationResult", "not found");
        }
    }

    @Override
    public void handleResponses(ResponseBuilder rb, ShardRequest sreq) {
        if (!this.shouldProcess) {
            return;
        }
        boolean queryFound = false;
        for (ShardResponse r : sreq.responses) {
            String cancellationResult = (String)r.getSolrResponse().getResponse().get("cancellationResult");
            if (!cancellationResult.equalsIgnoreCase("success")) continue;
            queryFound = true;
            break;
        }
        if (queryFound) {
            rb.rsp.getValues().add("status", (Object)("Query with queryID " + rb.getCancellationUUID() + " cancelled successfully"));
            rb.rsp.getValues().add("responseCode", (Object)200);
        } else {
            rb.rsp.getValues().add("status", (Object)("Query with queryID " + rb.getCancellationUUID() + " not found"));
            rb.rsp.getValues().add("responseCode", (Object)404);
        }
    }

    @Override
    public String getDescription() {
        return "Supports cancellation of queries which are cancellable";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.OTHER;
    }
}

