/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.util.Arrays;
import java.util.List;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.DisjointExtentException;
import org.apache.sis.coverage.grid.GridClippingMode;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridDerivation;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.GridRoundingMode;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.storage.AbstractGridCoverageResource;
import org.apache.sis.storage.CoverageQuery;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreReferencingException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.NoSuchDataException;
import org.apache.sis.storage.RasterLoadingStrategy;
import org.apache.sis.storage.event.StoreListeners;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

final class CoverageSubset
extends AbstractGridCoverageResource {
    private final GridCoverageResource source;
    private final CoverageQuery query;

    CoverageSubset(GridCoverageResource gridCoverageResource, CoverageQuery coverageQuery) {
        super(gridCoverageResource instanceof StoreListeners ? (StoreListeners)((Object)gridCoverageResource) : null, false);
        this.source = gridCoverageResource;
        this.query = coverageQuery;
    }

    @Override
    public GridGeometry getGridGeometry() throws DataStoreException {
        return this.clip(this.source.getGridGeometry(), GridRoundingMode.NEAREST, GridClippingMode.STRICT);
    }

    private GridGeometry clip(GridGeometry gridGeometry, GridRoundingMode gridRoundingMode, GridClippingMode gridClippingMode) throws DataStoreException {
        GridGeometry gridGeometry2 = this.query.getSelection();
        if (gridGeometry == null) {
            return gridGeometry2;
        }
        if (gridGeometry2 == null) {
            return gridGeometry;
        }
        try {
            GridDerivation gridDerivation = gridGeometry.derive().rounding(gridRoundingMode).clipping(gridClippingMode);
            int n = this.query.getSourceDomainExpansion();
            if (n != 0) {
                int[] nArray = new int[gridGeometry.getDimension()];
                Arrays.fill(nArray, n);
                gridDerivation.margin(nArray);
            }
            return gridDerivation.subgrid(gridGeometry2).build();
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {
            String string = Resources.forLocale(this.listeners.getLocale()).getString((short)57, this.listeners.getSourceName());
            Throwable throwable = runtimeException.getCause();
            if (throwable instanceof FactoryException || throwable instanceof TransformException) {
                throw new DataStoreReferencingException(string, throwable);
            }
            if (runtimeException instanceof DisjointExtentException) {
                throw new NoSuchDataException(string, runtimeException);
            }
            throw new DataStoreException(string, runtimeException);
        }
    }

    @Override
    public List<SampleDimension> getSampleDimensions() throws DataStoreException {
        List<SampleDimension> list = this.source.getSampleDimensions();
        int[] nArray = this.query.getProjection();
        if (nArray == null) {
            return list;
        }
        SampleDimension[] sampleDimensionArray = new SampleDimension[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            try {
                sampleDimensionArray[i] = list.get(n);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new DataStoreException(this.invalidRange(list.size(), n), indexOutOfBoundsException);
            }
        }
        return UnmodifiableArrayList.wrap(sampleDimensionArray);
    }

    @Override
    public RasterLoadingStrategy getLoadingStrategy() throws DataStoreException {
        return this.source.getLoadingStrategy();
    }

    @Override
    public boolean setLoadingStrategy(RasterLoadingStrategy rasterLoadingStrategy) throws DataStoreException {
        return this.source.setLoadingStrategy(rasterLoadingStrategy);
    }

    @Override
    public GridCoverage read(GridGeometry gridGeometry, int ... nArray) throws DataStoreException {
        if (gridGeometry == null) {
            gridGeometry = this.source.getGridGeometry();
        }
        gridGeometry = this.clip(gridGeometry, GridRoundingMode.ENCLOSING, GridClippingMode.BORDER_EXPANSION);
        int[] nArray2 = this.query.getProjection();
        if (nArray == null) {
            nArray = nArray2;
        } else if (nArray2 != null) {
            int[] nArray3 = new int[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                if (n < 0 || n >= nArray2.length) {
                    throw new IllegalArgumentException(this.invalidRange(nArray2.length, n));
                }
                nArray3[i] = nArray2[n];
            }
            nArray = nArray3;
        }
        return this.source.read(gridGeometry, nArray);
    }

    private String invalidRange(int n, int n2) {
        return Resources.forLocale(this.listeners.getLocale()).getString((short)52, n - 1, n2);
    }
}

