/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.request.search.query;

import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.protobufs.FieldValue;
import org.opensearch.protobufs.TermQuery;
import org.opensearch.transport.grpc.proto.request.common.ObjectMapProtoUtils;

public class TermQueryBuilderProtoUtils {
    private TermQueryBuilderProtoUtils() {
    }

    protected static TermQueryBuilder fromProto(TermQuery termQueryProto) {
        String queryName = null;
        String fieldName = termQueryProto.getField();
        Object value = null;
        float boost = 1.0f;
        boolean caseInsensitive = false;
        if (termQueryProto.hasUnderscoreName()) {
            queryName = termQueryProto.getUnderscoreName();
        }
        if (termQueryProto.hasBoost()) {
            boost = termQueryProto.getBoost();
        }
        FieldValue fieldValue = termQueryProto.getValue();
        block0 : switch (fieldValue.getTypeCase()) {
            case GENERAL_NUMBER: {
                switch (fieldValue.getGeneralNumber().getValueCase()) {
                    case INT32_VALUE: {
                        value = fieldValue.getGeneralNumber().getInt32Value();
                        break block0;
                    }
                    case INT64_VALUE: {
                        value = fieldValue.getGeneralNumber().getInt64Value();
                        break block0;
                    }
                    case FLOAT_VALUE: {
                        value = Float.valueOf(fieldValue.getGeneralNumber().getFloatValue());
                        break block0;
                    }
                    case DOUBLE_VALUE: {
                        value = fieldValue.getGeneralNumber().getDoubleValue();
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Unsupported general number type: " + String.valueOf(fieldValue.getGeneralNumber().getValueCase()));
            }
            case STRING_VALUE: {
                value = fieldValue.getStringValue();
                break;
            }
            case OBJECT_MAP: {
                value = ObjectMapProtoUtils.fromProto(fieldValue.getObjectMap());
                break;
            }
            case BOOL_VALUE: {
                value = fieldValue.getBoolValue();
                break;
            }
            default: {
                throw new IllegalArgumentException("TermQuery field value not recognized");
            }
        }
        if (termQueryProto.hasCaseInsensitive()) {
            caseInsensitive = termQueryProto.getCaseInsensitive();
        }
        TermQueryBuilder termQuery = new TermQueryBuilder(fieldName, value);
        termQuery.boost(boost);
        if (queryName != null) {
            termQuery.queryName(queryName);
        }
        termQuery.caseInsensitive(caseInsensitive);
        return termQuery;
    }
}

