/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import org.hibernate.dialect.Dialect;
import org.hibernate.mapping.CheckConstraint;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.metamodel.mapping.SelectablePath;

public final class AggregateColumn
extends Column {
    private final Component component;

    public AggregateColumn(Column column, Component component) {
        this.setLength(column.getLength());
        this.setPrecision(column.getPrecision());
        this.setScale(column.getScale());
        this.setArrayLength(column.getArrayLength());
        this.setValue(column.getValue());
        this.setTypeIndex(column.getTypeIndex());
        this.setName(column.getQuotedName());
        this.setNullable(column.isNullable());
        this.setUnique(column.isUnique());
        this.setUniqueKeyName(column.getUniqueKeyName());
        this.setSqlType(column.getSqlType());
        this.setSqlTypeCode(column.getSqlTypeCode());
        this.uniqueInteger = column.uniqueInteger;
        for (CheckConstraint constraint : column.getCheckConstraints()) {
            this.addCheckConstraint(constraint);
        }
        this.setComment(column.getComment());
        this.setCollation(column.getCollation());
        this.setDefaultValue(column.getDefaultValue());
        this.setGeneratedAs(column.getGeneratedAs());
        this.setAssignmentExpression(column.getAssignmentExpression());
        this.setCustomRead(column.getCustomRead());
        this.setCustomWrite(column.getCustomWrite());
        this.component = component;
    }

    public Component getComponent() {
        return this.component;
    }

    public SelectablePath getSelectablePath() {
        return AggregateColumn.getSelectablePath(this.component);
    }

    private static SelectablePath getSelectablePath(Component component) {
        AggregateColumn aggregateColumn = component.getAggregateColumn();
        AggregateColumn parent = component.getParentAggregateColumn();
        String simpleAggregateName = aggregateColumn.getQuotedName();
        return parent == null ? new SelectablePath(simpleAggregateName) : AggregateColumn.getSelectablePath(parent.getComponent()).append(simpleAggregateName);
    }

    public String getAggregateReadExpressionTemplate(Dialect dialect) {
        return AggregateColumn.getAggregateReadExpressionTemplate(dialect, this.component);
    }

    private static String getAggregateReadExpressionTemplate(Dialect dialect, Component component) {
        AggregateColumn aggregateColumn = component.getAggregateColumn();
        AggregateColumn parent = component.getParentAggregateColumn();
        String simpleAggregateName = aggregateColumn.getQuotedName(dialect);
        return parent == null || AggregateColumn.isArray(aggregateColumn) ? AggregateColumn.getRootAggregateSelectableExpression(aggregateColumn, simpleAggregateName) : dialect.getAggregateSupport().aggregateComponentCustomReadExpression("", "", AggregateColumn.getAggregateReadExpressionTemplate(dialect, parent.getComponent()), simpleAggregateName, parent, aggregateColumn);
    }

    private static String getRootAggregateSelectableExpression(AggregateColumn aggregateColumn, String simpleAggregateName) {
        return AggregateColumn.isArray(aggregateColumn) ? "{@}" : "{@}." + simpleAggregateName;
    }

    private static boolean isArray(AggregateColumn aggregateColumn) {
        return switch (aggregateColumn.getTypeCode()) {
            case 3016, 3017, 3018, 3019 -> true;
            default -> false;
        };
    }

    public String getAggregateAssignmentExpressionTemplate(Dialect dialect) {
        return AggregateColumn.getAggregateAssignmentExpressionTemplate(dialect, this.component);
    }

    private static String getAggregateAssignmentExpressionTemplate(Dialect dialect, Component component) {
        AggregateColumn aggregateColumn = component.getAggregateColumn();
        AggregateColumn parent = component.getParentAggregateColumn();
        String simpleAggregateName = aggregateColumn.getQuotedName(dialect);
        return parent == null ? "{@}." + simpleAggregateName : dialect.getAggregateSupport().aggregateComponentAssignmentExpression(AggregateColumn.getAggregateAssignmentExpressionTemplate(dialect, parent.getComponent()), simpleAggregateName, parent, (Column)aggregateColumn);
    }

    @Override
    public AggregateColumn clone() {
        return new AggregateColumn(this, this.component);
    }
}

