/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.resolver.AddressResolverGroup;
import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.PoolOptions;
import io.vertx.core.http.WebSocketClient;
import io.vertx.core.http.WebSocketClientOptions;
import io.vertx.core.http.impl.HttpServerImpl;
import io.vertx.core.impl.AddressResolver;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.Deployment;
import io.vertx.core.impl.FailoverCompleteHandler;
import io.vertx.core.impl.HAManager;
import io.vertx.core.impl.SharedClientHolder;
import io.vertx.core.impl.WorkerExecutorInternal;
import io.vertx.core.impl.WorkerPool;
import io.vertx.core.impl.btc.BlockedThreadChecker;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.net.impl.NetServerImpl;
import io.vertx.core.net.impl.ServerID;
import io.vertx.core.net.impl.TCPServerBase;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.core.spi.context.storage.ContextLocal;
import io.vertx.core.spi.file.FileResolver;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.spi.transport.Transport;
import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public interface VertxInternal
extends Vertx {
    public <T> PromiseInternal<T> promise();

    public <T> PromiseInternal<T> promise(Handler<AsyncResult<T>> var1);

    public long maxEventLoopExecTime();

    public TimeUnit maxEventLoopExecTimeUnit();

    @Override
    public ContextInternal getOrCreateContext();

    public EventLoopGroup getEventLoopGroup();

    public EventLoopGroup getAcceptorEventLoopGroup();

    public WorkerPool getWorkerPool();

    public WorkerPool getInternalWorkerPool();

    public Map<ServerID, HttpServerImpl> sharedHttpServers();

    public Map<ServerID, NetServerImpl> sharedNetServers();

    public <S extends TCPServerBase> Map<ServerID, S> sharedTCPServers(Class<S> var1);

    public VertxMetrics metricsSPI();

    public Transport transport();

    public WebSocketClient createWebSocketClient(WebSocketClientOptions var1, CloseFuture var2);

    public HttpClient createHttpPoolClient(HttpClientOptions var1, PoolOptions var2, CloseFuture var3);

    default public <C> C createSharedClient(String clientKey, String clientName, CloseFuture closeFuture, Function<CloseFuture, C> supplier) {
        return SharedClientHolder.createSharedClient(this, clientKey, clientName, closeFuture, supplier);
    }

    public ContextInternal getContext();

    public ContextInternal createEventLoopContext(Deployment var1, CloseFuture var2, WorkerPool var3, ClassLoader var4);

    public ContextInternal createEventLoopContext(EventLoop var1, WorkerPool var2, ClassLoader var3);

    public ContextInternal createEventLoopContext();

    public ContextInternal createWorkerContext(Deployment var1, CloseFuture var2, WorkerPool var3, ClassLoader var4);

    public ContextInternal createWorkerContext(EventLoop var1, WorkerPool var2, ClassLoader var3);

    public ContextInternal createWorkerContext();

    public ContextInternal createVirtualThreadContext(Deployment var1, CloseFuture var2, ClassLoader var3);

    public ContextInternal createVirtualThreadContext(EventLoop var1, ClassLoader var2);

    public ContextInternal createVirtualThreadContext();

    @Override
    public WorkerExecutorInternal createSharedWorkerExecutor(String var1);

    @Override
    public WorkerExecutorInternal createSharedWorkerExecutor(String var1, int var2);

    @Override
    public WorkerExecutorInternal createSharedWorkerExecutor(String var1, int var2, long var3);

    @Override
    public WorkerExecutorInternal createSharedWorkerExecutor(String var1, int var2, long var3, TimeUnit var5);

    public WorkerPool createSharedWorkerPool(String var1, int var2, long var3, TimeUnit var5);

    public WorkerPool wrapWorkerPool(ExecutorService var1);

    public void simulateKill();

    public Deployment getDeployment(String var1);

    public void failoverCompleteHandler(FailoverCompleteHandler var1);

    public boolean isKilled();

    public void failDuringFailover(boolean var1);

    public File resolveFile(String var1);

    @Deprecated
    default public <T> void executeBlockingInternal(Handler<Promise<T>> blockingCodeHandler, Handler<AsyncResult<T>> resultHandler) {
        ContextInternal context = this.getOrCreateContext();
        context.executeBlockingInternal(blockingCodeHandler, resultHandler);
    }

    default public <T> Future<T> executeBlockingInternal(Callable<T> blockingCodeHandler) {
        ContextInternal context = this.getOrCreateContext();
        return context.executeBlockingInternal(blockingCodeHandler);
    }

    @Deprecated
    default public <T> void executeBlockingInternal(Handler<Promise<T>> blockingCodeHandler, boolean ordered, Handler<AsyncResult<T>> resultHandler) {
        ContextInternal context = this.getOrCreateContext();
        context.executeBlockingInternal(blockingCodeHandler, ordered, resultHandler);
    }

    default public <T> Future<T> executeBlockingInternal(Callable<T> blockingCodeHandler, boolean ordered) {
        ContextInternal context = this.getOrCreateContext();
        return context.executeBlockingInternal(blockingCodeHandler, ordered);
    }

    public ClusterManager getClusterManager();

    public HAManager haManager();

    public void resolveAddress(String var1, Handler<AsyncResult<InetAddress>> var2);

    public AddressResolver addressResolver();

    public FileResolver fileResolver();

    public AddressResolverGroup<InetSocketAddress> nettyAddressResolverGroup();

    public List<ContextLocal<?>> contextLocals();

    public BlockedThreadChecker blockedThreadChecker();

    public CloseFuture closeFuture();

    public VertxTracer tracer();

    public void addCloseHook(Closeable var1);

    public void removeCloseHook(Closeable var1);

    public boolean isVirtualThreadAvailable();
}

