/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.organization.admin.resource;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.HashMap;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.extensions.Extension;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.parameters.RequestBody;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.jboss.resteasy.reactive.NoCache;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.OrganizationModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.organization.OrganizationProvider;
import org.keycloak.organization.admin.resource.OrganizationInvitationResource;
import org.keycloak.representations.idm.MemberRepresentation;
import org.keycloak.representations.idm.MembershipType;
import org.keycloak.representations.idm.OrganizationRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.utils.StringUtil;

@Extension(name="x-smallrye-profile-admin", value="")
public class OrganizationMemberResource {
    private final KeycloakSession session;
    private final RealmModel realm;
    private final OrganizationProvider provider;
    private final OrganizationModel organization;
    private final AdminEventBuilder adminEvent;

    public OrganizationMemberResource(KeycloakSession session, OrganizationModel organization, AdminEventBuilder adminEvent) {
        this.session = session;
        this.realm = session.getContext().getRealm();
        this.provider = (OrganizationProvider)session.getProvider(OrganizationProvider.class);
        this.organization = organization;
        this.adminEvent = adminEvent.resource(ResourceType.ORGANIZATION_MEMBERSHIP);
    }

    @POST
    @Consumes(value={"application/json"})
    @Tag(name="Organizations")
    @Operation(summary="Adds the user with the specified id as a member of the organization", description="Adds, or associates, an existing user with the organization. If no user is found, or if it is already associated with the organization, an error response is returned")
    @RequestBody(description="Payload should contain only id of the user to be added to the organization (UUID with or without quotes). Surrounding whitespace characters will be trimmed.", required=true)
    @APIResponses(value={@APIResponse(responseCode="201", description="Created"), @APIResponse(responseCode="400", description="Bad Request"), @APIResponse(responseCode="409", description="Conflict")})
    public Response addMember(String id) {
        id = id.trim().replaceAll("^\"|\"$", "");
        UserModel user = this.session.users().getUserById(this.realm, id);
        if (user == null) {
            throw ErrorResponse.error("User does not exist", Response.Status.BAD_REQUEST);
        }
        try {
            if (this.provider.addMember(this.organization, user)) {
                this.adminEvent.operation(OperationType.CREATE).resource(ResourceType.ORGANIZATION_MEMBERSHIP).representation(ModelToRepresentation.toRepresentation((OrganizationModel)this.organization)).resourcePath((UriInfo)this.session.getContext().getUri()).detail("username", user.getUsername()).detail("email", user.getEmail()).success();
                return Response.created((URI)this.session.getContext().getUri().getAbsolutePathBuilder().path(user.getId()).build(new Object[0])).build();
            }
        }
        catch (ModelException me) {
            throw ErrorResponse.error(me.getMessage(), Response.Status.BAD_REQUEST);
        }
        throw ErrorResponse.error("User is already a member of the organization.", Response.Status.CONFLICT);
    }

    @Path(value="invite-user")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Tag(name="Organizations")
    @Operation(summary="Invites an existing user or sends a registration link to a new user, based on the provided e-mail address.", description="If the user with the given e-mail address exists, it sends an invitation link, otherwise it sends a registration link.")
    @APIResponses(value={@APIResponse(responseCode="204", description="No Content"), @APIResponse(responseCode="400", description="Bad Request"), @APIResponse(responseCode="409", description="Conflict"), @APIResponse(responseCode="500", description="Internal Server Error")})
    public Response inviteUser(@FormParam(value="email") String email, @FormParam(value="firstName") String firstName, @FormParam(value="lastName") String lastName) {
        return new OrganizationInvitationResource(this.session, this.organization, this.adminEvent).inviteUser(email, firstName, lastName);
    }

    @POST
    @Path(value="invite-existing-user")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Tag(name="Organizations")
    @Operation(summary="Invites an existing user to the organization, using the specified user id")
    @APIResponses(value={@APIResponse(responseCode="204", description="No Content"), @APIResponse(responseCode="400", description="Bad Request"), @APIResponse(responseCode="500", description="Internal Server Error")})
    public Response inviteExistingUser(@FormParam(value="id") String id) {
        return new OrganizationInvitationResource(this.session, this.organization, this.adminEvent).inviteExistingUser(id);
    }

    @GET
    @Produces(value={"application/json"})
    @NoCache
    @Tag(name="Organizations")
    @Operation(summary="Returns a paginated list of organization members filtered according to the specified parameters")
    @APIResponses(value={@APIResponse(responseCode="200", description="", content={@Content(schema=@Schema(implementation=MemberRepresentation.class, type=SchemaType.ARRAY))})})
    public Stream<MemberRepresentation> search(@Parameter(description="A String representing either a member's username, e-mail, first name, or last name.") @QueryParam(value="search") String search, @Parameter(description="Boolean which defines whether the param 'search' must match exactly or not") @QueryParam(value="exact") Boolean exact, @Parameter(description="The position of the first result to be processed (pagination offset)") @QueryParam(value="first") @DefaultValue(value="0") Integer first, @Parameter(description="The maximum number of results to be returned. Defaults to 10") @QueryParam(value="max") @DefaultValue(value="10") Integer max, @Parameter(description="The membership type") @QueryParam(value="membershipType") String membershipType) {
        HashMap<String, String> filters = new HashMap<String, String>();
        if (search != null) {
            filters.put("keycloak.session.realm.users.query.search", search);
        }
        if (membershipType != null) {
            filters.put("membershipType", MembershipType.valueOf((String)membershipType.toUpperCase()).name());
        }
        return this.provider.getMembersStream(this.organization, filters, exact, first, max).map(this::toRepresentation);
    }

    @Path(value="{member-id}")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    @Tag(name="Organizations")
    @Operation(summary="Returns the member of the organization with the specified id", description="Searches for auser with the given id. If one is found, and is currently a member of the organization, returns it. Otherwise,an error response with status NOT_FOUND is returned")
    @APIResponses(value={@APIResponse(responseCode="200", description="", content={@Content(schema=@Schema(implementation=MemberRepresentation.class))}), @APIResponse(responseCode="400", description="Bad Request")})
    public MemberRepresentation get(@PathParam(value="member-id") String memberId) {
        if (StringUtil.isBlank((String)memberId)) {
            throw ErrorResponse.error("id cannot be null", Response.Status.BAD_REQUEST);
        }
        return this.toRepresentation(this.getMember(memberId));
    }

    @Path(value="{member-id}")
    @DELETE
    @Tag(name="Organizations")
    @Operation(summary="Removes the user with the specified id from the organization", description="Breaks the association between the user and organization. The user itself is deleted in case the membership is managed, otherwise the user is not deleted. If no user is found, or if they are not a member of the organization, an error response is returned")
    @APIResponses(value={@APIResponse(responseCode="204", description="No Content"), @APIResponse(responseCode="400", description="Bad Request")})
    public Response delete(@PathParam(value="member-id") String memberId) {
        if (StringUtil.isBlank((String)memberId)) {
            throw ErrorResponse.error("id cannot be null", Response.Status.BAD_REQUEST);
        }
        UserModel member = this.getMember(memberId);
        if (this.provider.removeMember(this.organization, member)) {
            this.adminEvent.operation(OperationType.DELETE).resource(ResourceType.ORGANIZATION_MEMBERSHIP).representation(ModelToRepresentation.toRepresentation((OrganizationModel)this.organization)).resourcePath((UriInfo)this.session.getContext().getUri()).detail("username", member.getUsername()).detail("email", member.getEmail()).success();
            return Response.noContent().build();
        }
        throw ErrorResponse.error("Not a member of the organization", Response.Status.BAD_REQUEST);
    }

    @Path(value="{member-id}/organizations")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    @Tag(name="Organizations")
    @Operation(summary="Returns the organizations associated with the user that has the specified id")
    @APIResponses(value={@APIResponse(responseCode="200", description="", content={@Content(schema=@Schema(implementation=OrganizationRepresentation.class, type=SchemaType.ARRAY))}), @APIResponse(responseCode="400", description="Bad Request")})
    public Stream<OrganizationRepresentation> getOrganizations(@PathParam(value="member-id") String memberId, @Parameter(description="if false, return the full representation. Otherwise, only the basic fields are returned.") @QueryParam(value="briefRepresentation") @DefaultValue(value="true") boolean briefRepresentation) {
        if (StringUtil.isBlank((String)memberId)) {
            throw ErrorResponse.error("id cannot be null", Response.Status.BAD_REQUEST);
        }
        UserModel member = this.getUser(memberId);
        return this.provider.getByMember(member).map(model -> ModelToRepresentation.toRepresentation((OrganizationModel)model, (boolean)briefRepresentation));
    }

    @Path(value="count")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    @Tag(name="Organizations")
    @Operation(summary="Returns number of members in the organization.")
    @APIResponses(value={@APIResponse(responseCode="200", description="", content={@Content(schema=@Schema(implementation=Long.class))})})
    public Long count() {
        return this.provider.getMembersCount(this.organization);
    }

    private UserModel getMember(String id) {
        UserModel member = this.provider.getMemberById(this.organization, id);
        if (member == null) {
            throw new NotFoundException();
        }
        return member;
    }

    private UserModel getUser(String id) {
        UserModel user = this.session.users().getUserById(this.realm, id);
        if (user == null) {
            throw new NotFoundException();
        }
        return user;
    }

    private MemberRepresentation toRepresentation(UserModel member) {
        MemberRepresentation result = new MemberRepresentation(ModelToRepresentation.toRepresentation((KeycloakSession)this.session, (RealmModel)this.realm, (UserModel)member));
        result.setMembershipType(this.provider.isManagedMember(this.organization, member) ? MembershipType.MANAGED : MembershipType.UNMANAGED);
        return result;
    }
}

