# Contributing Guidelines
This document contains the general contributing checklists for Intel optimization of High
Performance Conjugate Gradient (HPCG) Benchmark for Intel GPUs.

Please note, the check started with "\[text\]" is an optional check, that should be performed
only in case of condition described inside the brackets.

## Pull Request (PR) Checklist

**Before submitting your PR, ensure that you complete this checklist:**
1. Make sure all commit messages (of the final commit after squashing) has short and clear commit
   description, and may include tags like `[Build]` or `[Documentation]` if applicable.
2. Document (if applicable) any related JIRA and PR should provide initial problem description and solution
   overview.  When performance is being improved, a comparison of before and after is helpful as well.
3. Ensure it builds with Intel(R) MPI Library, and with NOMPI (testing MPICH is recommended but optional),
   builds with and without `BASIC_PROFILING=yes`, and builds/runs with and without
   `-DHPCG_TEST_CUSTOM_KERNELS` build option.

**Before merging your PR:**
1. Address all feedback. Depending on the changes, another round of testing might be required.
2. \[Infrastructure related changes\] coordinate with the infra team to avoid breaking changes
   (e.g. track changes in TBMKL script input/output)
3. \[Backward incompatible changes\] make sure it was approved on oneMKL PXT.

**After PR was merged:**
1. \[During release\] make sure the changes were merged to both develop and release branches, where PR for
   release branch must be approved by PM.
2. \[If this PR causes build issues in regular CI/Nightly procedures\] fix it in one business day or revert
   the changes and merge them with the fix when it's ready.
3. \[If this PR causes testing issues in regular CI/Nightly/Weekly procedures\] address it as soon as
   possible by fixing it or creating a JIRA.
4. \[If this PR adds public API related changes\] create Documentation JIRA in order to update documentation.

**During oneMKL release time:**
1. update submodule in oneMKL develop branch to point to desired commit in this repository and commit it.
2. \[If necessary\] update submodule in oneMKL release branch to point to desired commit in this
   repository and commit it.


## An Example Update

The following is an example of updating the Intel(R) oneAPI DPC++ Library (oneDPL) submodule to a particular tag:
```
# update oneDPL submodule to track a particular tag
git checkout -b dev/userid/oneDPL_2022.3.0

cd third-party/oneDPL
git checkout main      # reconcile detached HEAD
git pull origin main   # update the submodule
git checkout tags/oneDPL-2022.3.0-rc1
cd ../../

git add third-party/oneDPL
git commit -m"set oneDPL SHA to tags/oneDPL-2022.3.0-rc1 which corresponds to oneAPI 2024.0" third-party/oneDPL
git push origin dev/userid/oneDPL_2022.3.0
```
