/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.remote.internal.hub;

import java.util.HashSet;
import java.util.Set;
import org.gradle.internal.remote.internal.RemoteConnection;
import org.gradle.internal.remote.internal.hub.ConnectionState;
import org.gradle.internal.remote.internal.hub.IncomingQueue;
import org.gradle.internal.remote.internal.hub.OutgoingQueue;
import org.gradle.internal.remote.internal.hub.protocol.EndOfStream;
import org.gradle.internal.remote.internal.hub.protocol.InterHubMessage;
import org.gradle.internal.remote.internal.hub.queue.EndPointQueue;

class ConnectionSet {
    private final Set<ConnectionState> connections = new HashSet<ConnectionState>();
    private final IncomingQueue incomingQueue;
    private final OutgoingQueue outgoingQueue;
    private boolean stopping;

    ConnectionSet(IncomingQueue incomingQueue, OutgoingQueue outgoingQueue) {
        this.incomingQueue = incomingQueue;
        this.outgoingQueue = outgoingQueue;
    }

    public ConnectionState add(RemoteConnection<InterHubMessage> connection) {
        EndPointQueue queue = this.outgoingQueue.newEndpoint();
        ConnectionState state = new ConnectionState(this, connection, queue);
        this.connections.add(state);
        return state;
    }

    public void finished(ConnectionState connectionState) {
        this.connections.remove(connectionState);
        if (this.stopping) {
            this.maybeStop();
        }
    }

    public void noFurtherConnections() {
        this.stopping = true;
        this.maybeStop();
    }

    private void maybeStop() {
        if (this.connections.isEmpty()) {
            this.outgoingQueue.discardQueued();
            this.incomingQueue.queue(new EndOfStream());
        }
    }
}

