/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.DOMInvalidAccessException;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.RGBAColor;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.property.AbstractTextValue;
import io.sf.carte.doc.style.css.property.ColorIdentifiers;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.Locale;
import org.w3c.dom.DOMException;

public class IdentifierValue
extends AbstractTextValue {
    private static final long serialVersionUID = 1L;
    private String stringValue = null;

    public IdentifierValue() {
        super(CSSValue.Type.IDENT);
    }

    public IdentifierValue(String plainIdentifier) {
        super(CSSValue.Type.IDENT);
        this.stringValue = plainIdentifier;
        this.setPlainCssText(plainIdentifier);
    }

    protected IdentifierValue(IdentifierValue copied) {
        super(copied);
        this.stringValue = copied.stringValue;
        this.setPlainCssText(copied.getCssText());
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        LexicalUnit lu;
        this.checkModifiableProperty();
        if (cssText == null || cssText.length() == 0) {
            throw new DOMException(5, "Null or empty value.");
        }
        CSSParser parser = new CSSParser();
        try {
            lu = parser.parsePropertyValue(new StringReader(cssText));
        }
        catch (IOException e) {
            lu = null;
        }
        catch (CSSException e) {
            DOMException ex = new DOMException(5, "Invalid identifier: " + cssText);
            ex.initCause(e);
            throw ex;
        }
        if (lu.getLexicalUnitType() != LexicalUnit.LexicalType.IDENT || lu.getNextLexicalUnit() != null) {
            throw new DOMException(13, "Not an identifier: " + cssText);
        }
        PrimitiveValue.LexicalSetter setter = this.newLexicalSetter();
        setter.setLexicalUnit(lu);
    }

    @Override
    public String getMinifiedCssText(String propertyName) {
        return ParseHelper.safeEscape(this.stringValue, false);
    }

    @Override
    public String getStringValue() {
        return this.stringValue;
    }

    @Override
    public void setStringValue(CSSValue.Type stringType, String stringValue) throws DOMException {
        this.checkModifiableProperty();
        if (stringType != CSSValue.Type.IDENT) {
            throw new DOMException(13, "This value is an identifier. To have a new type, set it at the style-declaration level.");
        }
        if (stringValue == null || stringValue.length() == 0) {
            throw new DOMException(5, "Null or empty value.");
        }
        this.setStringValue(stringValue);
        this.setPlainCssText(this.escape(this.stringValue));
    }

    private void setStringValue(String value) {
        this.stringValue = value.intern();
    }

    private String escape(String css) throws DOMException {
        return ParseHelper.safeEscape(css);
    }

    @Override
    CSSValueSyntax.Match matchesComponent(CSSValueSyntax syntax) {
        switch (syntax.getCategory()) {
            case customIdent: {
                return CSSValueSyntax.Match.TRUE;
            }
            case IDENT: {
                return syntax.getName().equals(this.getStringValue()) ? CSSValueSyntax.Match.TRUE : CSSValueSyntax.Match.FALSE;
            }
            case color: {
                String lc = this.getStringValue().toLowerCase(Locale.ROOT);
                return ColorIdentifiers.getInstance().isColorIdentifier(lc) ? CSSValueSyntax.Match.TRUE : CSSValueSyntax.Match.FALSE;
            }
            case universal: {
                return CSSValueSyntax.Match.TRUE;
            }
        }
        return CSSValueSyntax.Match.FALSE;
    }

    @Override
    public RGBAColor toRGBColor() throws DOMException {
        String ident = this.getStringValue().toLowerCase(Locale.ROOT);
        String spec = "transparent".equals(ident) ? "#0000" : ColorIdentifiers.getInstance().getColor(ident);
        if (spec != null) {
            ValueFactory factory = new ValueFactory();
            try {
                StyleValue val = factory.parseProperty(spec);
                if (val.getCssValueType() == CSSValue.CssType.TYPED && val.getPrimitiveType() == CSSValue.Type.COLOR) {
                    return ((TypedValue)val).toRGBColor();
                }
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        }
        throw new DOMInvalidAccessException("Not an RGB Color");
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        wri.write((CharSequence)this.getCssText());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        String sv = this.getStringValue();
        result = 31 * result + (sv == null ? 0 : sv.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IdentifierValue other = (IdentifierValue)obj;
        String sv = this.getStringValue();
        String osv = other.getStringValue();
        if (sv == null) {
            return osv == null;
        }
        return sv.equals(osv);
    }

    @Override
    public IdentifierValue clone() {
        return new IdentifierValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
            super(IdentifierValue.this);
        }

        @Override
        void setLexicalUnit(LexicalUnit lunit) {
            String strval = lunit.getStringValue();
            IdentifierValue.this.setStringValue(strval);
            if (lunit instanceof LexicalUnit) {
                IdentifierValue.this.setPlainCssText(lunit.getCssText());
            } else {
                IdentifierValue.this.setPlainCssText(IdentifierValue.this.escape(IdentifierValue.this.stringValue));
            }
            this.nextLexicalUnit = lunit.getNextLexicalUnit();
        }
    }
}

