/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.DialogHandler;
import net.sf.freecol.client.gui.label.GoodsLabel;
import net.sf.freecol.client.gui.panel.FreeColButton;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.client.gui.panel.WrapLayout;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ExportData;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;

public final class WarehouseDialog
extends FreeColPanel {
    private static final Logger logger = Logger.getLogger(WarehouseDialog.class.getName());

    public WarehouseDialog(FreeColClient freeColClient, Colony colony, final DialogHandler<Boolean> dialogHandler) {
        super(freeColClient, null, new MigLayout("fill, wrap 1", "", ""));
        JPanel warehousePanel = this.createWarehousePanel(freeColClient, colony);
        JScrollPane scrollPane = this.scrollPaneWithHiddenBorder(warehousePanel);
        MigPanel panel = new MigPanel(new MigLayout("fill, wrap 1", "", ""));
        panel.add((Component)Utility.localizedHeader(Messages.nameKey("warehouseDialog"), Utility.FONTSPEC_TITLE), "align center");
        panel.add((Component)scrollPane, "grow, gap 0 0");
        FreeColButton okButton = Utility.localizedButton("ok").withButtonStyle(FreeColButton.ButtonStyle.IMPORTANT);
        okButton.setActionCommand("OK");
        okButton.addActionListener(event -> {
            for (Component c : warehousePanel.getComponents()) {
                if (!(c instanceof WarehouseGoodsPanel)) continue;
                ((WarehouseGoodsPanel)c).saveSettings();
            }
            this.getGUI().removeComponent(this);
            if (dialogHandler != null) {
                dialogHandler.handle(true);
            }
        });
        panel.add((Component)okButton, "newline, span, split 2, tag ok");
        FreeColButton cancelButton = Utility.localizedButton("cancel");
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                WarehouseDialog.this.getGUI().removeComponent(WarehouseDialog.this);
                if (dialogHandler != null) {
                    dialogHandler.handle(false);
                }
            }
        };
        cancelButton.addActionListener(cancelAction);
        this.setEscapeAction(cancelAction);
        panel.add((Component)cancelButton, "tag cancel");
        this.add((Component)panel, "grow");
    }

    private JPanel createWarehousePanel(FreeColClient freeColClient, Colony colony) {
        JPanel warehousePanel = new JPanel(new WrapLayout());
        warehousePanel.setOpaque(false);
        List<GoodsType> goodsTypes = freeColClient.getGame().getSpecification().getStorableGoodsTypeList();
        int preferredWidth = 0;
        for (GoodsType type : goodsTypes) {
            WarehouseGoodsPanel wgp = new WarehouseGoodsPanel(freeColClient, colony, type);
            warehousePanel.add(wgp);
            preferredWidth += wgp.getPreferredSize().width;
        }
        warehousePanel.setSize(new Dimension(preferredWidth /= 4, 1));
        return warehousePanel;
    }

    private JScrollPane scrollPaneWithHiddenBorder(JPanel warehousePanel) {
        JScrollPane scrollPane = new JScrollPane(warehousePanel, 20, 31);
        scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        scrollPane.getViewport().setOpaque(false);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        return scrollPane;
    }

    private class WarehouseGoodsPanel
    extends MigPanel {
        private final Colony colony;
        private final GoodsType goodsType;
        private final JCheckBox export;
        private final JSpinner lowLevel;
        private final JSpinner highLevel;
        private final JSpinner importLevel;
        private final JSpinner exportLevel;

        public WarehouseGoodsPanel(FreeColClient freeColClient, Colony colony, GoodsType goodsType) {
            super("WarehouseGoodsPanelUI", new MigLayout("wrap 2", "", ""));
            boolean enhancedTradeRoutes = colony.getSpecification().getBoolean("model.option.enhancedTradeRoutes");
            this.colony = colony;
            this.goodsType = goodsType;
            int capacity = colony.getWarehouseCapacity();
            int maxCapacity = 300;
            this.setOpaque(false);
            this.setBorder(Utility.localizedBorder(goodsType, new Color(0)));
            Utility.padBorder(this, 6, 6, 6, 6);
            ExportData exportData = colony.getExportData(goodsType);
            Goods goods = new Goods(colony.getGame(), colony, goodsType, colony.getGoodsCount(goodsType));
            GoodsLabel goodsLabel = new GoodsLabel(freeColClient, goods);
            goodsLabel.setHorizontalAlignment(10);
            this.add((Component)goodsLabel, "span 1 2");
            SpinnerNumberModel lowLevelModel = new SpinnerNumberModel(exportData.getLowLevel(), 0, 100, 1);
            this.lowLevel = new JSpinner(lowLevelModel);
            Utility.localizeToolTip((JComponent)this.lowLevel, "warehouseDialog.lowLevel.shortDescription");
            this.add(this.lowLevel);
            SpinnerNumberModel highLevelModel = new SpinnerNumberModel(exportData.getHighLevel(), 0, 100, 1);
            this.highLevel = new JSpinner(highLevelModel);
            Utility.localizeToolTip((JComponent)this.highLevel, "warehouseDialog.highLevel.shortDescription");
            this.add(this.highLevel);
            if (enhancedTradeRoutes) {
                int importInit = exportData.getEffectiveImportLevel(capacity);
                SpinnerNumberModel importLevelModel = new SpinnerNumberModel(importInit, 0, goodsType.limitIgnored() ? 300 : capacity, 1);
                this.importLevel = new JSpinner(importLevelModel);
                Utility.localizeToolTip((JComponent)this.importLevel, "warehouseDialog.importLevel.shortDescription");
                this.add(this.importLevel);
            } else {
                this.importLevel = null;
            }
            this.export = new JCheckBox(Messages.message("warehouseDialog.export"), exportData.getExported());
            Utility.localizeToolTip((JComponent)this.export, "warehouseDialog.export.shortDescription");
            if (!colony.hasAbility("model.ability.export")) {
                this.export.setEnabled(false);
            }
            this.add(this.export);
            SpinnerNumberModel exportLevelModel = new SpinnerNumberModel(exportData.getExportLevel(), 0, goodsType.limitIgnored() ? 300 : capacity, 1);
            this.exportLevel = new JSpinner(exportLevelModel);
            Utility.localizeToolTip((JComponent)this.exportLevel, "warehouseDialog.exportLevel.shortDescription");
            this.add(this.exportLevel);
            this.setSize(this.getPreferredSize());
        }

        public void saveSettings() {
            int lowLevelValue = ((SpinnerNumberModel)this.lowLevel.getModel()).getNumber().intValue();
            int highLevelValue = ((SpinnerNumberModel)this.highLevel.getModel()).getNumber().intValue();
            int importLevelValue = this.importLevel == null ? -1 : ((SpinnerNumberModel)this.importLevel.getModel()).getNumber().intValue();
            int exportLevelValue = ((SpinnerNumberModel)this.exportLevel.getModel()).getNumber().intValue();
            ExportData exportData = this.colony.getExportData(this.goodsType);
            int importValue = exportData.getEffectiveImportLevel(this.colony.getWarehouseCapacity());
            boolean changed = this.export.isSelected() != exportData.getExported() || lowLevelValue != exportData.getLowLevel() || highLevelValue != exportData.getHighLevel() || this.importLevel != null && importLevelValue != importValue || exportLevelValue != exportData.getExportLevel();
            exportData.setExported(this.export.isSelected());
            exportData.setLowLevel(lowLevelValue);
            exportData.setHighLevel(highLevelValue);
            exportData.setImportLevel(importLevelValue);
            exportData.setExportLevel(exportLevelValue);
            if (changed) {
                WarehouseDialog.this.getFreeColClient().getInGameController().setGoodsLevels(this.colony, this.goodsType);
            }
        }
    }
}

