"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IsTabletUp = exports.IsTabletDown = exports.IsTablet = exports.IsMobileUp = exports.IsMobileDown = exports.IsMobile = exports.IsDesktopXL = exports.IsDesktop = exports.MatchMedia = exports.useMatchMedia = void 0;
const jsx_runtime_1 = require("@emotion/react/jsx-runtime");
/*
 * Wire
 * Copyright (C) 2018 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 *
 */
const react_1 = require("react");
const mediaQueries_1 = require("../mediaQueries");
const useMatchMedia = (query) => {
    const matchMedia = (0, react_1.useMemo)(() => window.matchMedia(`(${query})`), [query]);
    const [isMatching, setIsMatching] = (0, react_1.useState)(matchMedia.matches);
    const updateMatching = (event) => {
        setIsMatching(event.matches);
    };
    (0, react_1.useEffect)(() => {
        matchMedia.addEventListener('change', updateMatching);
        return () => matchMedia.removeEventListener('change', updateMatching);
    }, [matchMedia]);
    return isMatching;
};
exports.useMatchMedia = useMatchMedia;
const MatchMedia = ({ query, children, not }) => {
    const matchQuery = (0, exports.useMatchMedia)(mediaQueries_1.QUERY[query] || query);
    const isMatching = not ? !matchQuery : matchQuery;
    return isMatching ? (0, jsx_runtime_1.jsx)(jsx_runtime_1.Fragment, { children: children }) : null;
};
exports.MatchMedia = MatchMedia;
const IsDesktop = (props) => (0, jsx_runtime_1.jsx)(exports.MatchMedia, Object.assign({ query: mediaQueries_1.QueryKeys.DESKTOP }, props));
exports.IsDesktop = IsDesktop;
const IsDesktopXL = (props) => (0, jsx_runtime_1.jsx)(exports.MatchMedia, Object.assign({ query: mediaQueries_1.QueryKeys.DESKTOP_XL }, props));
exports.IsDesktopXL = IsDesktopXL;
const IsMobile = (props) => (0, jsx_runtime_1.jsx)(exports.MatchMedia, Object.assign({ query: mediaQueries_1.QueryKeys.MOBILE }, props));
exports.IsMobile = IsMobile;
const IsMobileDown = (props) => (0, jsx_runtime_1.jsx)(exports.MatchMedia, Object.assign({ query: mediaQueries_1.QueryKeys.MOBILE_DOWN }, props));
exports.IsMobileDown = IsMobileDown;
const IsMobileUp = (props) => (0, jsx_runtime_1.jsx)(exports.MatchMedia, Object.assign({ query: mediaQueries_1.QueryKeys.MOBILE_UP }, props));
exports.IsMobileUp = IsMobileUp;
const IsTablet = (props) => (0, jsx_runtime_1.jsx)(exports.MatchMedia, Object.assign({ query: mediaQueries_1.QueryKeys.TABLET }, props));
exports.IsTablet = IsTablet;
const IsTabletDown = (props) => (0, jsx_runtime_1.jsx)(exports.MatchMedia, Object.assign({ query: mediaQueries_1.QueryKeys.TABLET_DOWN }, props));
exports.IsTabletDown = IsTabletDown;
const IsTabletUp = (props) => (0, jsx_runtime_1.jsx)(exports.MatchMedia, Object.assign({ query: mediaQueries_1.QueryKeys.TABLET_UP }, props));
exports.IsTabletUp = IsTabletUp;
