"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Tooltip = void 0;
const jsx_runtime_1 = require("@emotion/react/jsx-runtime");
const util_1 = require("../util");
const tooltipStyle = theme => ({
    position: 'relative',
    width: 'fit-content',
    '&:hover .tooltip-content': { visibility: 'visible', opacity: 1 },
    '.tooltip-content': {
        textAlign: 'center',
        visibility: 'hidden',
        opacity: 0,
        width: 'max-content',
        height: 'max-content',
        position: 'absolute',
        boxSizing: 'border-box',
        display: 'block',
        margin: '0 auto',
        padding: '4px 8px',
        backgroundColor: theme.Tooltip.backgroundColor,
        color: theme.Tooltip.color,
        borderRadius: 4,
        fontSize: theme.fontSizes.small,
        fontWeight: 500,
        whiteSpace: 'nowrap',
        transition: 'opacity ease-out 150ms, bottom ease-out 150ms',
        boxShadow: '1px 2px 6px rgba(0, 0, 0, 0.3)',
    },
    '& .tooltip-content .tooltip-arrow': {
        position: 'absolute',
        width: 0,
        height: 0,
    },
    "&[data-position='top'] .tooltip-content": {
        bottom: '100%',
        marginBottom: 10,
        left: '50%',
        transform: 'translateX(-50%)',
        '& .tooltip-arrow': {
            filter: 'drop-shadow(0px 2px 1px rgba(0, 0, 0, 0.1))',
            borderLeft: '12px solid transparent',
            borderRight: '12px solid transparent',
            borderTop: `12px solid ${theme.Tooltip.backgroundColor}`,
            top: '90%',
            left: '50%',
            transform: 'translateX(-50%)',
        },
    },
    "&[data-position='right'] .tooltip-content": {
        left: '100%',
        marginLeft: '8px !important',
        top: 0,
        bottom: 0,
        margin: 'auto 0',
        '& .tooltip-arrow': {
            filter: 'drop-shadow(-2px 0px 1px rgba(0, 0, 0, 0.1))',
            borderTop: '8px solid transparent',
            borderBottom: '8px solid transparent',
            borderRight: `8px solid ${theme.Tooltip.backgroundColor}`,
            top: '50%',
            transform: 'translateY(-50%)',
            left: -7,
        },
    },
    "&[data-position='bottom'] .tooltip-content": {
        top: '100%',
        marginTop: 10,
        left: '50%',
        transform: 'translateX(-50%)',
        '& .tooltip-arrow': {
            filter: 'drop-shadow(0px -2px 1px rgba(0, 0, 0, 0.1))',
            borderLeft: '12px solid transparent',
            borderRight: '12px solid transparent',
            borderBottom: `12px solid ${theme.Tooltip.backgroundColor}`,
            bottom: '90%',
            left: '50%',
            transform: 'translateX(-50%)',
        },
    },
    "&[data-position='left'] .tooltip-content": {
        right: '100%',
        marginRight: '8px !important',
        top: 0,
        bottom: 0,
        margin: 'auto 0',
        '& .tooltip-arrow': {
            filter: 'drop-shadow(2px 0px 1px rgba(0, 0, 0, 0.1))',
            borderTop: '8px solid transparent',
            borderBottom: '8px solid transparent',
            borderLeft: `8px solid ${theme.Tooltip.backgroundColor}`,
            top: '50%',
            transform: 'translateY(-50%)',
            right: -7,
        },
    },
});
const filterTooltipProps = (props) => (0, util_1.filterProps)(props, ['position', 'body']);
const Tooltip = (_a) => {
    var { children } = _a, props = __rest(_a, ["children"]);
    const filteredProps = filterTooltipProps(props);
    const { body, position = 'top' } = props;
    return ((0, jsx_runtime_1.jsxs)("div", Object.assign({ css: (theme) => tooltipStyle(theme), "data-position": position }, filteredProps, { "data-testid": "tooltip-wrapper" }, { children: [(0, jsx_runtime_1.jsxs)("div", Object.assign({ className: "tooltip-content", "data-testid": "tooltip-content" }, { children: [body, (0, jsx_runtime_1.jsx)("div", { className: "tooltip-arrow" })] })), children] })));
};
exports.Tooltip = Tooltip;
