"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.config = exports.HOUR_IN_MILLIS = exports.MINUTE_IN_MILLIS = void 0;
const wireJson = require('../../wire.json');
exports.MINUTE_IN_MILLIS = 60 * 1000;
exports.HOUR_IN_MILLIS = 60 * exports.MINUTE_IN_MILLIS;
const squirrelUpdateInterval = {
    DELAY: 5 * exports.MINUTE_IN_MILLIS,
    INTERVAL: 24 * exports.HOUR_IN_MILLIS,
};
var ARGUMENT;
(function (ARGUMENT) {
    ARGUMENT["DEVTOOLS"] = "devtools";
    ARGUMENT["ENV"] = "env";
    ARGUMENT["HIDDEN"] = "hidden";
    ARGUMENT["PORTABLE"] = "portable";
    ARGUMENT["PROXY_SERVER"] = "proxy-server";
    ARGUMENT["STARTUP"] = "startup";
    ARGUMENT["USER_DATA_DIR"] = "user_data_dir";
    ARGUMENT["VERSION"] = "version";
})(ARGUMENT || (ARGUMENT = {}));
exports.config = Object.assign(Object.assign({}, wireJson), { ARGUMENT, appUserModelId: `com.squirrel.wire.${wireJson.name.toLowerCase()}`, backendOrigins: ['https://staging-nginz-https.zinfra.io', 'https://prod-nginz-https.wire.com'], logFileName: 'console.log', maximumAccounts: parseInt(wireJson.maximumAccounts, 10), squirrelUpdateInterval, userAgent: 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.100 Safari/537.36' });
//# sourceMappingURL=config.js.map