"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const electron_1 = require("electron");
const path = __importStar(require("path"));
const webapp_events_1 = require("@wireapp/webapp-events");
const eventType_1 = require("../lib/eventType");
const getLogger_1 = require("../logging/getLogger");
const EnvironmentUtil = __importStar(require("../runtime/EnvironmentUtil"));
const remote = require('@electron/remote');
const logger = (0, getLogger_1.getLogger)(path.basename(__filename));
function subscribeToThemeChange() {
    function updateWebAppTheme() {
        if (webapp_events_1.WebAppEvents.PROPERTIES.UPDATE.INTERFACE) {
            const useDarkMode = remote.nativeTheme.shouldUseDarkColors;
            logger.info(`Switching dark mode ${useDarkMode ? 'on' : 'off'} ...`);
            window.amplify.publish(webapp_events_1.WebAppEvents.PROPERTIES.UPDATE.INTERFACE.USE_DARK_MODE, useDarkMode);
        }
    }
    function initialThemeCheck() {
        const useDarkMode = remote.nativeTheme.shouldUseDarkColors;
        logger.info(`Switching initial dark mode ${useDarkMode ? 'on' : 'off'} ...`);
        window.amplify.publish(webapp_events_1.WebAppEvents.PROPERTIES.UPDATE.INTERFACE.USE_DARK_MODE, useDarkMode);
        window.amplify.unsubscribe(webapp_events_1.WebAppEvents.LIFECYCLE.LOADED, initialThemeCheck);
    }
    window.amplify.subscribe(webapp_events_1.WebAppEvents.LIFECYCLE.LOADED, () => {
        electron_1.ipcRenderer.send(eventType_1.EVENT_TYPE.WEBAPP.APP_LOADED);
        initialThemeCheck();
    });
    remote.nativeTheme.on('updated', () => updateWebAppTheme());
}
electron_1.webFrame.setZoomFactor(1.0);
electron_1.webFrame.setVisualZoomLevelLimits(1, 1);
const subscribeToWebappEvents = () => {
    window.amplify.subscribe(webapp_events_1.WebAppEvents.LIFECYCLE.RESTART, () => {
        logger.info(`Received amplify event "${webapp_events_1.WebAppEvents.LIFECYCLE.RESTART}", forwarding event ...`);
        electron_1.ipcRenderer.send(eventType_1.EVENT_TYPE.WRAPPER.RELAUNCH);
    });
    window.amplify.subscribe(webapp_events_1.WebAppEvents.LIFECYCLE.LOADED, () => {
        logger.info(`Received amplify event "${webapp_events_1.WebAppEvents.LIFECYCLE.LOADED}", forwarding event ...`);
        electron_1.ipcRenderer.sendToHost(eventType_1.EVENT_TYPE.LIFECYCLE.SIGNED_IN);
    });
    window.amplify.subscribe(webapp_events_1.WebAppEvents.LIFECYCLE.SIGN_OUT, () => {
        logger.info(`Received amplify event "${webapp_events_1.WebAppEvents.LIFECYCLE.SIGN_OUT}", forwarding event ...`);
        electron_1.ipcRenderer.sendToHost(eventType_1.EVENT_TYPE.LIFECYCLE.SIGN_OUT);
    });
    window.amplify.subscribe(webapp_events_1.WebAppEvents.LIFECYCLE.SIGNED_OUT, (clearData) => {
        logger.info(`Received amplify event "${webapp_events_1.WebAppEvents.LIFECYCLE.SIGNED_OUT}", (clearData: "${clearData}") forwarding event ...`);
        electron_1.ipcRenderer.sendToHost(eventType_1.EVENT_TYPE.LIFECYCLE.SIGNED_OUT, clearData);
    });
    window.amplify.subscribe(webapp_events_1.WebAppEvents.LIFECYCLE.SSO_WINDOW_CLOSE, () => {
        logger.info(`Received amplify event "${webapp_events_1.WebAppEvents.LIFECYCLE.SSO_WINDOW_CLOSE}" event`);
        electron_1.ipcRenderer.send(webapp_events_1.WebAppEvents.LIFECYCLE.SSO_WINDOW_CLOSE);
    });
    window.amplify.subscribe(webapp_events_1.WebAppEvents.LIFECYCLE.SSO_WINDOW_FOCUS, () => {
        logger.info(`Received amplify event "${webapp_events_1.WebAppEvents.LIFECYCLE.SSO_WINDOW_FOCUS}" event`);
        electron_1.ipcRenderer.send(webapp_events_1.WebAppEvents.LIFECYCLE.SSO_WINDOW_FOCUS);
    });
    window.amplify.subscribe(webapp_events_1.WebAppEvents.LIFECYCLE.UNREAD_COUNT, (count) => {
        logger.info(`Received amplify event "${webapp_events_1.WebAppEvents.LIFECYCLE.UNREAD_COUNT}" (count: "${count}"), forwarding event ...`);
        electron_1.ipcRenderer.sendToHost(eventType_1.EVENT_TYPE.LIFECYCLE.UNREAD_COUNT, count);
    });
    window.amplify.subscribe(webapp_events_1.WebAppEvents.NOTIFICATION.CLICK, () => {
        logger.info(`Received amplify event "${webapp_events_1.WebAppEvents.NOTIFICATION.CLICK}", forwarding event ...`);
        electron_1.ipcRenderer.send(eventType_1.EVENT_TYPE.ACTION.NOTIFICATION_CLICK);
        electron_1.ipcRenderer.sendToHost(eventType_1.EVENT_TYPE.ACTION.NOTIFICATION_CLICK);
    });
    window.amplify.subscribe(webapp_events_1.WebAppEvents.TEAM.INFO, (info) => {
        const debugInfo = Object.assign(Object.assign({}, info), { picture: typeof info.picture === 'string' ? `${info.picture.substring(0, 100)}...` : '' });
        logger.info(`Received amplify event "${webapp_events_1.WebAppEvents.TEAM.INFO}":`, `"${JSON.stringify(debugInfo)}", forwarding event ...`);
        electron_1.ipcRenderer.sendToHost(eventType_1.EVENT_TYPE.ACCOUNT.UPDATE_INFO, info);
    });
    window.addEventListener(webapp_events_1.WebAppEvents.LIFECYCLE.CHANGE_ENVIRONMENT, event => {
        const data = event.detail;
        if (data) {
            electron_1.ipcRenderer.sendToHost(eventType_1.EVENT_TYPE.WRAPPER.NAVIGATE_WEBVIEW, data.url);
        }
    });
    window.amplify.subscribe(webapp_events_1.WebAppEvents.PROPERTIES.UPDATE.INTERFACE.THEME, (theme) => {
        electron_1.ipcRenderer.sendToHost(eventType_1.EVENT_TYPE.UI.THEME_UPDATE, theme);
    });
    window.amplify.subscribe(webapp_events_1.WebAppEvents.PROPERTIES.UPDATED, (properties) => {
        electron_1.ipcRenderer.sendToHost(eventType_1.EVENT_TYPE.UI.THEME_UPDATE, properties.settings.interface.theme);
    });
};
const subscribeToMainProcessEvents = () => {
    electron_1.ipcRenderer.on(eventType_1.EVENT_TYPE.CONVERSATION.ADD_PEOPLE, () => {
        logger.info(`Received event "${eventType_1.EVENT_TYPE.CONVERSATION.ADD_PEOPLE}", forwarding to amplify ...`);
        window.amplify.publish(webapp_events_1.WebAppEvents.SHORTCUT.ADD_PEOPLE);
    });
    electron_1.ipcRenderer.on(eventType_1.EVENT_TYPE.CONVERSATION.ARCHIVE, () => {
        logger.info(`Received event "${eventType_1.EVENT_TYPE.CONVERSATION.ARCHIVE}", forwarding to amplify ...`);
        window.amplify.publish(webapp_events_1.WebAppEvents.SHORTCUT.ARCHIVE);
    });
    electron_1.ipcRenderer.on(eventType_1.EVENT_TYPE.CONVERSATION.CALL, () => {
        logger.info(`Received event "${eventType_1.EVENT_TYPE.CONVERSATION.CALL}", forwarding to amplify ...`);
        window.amplify.publish(webapp_events_1.WebAppEvents.CALL.STATE.TOGGLE, false);
    });
    electron_1.ipcRenderer.on(eventType_1.EVENT_TYPE.CONVERSATION.DELETE, () => {
        logger.info(`Received event "${eventType_1.EVENT_TYPE.CONVERSATION.DELETE}", forwarding to amplify ...`);
        window.amplify.publish(webapp_events_1.WebAppEvents.SHORTCUT.DELETE);
    });
    electron_1.ipcRenderer.on(eventType_1.EVENT_TYPE.CONVERSATION.SHOW_NEXT, () => {
        logger.info(`Received event "${eventType_1.EVENT_TYPE.CONVERSATION.SHOW_NEXT}", forwarding to amplify ...`);
        window.amplify.publish(webapp_events_1.WebAppEvents.SHORTCUT.NEXT);
    });
    electron_1.ipcRenderer.on(eventType_1.EVENT_TYPE.CONVERSATION.PEOPLE, () => {
        logger.info(`Received event "${eventType_1.EVENT_TYPE.CONVERSATION.PEOPLE}", forwarding to amplify ...`);
        window.amplify.publish(webapp_events_1.WebAppEvents.SHORTCUT.PEOPLE);
    });
    electron_1.ipcRenderer.on(eventType_1.EVENT_TYPE.CONVERSATION.PING, () => {
        logger.info(`Received event "${eventType_1.EVENT_TYPE.CONVERSATION.PING}", forwarding to amplify ...`);
        window.amplify.publish(webapp_events_1.WebAppEvents.SHORTCUT.PING);
    });
    electron_1.ipcRenderer.on(eventType_1.EVENT_TYPE.CONVERSATION.SHOW_PREVIOUS, () => {
        logger.info(`Received event "${eventType_1.EVENT_TYPE.CONVERSATION.SHOW_PREVIOUS}", forwarding to amplify ...`);
        window.amplify.publish(webapp_events_1.WebAppEvents.SHORTCUT.PREV);
    });
    electron_1.ipcRenderer.on(eventType_1.EVENT_TYPE.WEBAPP.CHANGE_LOCATION_HASH, (_event, hash) => {
        logger.info(`Received event "${eventType_1.EVENT_TYPE.WEBAPP.CHANGE_LOCATION_HASH}" (hash: "${hash}"), forwarding to amplify ...`);
        window.location.hash = hash;
    });
    electron_1.ipcRenderer.on(eventType_1.EVENT_TYPE.CONVERSATION.TOGGLE_MUTE, () => {
        logger.info(`Received event "${eventType_1.EVENT_TYPE.CONVERSATION.TOGGLE_MUTE}", forwarding to amplify ...`);
        window.amplify.publish(webapp_events_1.WebAppEvents.SHORTCUT.SILENCE);
    });
    electron_1.ipcRenderer.on(eventType_1.EVENT_TYPE.CONVERSATION.START, () => {
        logger.info(`Received event "${eventType_1.EVENT_TYPE.CONVERSATION.START}", forwarding to amplify ...`);
        window.amplify.publish(webapp_events_1.WebAppEvents.SHORTCUT.START);
    });
    electron_1.ipcRenderer.on(eventType_1.EVENT_TYPE.CONVERSATION.VIDEO_CALL, () => {
        logger.info(`Received event "${eventType_1.EVENT_TYPE.CONVERSATION.VIDEO_CALL}", forwarding to amplify ...`);
        window.amplify.publish(webapp_events_1.WebAppEvents.CALL.STATE.TOGGLE, true);
    });
    electron_1.ipcRenderer.on(eventType_1.EVENT_TYPE.PREFERENCES.SHOW, () => {
        logger.info(`Received event "${eventType_1.EVENT_TYPE.PREFERENCES.SHOW}", forwarding to amplify ...`);
        window.amplify.publish(webapp_events_1.WebAppEvents.PREFERENCES.MANAGE_ACCOUNT);
    });
    electron_1.ipcRenderer.on(eventType_1.EVENT_TYPE.ACTION.SIGN_OUT, () => {
        logger.info(`Received event "${eventType_1.EVENT_TYPE.ACTION.SIGN_OUT}", forwarding to amplify ...`);
        window.amplify.publish(webapp_events_1.WebAppEvents.LIFECYCLE.ASK_TO_CLEAR_DATA);
    });
    electron_1.ipcRenderer.on(eventType_1.EVENT_TYPE.WRAPPER.UPDATE_AVAILABLE, () => {
        logger.info(`Received event "${eventType_1.EVENT_TYPE.WRAPPER.UPDATE_AVAILABLE}", forwarding to amplify ...`);
        window.amplify.publish(webapp_events_1.WebAppEvents.LIFECYCLE.UPDATE, window.z.lifecycle.UPDATE_SOURCE.DESKTOP);
    });
    electron_1.ipcRenderer.on(webapp_events_1.WebAppEvents.LIFECYCLE.SSO_WINDOW_CLOSED, () => {
        logger.info(`Received event "${webapp_events_1.WebAppEvents.LIFECYCLE.SSO_WINDOW_CLOSED}", forwarding to window ...`);
        window.amplify.publish(webapp_events_1.WebAppEvents.LIFECYCLE.SSO_WINDOW_CLOSED);
    });
    electron_1.ipcRenderer.on(eventType_1.EVENT_TYPE.ACTION.JOIN_CONVERSATION, (_event, { code, key }) => {
        logger.info(`Received event "${eventType_1.EVENT_TYPE.ACTION.JOIN_CONVERSATION}", forwarding to host ...`);
        electron_1.ipcRenderer.sendToHost(eventType_1.EVENT_TYPE.ACTION.JOIN_CONVERSATION, { code, key });
    });
    electron_1.ipcRenderer.on(webapp_events_1.WebAppEvents.CONVERSATION.JOIN, (_event, { code, key }) => {
        logger.info(`Received event "${webapp_events_1.WebAppEvents.CONVERSATION.JOIN}", forwarding to window ...`);
        window.dispatchEvent(new CustomEvent(webapp_events_1.WebAppEvents.CONVERSATION.JOIN, { detail: { code, key } }));
    });
};
function getOpenGraphDataViaChannel(url) {
    return electron_1.ipcRenderer.invoke(eventType_1.EVENT_TYPE.ACTION.GET_OG_DATA, url);
}
function reportWebappVersion() {
    electron_1.ipcRenderer.send(eventType_1.EVENT_TYPE.UI.WEBAPP_VERSION, window.z.util.Environment.version(false));
}
const _clearImmediate = clearImmediate;
const _setImmediate = setImmediate;
process.once('loaded', () => {
    global.clearImmediate = _clearImmediate;
    global.desktopCapturer = {
        getDesktopSources: opts => electron_1.ipcRenderer.invoke(eventType_1.EVENT_TYPE.ACTION.GET_DESKTOP_SOURCES, opts),
    };
    global.systemCrypto = {
        decrypt: (encrypted) => __awaiter(void 0, void 0, void 0, function* () {
            return electron_1.ipcRenderer.invoke(eventType_1.EVENT_TYPE.ACTION.DECRYPT, encrypted);
        }),
        encrypt: (value) => {
            return electron_1.ipcRenderer.invoke(eventType_1.EVENT_TYPE.ACTION.ENCRYPT, value);
        },
        version: 1,
    };
    global.environment = EnvironmentUtil;
    global.openGraphAsync = getOpenGraphDataViaChannel;
    global.setImmediate = _setImmediate;
});
const registerEvents = () => {
    return new Promise(resolve => {
        const HALF_SECOND_IN_MILLIS = 500;
        const intervalId = setInterval(() => {
            var _a;
            logger.info('Attempting to register event handlers...');
            if (window.amplify && window.wire && ((_a = window.z) === null || _a === void 0 ? void 0 : _a.event)) {
                clearInterval(intervalId);
                return resolve();
            }
        }, HALF_SECOND_IN_MILLIS);
    });
};
window.addEventListener('DOMContentLoaded', () => __awaiter(void 0, void 0, void 0, function* () {
    yield registerEvents();
    logger.info('Registering event handlers');
    subscribeToMainProcessEvents();
    subscribeToThemeChange();
    subscribeToWebappEvents();
    reportWebappVersion();
    yield Promise.resolve().then(() => __importStar(require('./menu/preload-context')));
}));
window.close = () => { };
//# sourceMappingURL=preload-webview.js.map