/*
 * Copyright (C) 2011-2012 Robin Burchell <robin+mer@viroteck.net>
 * Copyright (C) 2021-2023 Chupligin Sergey <neochapay@gmail.com>
 * You may use this file under the terms of the BSD license as follows:
 *
 * "Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *   * Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *   * Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in
 *     the documentation and/or other materials provided with the
 *     distribution.
 *   * Neither the name of Nemo Mobile nor the names of its contributors
 *     may be used to endorse or promote products derived from this
 *     software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
 */

import QtQuick
import QtQuick.Controls

import Nemo
import Nemo.Controls

import Nemo.Thumbnailer 1.0
import org.nemomobile.contacts 1.0

Image {
    id: avatarImage
    fillMode: Image.PreserveAspectCrop
    asynchronous: true
    width: Theme.itemHeightSmall
    height: Theme.itemHeightSmall
    property Person contact
    property string fullSource
    source: compute_avatar_path(((contact == undefined) || (contact == null) || contact.avatarPath === undefined) ? "" : contact.avatarPath)
    sourceSize.width: width
    sourceSize.height: width

    function compute_avatar_path(path) {
        if ((path === "")
                || (path === "image://theme/user")
                || (path === "image://theme/icon-m-telephony-contact-avatar")) {
            return "image://theme/user"
        }
        if (String(contact.avatarPath).startsWith("image://")) { // don't add thumbnail if already image provider
            return path;
        }
        return "image://nemothumbnail/" + path;
    }

    onStatusChanged: {
        if (status == Image.Error || status == Image.Null) {
             contact.avatarPath = ""
        }
    }
}
