/* postal-address-details.c generated by valac 0.12.0, the Vala compiler
 * generated from postal-address-details.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Marco Barisione <marco.barisione@collabora.co.uk>
 *       Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define FOLKS_TYPE_POSTAL_ADDRESS (folks_postal_address_get_type ())
#define FOLKS_POSTAL_ADDRESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_POSTAL_ADDRESS, FolksPostalAddress))
#define FOLKS_POSTAL_ADDRESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_POSTAL_ADDRESS, FolksPostalAddressClass))
#define FOLKS_IS_POSTAL_ADDRESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_POSTAL_ADDRESS))
#define FOLKS_IS_POSTAL_ADDRESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_POSTAL_ADDRESS))
#define FOLKS_POSTAL_ADDRESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_POSTAL_ADDRESS, FolksPostalAddressClass))

typedef struct _FolksPostalAddress FolksPostalAddress;
typedef struct _FolksPostalAddressClass FolksPostalAddressClass;
typedef struct _FolksPostalAddressPrivate FolksPostalAddressPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))

#define FOLKS_TYPE_POSTAL_ADDRESS_DETAILS (folks_postal_address_details_get_type ())
#define FOLKS_POSTAL_ADDRESS_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_POSTAL_ADDRESS_DETAILS, FolksPostalAddressDetails))
#define FOLKS_IS_POSTAL_ADDRESS_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_POSTAL_ADDRESS_DETAILS))
#define FOLKS_POSTAL_ADDRESS_DETAILS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_POSTAL_ADDRESS_DETAILS, FolksPostalAddressDetailsIface))

typedef struct _FolksPostalAddressDetails FolksPostalAddressDetails;
typedef struct _FolksPostalAddressDetailsIface FolksPostalAddressDetailsIface;

struct _FolksPostalAddress {
	GObject parent_instance;
	FolksPostalAddressPrivate * priv;
};

struct _FolksPostalAddressClass {
	GObjectClass parent_class;
};

struct _FolksPostalAddressPrivate {
	gchar* _po_box;
	gchar* _extension;
	gchar* _street;
	gchar* _locality;
	gchar* _region;
	gchar* _postal_code;
	gchar* _country;
	gchar* _address_format;
	GList* _types;
	gchar* _uid;
};

struct _FolksPostalAddressDetailsIface {
	GTypeInterface parent_iface;
	GList* (*get_postal_addresses) (FolksPostalAddressDetails* self);
	void (*set_postal_addresses) (FolksPostalAddressDetails* self, GList* value);
};


static gpointer folks_postal_address_parent_class = NULL;

GType folks_postal_address_get_type (void) G_GNUC_CONST;
#define FOLKS_POSTAL_ADDRESS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_TYPE_POSTAL_ADDRESS, FolksPostalAddressPrivate))
enum  {
	FOLKS_POSTAL_ADDRESS_DUMMY_PROPERTY,
	FOLKS_POSTAL_ADDRESS_PO_BOX,
	FOLKS_POSTAL_ADDRESS_EXTENSION,
	FOLKS_POSTAL_ADDRESS_STREET,
	FOLKS_POSTAL_ADDRESS_LOCALITY,
	FOLKS_POSTAL_ADDRESS_REGION,
	FOLKS_POSTAL_ADDRESS_POSTAL_CODE,
	FOLKS_POSTAL_ADDRESS_COUNTRY,
	FOLKS_POSTAL_ADDRESS_ADDRESS_FORMAT,
	FOLKS_POSTAL_ADDRESS_TYPES,
	FOLKS_POSTAL_ADDRESS_UID
};
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
FolksPostalAddress* folks_postal_address_new (const gchar* po_box, const gchar* extension, const gchar* street, const gchar* locality, const gchar* region, const gchar* postal_code, const gchar* country, const gchar* address_format, GList* types, const gchar* uid);
FolksPostalAddress* folks_postal_address_construct (GType object_type, const gchar* po_box, const gchar* extension, const gchar* street, const gchar* locality, const gchar* region, const gchar* postal_code, const gchar* country, const gchar* address_format, GList* types, const gchar* uid);
gboolean folks_postal_address_equal (FolksPostalAddress* self, FolksPostalAddress* with);
const gchar* folks_postal_address_get_po_box (FolksPostalAddress* self);
const gchar* folks_postal_address_get_extension (FolksPostalAddress* self);
const gchar* folks_postal_address_get_street (FolksPostalAddress* self);
const gchar* folks_postal_address_get_locality (FolksPostalAddress* self);
const gchar* folks_postal_address_get_region (FolksPostalAddress* self);
const gchar* folks_postal_address_get_postal_code (FolksPostalAddress* self);
const gchar* folks_postal_address_get_country (FolksPostalAddress* self);
const gchar* folks_postal_address_get_address_format (FolksPostalAddress* self);
GList* folks_postal_address_get_types (FolksPostalAddress* self);
const gchar* folks_postal_address_get_uid (FolksPostalAddress* self);
gchar* folks_postal_address_to_string (FolksPostalAddress* self);
void folks_postal_address_set_po_box (FolksPostalAddress* self, const gchar* value);
void folks_postal_address_set_extension (FolksPostalAddress* self, const gchar* value);
void folks_postal_address_set_street (FolksPostalAddress* self, const gchar* value);
void folks_postal_address_set_locality (FolksPostalAddress* self, const gchar* value);
void folks_postal_address_set_region (FolksPostalAddress* self, const gchar* value);
void folks_postal_address_set_postal_code (FolksPostalAddress* self, const gchar* value);
void folks_postal_address_set_country (FolksPostalAddress* self, const gchar* value);
void folks_postal_address_set_address_format (FolksPostalAddress* self, const gchar* value);
void folks_postal_address_set_types (FolksPostalAddress* self, GList* value);
void folks_postal_address_set_uid (FolksPostalAddress* self, const gchar* value);
static void folks_postal_address_finalize (GObject* obj);
static void _vala_folks_postal_address_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_folks_postal_address_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType folks_postal_address_details_get_type (void) G_GNUC_CONST;
GList* folks_postal_address_details_get_postal_addresses (FolksPostalAddressDetails* self);
void folks_postal_address_details_set_postal_addresses (FolksPostalAddressDetails* self, GList* value);


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


/**
   * Create a PostalAddress.
   *
   * You can pass `null` if a component is not set.
   *
   * @param po_box the PO Box
   * @param extension the address extension
   * @param street the street name and number
   * @param locality the locality (city, town or village) name
   * @param region the region (state or province) name
   * @param postal_code the postal code
   * @param address_format the address format
   */
FolksPostalAddress* folks_postal_address_construct (GType object_type, const gchar* po_box, const gchar* extension, const gchar* street, const gchar* locality, const gchar* region, const gchar* postal_code, const gchar* country, const gchar* address_format, GList* types, const gchar* uid) {
	FolksPostalAddress * self = NULL;
	self = (FolksPostalAddress*) g_object_new (object_type, "po-box", po_box, "extension", extension, "street", street, "locality", locality, "region", region, "postal-code", postal_code, "country", country, "address-format", address_format, "types", types, "uid", uid, NULL);
	return self;
}


FolksPostalAddress* folks_postal_address_new (const gchar* po_box, const gchar* extension, const gchar* street, const gchar* locality, const gchar* region, const gchar* postal_code, const gchar* country, const gchar* address_format, GList* types, const gchar* uid) {
	return folks_postal_address_construct (FOLKS_TYPE_POSTAL_ADDRESS, po_box, extension, street, locality, region, postal_code, country, address_format, types, uid);
}


gboolean folks_postal_address_equal (FolksPostalAddress* self, FolksPostalAddress* with) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (with != NULL, FALSE);
	_tmp9_ = folks_postal_address_get_po_box (self);
	_tmp10_ = folks_postal_address_get_po_box (with);
	if (g_strcmp0 (_tmp9_, _tmp10_) != 0) {
		_tmp8_ = TRUE;
	} else {
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		_tmp11_ = folks_postal_address_get_extension (self);
		_tmp12_ = folks_postal_address_get_extension (with);
		_tmp8_ = g_strcmp0 (_tmp11_, _tmp12_) != 0;
	}
	if (_tmp8_) {
		_tmp7_ = TRUE;
	} else {
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		_tmp13_ = folks_postal_address_get_street (self);
		_tmp14_ = folks_postal_address_get_street (with);
		_tmp7_ = g_strcmp0 (_tmp13_, _tmp14_) != 0;
	}
	if (_tmp7_) {
		_tmp6_ = TRUE;
	} else {
		const gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		_tmp15_ = folks_postal_address_get_locality (self);
		_tmp16_ = folks_postal_address_get_locality (with);
		_tmp6_ = g_strcmp0 (_tmp15_, _tmp16_) != 0;
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		const gchar* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		_tmp17_ = folks_postal_address_get_region (self);
		_tmp18_ = folks_postal_address_get_region (with);
		_tmp5_ = g_strcmp0 (_tmp17_, _tmp18_) != 0;
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		_tmp19_ = folks_postal_address_get_postal_code (self);
		_tmp20_ = folks_postal_address_get_postal_code (with);
		_tmp4_ = g_strcmp0 (_tmp19_, _tmp20_) != 0;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		_tmp21_ = folks_postal_address_get_country (self);
		_tmp22_ = folks_postal_address_get_country (with);
		_tmp3_ = g_strcmp0 (_tmp21_, _tmp22_) != 0;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		_tmp23_ = folks_postal_address_get_address_format (self);
		_tmp24_ = folks_postal_address_get_address_format (with);
		_tmp2_ = g_strcmp0 (_tmp23_, _tmp24_) != 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		GList* _tmp25_ = NULL;
		guint _tmp26_;
		GList* _tmp27_ = NULL;
		guint _tmp28_;
		_tmp25_ = folks_postal_address_get_types (self);
		_tmp26_ = g_list_length (_tmp25_);
		_tmp27_ = folks_postal_address_get_types (with);
		_tmp28_ = g_list_length (_tmp27_);
		_tmp1_ = _tmp26_ != _tmp28_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
		_tmp29_ = folks_postal_address_get_uid (self);
		_tmp30_ = folks_postal_address_get_uid (with);
		_tmp0_ = g_strcmp0 (_tmp29_, _tmp30_) != 0;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp31_;
			_tmp31_ = TRUE;
			while (TRUE) {
				GList* _tmp32_ = NULL;
				guint _tmp33_;
				GList* _tmp34_ = NULL;
				gconstpointer _tmp35_ = NULL;
				GList* _tmp36_ = NULL;
				gconstpointer _tmp37_ = NULL;
				if (!_tmp31_) {
					i++;
				}
				_tmp31_ = FALSE;
				_tmp32_ = folks_postal_address_get_types (self);
				_tmp33_ = g_list_length (_tmp32_);
				if (!(i < _tmp33_)) {
					break;
				}
				_tmp34_ = folks_postal_address_get_types (self);
				_tmp35_ = g_list_nth_data (_tmp34_, (guint) i);
				_tmp36_ = folks_postal_address_get_types (with);
				_tmp37_ = g_list_nth_data (_tmp36_, (guint) i);
				if (g_strcmp0 ((const gchar*) _tmp35_, (const gchar*) _tmp37_) != 0) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}


/**
   * Returns a formatted address.
   *
   * @since 0.4.0
   */
gchar* folks_postal_address_to_string (FolksPostalAddress* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* str;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _ ("%s, %s, %s, %s, %s, %s, %s");
	_tmp1_ = g_strdup (_tmp0_);
	str = _tmp1_;
	_tmp2_ = folks_postal_address_get_po_box (self);
	_tmp3_ = folks_postal_address_get_extension (self);
	_tmp4_ = folks_postal_address_get_street (self);
	_tmp5_ = folks_postal_address_get_locality (self);
	_tmp6_ = folks_postal_address_get_region (self);
	_tmp7_ = folks_postal_address_get_postal_code (self);
	_tmp8_ = folks_postal_address_get_country (self);
	_tmp9_ = g_strdup_printf (str, _tmp2_, _tmp3_, _tmp4_, _tmp5_, _tmp6_, _tmp7_, _tmp8_);
	result = _tmp9_;
	_g_free0 (str);
	return result;
}


const gchar* folks_postal_address_get_po_box (FolksPostalAddress* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_po_box;
	return result;
}


void folks_postal_address_set_po_box (FolksPostalAddress* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		_tmp0_ = value;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_po_box);
	self->priv->_po_box = _tmp1_;
	g_object_notify ((GObject *) self, "po-box");
}


const gchar* folks_postal_address_get_extension (FolksPostalAddress* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_extension;
	return result;
}


void folks_postal_address_set_extension (FolksPostalAddress* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		_tmp0_ = value;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_extension);
	self->priv->_extension = _tmp1_;
	g_object_notify ((GObject *) self, "extension");
}


const gchar* folks_postal_address_get_street (FolksPostalAddress* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_street;
	return result;
}


void folks_postal_address_set_street (FolksPostalAddress* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		_tmp0_ = value;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_street);
	self->priv->_street = _tmp1_;
	g_object_notify ((GObject *) self, "street");
}


const gchar* folks_postal_address_get_locality (FolksPostalAddress* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_locality;
	return result;
}


void folks_postal_address_set_locality (FolksPostalAddress* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		_tmp0_ = value;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_locality);
	self->priv->_locality = _tmp1_;
	g_object_notify ((GObject *) self, "locality");
}


const gchar* folks_postal_address_get_region (FolksPostalAddress* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_region;
	return result;
}


void folks_postal_address_set_region (FolksPostalAddress* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		_tmp0_ = value;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_region);
	self->priv->_region = _tmp1_;
	g_object_notify ((GObject *) self, "region");
}


const gchar* folks_postal_address_get_postal_code (FolksPostalAddress* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_postal_code;
	return result;
}


void folks_postal_address_set_postal_code (FolksPostalAddress* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		_tmp0_ = value;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_postal_code);
	self->priv->_postal_code = _tmp1_;
	g_object_notify ((GObject *) self, "postal-code");
}


const gchar* folks_postal_address_get_country (FolksPostalAddress* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_country;
	return result;
}


void folks_postal_address_set_country (FolksPostalAddress* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		_tmp0_ = value;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_country);
	self->priv->_country = _tmp1_;
	g_object_notify ((GObject *) self, "country");
}


const gchar* folks_postal_address_get_address_format (FolksPostalAddress* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_address_format;
	return result;
}


void folks_postal_address_set_address_format (FolksPostalAddress* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		_tmp0_ = value;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_address_format);
	self->priv->_address_format = _tmp1_;
	g_object_notify ((GObject *) self, "address-format");
}


GList* folks_postal_address_get_types (FolksPostalAddress* self) {
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_types;
	return result;
}


void folks_postal_address_set_types (FolksPostalAddress* self, GList* value) {
	g_return_if_fail (self != NULL);
	__g_list_free__g_free0_0 (self->priv->_types);
	self->priv->_types = NULL;
	{
		GList* type_collection;
		GList* type_it;
		type_collection = value;
		for (type_it = type_collection; type_it != NULL; type_it = type_it->next) {
			const gchar* type;
			type = (const gchar*) type_it->data;
			{
				gchar* _tmp0_;
				_tmp0_ = g_strdup (type);
				self->priv->_types = g_list_prepend (self->priv->_types, _tmp0_);
			}
		}
	}
	self->priv->_types = g_list_reverse (self->priv->_types);
	g_object_notify ((GObject *) self, "types");
}


const gchar* folks_postal_address_get_uid (FolksPostalAddress* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_uid;
	return result;
}


void folks_postal_address_set_uid (FolksPostalAddress* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		_tmp0_ = value;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_uid);
	self->priv->_uid = _tmp1_;
	g_object_notify ((GObject *) self, "uid");
}


static void folks_postal_address_class_init (FolksPostalAddressClass * klass) {
	folks_postal_address_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksPostalAddressPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_postal_address_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_postal_address_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_postal_address_finalize;
	/**
	   * The PO Box.
	   *
	   * The PO Box (also known as Postal office box or Postal box).
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_POSTAL_ADDRESS_PO_BOX, g_param_spec_string ("po-box", "po-box", "po-box", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The address extension.
	   *
	   * Any additional part of the address, for instance a flat number.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_POSTAL_ADDRESS_EXTENSION, g_param_spec_string ("extension", "extension", "extension", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The street name and number.
	   *
	   * The street name including the optional building number.
	   * The number can be before or after the street name based on the
	   * language and country.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_POSTAL_ADDRESS_STREET, g_param_spec_string ("street", "street", "street", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The locality.
	   *
	   * The locality, for instance the city name.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_POSTAL_ADDRESS_LOCALITY, g_param_spec_string ("locality", "locality", "locality", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The region.
	   *
	   * The region, for instance the name of the state or province.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_POSTAL_ADDRESS_REGION, g_param_spec_string ("region", "region", "region", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The postal code.
	   *
	   * The postal code (also known as post code, postcode or ZIP code).
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_POSTAL_ADDRESS_POSTAL_CODE, g_param_spec_string ("postal-code", "postal-code", "postal-code", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The country.
	   *
	   * The name of the country.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_POSTAL_ADDRESS_COUNTRY, g_param_spec_string ("country", "country", "country", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The address format.
	   *
	   * The two letter country code that determines the format or exact
	   * meaning of the other fields.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_POSTAL_ADDRESS_ADDRESS_FORMAT, g_param_spec_string ("address-format", "address-format", "address-format", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The types of the address.
	   *
	   * The types of address, for instance an address can be a home or work
	   * address.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_POSTAL_ADDRESS_TYPES, g_param_spec_pointer ("types", "types", "types", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The UID of the Postal Address (if any).
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_POSTAL_ADDRESS_UID, g_param_spec_string ("uid", "uid", "uid", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void folks_postal_address_instance_init (FolksPostalAddress * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	self->priv = FOLKS_POSTAL_ADDRESS_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("");
	self->priv->_po_box = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_extension = _tmp1_;
	_tmp2_ = g_strdup ("");
	self->priv->_street = _tmp2_;
	_tmp3_ = g_strdup ("");
	self->priv->_locality = _tmp3_;
	_tmp4_ = g_strdup ("");
	self->priv->_region = _tmp4_;
	_tmp5_ = g_strdup ("");
	self->priv->_postal_code = _tmp5_;
	_tmp6_ = g_strdup ("");
	self->priv->_country = _tmp6_;
	_tmp7_ = g_strdup ("");
	self->priv->_address_format = _tmp7_;
	_tmp8_ = g_strdup ("");
	self->priv->_uid = _tmp8_;
}


static void folks_postal_address_finalize (GObject* obj) {
	FolksPostalAddress * self;
	self = FOLKS_POSTAL_ADDRESS (obj);
	_g_free0 (self->priv->_po_box);
	_g_free0 (self->priv->_extension);
	_g_free0 (self->priv->_street);
	_g_free0 (self->priv->_locality);
	_g_free0 (self->priv->_region);
	_g_free0 (self->priv->_postal_code);
	_g_free0 (self->priv->_country);
	_g_free0 (self->priv->_address_format);
	__g_list_free__g_free0_0 (self->priv->_types);
	_g_free0 (self->priv->_uid);
	G_OBJECT_CLASS (folks_postal_address_parent_class)->finalize (obj);
}


/**
 * Object representing a postal mail address.
 * The components of the address are never null, an empty string
 * indicates that a property is not set.
 */
GType folks_postal_address_get_type (void) {
	static volatile gsize folks_postal_address_type_id__volatile = 0;
	if (g_once_init_enter (&folks_postal_address_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksPostalAddressClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_postal_address_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksPostalAddress), 0, (GInstanceInitFunc) folks_postal_address_instance_init, NULL };
		GType folks_postal_address_type_id;
		folks_postal_address_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksPostalAddress", &g_define_type_info, 0);
		g_once_init_leave (&folks_postal_address_type_id__volatile, folks_postal_address_type_id);
	}
	return folks_postal_address_type_id__volatile;
}


static void _vala_folks_postal_address_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksPostalAddress * self;
	self = FOLKS_POSTAL_ADDRESS (object);
	switch (property_id) {
		case FOLKS_POSTAL_ADDRESS_PO_BOX:
		g_value_set_string (value, folks_postal_address_get_po_box (self));
		break;
		case FOLKS_POSTAL_ADDRESS_EXTENSION:
		g_value_set_string (value, folks_postal_address_get_extension (self));
		break;
		case FOLKS_POSTAL_ADDRESS_STREET:
		g_value_set_string (value, folks_postal_address_get_street (self));
		break;
		case FOLKS_POSTAL_ADDRESS_LOCALITY:
		g_value_set_string (value, folks_postal_address_get_locality (self));
		break;
		case FOLKS_POSTAL_ADDRESS_REGION:
		g_value_set_string (value, folks_postal_address_get_region (self));
		break;
		case FOLKS_POSTAL_ADDRESS_POSTAL_CODE:
		g_value_set_string (value, folks_postal_address_get_postal_code (self));
		break;
		case FOLKS_POSTAL_ADDRESS_COUNTRY:
		g_value_set_string (value, folks_postal_address_get_country (self));
		break;
		case FOLKS_POSTAL_ADDRESS_ADDRESS_FORMAT:
		g_value_set_string (value, folks_postal_address_get_address_format (self));
		break;
		case FOLKS_POSTAL_ADDRESS_TYPES:
		g_value_set_pointer (value, folks_postal_address_get_types (self));
		break;
		case FOLKS_POSTAL_ADDRESS_UID:
		g_value_set_string (value, folks_postal_address_get_uid (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_folks_postal_address_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksPostalAddress * self;
	self = FOLKS_POSTAL_ADDRESS (object);
	switch (property_id) {
		case FOLKS_POSTAL_ADDRESS_PO_BOX:
		folks_postal_address_set_po_box (self, g_value_get_string (value));
		break;
		case FOLKS_POSTAL_ADDRESS_EXTENSION:
		folks_postal_address_set_extension (self, g_value_get_string (value));
		break;
		case FOLKS_POSTAL_ADDRESS_STREET:
		folks_postal_address_set_street (self, g_value_get_string (value));
		break;
		case FOLKS_POSTAL_ADDRESS_LOCALITY:
		folks_postal_address_set_locality (self, g_value_get_string (value));
		break;
		case FOLKS_POSTAL_ADDRESS_REGION:
		folks_postal_address_set_region (self, g_value_get_string (value));
		break;
		case FOLKS_POSTAL_ADDRESS_POSTAL_CODE:
		folks_postal_address_set_postal_code (self, g_value_get_string (value));
		break;
		case FOLKS_POSTAL_ADDRESS_COUNTRY:
		folks_postal_address_set_country (self, g_value_get_string (value));
		break;
		case FOLKS_POSTAL_ADDRESS_ADDRESS_FORMAT:
		folks_postal_address_set_address_format (self, g_value_get_string (value));
		break;
		case FOLKS_POSTAL_ADDRESS_TYPES:
		folks_postal_address_set_types (self, g_value_get_pointer (value));
		break;
		case FOLKS_POSTAL_ADDRESS_UID:
		folks_postal_address_set_uid (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GList* folks_postal_address_details_get_postal_addresses (FolksPostalAddressDetails* self) {
	return FOLKS_POSTAL_ADDRESS_DETAILS_GET_INTERFACE (self)->get_postal_addresses (self);
}


void folks_postal_address_details_set_postal_addresses (FolksPostalAddressDetails* self, GList* value) {
	FOLKS_POSTAL_ADDRESS_DETAILS_GET_INTERFACE (self)->set_postal_addresses (self, value);
}


static void folks_postal_address_details_base_init (FolksPostalAddressDetailsIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		/**
		   * The postal addresses of the contact.
		   *
		   * A list of postal addresses associated to the contact.
		   */
		g_object_interface_install_property (iface, g_param_spec_pointer ("postal-addresses", "postal-addresses", "postal-addresses", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	}
}


/**
 * Interface for classes that can provide postal addresses, such as
 * {@link Persona} and {@link Individual}.
 */
GType folks_postal_address_details_get_type (void) {
	static volatile gsize folks_postal_address_details_type_id__volatile = 0;
	if (g_once_init_enter (&folks_postal_address_details_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksPostalAddressDetailsIface), (GBaseInitFunc) folks_postal_address_details_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType folks_postal_address_details_type_id;
		folks_postal_address_details_type_id = g_type_register_static (G_TYPE_INTERFACE, "FolksPostalAddressDetails", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (folks_postal_address_details_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&folks_postal_address_details_type_id__volatile, folks_postal_address_details_type_id);
	}
	return folks_postal_address_details_type_id__volatile;
}



