/* individual-aggregator.c generated by valac 0.12.0, the Vala compiler
 * generated from individual-aggregator.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define FOLKS_TYPE_INDIVIDUAL_AGGREGATOR (folks_individual_aggregator_get_type ())
#define FOLKS_INDIVIDUAL_AGGREGATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, FolksIndividualAggregator))
#define FOLKS_INDIVIDUAL_AGGREGATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, FolksIndividualAggregatorClass))
#define FOLKS_IS_INDIVIDUAL_AGGREGATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_INDIVIDUAL_AGGREGATOR))
#define FOLKS_IS_INDIVIDUAL_AGGREGATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_INDIVIDUAL_AGGREGATOR))
#define FOLKS_INDIVIDUAL_AGGREGATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, FolksIndividualAggregatorClass))

typedef struct _FolksIndividualAggregator FolksIndividualAggregator;
typedef struct _FolksIndividualAggregatorClass FolksIndividualAggregatorClass;
typedef struct _FolksIndividualAggregatorPrivate FolksIndividualAggregatorPrivate;

#define FOLKS_TYPE_BACKEND_STORE (folks_backend_store_get_type ())
#define FOLKS_BACKEND_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_BACKEND_STORE, FolksBackendStore))
#define FOLKS_BACKEND_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_BACKEND_STORE, FolksBackendStoreClass))
#define FOLKS_IS_BACKEND_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_BACKEND_STORE))
#define FOLKS_IS_BACKEND_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_BACKEND_STORE))
#define FOLKS_BACKEND_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_BACKEND_STORE, FolksBackendStoreClass))

typedef struct _FolksBackendStore FolksBackendStore;
typedef struct _FolksBackendStoreClass FolksBackendStoreClass;

#define FOLKS_TYPE_PERSONA_STORE (folks_persona_store_get_type ())
#define FOLKS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStore))
#define FOLKS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStoreClass))
#define FOLKS_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_PERSONA_STORE))
#define FOLKS_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_PERSONA_STORE))
#define FOLKS_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStoreClass))

typedef struct _FolksPersonaStore FolksPersonaStore;
typedef struct _FolksPersonaStoreClass FolksPersonaStoreClass;

#define FOLKS_TYPE_BACKEND (folks_backend_get_type ())
#define FOLKS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_BACKEND, FolksBackend))
#define FOLKS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_BACKEND, FolksBackendClass))
#define FOLKS_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_BACKEND))
#define FOLKS_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_BACKEND))
#define FOLKS_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_BACKEND, FolksBackendClass))

typedef struct _FolksBackend FolksBackend;
typedef struct _FolksBackendClass FolksBackendClass;

#define FOLKS_TYPE_INDIVIDUAL (folks_individual_get_type ())
#define FOLKS_INDIVIDUAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_INDIVIDUAL, FolksIndividual))
#define FOLKS_INDIVIDUAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_INDIVIDUAL, FolksIndividualClass))
#define FOLKS_IS_INDIVIDUAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_INDIVIDUAL))
#define FOLKS_IS_INDIVIDUAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_INDIVIDUAL))
#define FOLKS_INDIVIDUAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_INDIVIDUAL, FolksIndividualClass))

typedef struct _FolksIndividual FolksIndividual;
typedef struct _FolksIndividualClass FolksIndividualClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _FolksIndividualAggregatorPrepareData FolksIndividualAggregatorPrepareData;
typedef struct _Block9Data Block9Data;
typedef struct _FolksIndividualAggregatorAddBackendData FolksIndividualAggregatorAddBackendData;
typedef struct _Block10Data Block10Data;

#define FOLKS_TYPE_PERSONA_STORE_TRUST (folks_persona_store_trust_get_type ())

#define FOLKS_TYPE_PERSONA (folks_persona_get_type ())
#define FOLKS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_PERSONA, FolksPersona))
#define FOLKS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_PERSONA, FolksPersonaClass))
#define FOLKS_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_PERSONA))
#define FOLKS_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_PERSONA))
#define FOLKS_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_PERSONA, FolksPersonaClass))

typedef struct _FolksPersona FolksPersona;
typedef struct _FolksPersonaClass FolksPersonaClass;

#define FOLKS_GROUP_DETAILS_TYPE_CHANGE_REASON (folks_group_details_change_reason_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block11Data Block11Data;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define FOLKS_TYPE_TRUST_LEVEL (folks_trust_level_get_type ())
typedef struct _Block12Data Block12Data;
typedef struct _Block13Data Block13Data;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _FolksIndividualAggregatorAddPersonaFromDetailsData FolksIndividualAggregatorAddPersonaFromDetailsData;
typedef struct _Block14Data Block14Data;
typedef struct _FolksIndividualAggregatorRemoveIndividualData FolksIndividualAggregatorRemoveIndividualData;
typedef struct _FolksIndividualAggregatorRemovePersonaData FolksIndividualAggregatorRemovePersonaData;

#define FOLKS_TYPE_LINKED_HASH_SET (folks_linked_hash_set_get_type ())
#define FOLKS_LINKED_HASH_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_LINKED_HASH_SET, FolksLinkedHashSet))
#define FOLKS_LINKED_HASH_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_LINKED_HASH_SET, FolksLinkedHashSetClass))
#define FOLKS_IS_LINKED_HASH_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_LINKED_HASH_SET))
#define FOLKS_IS_LINKED_HASH_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_LINKED_HASH_SET))
#define FOLKS_LINKED_HASH_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_LINKED_HASH_SET, FolksLinkedHashSetClass))

typedef struct _FolksLinkedHashSet FolksLinkedHashSet;
typedef struct _FolksLinkedHashSetClass FolksLinkedHashSetClass;
typedef struct _Block15Data Block15Data;

#define FOLKS_TYPE_IM_DETAILS (folks_im_details_get_type ())
#define FOLKS_IM_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_IM_DETAILS, FolksImDetails))
#define FOLKS_IS_IM_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_IM_DETAILS))
#define FOLKS_IM_DETAILS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_IM_DETAILS, FolksImDetailsIface))

typedef struct _FolksImDetails FolksImDetails;
typedef struct _FolksImDetailsIface FolksImDetailsIface;
typedef struct _FolksIndividualAggregatorLinkPersonasData FolksIndividualAggregatorLinkPersonasData;
typedef struct _FolksIndividualAggregatorUnlinkIndividualData FolksIndividualAggregatorUnlinkIndividualData;

/**
 * Errors from {@link IndividualAggregator}s.
 */
typedef enum  {
	FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_ADD_FAILED,
	FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_NO_WRITEABLE_STORE,
	FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_STORE_OFFLINE
} FolksIndividualAggregatorError;
#define FOLKS_INDIVIDUAL_AGGREGATOR_ERROR folks_individual_aggregator_error_quark ()
struct _FolksIndividualAggregator {
	GObject parent_instance;
	FolksIndividualAggregatorPrivate * priv;
};

struct _FolksIndividualAggregatorClass {
	GObjectClass parent_class;
};

struct _FolksIndividualAggregatorPrivate {
	FolksBackendStore* _backend_store;
	GeeHashMap* _stores;
	FolksPersonaStore* _writeable_store;
	GeeHashSet* _backends;
	GHashTable* _link_map;
	gboolean _linking_enabled;
	gboolean _is_prepared;
	GStaticRecMutex __lock__is_prepared;
	GHashTable* _individuals;
	FolksIndividual* _user;
};

struct _FolksIndividualAggregatorPrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksIndividualAggregator* self;
	GError * _inner_error_;
};

struct _Block9Data {
	int _ref_count_;
	FolksIndividualAggregator * self;
	FolksBackend* backend;
	gpointer _async_data_;
};

struct _FolksIndividualAggregatorAddBackendData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksIndividualAggregator* self;
	FolksBackend* backend;
	Block9Data* _data9_;
	gboolean _tmp0_;
	GHashTable* _tmp1_;
};

struct _Block10Data {
	int _ref_count_;
	FolksIndividualAggregator * self;
	gchar* store_id;
	FolksPersonaStore* store;
};

typedef enum  {
	FOLKS_PERSONA_STORE_TRUST_NONE,
	FOLKS_PERSONA_STORE_TRUST_PARTIAL,
	FOLKS_PERSONA_STORE_TRUST_FULL
} FolksPersonaStoreTrust;

typedef enum  {
	FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE = 0,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_OFFLINE = 1,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_KICKED = 2,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_BUSY = 3,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_INVITED = 4,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_BANNED = 5,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_ERROR = 6,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_INVALID_MEMBER = 7,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_NO_ANSWER = 8,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_RENAMED = 9,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_PERMISSION_DENIED = 10,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_SEPARATED = 11
} FolksGroupDetailsChangeReason;

struct _Block11Data {
	int _ref_count_;
	FolksIndividualAggregator * self;
	GList* candidate_inds;
	GeeHashSet* candidate_ind_set;
	GList* final_personas;
	FolksIndividual* final_individual;
};

typedef enum  {
	FOLKS_TRUST_LEVEL_NONE,
	FOLKS_TRUST_LEVEL_PERSONAS
} FolksTrustLevel;

struct _Block12Data {
	int _ref_count_;
	Block11Data * _data11_;
	const gchar* prop_name;
};

typedef void (*FolksPersonaLinkablePropertyCallback) (const gchar* link, void* user_data);
struct _Block13Data {
	int _ref_count_;
	FolksIndividualAggregator * self;
	GList* removed_individuals;
	GeeHashSet* removed_personas;
};

typedef enum  {
	FOLKS_PERSONA_STORE_ERROR_INVALID_ARGUMENT,
	FOLKS_PERSONA_STORE_ERROR_CREATE_FAILED,
	FOLKS_PERSONA_STORE_ERROR_UNSUPPORTED_ON_USER,
	FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE,
	FOLKS_PERSONA_STORE_ERROR_READ_ONLY
} FolksPersonaStoreError;
#define FOLKS_PERSONA_STORE_ERROR folks_persona_store_error_quark ()
struct _FolksIndividualAggregatorAddPersonaFromDetailsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksIndividualAggregator* self;
	FolksIndividual* parent;
	FolksPersonaStore* persona_store;
	GHashTable* details;
	FolksPersona* result;
	FolksPersona* persona;
	GHashTable* _tmp0_;
	GHashTable* details_copy;
	FolksPersona* _tmp1_;
	FolksPersona* _tmp2_;
	GError * e;
	GError* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* full_id;
	const gchar* _tmp7_;
	GError* _tmp8_;
	gboolean _tmp9_;
	GList* _tmp10_;
	GList* _tmp11_;
	GList* personas;
	GError * _inner_error_;
};

struct _Block14Data {
	int _ref_count_;
	FolksIndividualAggregator * self;
	GHashTable* retval;
};

struct _FolksIndividualAggregatorRemoveIndividualData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksIndividualAggregator* self;
	FolksIndividual* individual;
	GList* _tmp0_;
	GList* _tmp1_;
	GList* personas;
	GList* i;
	gboolean _tmp2_;
	FolksPersona* _tmp3_;
	FolksPersona* persona;
	FolksPersonaStore* _tmp4_;
	GError * _inner_error_;
};

struct _FolksIndividualAggregatorRemovePersonaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksIndividualAggregator* self;
	FolksPersona* persona;
	FolksPersonaStore* _tmp0_;
	GError * _inner_error_;
};

struct _Block15Data {
	int _ref_count_;
	FolksIndividualAggregator * self;
	GHashTable* protocols_addrs_set;
	gpointer _async_data_;
};

struct _FolksImDetailsIface {
	GTypeInterface parent_iface;
	GHashTable* (*get_im_addresses) (FolksImDetails* self);
	void (*set_im_addresses) (FolksImDetails* self, GHashTable* value);
};

struct _FolksIndividualAggregatorLinkPersonasData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksIndividualAggregator* self;
	void* personas_in;
	Block15Data* _data15_;
	GList* personas;
	const gchar* _tmp0_;
	GError* _tmp1_;
	const gchar* _tmp2_;
	GHashTable* _tmp3_;
	GList* persona_collection;
	GList* persona_it;
	FolksPersona* _tmp4_;
	FolksPersona* persona;
	GHashTable* _tmp5_;
	GValue addresses_value;
	GHashTable* _tmp6_;
	GHashTable* details;
	gchar* _tmp7_;
	GValue* _tmp8_;
	FolksPersona* _tmp9_;
	FolksPersona* _tmp10_;
	GError * _inner_error_;
};

struct _FolksIndividualAggregatorUnlinkIndividualData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksIndividualAggregator* self;
	FolksIndividual* individual;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	GList* personas;
	GList* p_collection;
	GList* p_it;
	FolksPersona* p;
	GList* persona_collection;
	GList* persona_it;
	FolksPersona* persona;
	FolksPersonaStore* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GError * _inner_error_;
};


static gpointer folks_individual_aggregator_parent_class = NULL;

GQuark folks_individual_aggregator_error_quark (void);
GType folks_individual_aggregator_get_type (void) G_GNUC_CONST;
GType folks_backend_store_get_type (void) G_GNUC_CONST;
GType folks_persona_store_get_type (void) G_GNUC_CONST;
GType folks_backend_get_type (void) G_GNUC_CONST;
GType folks_individual_get_type (void) G_GNUC_CONST;
#define FOLKS_INDIVIDUAL_AGGREGATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, FolksIndividualAggregatorPrivate))
enum  {
	FOLKS_INDIVIDUAL_AGGREGATOR_DUMMY_PROPERTY,
	FOLKS_INDIVIDUAL_AGGREGATOR_IS_PREPARED,
	FOLKS_INDIVIDUAL_AGGREGATOR_INDIVIDUALS,
	FOLKS_INDIVIDUAL_AGGREGATOR_USER
};
FolksIndividualAggregator* folks_individual_aggregator_new (void);
FolksIndividualAggregator* folks_individual_aggregator_construct (GType object_type);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void folks_individual_aggregator_set_individuals (FolksIndividualAggregator* self, GHashTable* value);
FolksBackendStore* folks_backend_store_dup (void);
static void _folks_individual_aggregator_backend_available_cb (FolksIndividualAggregator* self, FolksBackendStore* backend_store, FolksBackend* backend);
static void __folks_individual_aggregator_backend_available_cb_folks_backend_store_backend_available (FolksBackendStore* _sender, FolksBackend* backend, gpointer self);
static void folks_individual_aggregator_prepare_data_free (gpointer _data);
void folks_individual_aggregator_prepare (FolksIndividualAggregator* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_individual_aggregator_prepare_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error);
static gboolean folks_individual_aggregator_prepare_co (FolksIndividualAggregatorPrepareData* data);
void folks_backend_store_load_backends (FolksBackendStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_backend_store_load_backends_finish (FolksBackendStore* self, GAsyncResult* _res_, GError** error);
static void folks_individual_aggregator_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _folks_individual_aggregator_add_backend_data_free (gpointer _data);
static void _folks_individual_aggregator_add_backend (FolksIndividualAggregator* self, FolksBackend* backend, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _folks_individual_aggregator_add_backend_finish (FolksIndividualAggregator* self, GAsyncResult* _res_);
static gboolean _folks_individual_aggregator_add_backend_co (FolksIndividualAggregatorAddBackendData* data);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (Block9Data* _data9_);
static void _folks_individual_aggregator_backend_persona_store_added_cb (FolksIndividualAggregator* self, FolksBackend* backend, FolksPersonaStore* store);
static void __folks_individual_aggregator_backend_persona_store_added_cb_folks_backend_persona_store_added (FolksBackend* _sender, FolksPersonaStore* store, gpointer self);
static void _folks_individual_aggregator_backend_persona_store_removed_cb (FolksIndividualAggregator* self, FolksBackend* backend, FolksPersonaStore* store);
static void __folks_individual_aggregator_backend_persona_store_removed_cb_folks_backend_persona_store_removed (FolksBackend* _sender, FolksPersonaStore* store, gpointer self);
GHashTable* folks_backend_get_persona_stores (FolksBackend* self);
static void _lambda24_ (const gchar* k, FolksPersonaStore* v, Block9Data* _data9_);
static void __lambda24__gh_func (gconstpointer key, gconstpointer value, gpointer self);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (Block10Data* _data10_);
static gchar* _folks_individual_aggregator_get_store_full_id (FolksIndividualAggregator* self, const gchar* type_id, const gchar* id);
const gchar* folks_persona_store_get_type_id (FolksPersonaStore* self);
const gchar* folks_persona_store_get_id (FolksPersonaStore* self);
void folks_persona_store_set_is_writeable (FolksPersonaStore* self, gboolean value);
GType folks_persona_store_trust_get_type (void) G_GNUC_CONST;
void folks_persona_store_set_trust_level (FolksPersonaStore* self, FolksPersonaStoreTrust value);
GType folks_persona_get_type (void) G_GNUC_CONST;
GType folks_group_details_change_reason_get_type (void) G_GNUC_CONST;
static void _folks_individual_aggregator_personas_changed_cb (FolksIndividualAggregator* self, FolksPersonaStore* store, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason);
static void __folks_individual_aggregator_personas_changed_cb_folks_persona_store_personas_changed (FolksPersonaStore* _sender, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self);
static void _folks_individual_aggregator_is_writeable_changed_cb (FolksIndividualAggregator* self, GObject* object, GParamSpec* pspec);
static void __folks_individual_aggregator_is_writeable_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _folks_individual_aggregator_trust_level_changed_cb (FolksIndividualAggregator* self, GObject* object, GParamSpec* pspec);
static void __folks_individual_aggregator_trust_level_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void folks_persona_store_prepare (FolksPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_persona_store_prepare_finish (FolksPersonaStore* self, GAsyncResult* _res_, GError** error);
static void _lambda23_ (GObject* obj, GAsyncResult* _result_, Block10Data* _data10_);
static void __lambda23__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _folks_individual_aggregator_add_personas (FolksIndividualAggregator* self, GList* added, GList** added_individuals, GeeHashMap** replaced_individuals, FolksIndividual** user);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (Block11Data* _data11_);
static void _g_list_free__g_object_unref0_ (GList* self);
FolksPersonaStore* folks_persona_get_store (FolksPersona* self);
FolksPersonaStoreTrust folks_persona_store_get_trust_level (FolksPersonaStore* self);
const gchar* folks_persona_get_uid (FolksPersona* self);
const gchar* folks_persona_get_iid (FolksPersona* self);
gboolean folks_persona_get_is_user (FolksPersona* self);
const gchar* folks_individual_get_id (FolksIndividual* self);
GType folks_trust_level_get_type (void) G_GNUC_CONST;
FolksTrustLevel folks_individual_get_trust_level (FolksIndividual* self);
gchar** folks_persona_get_linkable_properties (FolksPersona* self, int* result_length1);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (Block12Data* _data12_);
void folks_persona_linkable_property_to_links (FolksPersona* self, const gchar* prop_name, FolksPersonaLinkablePropertyCallback callback, void* callback_target);
static void _lambda16_ (const gchar* l, Block12Data* _data12_);
static void __lambda16__folks_persona_linkable_property_callback (const gchar* link, gpointer self);
static void _lambda17_ (FolksIndividual* i, Block11Data* _data11_);
GList* folks_individual_get_personas (FolksIndividual* self);
static void _lambda18_ (FolksPersona* p, FolksIndividualAggregator* self);
static void __lambda18__gfunc (gconstpointer data, gpointer self);
static void __lambda17__gfunc (gconstpointer data, gpointer self);
FolksIndividual* folks_individual_new (GList* personas);
FolksIndividual* folks_individual_construct (GType object_type, GList* personas);
static void _lambda19_ (FolksPersona* i, Block11Data* _data11_);
static void _lambda20_ (const gchar* l, Block11Data* _data11_);
static void __lambda20__folks_persona_linkable_property_callback (const gchar* link, gpointer self);
static void __lambda19__gfunc (gconstpointer data, gpointer self);
gboolean folks_individual_get_is_user (FolksIndividual* self);
static void _folks_individual_aggregator_individual_removed_cb (FolksIndividualAggregator* self, FolksIndividual* i, FolksIndividual* replacement);
static void __folks_individual_aggregator_individual_removed_cb_folks_individual_removed (FolksIndividual* _sender, FolksIndividual* replacement_individual, gpointer self);
GHashTable* folks_individual_aggregator_get_individuals (FolksIndividualAggregator* self);
static void _folks_individual_aggregator_remove_persona_from_link_map (FolksIndividualAggregator* self, FolksPersona* persona);
static void _lambda22_ (const gchar* linking_value, FolksIndividualAggregator* self);
static void __lambda22__folks_persona_linkable_property_callback (const gchar* link, gpointer self);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (Block13Data* _data13_);
FolksIndividual* folks_individual_aggregator_get_user (FolksIndividualAggregator* self);
static void _lambda21_ (FolksPersona* p, Block13Data* _data13_);
static void __lambda21__gfunc (gconstpointer data, gpointer self);
void folks_individual_set_personas (FolksIndividual* self, GList* value);
static void folks_individual_aggregator_set_user (FolksIndividualAggregator* self, FolksIndividual* value);
void folks_individual_replace (FolksIndividual* self, FolksIndividual* replacement_individual);
gboolean folks_persona_store_get_is_writeable (FolksPersonaStore* self);
static void folks_individual_aggregator_add_persona_from_details_data_free (gpointer _data);
void folks_individual_aggregator_add_persona_from_details (FolksIndividualAggregator* self, FolksIndividual* parent, FolksPersonaStore* persona_store, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_);
FolksPersona* folks_individual_aggregator_add_persona_from_details_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error);
static gboolean folks_individual_aggregator_add_persona_from_details_co (FolksIndividualAggregatorAddPersonaFromDetailsData* data);
static GHashTable* _folks_individual_aggregator_asv_copy (FolksIndividualAggregator* self, GHashTable* asv);
void folks_persona_store_add_persona_from_details (FolksPersonaStore* self, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_);
GQuark folks_persona_store_error_quark (void);
FolksPersona* folks_persona_store_add_persona_from_details_finish (FolksPersonaStore* self, GAsyncResult* _res_, GError** error);
static void folks_individual_aggregator_add_persona_from_details_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (Block14Data* _data14_);
static void _vala_GValue_free (GValue* self);
static void __vala_GValue_free0_ (gpointer var);
static void _lambda25_ (const gchar* k, GValue* v, Block14Data* _data14_);
static GValue* _g_value_dup (GValue* self);
static void __lambda25__gh_func (gconstpointer key, gconstpointer value, gpointer self);
static void folks_individual_aggregator_remove_individual_data_free (gpointer _data);
void folks_individual_aggregator_remove_individual (FolksIndividualAggregator* self, FolksIndividual* individual, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_individual_aggregator_remove_individual_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error);
static gboolean folks_individual_aggregator_remove_individual_co (FolksIndividualAggregatorRemoveIndividualData* data);
void folks_persona_store_remove_persona (FolksPersonaStore* self, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_persona_store_remove_persona_finish (FolksPersonaStore* self, GAsyncResult* _res_, GError** error);
static void folks_individual_aggregator_remove_individual_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void folks_individual_aggregator_remove_persona_data_free (gpointer _data);
void folks_individual_aggregator_remove_persona (FolksIndividualAggregator* self, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_individual_aggregator_remove_persona_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error);
static gboolean folks_individual_aggregator_remove_persona_co (FolksIndividualAggregatorRemovePersonaData* data);
static void folks_individual_aggregator_remove_persona_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void folks_individual_aggregator_link_personas_data_free (gpointer _data);
void folks_individual_aggregator_link_personas (FolksIndividualAggregator* self, void* personas_in, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_individual_aggregator_link_personas_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error);
static gboolean folks_individual_aggregator_link_personas_co (FolksIndividualAggregatorLinkPersonasData* data);
GType folks_linked_hash_set_get_type (void) G_GNUC_CONST;
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (Block15Data* _data15_);
GType folks_im_details_get_type (void) G_GNUC_CONST;
GHashTable* folks_im_details_get_im_addresses (FolksImDetails* self);
static void _lambda26_ (const gchar* k, FolksLinkedHashSet* v, Block15Data* _data15_);
FolksLinkedHashSet* folks_linked_hash_set_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GHashFunc hash_func, GEqualFunc equal_func);
FolksLinkedHashSet* folks_linked_hash_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GHashFunc hash_func, GEqualFunc equal_func);
static void __lambda26__gh_func (gconstpointer key, gconstpointer value, gpointer self);
static void folks_individual_aggregator_link_personas_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void folks_individual_aggregator_unlink_individual_data_free (gpointer _data);
void folks_individual_aggregator_unlink_individual (FolksIndividualAggregator* self, FolksIndividual* individual, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_individual_aggregator_unlink_individual_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error);
static gboolean folks_individual_aggregator_unlink_individual_co (FolksIndividualAggregatorUnlinkIndividualData* data);
static void folks_individual_aggregator_unlink_individual_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gboolean folks_individual_aggregator_get_is_prepared (FolksIndividualAggregator* self);
static void g_cclosure_user_marshal_VOID__POINTER_POINTER_STRING_OBJECT_ENUM (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void folks_individual_aggregator_finalize (GObject* obj);
static void _vala_folks_individual_aggregator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_folks_individual_aggregator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GQuark folks_individual_aggregator_error_quark (void) {
	return g_quark_from_static_string ("folks_individual_aggregator_error-quark");
}


/**
   * Create a new IndividualAggregator.
   *
   * Clients should connect to the
   * {@link IndividualAggregator.individuals_changed} signal, then call
   * {@link IndividualAggregator.prepare} to load the backends and start
   * aggregating individuals.
   *
   * An example of how to set up an IndividualAggregator:
   * {{{
   *   IndividualAggregator agg = new IndividualAggregator ();
   *   agg.individuals_changed.connect (individuals_changed_cb);
   *   agg.prepare ();
   * }}}
   */
static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static void __folks_individual_aggregator_backend_available_cb_folks_backend_store_backend_available (FolksBackendStore* _sender, FolksBackend* backend, gpointer self) {
	_folks_individual_aggregator_backend_available_cb (self, _sender, backend);
}


FolksIndividualAggregator* folks_individual_aggregator_construct (GType object_type) {
	FolksIndividualAggregator * self = NULL;
	GeeHashMap* _tmp0_ = NULL;
	GHashTable* _tmp1_ = NULL;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_ = NULL;
	GeeHashSet* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* disable_linking;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	FolksBackendStore* _tmp12_ = NULL;
	self = (FolksIndividualAggregator*) g_object_new (object_type, NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_PERSONA_STORE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_stores);
	self->priv->_stores = _tmp0_;
	_tmp1_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, _g_object_unref0_);
	_tmp2_ = _tmp1_;
	folks_individual_aggregator_set_individuals (self, _tmp2_);
	_g_hash_table_unref0 (_tmp2_);
	_tmp3_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->_link_map);
	self->priv->_link_map = _tmp3_;
	_tmp4_ = gee_hash_set_new (FOLKS_TYPE_BACKEND, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	_g_object_unref0 (self->priv->_backends);
	self->priv->_backends = _tmp4_;
	_tmp5_ = g_getenv ("FOLKS_DISABLE_LINKING");
	_tmp6_ = g_strdup (_tmp5_);
	disable_linking = _tmp6_;
	if (disable_linking != NULL) {
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		gchar* _tmp9_ = NULL;
		_tmp7_ = string_strip (disable_linking);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_utf8_strdown (_tmp8_, (gssize) (-1));
		_g_free0 (disable_linking);
		disable_linking = _tmp9_;
		_g_free0 (_tmp8_);
	}
	if (disable_linking == NULL) {
		_tmp11_ = TRUE;
	} else {
		_tmp11_ = g_strcmp0 (disable_linking, "no") == 0;
	}
	if (_tmp11_) {
		_tmp10_ = TRUE;
	} else {
		_tmp10_ = g_strcmp0 (disable_linking, "0") == 0;
	}
	self->priv->_linking_enabled = _tmp10_;
	_tmp12_ = folks_backend_store_dup ();
	_g_object_unref0 (self->priv->_backend_store);
	self->priv->_backend_store = _tmp12_;
	g_signal_connect_object (self->priv->_backend_store, "backend-available", (GCallback) __folks_individual_aggregator_backend_available_cb_folks_backend_store_backend_available, self, 0);
	_g_free0 (disable_linking);
	return self;
}


FolksIndividualAggregator* folks_individual_aggregator_new (void) {
	return folks_individual_aggregator_construct (FOLKS_TYPE_INDIVIDUAL_AGGREGATOR);
}


static void folks_individual_aggregator_prepare_data_free (gpointer _data) {
	FolksIndividualAggregatorPrepareData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (FolksIndividualAggregatorPrepareData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void folks_individual_aggregator_prepare (FolksIndividualAggregator* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksIndividualAggregatorPrepareData* _data_;
	_data_ = g_slice_new0 (FolksIndividualAggregatorPrepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_individual_aggregator_prepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_individual_aggregator_prepare_data_free);
	_data_->self = _g_object_ref0 (self);
	folks_individual_aggregator_prepare_co (_data_);
}


void folks_individual_aggregator_prepare_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error) {
	FolksIndividualAggregatorPrepareData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Prepare the IndividualAggregator for use.
   *
   * This loads all the available backends and prepares them for use by the
   * IndividualAggregator. This should be called //after// connecting to the
   * {@link IndividualAggregator.individuals_changed} signal, or a race
   * condition could occur, with the signal being emitted before your code has
   * connected to them, and {@link Individual}s getting "lost" as a result.
   *
   * This function is guaranteed to be idempotent (since version 0.3.0).
   *
   * @since 0.1.11
   */
static void folks_individual_aggregator_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksIndividualAggregatorPrepareData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	folks_individual_aggregator_prepare_co (data);
}


static gboolean folks_individual_aggregator_prepare_co (FolksIndividualAggregatorPrepareData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		g_static_rec_mutex_lock (&data->self->priv->__lock__is_prepared);
		if (!data->self->priv->_is_prepared) {
			data->_state_ = 1;
			folks_backend_store_load_backends (data->self->priv->_backend_store, folks_individual_aggregator_prepare_ready, data);
			return FALSE;
			_state_1:
			folks_backend_store_load_backends_finish (data->self->priv->_backend_store, data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				goto __finally9;
			}
			data->self->priv->_is_prepared = TRUE;
			g_object_notify ((GObject*) data->self, "is-prepared");
		}
		__finally9:
		g_static_rec_mutex_unlock (&data->self->priv->__lock__is_prepared);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void _folks_individual_aggregator_add_backend_data_free (gpointer _data) {
	FolksIndividualAggregatorAddBackendData* data;
	data = _data;
	_g_object_unref0 (data->backend);
	_g_object_unref0 (data->self);
	g_slice_free (FolksIndividualAggregatorAddBackendData, data);
}


static void _folks_individual_aggregator_add_backend (FolksIndividualAggregator* self, FolksBackend* backend, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksIndividualAggregatorAddBackendData* _data_;
	_data_ = g_slice_new0 (FolksIndividualAggregatorAddBackendData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _folks_individual_aggregator_add_backend);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _folks_individual_aggregator_add_backend_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->backend = _g_object_ref0 (backend);
	_folks_individual_aggregator_add_backend_co (_data_);
}


static void _folks_individual_aggregator_add_backend_finish (FolksIndividualAggregator* self, GAsyncResult* _res_) {
	FolksIndividualAggregatorAddBackendData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block9Data* block9_data_ref (Block9Data* _data9_) {
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}


static void block9_data_unref (Block9Data* _data9_) {
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		_g_object_unref0 (_data9_->self);
		_g_object_unref0 (_data9_->backend);
		g_slice_free (Block9Data, _data9_);
	}
}


static void __folks_individual_aggregator_backend_persona_store_added_cb_folks_backend_persona_store_added (FolksBackend* _sender, FolksPersonaStore* store, gpointer self) {
	_folks_individual_aggregator_backend_persona_store_added_cb (self, _sender, store);
}


static void __folks_individual_aggregator_backend_persona_store_removed_cb_folks_backend_persona_store_removed (FolksBackend* _sender, FolksPersonaStore* store, gpointer self) {
	_folks_individual_aggregator_backend_persona_store_removed_cb (self, _sender, store);
}


static void _lambda24_ (const gchar* k, FolksPersonaStore* v, Block9Data* _data9_) {
	FolksIndividualAggregator * self;
	self = _data9_->self;
	g_return_if_fail (k != NULL);
	g_return_if_fail (v != NULL);
	_folks_individual_aggregator_backend_persona_store_added_cb (self, _data9_->backend, FOLKS_PERSONA_STORE (v));
}


static void __lambda24__gh_func (gconstpointer key, gconstpointer value, gpointer self) {
	_lambda24_ (key, value, self);
}


static gboolean _folks_individual_aggregator_add_backend_co (FolksIndividualAggregatorAddBackendData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_data9_ = g_slice_new0 (Block9Data);
	data->_data9_->_ref_count_ = 1;
	data->_data9_->self = g_object_ref (data->self);
	data->_data9_->backend = _g_object_ref0 (data->backend);
	data->_data9_->_async_data_ = data;
	data->_tmp0_ = gee_abstract_collection_contains ((GeeAbstractCollection*) data->self->priv->_backends, data->_data9_->backend);
	if (!data->_tmp0_) {
		gee_abstract_collection_add ((GeeAbstractCollection*) data->self->priv->_backends, data->_data9_->backend);
		g_signal_connect_object (data->_data9_->backend, "persona-store-added", (GCallback) __folks_individual_aggregator_backend_persona_store_added_cb_folks_backend_persona_store_added, data->self, 0);
		g_signal_connect_object (data->_data9_->backend, "persona-store-removed", (GCallback) __folks_individual_aggregator_backend_persona_store_removed_cb_folks_backend_persona_store_removed, data->self, 0);
		data->_tmp1_ = NULL;
		data->_tmp1_ = folks_backend_get_persona_stores (data->_data9_->backend);
		g_hash_table_foreach (data->_tmp1_, __lambda24__gh_func, data->_data9_);
	}
	block9_data_unref (data->_data9_);
	data->_data9_ = NULL;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void _folks_individual_aggregator_backend_available_cb (FolksIndividualAggregator* self, FolksBackendStore* backend_store, FolksBackend* backend) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (backend_store != NULL);
	g_return_if_fail (backend != NULL);
	_folks_individual_aggregator_add_backend (self, backend, NULL, NULL);
}


static Block10Data* block10_data_ref (Block10Data* _data10_) {
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}


static void block10_data_unref (Block10Data* _data10_) {
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		_g_object_unref0 (_data10_->self);
		_g_free0 (_data10_->store_id);
		_g_object_unref0 (_data10_->store);
		g_slice_free (Block10Data, _data10_);
	}
}


static void __folks_individual_aggregator_personas_changed_cb_folks_persona_store_personas_changed (FolksPersonaStore* _sender, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self) {
	_folks_individual_aggregator_personas_changed_cb (self, _sender, added, removed, message, actor, reason);
}


static void __folks_individual_aggregator_is_writeable_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_folks_individual_aggregator_is_writeable_changed_cb (self, _sender, pspec);
}


static void __folks_individual_aggregator_trust_level_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_folks_individual_aggregator_trust_level_changed_cb (self, _sender, pspec);
}


static void _lambda23_ (GObject* obj, GAsyncResult* _result_, Block10Data* _data10_) {
	FolksIndividualAggregator * self;
	GError * _inner_error_ = NULL;
	self = _data10_->self;
	g_return_if_fail (_result_ != NULL);
	folks_persona_store_prepare_finish (_data10_->store, _result_, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch10_g_error;
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError * e;
		const gchar* _tmp0_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp0_ = _ ("Error preparing persona store '%s': %s");
		g_warning (_tmp0_, _data10_->store_id, e->message);
		_g_error_free0 (e);
	}
	__finally10:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __lambda23__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_lambda23_ (source_object, res, self);
	block10_data_unref (self);
}


static void _folks_individual_aggregator_backend_persona_store_added_cb (FolksIndividualAggregator* self, FolksBackend* backend, FolksPersonaStore* store) {
	Block10Data* _data10_;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (backend != NULL);
	g_return_if_fail (store != NULL);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	_data10_->store = _g_object_ref0 (store);
	_tmp0_ = folks_persona_store_get_type_id (_data10_->store);
	_tmp1_ = folks_persona_store_get_id (_data10_->store);
	_tmp2_ = _folks_individual_aggregator_get_store_full_id (self, _tmp0_, _tmp1_);
	_data10_->store_id = _tmp2_;
	_tmp3_ = folks_persona_store_get_type_id (_data10_->store);
	if (g_strcmp0 (_tmp3_, "key-file") == 0) {
		folks_persona_store_set_is_writeable (_data10_->store, TRUE);
		folks_persona_store_set_trust_level (_data10_->store, FOLKS_PERSONA_STORE_TRUST_FULL);
		self->priv->_writeable_store = _data10_->store;
	}
	gee_abstract_map_set ((GeeAbstractMap*) self->priv->_stores, _data10_->store_id, _data10_->store);
	g_signal_connect_object (_data10_->store, "personas-changed", (GCallback) __folks_individual_aggregator_personas_changed_cb_folks_persona_store_personas_changed, self, 0);
	g_signal_connect_object ((GObject*) _data10_->store, "notify::is-writeable", (GCallback) __folks_individual_aggregator_is_writeable_changed_cb_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) _data10_->store, "notify::trust-level", (GCallback) __folks_individual_aggregator_trust_level_changed_cb_g_object_notify, self, 0);
	folks_persona_store_prepare (_data10_->store, __lambda23__gasync_ready_callback, block10_data_ref (_data10_));
	block10_data_unref (_data10_);
	_data10_ = NULL;
}


static void _folks_individual_aggregator_backend_persona_store_removed_cb (FolksIndividualAggregator* self, FolksBackend* backend, FolksPersonaStore* store) {
	guint _tmp0_;
	guint _tmp1_;
	GQuark _tmp2_;
	guint _tmp3_;
	GQuark _tmp4_;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (backend != NULL);
	g_return_if_fail (store != NULL);
	g_signal_parse_name ("personas-changed", FOLKS_TYPE_PERSONA_STORE, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (store, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) __folks_individual_aggregator_personas_changed_cb_folks_persona_store_personas_changed, self);
	g_signal_parse_name ("notify::trust-level", G_TYPE_OBJECT, &_tmp1_, &_tmp2_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) store, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, _tmp2_, NULL, (GCallback) __folks_individual_aggregator_trust_level_changed_cb_g_object_notify, self);
	g_signal_parse_name ("notify::is-writeable", G_TYPE_OBJECT, &_tmp3_, &_tmp4_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) store, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, _tmp4_, NULL, (GCallback) __folks_individual_aggregator_is_writeable_changed_cb_g_object_notify, self);
	if (self->priv->_writeable_store == store) {
		self->priv->_writeable_store = NULL;
	}
	_tmp5_ = folks_persona_store_get_type_id (store);
	_tmp6_ = folks_persona_store_get_id (store);
	_tmp7_ = _folks_individual_aggregator_get_store_full_id (self, _tmp5_, _tmp6_);
	_tmp8_ = _tmp7_;
	gee_abstract_map_unset ((GeeAbstractMap*) self->priv->_stores, _tmp8_, NULL);
	_g_free0 (_tmp8_);
}


static gchar* _folks_individual_aggregator_get_store_full_id (FolksIndividualAggregator* self, const gchar* type_id, const gchar* id) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_id != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = g_strconcat (type_id, ":", NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, id, NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}


static Block11Data* block11_data_ref (Block11Data* _data11_) {
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void block11_data_unref (Block11Data* _data11_) {
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		_g_object_unref0 (_data11_->self);
		_g_object_unref0 (_data11_->final_individual);
		__g_list_free__g_object_unref0_0 (_data11_->final_personas);
		_g_object_unref0 (_data11_->candidate_ind_set);
		__g_list_free__g_object_unref0_0 (_data11_->candidate_inds);
		g_slice_free (Block11Data, _data11_);
	}
}


static Block12Data* block12_data_ref (Block12Data* _data12_) {
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}


static void block12_data_unref (Block12Data* _data12_) {
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		block11_data_unref (_data12_->_data11_);
		_data12_->_data11_ = NULL;
		g_slice_free (Block12Data, _data12_);
	}
}


static void _lambda16_ (const gchar* l, Block12Data* _data12_) {
	Block11Data* _data11_;
	FolksIndividualAggregator * self;
	const gchar* prop_linking_value;
	gconstpointer _tmp0_ = NULL;
	FolksIndividual* _tmp1_;
	FolksIndividual* candidate_ind;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	_data11_ = _data12_->_data11_;
	self = _data11_->self;
	g_return_if_fail (l != NULL);
	prop_linking_value = l;
	_tmp0_ = g_hash_table_lookup (self->priv->_link_map, prop_linking_value);
	_tmp1_ = _g_object_ref0 ((FolksIndividual*) _tmp0_);
	candidate_ind = _tmp1_;
	if (candidate_ind != NULL) {
		FolksTrustLevel _tmp4_;
		_tmp4_ = folks_individual_get_trust_level (candidate_ind);
		_tmp3_ = _tmp4_ != FOLKS_TRUST_LEVEL_NONE;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gboolean _tmp5_;
		_tmp5_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _data11_->candidate_ind_set, candidate_ind);
		_tmp2_ = !_tmp5_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		const gchar* _tmp6_ = NULL;
		FolksIndividual* _tmp7_;
		_tmp6_ = folks_individual_get_id (candidate_ind);
		g_debug ("    Found candidate individual '%s' by " "linkable property '%s' = '%s'.", _tmp6_, _data12_->prop_name, prop_linking_value);
		_tmp7_ = _g_object_ref0 (candidate_ind);
		_data11_->candidate_inds = g_list_prepend (_data11_->candidate_inds, _tmp7_);
		gee_abstract_collection_add ((GeeAbstractCollection*) _data11_->candidate_ind_set, candidate_ind);
	}
	_g_object_unref0 (candidate_ind);
}


static void __lambda16__folks_persona_linkable_property_callback (const gchar* link, gpointer self) {
	_lambda16_ (link, self);
}


static void _lambda18_ (FolksPersona* p, FolksIndividualAggregator* self) {
	g_return_if_fail (p != NULL);
	g_object_ref ((GObject*) FOLKS_PERSONA (p));
}


static void __lambda18__gfunc (gconstpointer data, gpointer self) {
	_lambda18_ (data, self);
}


static void _lambda17_ (FolksIndividual* i, Block11Data* _data11_) {
	FolksIndividualAggregator * self;
	FolksIndividual* _tmp0_;
	FolksIndividual* individual;
	GList* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	self = _data11_->self;
	g_return_if_fail (i != NULL);
	_tmp0_ = _g_object_ref0 (FOLKS_INDIVIDUAL (i));
	individual = _tmp0_;
	_tmp1_ = folks_individual_get_personas (individual);
	g_list_foreach (_tmp1_, __lambda18__gfunc, self);
	_tmp2_ = folks_individual_get_personas (individual);
	_tmp3_ = g_list_copy (_tmp2_);
	_data11_->final_personas = g_list_concat (_data11_->final_personas, _tmp3_);
	_g_object_unref0 (individual);
}


static void __lambda17__gfunc (gconstpointer data, gpointer self) {
	_lambda17_ (data, self);
}


static void _lambda20_ (const gchar* l, Block11Data* _data11_) {
	FolksIndividualAggregator * self;
	const gchar* prop_linking_value;
	gchar* _tmp0_;
	FolksIndividual* _tmp1_;
	self = _data11_->self;
	g_return_if_fail (l != NULL);
	prop_linking_value = l;
	g_debug ("individual-aggregator.vala:455:             %s", prop_linking_value);
	_tmp0_ = g_strdup (prop_linking_value);
	_tmp1_ = _g_object_ref0 (_data11_->final_individual);
	g_hash_table_replace (self->priv->_link_map, _tmp0_, _tmp1_);
}


static void __lambda20__folks_persona_linkable_property_callback (const gchar* link, gpointer self) {
	_lambda20_ (link, self);
}


static void _lambda19_ (FolksPersona* i, Block11Data* _data11_) {
	FolksIndividualAggregator * self;
	FolksPersona* _tmp0_;
	FolksPersona* final_persona;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	FolksIndividual* _tmp7_;
	FolksPersonaStore* _tmp8_ = NULL;
	FolksPersonaStoreTrust _tmp9_;
	self = _data11_->self;
	g_return_if_fail (i != NULL);
	_tmp0_ = _g_object_ref0 (FOLKS_PERSONA (i));
	final_persona = _tmp0_;
	_tmp2_ = folks_persona_get_is_user (final_persona);
	if (_tmp2_) {
		_tmp1_ = "yes";
	} else {
		_tmp1_ = "no";
	}
	_tmp3_ = folks_persona_get_uid (final_persona);
	_tmp4_ = folks_persona_get_iid (final_persona);
	g_debug ("individual-aggregator.vala:418:         %s (is user: %s, IID: %s)", _tmp3_, _tmp1_, _tmp4_);
	_tmp5_ = folks_persona_get_iid (final_persona);
	_tmp6_ = g_strdup (_tmp5_);
	_tmp7_ = _g_object_ref0 (_data11_->final_individual);
	g_hash_table_replace (self->priv->_link_map, _tmp6_, _tmp7_);
	_tmp8_ = folks_persona_get_store (final_persona);
	_tmp9_ = folks_persona_store_get_trust_level (_tmp8_);
	if (_tmp9_ == FOLKS_PERSONA_STORE_TRUST_FULL) {
		gchar** _tmp10_ = NULL;
		gint _tmp11_;
		g_debug ("individual-aggregator.vala:431:         Inserting links:");
		_tmp10_ = folks_persona_get_linkable_properties (final_persona, &_tmp11_);
		{
			gchar** prop_name_collection;
			int prop_name_collection_length1;
			int prop_name_it;
			prop_name_collection = _tmp10_;
			prop_name_collection_length1 = _tmp11_;
			for (prop_name_it = 0; prop_name_it < _tmp11_; prop_name_it = prop_name_it + 1) {
				const gchar* prop_name;
				prop_name = prop_name_collection[prop_name_it];
				{
					GObjectClass* _tmp12_ = NULL;
					GObjectClass* pclass;
					GParamSpec* _tmp13_ = NULL;
					_tmp12_ = G_OBJECT_GET_CLASS ((GObject*) final_persona);
					pclass = _tmp12_;
					_tmp13_ = g_object_class_find_property (pclass, prop_name);
					if (_tmp13_ == NULL) {
						const gchar* _tmp14_ = NULL;
						_tmp14_ = _ ("Unknown property '%s' in linkable property list.");
						g_warning (_tmp14_, prop_name);
						continue;
					}
					folks_persona_linkable_property_to_links (final_persona, prop_name, __lambda20__folks_persona_linkable_property_callback, _data11_);
				}
			}
		}
	}
	_g_object_unref0 (final_persona);
}


static void __lambda19__gfunc (gconstpointer data, gpointer self) {
	_lambda19_ (data, self);
}


static void __folks_individual_aggregator_individual_removed_cb_folks_individual_removed (FolksIndividual* _sender, FolksIndividual* replacement_individual, gpointer self) {
	_folks_individual_aggregator_individual_removed_cb (self, _sender, replacement_individual);
}


static void _folks_individual_aggregator_add_personas (FolksIndividualAggregator* self, GList* added, GList** added_individuals, GeeHashMap** replaced_individuals, FolksIndividual** user) {
	GeeHashSet* _tmp0_ = NULL;
	GeeHashSet* almost_added_individuals;
	g_return_if_fail (self != NULL);
	g_return_if_fail (replaced_individuals != NULL);
	g_return_if_fail (user != NULL);
	_tmp0_ = gee_hash_set_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	almost_added_individuals = _tmp0_;
	{
		GList* persona_collection;
		GList* persona_it;
		persona_collection = added;
		for (persona_it = persona_collection; persona_it != NULL; persona_it = persona_it->next) {
			FolksPersona* _tmp1_;
			FolksPersona* persona;
			_tmp1_ = _g_object_ref0 ((FolksPersona*) persona_it->data);
			persona = _tmp1_;
			{
				Block11Data* _data11_;
				FolksPersonaStore* _tmp2_ = NULL;
				FolksPersonaStoreTrust _tmp3_;
				FolksPersonaStoreTrust trust_level;
				GeeHashSet* _tmp4_ = NULL;
				const gchar* _tmp5_ = NULL;
				const gchar* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_;
				FolksPersonaStore* _tmp21_ = NULL;
				FolksPersonaStoreTrust _tmp22_;
				FolksPersona* _tmp28_;
				gboolean _tmp29_ = FALSE;
				FolksIndividual* _tmp30_ = NULL;
				const gchar* _tmp31_ = NULL;
				gboolean _tmp34_;
				_data11_ = g_slice_new0 (Block11Data);
				_data11_->_ref_count_ = 1;
				_data11_->self = g_object_ref (self);
				_tmp2_ = folks_persona_get_store (persona);
				_tmp3_ = folks_persona_store_get_trust_level (_tmp2_);
				trust_level = _tmp3_;
				_data11_->candidate_inds = NULL;
				_tmp4_ = gee_hash_set_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
				_data11_->candidate_ind_set = _tmp4_;
				_data11_->final_personas = NULL;
				_data11_->final_individual = NULL;
				_tmp5_ = folks_persona_get_uid (persona);
				_tmp6_ = folks_persona_get_iid (persona);
				g_debug ("individual-aggregator.vala:305: Aggregating persona '%s' on '%s'.", _tmp5_, _tmp6_);
				_tmp8_ = folks_persona_get_is_user (persona);
				if (_tmp8_ == TRUE) {
					_tmp7_ = (*user) != NULL;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					const gchar* _tmp9_ = NULL;
					FolksIndividual* _tmp10_;
					_tmp9_ = folks_individual_get_id (*user);
					g_debug ("individual-aggregator.vala:311:     Found candidate individual '%s' as" \
" user.", _tmp9_);
					_tmp10_ = _g_object_ref0 (*user);
					_data11_->candidate_inds = g_list_prepend (_data11_->candidate_inds, _tmp10_);
					gee_abstract_collection_add ((GeeAbstractCollection*) _data11_->candidate_ind_set, *user);
				}
				if (trust_level != FOLKS_PERSONA_STORE_TRUST_NONE) {
					const gchar* _tmp11_ = NULL;
					gconstpointer _tmp12_ = NULL;
					FolksIndividual* _tmp13_;
					FolksIndividual* candidate_ind;
					gboolean _tmp14_ = FALSE;
					gboolean _tmp15_ = FALSE;
					_tmp11_ = folks_persona_get_iid (persona);
					_tmp12_ = g_hash_table_lookup (self->priv->_link_map, _tmp11_);
					_tmp13_ = _g_object_ref0 ((FolksIndividual*) _tmp12_);
					candidate_ind = _tmp13_;
					if (candidate_ind != NULL) {
						FolksTrustLevel _tmp16_;
						_tmp16_ = folks_individual_get_trust_level (candidate_ind);
						_tmp15_ = _tmp16_ != FOLKS_TRUST_LEVEL_NONE;
					} else {
						_tmp15_ = FALSE;
					}
					if (_tmp15_) {
						gboolean _tmp17_;
						_tmp17_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _data11_->candidate_ind_set, candidate_ind);
						_tmp14_ = !_tmp17_;
					} else {
						_tmp14_ = FALSE;
					}
					if (_tmp14_) {
						const gchar* _tmp18_ = NULL;
						const gchar* _tmp19_ = NULL;
						FolksIndividual* _tmp20_;
						_tmp18_ = folks_individual_get_id (candidate_ind);
						_tmp19_ = folks_persona_get_iid (persona);
						g_debug ("individual-aggregator.vala:325:     Found candidate individual '%s' by" \
" IID '%s'.", _tmp18_, _tmp19_);
						_tmp20_ = _g_object_ref0 (candidate_ind);
						_data11_->candidate_inds = g_list_prepend (_data11_->candidate_inds, _tmp20_);
						gee_abstract_collection_add ((GeeAbstractCollection*) _data11_->candidate_ind_set, candidate_ind);
					}
					_g_object_unref0 (candidate_ind);
				}
				_tmp21_ = folks_persona_get_store (persona);
				_tmp22_ = folks_persona_store_get_trust_level (_tmp21_);
				if (_tmp22_ == FOLKS_PERSONA_STORE_TRUST_FULL) {
					gchar** _tmp23_ = NULL;
					gint _tmp24_;
					_tmp23_ = folks_persona_get_linkable_properties (persona, &_tmp24_);
					{
						gchar** foo_collection;
						int foo_collection_length1;
						int foo_it;
						foo_collection = _tmp23_;
						foo_collection_length1 = _tmp24_;
						for (foo_it = 0; foo_it < _tmp24_; foo_it = foo_it + 1) {
							const gchar* foo;
							foo = foo_collection[foo_it];
							{
								Block12Data* _data12_;
								GObjectClass* _tmp25_ = NULL;
								GObjectClass* pclass;
								GParamSpec* _tmp26_ = NULL;
								_data12_ = g_slice_new0 (Block12Data);
								_data12_->_ref_count_ = 1;
								_data12_->_data11_ = block11_data_ref (_data11_);
								_data12_->prop_name = foo;
								_tmp25_ = G_OBJECT_GET_CLASS ((GObject*) persona);
								pclass = _tmp25_;
								_tmp26_ = g_object_class_find_property (pclass, _data12_->prop_name);
								if (_tmp26_ == NULL) {
									const gchar* _tmp27_ = NULL;
									_tmp27_ = _ ("Unknown property '%s' in linkable property list.");
									g_warning (_tmp27_, _data12_->prop_name);
									block12_data_unref (_data12_);
									_data12_ = NULL;
									continue;
								}
								folks_persona_linkable_property_to_links (persona, _data12_->prop_name, __lambda16__folks_persona_linkable_property_callback, _data12_);
								block12_data_unref (_data12_);
								_data12_ = NULL;
							}
						}
					}
				}
				_tmp28_ = _g_object_ref0 (persona);
				_data11_->final_personas = g_list_prepend (_data11_->final_personas, _tmp28_);
				if (_data11_->candidate_inds != NULL) {
					_tmp29_ = self->priv->_linking_enabled == TRUE;
				} else {
					_tmp29_ = FALSE;
				}
				if (_tmp29_) {
					g_list_foreach (_data11_->candidate_inds, __lambda17__gfunc, _data11_);
				} else {
					if (_data11_->candidate_inds != NULL) {
						g_debug ("individual-aggregator.vala:403:     Linking disabled.");
					} else {
						g_debug ("individual-aggregator.vala:407:     Did not find any candidate individ" \
"uals.");
					}
				}
				_tmp30_ = folks_individual_new (_data11_->final_personas);
				_g_object_unref0 (_data11_->final_individual);
				_data11_->final_individual = _tmp30_;
				_tmp31_ = folks_individual_get_id (_data11_->final_individual);
				g_debug ("individual-aggregator.vala:412:     Created new individual '%s' with p" \
"ersonas:", _tmp31_);
				g_list_foreach (_data11_->final_personas, __lambda19__gfunc, _data11_);
				{
					GList* i_collection;
					GList* i_it;
					i_collection = _data11_->candidate_inds;
					for (i_it = i_collection; i_it != NULL; i_it = i_it->next) {
						FolksIndividual* _tmp32_;
						FolksIndividual* i;
						_tmp32_ = _g_object_ref0 ((FolksIndividual*) i_it->data);
						i = _tmp32_;
						{
							gboolean _tmp33_;
							_tmp33_ = gee_abstract_collection_contains ((GeeAbstractCollection*) almost_added_individuals, i);
							if (_tmp33_ == TRUE) {
								gee_abstract_collection_remove ((GeeAbstractCollection*) almost_added_individuals, i);
							} else {
								gee_abstract_map_set ((GeeAbstractMap*) (*replaced_individuals), i, _data11_->final_individual);
							}
							_g_object_unref0 (i);
						}
					}
				}
				_tmp34_ = folks_individual_get_is_user (_data11_->final_individual);
				if (_tmp34_ == TRUE) {
					FolksIndividual* _tmp35_;
					_tmp35_ = _g_object_ref0 (_data11_->final_individual);
					_g_object_unref0 (*user);
					*user = _tmp35_;
				}
				gee_abstract_collection_add ((GeeAbstractCollection*) almost_added_individuals, _data11_->final_individual);
				_g_object_unref0 (persona);
				block11_data_unref (_data11_);
				_data11_ = NULL;
			}
		}
	}
	{
		GeeIterator* _tmp36_ = NULL;
		GeeIterator* _i_it;
		_tmp36_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) almost_added_individuals);
		_i_it = _tmp36_;
		while (TRUE) {
			gboolean _tmp37_;
			gpointer _tmp38_ = NULL;
			FolksIndividual* i;
			FolksIndividual* _tmp39_;
			const gchar* _tmp40_ = NULL;
			gchar* _tmp41_;
			FolksIndividual* _tmp42_;
			_tmp37_ = gee_iterator_next (_i_it);
			if (!_tmp37_) {
				break;
			}
			_tmp38_ = gee_iterator_get (_i_it);
			i = (FolksIndividual*) _tmp38_;
			g_signal_connect_object (i, "removed", (GCallback) __folks_individual_aggregator_individual_removed_cb_folks_individual_removed, self, 0);
			_tmp39_ = _g_object_ref0 (i);
			*added_individuals = g_list_prepend (*added_individuals, _tmp39_);
			_tmp40_ = folks_individual_get_id (i);
			_tmp41_ = g_strdup (_tmp40_);
			_tmp42_ = _g_object_ref0 (i);
			g_hash_table_insert (self->priv->_individuals, _tmp41_, _tmp42_);
			_g_object_unref0 (i);
		}
		_g_object_unref0 (_i_it);
	}
	_g_object_unref0 (almost_added_individuals);
}


static void _lambda22_ (const gchar* linking_value, FolksIndividualAggregator* self) {
	g_return_if_fail (linking_value != NULL);
	g_debug ("individual-aggregator.vala:520:         %s", linking_value);
	g_hash_table_remove (self->priv->_link_map, linking_value);
}


static void __lambda22__folks_persona_linkable_property_callback (const gchar* link, gpointer self) {
	_lambda22_ (link, self);
}


static void _folks_individual_aggregator_remove_persona_from_link_map (FolksIndividualAggregator* self, FolksPersona* persona) {
	const gchar* _tmp0_ = NULL;
	FolksPersonaStore* _tmp1_ = NULL;
	FolksPersonaStoreTrust _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (persona != NULL);
	_tmp0_ = folks_persona_get_iid (persona);
	g_hash_table_remove (self->priv->_link_map, _tmp0_);
	_tmp1_ = folks_persona_get_store (persona);
	_tmp2_ = folks_persona_store_get_trust_level (_tmp1_);
	if (_tmp2_ == FOLKS_PERSONA_STORE_TRUST_FULL) {
		const gchar* _tmp3_ = NULL;
		gchar** _tmp4_ = NULL;
		gint _tmp5_;
		_tmp3_ = folks_persona_get_uid (persona);
		g_debug ("individual-aggregator.vala:500:     Removing links to %s:", _tmp3_);
		_tmp4_ = folks_persona_get_linkable_properties (persona, &_tmp5_);
		{
			gchar** prop_name_collection;
			int prop_name_collection_length1;
			int prop_name_it;
			prop_name_collection = _tmp4_;
			prop_name_collection_length1 = _tmp5_;
			for (prop_name_it = 0; prop_name_it < _tmp5_; prop_name_it = prop_name_it + 1) {
				const gchar* prop_name;
				prop_name = prop_name_collection[prop_name_it];
				{
					GObjectClass* _tmp6_ = NULL;
					GObjectClass* pclass;
					GParamSpec* _tmp7_ = NULL;
					_tmp6_ = G_OBJECT_GET_CLASS ((GObject*) persona);
					pclass = _tmp6_;
					_tmp7_ = g_object_class_find_property (pclass, prop_name);
					if (_tmp7_ == NULL) {
						const gchar* _tmp8_ = NULL;
						_tmp8_ = _ ("Unknown property '%s' in linkable property list.");
						g_warning (_tmp8_, prop_name);
						continue;
					}
					folks_persona_linkable_property_to_links (persona, prop_name, __lambda22__folks_persona_linkable_property_callback, self);
				}
			}
		}
	}
}


static Block13Data* block13_data_ref (Block13Data* _data13_) {
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}


static void block13_data_unref (Block13Data* _data13_) {
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		_g_object_unref0 (_data13_->self);
		_g_object_unref0 (_data13_->removed_personas);
		__g_list_free__g_object_unref0_0 (_data13_->removed_individuals);
		g_slice_free (Block13Data, _data13_);
	}
}


static void _lambda21_ (FolksPersona* p, Block13Data* _data13_) {
	FolksIndividualAggregator * self;
	FolksPersona* _tmp0_;
	FolksPersona* persona;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gconstpointer _tmp6_ = NULL;
	FolksIndividual* _tmp7_;
	FolksIndividual* ind;
	self = _data13_->self;
	g_return_if_fail (p != NULL);
	_tmp0_ = _g_object_ref0 (FOLKS_PERSONA (p));
	persona = _tmp0_;
	_tmp2_ = folks_persona_get_is_user (persona);
	if (_tmp2_) {
		_tmp1_ = "yes";
	} else {
		_tmp1_ = "no";
	}
	_tmp3_ = folks_persona_get_uid (persona);
	_tmp4_ = folks_persona_get_iid (persona);
	g_debug ("individual-aggregator.vala:559:     %s (is user: %s, IID: %s)", _tmp3_, _tmp1_, _tmp4_);
	gee_abstract_collection_add ((GeeAbstractCollection*) _data13_->removed_personas, persona);
	_tmp5_ = folks_persona_get_iid (persona);
	_tmp6_ = g_hash_table_lookup (self->priv->_link_map, _tmp5_);
	_tmp7_ = _g_object_ref0 ((FolksIndividual*) _tmp6_);
	ind = _tmp7_;
	if (ind != NULL) {
		FolksIndividual* _tmp8_;
		_tmp8_ = _g_object_ref0 (ind);
		_data13_->removed_individuals = g_list_prepend (_data13_->removed_individuals, _tmp8_);
	}
	_folks_individual_aggregator_remove_persona_from_link_map (self, persona);
	_g_object_unref0 (ind);
	_g_object_unref0 (persona);
}


static void __lambda21__gfunc (gconstpointer data, gpointer self) {
	_lambda21_ (data, self);
}


static void _folks_individual_aggregator_personas_changed_cb (FolksIndividualAggregator* self, FolksPersonaStore* store, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason) {
	Block13Data* _data13_;
	GList* added_individuals;
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* replaced_individuals;
	GList* relinked_personas;
	GeeHashSet* _tmp1_ = NULL;
	GeeHashSet* relinked_personas_set;
	GeeHashSet* _tmp2_ = NULL;
	FolksIndividual* _tmp3_;
	FolksIndividual* user;
	gboolean _tmp23_ = FALSE;
	GeeMapIterator* _tmp24_ = NULL;
	GeeMapIterator* iter;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	_data13_ = g_slice_new0 (Block13Data);
	_data13_->_ref_count_ = 1;
	_data13_->self = g_object_ref (self);
	added_individuals = NULL;
	_data13_->removed_individuals = NULL;
	_tmp0_ = gee_hash_map_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	replaced_individuals = _tmp0_;
	relinked_personas = NULL;
	_tmp1_ = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_hash, g_direct_equal);
	relinked_personas_set = _tmp1_;
	_tmp2_ = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_hash, g_direct_equal);
	_data13_->removed_personas = _tmp2_;
	_tmp3_ = _g_object_ref0 (self->priv->_user);
	user = _tmp3_;
	if (added != NULL) {
		_folks_individual_aggregator_add_personas (self, added, &added_individuals, &replaced_individuals, &user);
	}
	g_debug ("individual-aggregator.vala:553: Removing Personas:");
	g_list_foreach (removed, __lambda21__gfunc, _data13_);
	g_debug ("individual-aggregator.vala:584: Removing Individuals due to removed li" \
"nks:");
	{
		GList* individual_collection;
		GList* individual_it;
		individual_collection = _data13_->removed_individuals;
		for (individual_it = individual_collection; individual_it != NULL; individual_it = individual_it->next) {
			FolksIndividual* _tmp4_;
			FolksIndividual* individual;
			_tmp4_ = _g_object_ref0 ((FolksIndividual*) individual_it->data);
			individual = _tmp4_;
			{
				const gchar* _tmp5_ = NULL;
				gconstpointer _tmp6_ = NULL;
				const gchar* _tmp7_ = NULL;
				GList* _tmp8_ = NULL;
				const gchar* _tmp14_ = NULL;
				_tmp5_ = folks_individual_get_id (individual);
				_tmp6_ = g_hash_table_lookup (self->priv->_individuals, _tmp5_);
				if (((FolksIndividual*) _tmp6_) == NULL) {
					_g_object_unref0 (individual);
					continue;
				}
				_tmp7_ = folks_individual_get_id (individual);
				g_debug ("individual-aggregator.vala:591:     %s", _tmp7_);
				_tmp8_ = folks_individual_get_personas (individual);
				{
					GList* persona_collection;
					GList* persona_it;
					persona_collection = _tmp8_;
					for (persona_it = persona_collection; persona_it != NULL; persona_it = persona_it->next) {
						FolksPersona* _tmp9_;
						FolksPersona* persona;
						_tmp9_ = _g_object_ref0 ((FolksPersona*) persona_it->data);
						persona = _tmp9_;
						{
							gboolean _tmp10_ = FALSE;
							gboolean _tmp11_;
							FolksPersona* _tmp13_;
							_tmp11_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _data13_->removed_personas, persona);
							if (_tmp11_ == TRUE) {
								_tmp10_ = TRUE;
							} else {
								gboolean _tmp12_;
								_tmp12_ = gee_abstract_collection_contains ((GeeAbstractCollection*) relinked_personas_set, persona);
								_tmp10_ = _tmp12_ == TRUE;
							}
							if (_tmp10_) {
								_g_object_unref0 (persona);
								continue;
							}
							_tmp13_ = _g_object_ref0 (persona);
							relinked_personas = g_list_prepend (relinked_personas, _tmp13_);
							gee_abstract_collection_add ((GeeAbstractCollection*) relinked_personas_set, persona);
							_folks_individual_aggregator_remove_persona_from_link_map (self, persona);
							_g_object_unref0 (persona);
						}
					}
				}
				if (user == individual) {
					_g_object_unref0 (user);
					user = NULL;
				}
				_tmp14_ = folks_individual_get_id (individual);
				g_hash_table_remove (self->priv->_individuals, _tmp14_);
				folks_individual_set_personas (individual, NULL);
				_g_object_unref0 (individual);
			}
		}
	}
	g_debug ("individual-aggregator.vala:615: Relinking Personas:");
	{
		GList* persona_collection;
		GList* persona_it;
		persona_collection = relinked_personas;
		for (persona_it = persona_collection; persona_it != NULL; persona_it = persona_it->next) {
			FolksPersona* _tmp15_;
			FolksPersona* persona;
			_tmp15_ = _g_object_ref0 ((FolksPersona*) persona_it->data);
			persona = _tmp15_;
			{
				const gchar* _tmp16_ = NULL;
				gboolean _tmp17_;
				const gchar* _tmp18_ = NULL;
				const gchar* _tmp19_ = NULL;
				_tmp17_ = folks_persona_get_is_user (persona);
				if (_tmp17_) {
					_tmp16_ = "yes";
				} else {
					_tmp16_ = "no";
				}
				_tmp18_ = folks_persona_get_uid (persona);
				_tmp19_ = folks_persona_get_iid (persona);
				g_debug ("individual-aggregator.vala:618:     %s (is user: %s, IID: %s)", _tmp18_, _tmp16_, _tmp19_);
				_g_object_unref0 (persona);
			}
		}
	}
	_folks_individual_aggregator_add_personas (self, relinked_personas, &added_individuals, &replaced_individuals, &user);
	if (replaced_individuals != NULL) {
		GeeMapIterator* _tmp20_ = NULL;
		GeeMapIterator* iter;
		_tmp20_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) replaced_individuals);
		iter = _tmp20_;
		while (TRUE) {
			gboolean _tmp21_;
			gpointer _tmp22_ = NULL;
			_tmp21_ = gee_map_iterator_next (iter);
			if (!(_tmp21_ == TRUE)) {
				break;
			}
			_tmp22_ = gee_map_iterator_get_key (iter);
			_data13_->removed_individuals = g_list_prepend (_data13_->removed_individuals, (FolksIndividual*) _tmp22_);
		}
		_g_object_unref0 (iter);
	}
	folks_individual_aggregator_set_user (self, user);
	if (added_individuals != NULL) {
		_tmp23_ = TRUE;
	} else {
		_tmp23_ = _data13_->removed_individuals != NULL;
	}
	if (_tmp23_) {
		g_signal_emit_by_name (self, "individuals-changed", added_individuals, _data13_->removed_individuals, NULL, NULL, 0);
	}
	g_debug ("individual-aggregator.vala:650: Replacing Individuals due to linking:");
	_tmp24_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) replaced_individuals);
	iter = _tmp24_;
	while (TRUE) {
		gboolean _tmp25_;
		gpointer _tmp26_ = NULL;
		FolksIndividual* _tmp27_;
		gpointer _tmp28_ = NULL;
		FolksIndividual* _tmp29_;
		_tmp25_ = gee_map_iterator_next (iter);
		if (!(_tmp25_ == TRUE)) {
			break;
		}
		_tmp26_ = gee_map_iterator_get_key (iter);
		_tmp27_ = (FolksIndividual*) _tmp26_;
		_tmp28_ = gee_map_iterator_get_value (iter);
		_tmp29_ = (FolksIndividual*) _tmp28_;
		folks_individual_replace (_tmp27_, _tmp29_);
		_g_object_unref0 (_tmp29_);
		_g_object_unref0 (_tmp27_);
	}
	_g_object_unref0 (iter);
	_g_object_unref0 (user);
	_g_object_unref0 (relinked_personas_set);
	__g_list_free__g_object_unref0_0 (relinked_personas);
	_g_object_unref0 (replaced_individuals);
	__g_list_free__g_object_unref0_0 (added_individuals);
	block13_data_unref (_data13_);
	_data13_ = NULL;
}


static void _folks_individual_aggregator_is_writeable_changed_cb (FolksIndividualAggregator* self, GObject* object, GParamSpec* pspec) {
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* store;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = _g_object_ref0 (FOLKS_PERSONA_STORE (object));
	store = _tmp0_;
	_tmp3_ = folks_persona_store_get_is_writeable (store);
	if (_tmp3_ == TRUE) {
		_tmp2_ = store == self->priv->_writeable_store;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_;
		_tmp5_ = folks_persona_store_get_is_writeable (store);
		if (_tmp5_ == FALSE) {
			_tmp4_ = store != self->priv->_writeable_store;
		} else {
			_tmp4_ = FALSE;
		}
		_tmp1_ = _tmp4_;
	}
	g_assert (_tmp1_);
	_g_object_unref0 (store);
}


static void _folks_individual_aggregator_trust_level_changed_cb (FolksIndividualAggregator* self, GObject* object, GParamSpec* pspec) {
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* store;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = _g_object_ref0 (FOLKS_PERSONA_STORE (object));
	store = _tmp0_;
	_tmp1_ = folks_persona_store_get_type_id (store);
	if (g_strcmp0 (_tmp1_, "key-file") == 0) {
		FolksPersonaStoreTrust _tmp2_;
		_tmp2_ = folks_persona_store_get_trust_level (store);
		g_assert (_tmp2_ == FOLKS_PERSONA_STORE_TRUST_FULL);
	} else {
		FolksPersonaStoreTrust _tmp3_;
		_tmp3_ = folks_persona_store_get_trust_level (store);
		g_assert (_tmp3_ != FOLKS_PERSONA_STORE_TRUST_FULL);
	}
	_g_object_unref0 (store);
}


static void _folks_individual_aggregator_individual_removed_cb (FolksIndividualAggregator* self, FolksIndividual* i, FolksIndividual* replacement) {
	const gchar* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	GList* i_list;
	FolksIndividual* _tmp2_;
	GList* _tmp6_ = NULL;
	guint _tmp7_;
	const gchar* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (i != NULL);
	if (self->priv->_user == i) {
		folks_individual_aggregator_set_user (self, NULL);
	}
	_tmp0_ = folks_individual_get_id (i);
	_tmp1_ = g_hash_table_lookup (self->priv->_individuals, _tmp0_);
	if (((FolksIndividual*) _tmp1_) != i) {
		return;
	}
	i_list = NULL;
	_tmp2_ = _g_object_ref0 (i);
	i_list = g_list_append (i_list, _tmp2_);
	if (replacement != NULL) {
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		_tmp3_ = folks_individual_get_id (i);
		_tmp4_ = folks_individual_get_id (replacement);
		g_debug ("individual-aggregator.vala:692: Individual '%s' removed (replaced by '" \
"%s')", _tmp3_, _tmp4_);
	} else {
		const gchar* _tmp5_ = NULL;
		_tmp5_ = folks_individual_get_id (i);
		g_debug ("individual-aggregator.vala:697: Individual '%s' removed (not replaced)", _tmp5_);
	}
	_tmp6_ = folks_individual_get_personas (i);
	_tmp7_ = g_list_length (_tmp6_);
	if (_tmp7_ > 0) {
		g_signal_emit_by_name (self, "individuals-changed", NULL, i_list, NULL, NULL, 0);
	}
	_tmp8_ = folks_individual_get_id (i);
	g_hash_table_remove (self->priv->_individuals, _tmp8_);
	__g_list_free__g_object_unref0_0 (i_list);
}


static void folks_individual_aggregator_add_persona_from_details_data_free (gpointer _data) {
	FolksIndividualAggregatorAddPersonaFromDetailsData* data;
	data = _data;
	_g_object_unref0 (data->parent);
	_g_object_unref0 (data->persona_store);
	_g_hash_table_unref0 (data->details);
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (FolksIndividualAggregatorAddPersonaFromDetailsData, data);
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


void folks_individual_aggregator_add_persona_from_details (FolksIndividualAggregator* self, FolksIndividual* parent, FolksPersonaStore* persona_store, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksIndividualAggregatorAddPersonaFromDetailsData* _data_;
	_data_ = g_slice_new0 (FolksIndividualAggregatorAddPersonaFromDetailsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_individual_aggregator_add_persona_from_details);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_individual_aggregator_add_persona_from_details_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->parent = _g_object_ref0 (parent);
	_data_->persona_store = _g_object_ref0 (persona_store);
	_data_->details = _g_hash_table_ref0 (details);
	folks_individual_aggregator_add_persona_from_details_co (_data_);
}


FolksPersona* folks_individual_aggregator_add_persona_from_details_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error) {
	FolksPersona* result;
	FolksIndividualAggregatorAddPersonaFromDetailsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
   * Add a new persona in the given {@link PersonaStore} based on the `details`
   * provided.
   *
   * If the target store is offline, this function will throw
   * {@link IndividualAggregatorError.STORE_OFFLINE}. It's the responsibility of
   * the caller to cache details and re-try this function if it wishes to make
   * offline adds work.
   *
   * The details hash is a backend-specific mapping of key, value strings.
   * Common keys include:
   *
   *  * contact - service-specific contact ID
   *  * message - a user-readable message to pass to the persona being added
   *
   * If a {@link Persona} with the given details already exists in the store, no
   * error will be thrown and this function will return `null`.
   *
   * @param parent an optional {@link Individual} to add the new {@link Persona}
   * to. This persona will be appended to its ordered list of personas.
   * @param persona_store the {@link PersonaStore} to add the persona to
   * @param details a key-value map of details to use in creating the new
   * {@link Persona}
   * @return the new {@link Persona} or `null` if the corresponding
   * {@link Persona} already existed. If non-`null`, the new {@link Persona}
   * will also be added to a new or existing {@link Individual} as necessary.
   *
   * @since 0.3.5
   */
static void folks_individual_aggregator_add_persona_from_details_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksIndividualAggregatorAddPersonaFromDetailsData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	folks_individual_aggregator_add_persona_from_details_co (data);
}


static gboolean folks_individual_aggregator_add_persona_from_details_co (FolksIndividualAggregatorAddPersonaFromDetailsData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->persona = NULL;
	data->_tmp0_ = NULL;
	data->_tmp0_ = _folks_individual_aggregator_asv_copy (data->self, data->details);
	data->details_copy = data->_tmp0_;
	data->_state_ = 1;
	folks_persona_store_add_persona_from_details (data->persona_store, data->details_copy, folks_individual_aggregator_add_persona_from_details_ready, data);
	return FALSE;
	_state_1:
	data->_tmp1_ = NULL;
	data->_tmp1_ = folks_persona_store_add_persona_from_details_finish (data->persona_store, data->_res_, &data->_inner_error_);
	data->_tmp2_ = data->_tmp1_;
	if (data->_inner_error_ != NULL) {
		_g_hash_table_unref0 (data->details_copy);
		if (data->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			goto __catch11_folks_persona_store_error;
		}
		_g_hash_table_unref0 (data->details_copy);
		_g_object_unref0 (data->persona);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (data->persona);
	data->persona = data->_tmp2_;
	_g_hash_table_unref0 (data->details_copy);
	goto __finally11;
	__catch11_folks_persona_store_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		if (g_error_matches (data->e, FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE)) {
			data->_tmp3_ = NULL;
			data->_tmp3_ = g_error_new_literal (FOLKS_INDIVIDUAL_AGGREGATOR_ERROR, FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_STORE_OFFLINE, data->e->message);
			data->_inner_error_ = data->_tmp3_;
			_g_error_free0 (data->e);
			goto __finally11;
		} else {
			data->_tmp4_ = NULL;
			data->_tmp4_ = folks_persona_store_get_type_id (data->persona_store);
			data->_tmp5_ = NULL;
			data->_tmp5_ = folks_persona_store_get_id (data->persona_store);
			data->_tmp6_ = NULL;
			data->_tmp6_ = _folks_individual_aggregator_get_store_full_id (data->self, data->_tmp4_, data->_tmp5_);
			data->full_id = data->_tmp6_;
			data->_tmp7_ = NULL;
			data->_tmp7_ = _ ("Failed to add contact for persona store ID '%s': %s");
			data->_tmp8_ = NULL;
			data->_tmp8_ = g_error_new (FOLKS_INDIVIDUAL_AGGREGATOR_ERROR, FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_ADD_FAILED, data->_tmp7_, data->full_id, data->e->message);
			data->_inner_error_ = data->_tmp8_;
			_g_free0 (data->full_id);
			_g_error_free0 (data->e);
			goto __finally11;
		}
		_g_error_free0 (data->e);
	}
	__finally11:
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->persona);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (data->persona);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	if (data->parent != NULL) {
		data->_tmp9_ = data->persona != NULL;
	} else {
		data->_tmp9_ = FALSE;
	}
	if (data->_tmp9_) {
		data->_tmp10_ = NULL;
		data->_tmp10_ = folks_individual_get_personas (data->parent);
		data->_tmp11_ = NULL;
		data->_tmp11_ = g_list_copy (data->_tmp10_);
		data->personas = data->_tmp11_;
		data->personas = g_list_append (data->personas, data->persona);
		folks_individual_set_personas (data->parent, data->personas);
		_g_list_free0 (data->personas);
	}
	data->result = data->persona;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_object_unref0 (data->persona);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static Block14Data* block14_data_ref (Block14Data* _data14_) {
	g_atomic_int_inc (&_data14_->_ref_count_);
	return _data14_;
}


static void block14_data_unref (Block14Data* _data14_) {
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
		_g_object_unref0 (_data14_->self);
		_g_hash_table_unref0 (_data14_->retval);
		g_slice_free (Block14Data, _data14_);
	}
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


static void __vala_GValue_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL));
}


static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


static gpointer __g_value_dup0 (gpointer self) {
	return self ? _g_value_dup (self) : NULL;
}


static void _lambda25_ (const gchar* k, GValue* v, Block14Data* _data14_) {
	FolksIndividualAggregator * self;
	gchar* _tmp0_;
	GValue* _tmp1_;
	self = _data14_->self;
	g_return_if_fail (k != NULL);
	_tmp0_ = g_strdup ((const gchar*) k);
	_tmp1_ = __g_value_dup0 (v);
	g_hash_table_insert (_data14_->retval, _tmp0_, _tmp1_);
}


static void __lambda25__gh_func (gconstpointer key, gconstpointer value, gpointer self) {
	_lambda25_ (key, value, self);
}


static GHashTable* _folks_individual_aggregator_asv_copy (FolksIndividualAggregator* self, GHashTable* asv) {
	GHashTable* result = NULL;
	Block14Data* _data14_;
	GHashTable* _tmp0_ = NULL;
	GHashTable* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (asv != NULL, NULL);
	_data14_ = g_slice_new0 (Block14Data);
	_data14_->_ref_count_ = 1;
	_data14_->self = g_object_ref (self);
	_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, __vala_GValue_free0_);
	_data14_->retval = _tmp0_;
	g_hash_table_foreach (asv, __lambda25__gh_func, _data14_);
	_tmp1_ = _g_hash_table_ref0 (_data14_->retval);
	result = _tmp1_;
	block14_data_unref (_data14_);
	_data14_ = NULL;
	return result;
}


static void folks_individual_aggregator_remove_individual_data_free (gpointer _data) {
	FolksIndividualAggregatorRemoveIndividualData* data;
	data = _data;
	_g_object_unref0 (data->individual);
	_g_object_unref0 (data->self);
	g_slice_free (FolksIndividualAggregatorRemoveIndividualData, data);
}


void folks_individual_aggregator_remove_individual (FolksIndividualAggregator* self, FolksIndividual* individual, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksIndividualAggregatorRemoveIndividualData* _data_;
	_data_ = g_slice_new0 (FolksIndividualAggregatorRemoveIndividualData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_individual_aggregator_remove_individual);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_individual_aggregator_remove_individual_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->individual = _g_object_ref0 (individual);
	folks_individual_aggregator_remove_individual_co (_data_);
}


void folks_individual_aggregator_remove_individual_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error) {
	FolksIndividualAggregatorRemoveIndividualData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Completely remove the individual and all of its personas from their
   * backing stores.
   *
   * @param individual the {@link Individual} to remove
   * @since 0.1.11
   */
static void folks_individual_aggregator_remove_individual_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksIndividualAggregatorRemoveIndividualData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	folks_individual_aggregator_remove_individual_co (data);
}


static gboolean folks_individual_aggregator_remove_individual_co (FolksIndividualAggregatorRemoveIndividualData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = folks_individual_get_personas (data->individual);
	data->_tmp1_ = NULL;
	data->_tmp1_ = g_list_copy (data->_tmp0_);
	data->personas = data->_tmp1_;
	{
		data->i = data->personas;
		data->_tmp2_ = TRUE;
		while (TRUE) {
			if (!data->_tmp2_) {
				data->i = data->i->next;
			}
			data->_tmp2_ = FALSE;
			if (!(data->i != NULL)) {
				break;
			}
			data->_tmp3_ = _g_object_ref0 (FOLKS_PERSONA ((FolksPersona*) data->i->data));
			data->persona = data->_tmp3_;
			data->_tmp4_ = NULL;
			data->_tmp4_ = folks_persona_get_store (data->persona);
			data->_state_ = 1;
			folks_persona_store_remove_persona (data->_tmp4_, data->persona, folks_individual_aggregator_remove_individual_ready, data);
			return FALSE;
			_state_1:
			folks_persona_store_remove_persona_finish (data->_tmp4_, data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				_g_object_unref0 (data->persona);
				_g_list_free0 (data->personas);
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			_g_object_unref0 (data->persona);
		}
	}
	_g_list_free0 (data->personas);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void folks_individual_aggregator_remove_persona_data_free (gpointer _data) {
	FolksIndividualAggregatorRemovePersonaData* data;
	data = _data;
	_g_object_unref0 (data->persona);
	_g_object_unref0 (data->self);
	g_slice_free (FolksIndividualAggregatorRemovePersonaData, data);
}


void folks_individual_aggregator_remove_persona (FolksIndividualAggregator* self, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksIndividualAggregatorRemovePersonaData* _data_;
	_data_ = g_slice_new0 (FolksIndividualAggregatorRemovePersonaData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_individual_aggregator_remove_persona);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_individual_aggregator_remove_persona_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->persona = _g_object_ref0 (persona);
	folks_individual_aggregator_remove_persona_co (_data_);
}


void folks_individual_aggregator_remove_persona_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error) {
	FolksIndividualAggregatorRemovePersonaData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Completely remove the persona from its backing store.
   *
   * This will leave other personas in the same individual alone.
   *
   * @param persona the {@link Persona} to remove
   * @since 0.1.11
   */
static void folks_individual_aggregator_remove_persona_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksIndividualAggregatorRemovePersonaData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	folks_individual_aggregator_remove_persona_co (data);
}


static gboolean folks_individual_aggregator_remove_persona_co (FolksIndividualAggregatorRemovePersonaData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = folks_persona_get_store (data->persona);
	data->_state_ = 1;
	folks_persona_store_remove_persona (data->_tmp0_, data->persona, folks_individual_aggregator_remove_persona_ready, data);
	return FALSE;
	_state_1:
	folks_persona_store_remove_persona_finish (data->_tmp0_, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void folks_individual_aggregator_link_personas_data_free (gpointer _data) {
	FolksIndividualAggregatorLinkPersonasData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (FolksIndividualAggregatorLinkPersonasData, data);
}


void folks_individual_aggregator_link_personas (FolksIndividualAggregator* self, void* personas_in, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksIndividualAggregatorLinkPersonasData* _data_;
	_data_ = g_slice_new0 (FolksIndividualAggregatorLinkPersonasData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_individual_aggregator_link_personas);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_individual_aggregator_link_personas_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->personas_in = personas_in;
	folks_individual_aggregator_link_personas_co (_data_);
}


void folks_individual_aggregator_link_personas_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error) {
	FolksIndividualAggregatorLinkPersonasData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Link the given {@link Persona}s together.
   *
   * Create links between the given {@link Persona}s so that they form a single
   * {@link Individual}. The new {@link Individual} will be returned via the
   * {@link IndividualAggregator.individuals_changed} signal.
   *
   * Removal of the {@link Individual}s which the {@link Persona}s were in
   * before is signalled by {@link IndividualAggregator.individuals_changed} and
   * {@link Individual.removed}.
   *
   * @param personas_in the {@link Persona}s to be linked
   * @since 0.1.13
   */
static Block15Data* block15_data_ref (Block15Data* _data15_) {
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}


static void block15_data_unref (Block15Data* _data15_) {
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		_g_object_unref0 (_data15_->self);
		_g_hash_table_unref0 (_data15_->protocols_addrs_set);
		g_slice_free (Block15Data, _data15_);
	}
}


static void _lambda26_ (const gchar* k, FolksLinkedHashSet* v, Block15Data* _data15_) {
	FolksIndividualAggregator * self;
	const gchar* protocol;
	FolksLinkedHashSet* addresses;
	gconstpointer _tmp0_ = NULL;
	FolksLinkedHashSet* _tmp1_;
	FolksLinkedHashSet* address_set;
	self = _data15_->self;
	g_return_if_fail (k != NULL);
	g_return_if_fail (v != NULL);
	protocol = (const gchar*) k;
	addresses = FOLKS_LINKED_HASH_SET (v);
	_tmp0_ = g_hash_table_lookup (_data15_->protocols_addrs_set, protocol);
	_tmp1_ = _g_object_ref0 ((FolksLinkedHashSet*) _tmp0_);
	address_set = _tmp1_;
	if (address_set == NULL) {
		FolksLinkedHashSet* _tmp2_ = NULL;
		gchar* _tmp3_;
		FolksLinkedHashSet* _tmp4_;
		_tmp2_ = folks_linked_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
		_g_object_unref0 (address_set);
		address_set = _tmp2_;
		_tmp3_ = g_strdup (protocol);
		_tmp4_ = _g_object_ref0 (address_set);
		g_hash_table_insert (_data15_->protocols_addrs_set, _tmp3_, _tmp4_);
	}
	gee_abstract_collection_add_all ((GeeAbstractCollection*) address_set, (GeeCollection*) addresses);
	_g_object_unref0 (address_set);
}


static void __lambda26__gh_func (gconstpointer key, gconstpointer value, gpointer self) {
	_lambda26_ (key, value, self);
}


static void folks_individual_aggregator_link_personas_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksIndividualAggregatorLinkPersonasData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	folks_individual_aggregator_link_personas_co (data);
}


static gboolean folks_individual_aggregator_link_personas_co (FolksIndividualAggregatorLinkPersonasData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_data15_ = g_slice_new0 (Block15Data);
	data->_data15_->_ref_count_ = 1;
	data->_data15_->self = g_object_ref (data->self);
	data->_data15_->_async_data_ = data;
	data->personas = (GList*) data->personas_in;
	if (data->self->priv->_writeable_store == NULL) {
		data->_tmp0_ = NULL;
		data->_tmp0_ = _ ("Can't link personas with no writeable store.");
		data->_tmp1_ = NULL;
		data->_tmp1_ = g_error_new_literal (FOLKS_INDIVIDUAL_AGGREGATOR_ERROR, FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_NO_WRITEABLE_STORE, data->_tmp0_);
		data->_inner_error_ = data->_tmp1_;
		if (data->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			block15_data_unref (data->_data15_);
			data->_data15_ = NULL;
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			block15_data_unref (data->_data15_);
			data->_data15_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	if (data->personas->next == NULL) {
		block15_data_unref (data->_data15_);
		data->_data15_ = NULL;
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	if (data->self->priv->_linking_enabled == FALSE) {
		g_debug ("individual-aggregator.vala:858: Can't link Personas: linking disabled.");
		block15_data_unref (data->_data15_);
		data->_data15_ = NULL;
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp2_ = NULL;
	data->_tmp2_ = folks_persona_store_get_type_id (data->self->priv->_writeable_store);
	g_assert (g_strcmp0 (data->_tmp2_, "key-file") == 0);
	data->_tmp3_ = NULL;
	data->_tmp3_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, _g_object_unref0_);
	data->_data15_->protocols_addrs_set = data->_tmp3_;
	{
		data->persona_collection = data->personas;
		for (data->persona_it = data->persona_collection; data->persona_it != NULL; data->persona_it = data->persona_it->next) {
			data->_tmp4_ = _g_object_ref0 ((FolksPersona*) data->persona_it->data);
			data->persona = data->_tmp4_;
			{
				if (!FOLKS_IS_IM_DETAILS (data->persona)) {
					_g_object_unref0 (data->persona);
					continue;
				}
				data->_tmp5_ = NULL;
				data->_tmp5_ = folks_im_details_get_im_addresses (FOLKS_IM_DETAILS (data->persona));
				g_hash_table_foreach (data->_tmp5_, __lambda26__gh_func, data->_data15_);
				_g_object_unref0 (data->persona);
			}
		}
	}
	g_value_init (&data->addresses_value, G_TYPE_HASH_TABLE);
	g_value_set_boxed (&data->addresses_value, data->_data15_->protocols_addrs_set);
	data->_tmp6_ = NULL;
	data->_tmp6_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, __vala_GValue_free0_);
	data->details = data->_tmp6_;
	data->_tmp7_ = g_strdup ("im-addresses");
	data->_tmp8_ = __g_value_dup0 (&data->addresses_value);
	g_hash_table_insert (data->details, data->_tmp7_, data->_tmp8_);
	data->_state_ = 1;
	folks_individual_aggregator_add_persona_from_details (data->self, NULL, data->self->priv->_writeable_store, data->details, folks_individual_aggregator_link_personas_ready, data);
	return FALSE;
	_state_1:
	data->_tmp9_ = NULL;
	data->_tmp9_ = folks_individual_aggregator_add_persona_from_details_finish (data->self, data->_res_, &data->_inner_error_);
	data->_tmp10_ = data->_tmp9_;
	_g_object_unref0 (data->_tmp10_);
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_hash_table_unref0 (data->details);
			G_IS_VALUE (&data->addresses_value) ? (g_value_unset (&data->addresses_value), NULL) : NULL;
			block15_data_unref (data->_data15_);
			data->_data15_ = NULL;
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			_g_hash_table_unref0 (data->details);
			G_IS_VALUE (&data->addresses_value) ? (g_value_unset (&data->addresses_value), NULL) : NULL;
			block15_data_unref (data->_data15_);
			data->_data15_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	_g_hash_table_unref0 (data->details);
	G_IS_VALUE (&data->addresses_value) ? (g_value_unset (&data->addresses_value), NULL) : NULL;
	block15_data_unref (data->_data15_);
	data->_data15_ = NULL;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void folks_individual_aggregator_unlink_individual_data_free (gpointer _data) {
	FolksIndividualAggregatorUnlinkIndividualData* data;
	data = _data;
	_g_object_unref0 (data->individual);
	_g_object_unref0 (data->self);
	g_slice_free (FolksIndividualAggregatorUnlinkIndividualData, data);
}


void folks_individual_aggregator_unlink_individual (FolksIndividualAggregator* self, FolksIndividual* individual, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksIndividualAggregatorUnlinkIndividualData* _data_;
	_data_ = g_slice_new0 (FolksIndividualAggregatorUnlinkIndividualData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_individual_aggregator_unlink_individual);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_individual_aggregator_unlink_individual_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->individual = _g_object_ref0 (individual);
	folks_individual_aggregator_unlink_individual_co (_data_);
}


void folks_individual_aggregator_unlink_individual_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error) {
	FolksIndividualAggregatorUnlinkIndividualData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Unlinks the given {@link Individual} into its constituent {@link Persona}s.
   *
   * This completely unlinks the given {@link Individual}, destroying all of
   * its writeable {@link Persona}s.
   *
   * The {@link Individual}'s removal is signalled by
   * {@link IndividualAggregator.individuals_changed} and
   * {@link Individual.removed}.
   *
   * The {@link Persona}s comprising the {@link Individual} will be re-linked
   * into one or more new {@link Individual}s, depending on how much linking
   * data remains (typically only implicit links remain). The addition of these
   * new {@link Individual}s will be signalled by
   * {@link IndividualAggregator.individuals_changed}.
   *
   * @param individual the {@link Individual} to unlink
   * @since 0.1.13
   */
static void folks_individual_aggregator_unlink_individual_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksIndividualAggregatorUnlinkIndividualData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	folks_individual_aggregator_unlink_individual_co (data);
}


static gboolean folks_individual_aggregator_unlink_individual_co (FolksIndividualAggregatorUnlinkIndividualData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (data->self->priv->_linking_enabled == FALSE) {
		data->_tmp0_ = NULL;
		data->_tmp0_ = folks_individual_get_id (data->individual);
		g_debug ("individual-aggregator.vala:928: Can't unlink Individual '%s': linking " \
"disabled.", data->_tmp0_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp1_ = NULL;
	data->_tmp1_ = folks_individual_get_id (data->individual);
	g_debug ("individual-aggregator.vala:936: Unlinking Individual '%s', deleting Pe" \
"rsonas:", data->_tmp1_);
	data->_tmp2_ = NULL;
	data->_tmp2_ = folks_individual_get_personas (data->individual);
	data->_tmp3_ = NULL;
	data->_tmp3_ = g_list_copy (data->_tmp2_);
	data->personas = data->_tmp3_;
	{
		data->p_collection = data->personas;
		for (data->p_it = data->p_collection; data->p_it != NULL; data->p_it = data->p_it->next) {
			data->p = (FolksPersona*) data->p_it->data;
			{
				g_object_ref ((GObject*) data->p);
			}
		}
	}
	{
		data->persona_collection = data->personas;
		for (data->persona_it = data->persona_collection; data->persona_it != NULL; data->persona_it = data->persona_it->next) {
			data->persona = (FolksPersona*) data->persona_it->data;
			{
				data->_tmp4_ = NULL;
				data->_tmp4_ = folks_persona_get_store (data->persona);
				if (data->_tmp4_ == data->self->priv->_writeable_store) {
					data->_tmp6_ = folks_persona_get_is_user (data->persona);
					if (data->_tmp6_) {
						data->_tmp5_ = "yes";
					} else {
						data->_tmp5_ = "no";
					}
					data->_tmp7_ = NULL;
					data->_tmp7_ = folks_persona_get_uid (data->persona);
					data->_tmp8_ = NULL;
					data->_tmp8_ = folks_persona_get_iid (data->persona);
					g_debug ("individual-aggregator.vala:950:     %s (is user: %s, IID: %s)", data->_tmp7_, data->_tmp5_, data->_tmp8_);
					data->_state_ = 1;
					folks_persona_store_remove_persona (data->self->priv->_writeable_store, data->persona, folks_individual_aggregator_unlink_individual_ready, data);
					return FALSE;
					_state_1:
					folks_persona_store_remove_persona_finish (data->self->priv->_writeable_store, data->_res_, &data->_inner_error_);
					if (data->_inner_error_ != NULL) {
						g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
						g_error_free (data->_inner_error_);
						_g_list_free0 (data->personas);
						if (data->_state_ == 0) {
							g_simple_async_result_complete_in_idle (data->_async_result);
						} else {
							g_simple_async_result_complete (data->_async_result);
						}
						g_object_unref (data->_async_result);
						return FALSE;
					}
				}
			}
		}
	}
	_g_list_free0 (data->personas);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


gboolean folks_individual_aggregator_get_is_prepared (FolksIndividualAggregator* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_prepared;
	return result;
}


GHashTable* folks_individual_aggregator_get_individuals (FolksIndividualAggregator* self) {
	GHashTable* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_individuals;
	return result;
}


static void folks_individual_aggregator_set_individuals (FolksIndividualAggregator* self, GHashTable* value) {
	GHashTable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_hash_table_ref0 (value);
	_g_hash_table_unref0 (self->priv->_individuals);
	self->priv->_individuals = _tmp0_;
	g_object_notify ((GObject *) self, "individuals");
}


FolksIndividual* folks_individual_aggregator_get_user (FolksIndividualAggregator* self) {
	FolksIndividual* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_user;
	return result;
}


static void folks_individual_aggregator_set_user (FolksIndividualAggregator* self, FolksIndividual* value) {
	FolksIndividual* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_user);
	self->priv->_user = _tmp0_;
	g_object_notify ((GObject *) self, "user");
}


static void g_cclosure_user_marshal_VOID__POINTER_POINTER_STRING_OBJECT_ENUM (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__POINTER_POINTER_STRING_OBJECT_ENUM) (gpointer data1, gpointer arg_1, gpointer arg_2, const char* arg_3, gpointer arg_4, gint arg_5, gpointer data2);
	register GMarshalFunc_VOID__POINTER_POINTER_STRING_OBJECT_ENUM callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 6);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__POINTER_POINTER_STRING_OBJECT_ENUM) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_pointer (param_values + 1), g_value_get_pointer (param_values + 2), g_value_get_string (param_values + 3), g_value_get_object (param_values + 4), g_value_get_enum (param_values + 5), data2);
}


static void folks_individual_aggregator_class_init (FolksIndividualAggregatorClass * klass) {
	folks_individual_aggregator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksIndividualAggregatorPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_individual_aggregator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_individual_aggregator_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_individual_aggregator_finalize;
	/**
	   * Whether {@link IndividualAggregator.prepare} has successfully completed for
	   * this aggregator.
	   *
	   * @since 0.3.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_AGGREGATOR_IS_PREPARED, g_param_spec_boolean ("is-prepared", "is-prepared", "is-prepared", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * A table mapping {@link Individual.id}s to their {@link Individual}s.
	   *
	   * This is the canonical set of {@link Individual}s provided by this
	   * IndividualAggregator.
	   *
	   * {@link Individual}s may be added or removed using
	   * {@link IndividualAggregator.add_persona_from_details} and
	   * {@link IndividualAggregator.remove_individual}, respectively.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_AGGREGATOR_INDIVIDUALS, g_param_spec_boxed ("individuals", "individuals", "individuals", G_TYPE_HASH_TABLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * The {@link Individual} representing the user.
	   *
	   * If it exists, this holds the {@link Individual} who is the user: the
	   * {@link Individual} containing the {@link Persona}s who are the owners of
	   * the accounts for their respective backends.
	   *
	   * @since 0.3.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_AGGREGATOR_USER, g_param_spec_object ("user", "user", "user", FOLKS_TYPE_INDIVIDUAL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Emitted when one or more {@link Individual}s are added to or removed from
	   * the aggregator.
	   *
	   * This will not be emitted until after {@link IndividualAggregator.prepare}
	   * has been called.
	   *
	   * @param added a list of {@link Individual}s which have been removed
	   * @param removed a list of {@link Individual}s which have been removed
	   * @param message a string message from the backend, if any
	   * @param actor the {@link Persona} who made the change, if known
	   * @param reason the reason for the change
	   */
	g_signal_new ("individuals_changed", FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__POINTER_POINTER_STRING_OBJECT_ENUM, G_TYPE_NONE, 5, G_TYPE_POINTER, G_TYPE_POINTER, G_TYPE_STRING, FOLKS_TYPE_PERSONA, FOLKS_GROUP_DETAILS_TYPE_CHANGE_REASON);
}


static void folks_individual_aggregator_instance_init (FolksIndividualAggregator * self) {
	self->priv = FOLKS_INDIVIDUAL_AGGREGATOR_GET_PRIVATE (self);
	self->priv->_linking_enabled = TRUE;
	g_static_rec_mutex_init (&self->priv->__lock__is_prepared);
	self->priv->_is_prepared = FALSE;
}


static void folks_individual_aggregator_finalize (GObject* obj) {
	FolksIndividualAggregator * self;
	self = FOLKS_INDIVIDUAL_AGGREGATOR (obj);
	_g_object_unref0 (self->priv->_backend_store);
	_g_object_unref0 (self->priv->_stores);
	_g_object_unref0 (self->priv->_backends);
	_g_hash_table_unref0 (self->priv->_link_map);
	g_static_rec_mutex_free (&self->priv->__lock__is_prepared);
	_g_hash_table_unref0 (self->priv->_individuals);
	_g_object_unref0 (self->priv->_user);
	G_OBJECT_CLASS (folks_individual_aggregator_parent_class)->finalize (obj);
}


/**
 * Stores {@link Individual}s which have been created through
 * aggregation of all the {@link Persona}s provided by the various
 * {@link Backend}s.
 *
 * This is the main interface for client applications.
 */
GType folks_individual_aggregator_get_type (void) {
	static volatile gsize folks_individual_aggregator_type_id__volatile = 0;
	if (g_once_init_enter (&folks_individual_aggregator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksIndividualAggregatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_individual_aggregator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksIndividualAggregator), 0, (GInstanceInitFunc) folks_individual_aggregator_instance_init, NULL };
		GType folks_individual_aggregator_type_id;
		folks_individual_aggregator_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksIndividualAggregator", &g_define_type_info, 0);
		g_once_init_leave (&folks_individual_aggregator_type_id__volatile, folks_individual_aggregator_type_id);
	}
	return folks_individual_aggregator_type_id__volatile;
}


static void _vala_folks_individual_aggregator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksIndividualAggregator * self;
	self = FOLKS_INDIVIDUAL_AGGREGATOR (object);
	switch (property_id) {
		case FOLKS_INDIVIDUAL_AGGREGATOR_IS_PREPARED:
		g_value_set_boolean (value, folks_individual_aggregator_get_is_prepared (self));
		break;
		case FOLKS_INDIVIDUAL_AGGREGATOR_INDIVIDUALS:
		g_value_set_boxed (value, folks_individual_aggregator_get_individuals (self));
		break;
		case FOLKS_INDIVIDUAL_AGGREGATOR_USER:
		g_value_set_object (value, folks_individual_aggregator_get_user (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_folks_individual_aggregator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksIndividualAggregator * self;
	self = FOLKS_INDIVIDUAL_AGGREGATOR (object);
	switch (property_id) {
		case FOLKS_INDIVIDUAL_AGGREGATOR_INDIVIDUALS:
		folks_individual_aggregator_set_individuals (self, g_value_get_boxed (value));
		break;
		case FOLKS_INDIVIDUAL_AGGREGATOR_USER:
		folks_individual_aggregator_set_user (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



