//------------------------------ $Keywords ----------------------------------
// GPGee - GNU Privacy Guard Explorer Extension
// TProgressForm.cpp - Generic progress bar form
// Copyright 2005, Kurt Fitzner <kfitzner@excelcia.org>
//---------------------------------------------------------------------------
// This file is part of GPGee.
//
// GPGee is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License (Version 2) as
// published by the Free Software Foundation.
//
// GPGee is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License (Version 2) as
// published by the Free Software Foundation.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// VCS: $Version: 1 $ $Revision: 2 $
/*
$History: **** V 1.0 by kfitzner ****
$History: * tprogressform.cpp - 2005-05-17 1:44:23 AM - 3006 Bytes
$History: * tprogressform.dfm - 2005-05-17 12:26:36 AM - 1434 Bytes
$History: * tprogressform.h - 2005-05-17 12:32:20 AM - 1001 Bytes
$History: * Addition of progress dialog
$History: **** V 1.1 by kfitzner ****
$History: * tprogressform.cpp - 2005-05-17 2:16:49 AM - 3320 Bytes
$History: * tprogressform.dfm - 2005-05-17 12:26:36 AM - 1434 Bytes
$History: * tprogressform.h - 2005-05-17 2:08:36 AM - 1057 Bytes
$History: * tprogressform.ddp - 2005-05-17 2:09:36 AM - 51 Bytes
$History: * Add constraints so won't go over 100%
$History: **** Latest ** V 1.2 by kfitzner ** 2005-08-08 6:51:14 AM ****
$History: * License change - remove option for later versions of GPL
*/
//----------------------------  $NoKeywords ---------------------------------


//---------------------------------------------------------------------------
// File Notes:
//---------------------------------------------------------------------------
// 16 May 2005 - Kurt Fitzner <kfitzner@excelcia.org>
//
// A small generic progress bar form.  Simple is good.
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "TProgressForm.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TProgressForm *ProgressForm;
//---------------------------------------------------------------------------
__fastcall TProgressForm::TProgressForm(TComponent* Owner, AnsiString Message): TForm(Owner)
{
  lblMessage->Caption = Message;
  ProgressBar->Position = 0;
  lblPercent->Caption = "0%";
  lblCount->Caption = "0/0";
}  // __fastcall TProgressForm::TProgressForm(TComponent* Owner): TForm(Owner)
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
void __fastcall TProgressForm::SetPosition(int Count, int Max)
{
  ProgressBar->Max = Max;
  ProgressBar->Position = Count;
  lblCount->Caption = String(Count) + "/" + String(max(Max,Count));
  lblPercent->Caption = String(min(Count * 100 / Max,100)) + "%";
}  // void __fastcall TProgressForm::SetPosition(int Count, int Max)
//---------------------------------------------------------------------------



