//---------------------------------------------------------------------------
// GPGee - GNU Privacy Guard Explorer Extension
// GPGeeSignEncrypt.h - 'Main' form code header
// Copyright 2005, Kurt Fitzner <kfitzner@excelcia.org>
//---------------------------------------------------------------------------
// This file is part of GPGee.
//
// GPGee is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License (Version 2) as
// published by the Free Software Foundation.
//
// GPGee is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
//---------------------------------------------------------------------------
#ifndef GPGeeSignEncryptH
#define GPGeeSignEncryptH
//---------------------------------------------------------------------------
#include "gpgme/gpgme.h"
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Grids.hpp>
#include <ExtCtrls.hpp>
#include <Buttons.hpp>
#include <ComCtrls.hpp>
#include <ImgList.hpp>
#include <Menus.hpp>
#include <Mask.hpp>
#include "CheckCombo.hpp"
//---------------------------------------------------------------------------
class TformGPGeeSignEncrypt : public TForm
{
__published:	// IDE-managed Components
  TPanel *pnlClient;
  TLabel *lblSigningKey;
  TRadioGroup *rgEncryptionOptions;
  TGroupBox *gbMiscOptions;
  TCheckBox *chbASCIIArmor;
  TButton *btnOk;
  TButton *btnCancel;
  TListView *lvPublicKeys;
  TLabel *lblKeyGroups;
  TComboBox *cbKeyGroups;
  TSpeedButton *btnGroupAdd;
  TSpeedButton *btnGroupModify;
  TSpeedButton *btnGroupDelete;
  TGroupBox *gbSignatureOptions;
  TRadioButton *radioNoSignature;
  TRadioButton *radioAttached;
  TRadioButton *radioDetached;
  TCheckBox *chbClearsign;
  TButton *btnHelp;
  TImageList *IconList;
  TCheckedComboBox *ccbSigningKey;
        TCheckBox *chbReadOnly;

  void __fastcall FormShow(TObject *Sender);
  void __fastcall lvPublicKeysColumnClick(TObject *Sender, TListColumn *Column);
  void __fastcall SanityCheck(TObject *Sender);
  void __fastcall lvPublicKeysChanging(TObject *Sender, TListItem *Item, TItemChange Change, bool &AllowChange);
  void __fastcall lvPublicKeysChange(TObject *Sender, TListItem *Item, TItemChange Change);
  void __fastcall btnOkClick(TObject *Sender);
  void __fastcall btnHelpClick(TObject *Sender);
  void __fastcall cbKeyGroupsChange(TObject *Sender);
  void __fastcall btnGroupAddClick(TObject *Sender);
  void __fastcall btnGroupModifyClick(TObject *Sender);
  void __fastcall btnGroupDeleteClick(TObject *Sender);
  void __fastcall cbKeyGroupsKeyUp(TObject *Sender, WORD &Key, TShiftState Shift);

private:	// User declarations
  AnsiString        sBinDir;                          // The directory where the DLL is located
  gpgme_ctx_t       ctxGPG;                           // GPGME context
  gpgme_keycache_t  cachePublic;                      // Public key cache
  gpgme_keycache_t  cacheSecret;                      // Secret key cache
  bool              bStartupSign, bStartupEncrypt;    // Store our startup default settings here
  TStringList       *FileNames;                       // Store the filenames for all the files we're operating on
  int               nEncryptCount;                    // The number of keys the user has selected to encrypt to
  int               nOpNumber;
  int               nPreviousOpNumber;
  bool              bCancelled;

  AnsiString        sGPGPath;
  AnsiString        sOptfile;
  AnsiString        sKeyring;
  AnsiString        sSecretKeyring;
  bool              bForceTrustMode;

  void __fastcall Cleanup(void);
  void __fastcall ReadDefaults(void);

protected:
  void __fastcall ResetGPGMEContext(gpgme_ctx_t *pCtx);

public:		// User declarations
  __fastcall TformGPGeeSignEncrypt(TComponent* Owner);
  __fastcall ~TformGPGeeSignEncrypt();
  int __fastcall ShowModalWithDefaults(bool bSign, bool bEncrypt, TStringList *FileNames);
  const char * __fastcall GetPassphrase(const char *desc);
};

int __stdcall SortByColumn(long Item1, long Item2, long Data);
static int  pubkeysLastSorted;
static bool pubkeysAscending;

#define GPGEE_ENCRYPTION_NONE 0
#define GPGEE_ENCRYPTION_PUBLIC 1
#define GPGEE_ENCRYPTION_SYMMETRIC 2
//---------------------------------------------------------------------------
static const char * PassphraseCallback(void *hook, const char *desc, void *dummy);
//---------------------------------------------------------------------------
extern PACKAGE TformGPGeeSignEncrypt *formGPGeeSignEncrypt;
//---------------------------------------------------------------------------
#endif
