/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.tool;

import gnu.crypto.cipher.CipherFactory;
import gnu.crypto.cipher.IBlockCipher;
import gnu.crypto.util.Util;
import java.security.InvalidKeyException;
import java.util.HashMap;

public final class NistKat {
    private String cipherName;
    private int keySize;
    private IBlockCipher cipher;
    private long encBlocks;
    private long decBlocks;
    private long keyCount;

    private NistKat(String cipherName, IBlockCipher cipher, int keySize) {
        this.cipherName = cipherName;
        this.cipher = cipher;
        this.keySize = keySize;
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            NistKat.printUsage();
            return;
        }
        try {
            doVT = false;
            doVK = false;
            cipherName = null;
            kSize = null;
            i = 0;
            while (i < args.length) {
                arg = args[i];
                if (!arg.startsWith("-")) ** GOTO lbl-1000
                option = arg.substring(1);
                if (option.equals("k")) {
                    doVK = true;
                } else if (option.equals("t")) {
                    doVT = true;
                } else if (option.equals("a")) {
                    doVK = true;
                    doVT = true;
                } else if (option.equals("h")) {
                    NistKat.printUsage();
                } else if (cipherName == null) {
                    cipherName = args[i];
                } else if (kSize == null) {
                    kSize = args[i];
                    break;
                }
                ++i;
            }
            if (!doVT && !doVK) {
                doVT = true;
                doVK = true;
            }
            if (cipherName == null) {
                System.err.println("Missing cipher name...");
                NistKat.printUsage();
                return;
            }
            cipher = CipherFactory.getInstance(cipherName);
            time = -System.currentTimeMillis();
            cmd = kSize == null ? new NistKat[]{new NistKat(cipherName, cipher, 128), new NistKat(cipherName, cipher, 192), new NistKat(cipherName, cipher, 256)} : new NistKat[]{new NistKat(cipherName, cipher, Integer.parseInt(kSize))};
            if (doVK) {
                System.out.println();
                System.out.println("=========================");
                System.out.println();
                System.out.println("Electronic Codebook (ECB) Mode");
                System.out.println("Variable Key Known Answer Tests");
                System.out.println();
                System.out.println("Algorithm Name: " + String.valueOf(cipherName));
                System.out.println();
                System.out.println("==========");
                i = 0;
                while (i < cmd.length) {
                    cmd[i].variableKeyKat();
                    ++i;
                }
            }
            if (doVT) {
                System.out.println();
                System.out.println("=========================");
                System.out.println();
                System.out.println("Electronic Codebook (ECB) Mode");
                System.out.println("Variable Text Known Answer Tests");
                System.out.println();
                System.out.println("Algorithm Name: " + String.valueOf(cipherName));
                i = 0;
                while (i < cmd.length) {
                    cmd[i].variableTextKat();
                    ++i;
                }
            }
            time += System.currentTimeMillis();
            encryptions = 0L;
            decryptions = 0L;
            keySetups = 0L;
            i = 0;
            while (i < cmd.length) {
                encryptions += cmd[i].encBlocks;
                decryptions += cmd[i].decBlocks;
                keySetups += cmd[i].keyCount;
                ++i;
            }
            System.out.println();
            System.out.println("Total execution time (ms): " + String.valueOf(time));
            System.out.println("During this time, " + String.valueOf(cipherName) + ":");
            System.out.println("  Encrypted " + String.valueOf(encryptions) + " blocks");
            System.out.println("  Decrypted " + String.valueOf(decryptions) + " blocks");
            System.out.println("  Created " + String.valueOf(keySetups) + " session keys");
        }
        catch (Exception x) {
            x.printStackTrace(System.err);
        }
    }

    private static final void printUsage() {
        System.err.println();
        System.err.println("Usage:");
        System.err.println("   gnu.crypto.tool.NistKat (options) cipher [key-size]");
        System.err.println();
        System.err.println("Where:");
        System.err.println("   cipher");
        System.err.println("      The canonical name of the cipher algorithm.");
        System.err.println("   key-size");
        System.err.println("      The key-size in bits to use for the algorithm.  If unspecified,");
        System.err.println("      then the three NIST key-sizes 128, 192 and 256 shall be used.");
        System.err.println();
        System.err.println("Options:");
        System.err.println("   -k | -t | -a");
        System.err.println("      Generate Variable Key Known Answer Test (KAT) data only, Variable");
        System.err.println("      Text KAT data only, or both.  For backward compatibility, if this");
        System.err.println("      option is unspecified, then -a (both Variable Text and Variable");
        System.err.println("      Key data) is activated.");
        System.err.println("   -h");
        System.err.println("      Print this help page.");
        System.err.println();
    }

    private void variableKeyKat() throws InvalidKeyException {
        int count = this.keySize / 8;
        int size = this.cipher.defaultBlockSize();
        byte[] k = new byte[count];
        byte[] pt = new byte[size];
        byte[] ct = new byte[size];
        byte[] cpt = new byte[size];
        int round = 0;
        System.out.println();
        System.out.println("KEYSIZE=" + String.valueOf(this.keySize));
        System.out.println();
        System.out.println("PT=" + Util.toString(pt));
        System.out.println();
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        int i = 0;
        while (i < count) {
            int j = 0;
            while (j < 8) {
                System.out.println("I=" + String.valueOf(++round));
                k[i] = (byte)(1 << 7 - j);
                System.out.println("KEY=" + Util.toString(k));
                map.put("gnu.crypto.cipher.key.material", k);
                this.cipher.init(map);
                ++this.keyCount;
                this.cipher.encryptBlock(pt, 0, ct, 0);
                ++this.encBlocks;
                System.out.print("CT=" + Util.toString(ct));
                this.cipher.decryptBlock(ct, 0, cpt, 0);
                ++this.decBlocks;
                this.cipher.reset();
                if (!Util.areEqual(pt, cpt)) {
                    System.out.print(" *** ERROR ***");
                }
                System.out.println();
                System.out.println();
                ++j;
            }
            k[i] = 0;
            ++i;
        }
        System.out.println("==========");
    }

    private void variableTextKat() throws InvalidKeyException {
        byte[] k = new byte[this.keySize / 8];
        int count = this.cipher.defaultBlockSize();
        byte[] pt = new byte[count];
        byte[] ct = new byte[count];
        byte[] cpt = new byte[count];
        int round = 0;
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        map.put("gnu.crypto.cipher.key.material", k);
        this.cipher.init(map);
        ++this.keyCount;
        System.out.println();
        System.out.println("KEYSIZE=" + String.valueOf(this.keySize));
        System.out.println();
        System.out.println("KEY=" + Util.toString(k));
        System.out.println();
        int i = 0;
        while (i < count) {
            int j = 0;
            while (j < 8) {
                System.out.println("I=" + String.valueOf(++round));
                pt[i] = (byte)(1 << 7 - j);
                System.out.println("PT=" + Util.toString(pt));
                this.cipher.encryptBlock(pt, 0, ct, 0);
                ++this.encBlocks;
                System.out.print("CT=" + Util.toString(ct));
                this.cipher.decryptBlock(ct, 0, cpt, 0);
                ++this.decBlocks;
                if (!Util.areEqual(pt, cpt)) {
                    System.out.print(" *** ERROR ***");
                }
                System.out.println();
                System.out.println();
                ++j;
            }
            pt[i] = 0;
            ++i;
        }
        this.cipher.reset();
        System.out.println("==========");
    }
}

