/*
 * Decompiled with CFR 0.152.
 */
package test.sig.dss;

import gnu.crypto.sig.dss.DSSKeyPairGenerator;
import gnu.crypto.util.Prime;
import java.lang.constant.Constable;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.util.HashMap;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestOfDSSKeyGeneration
extends TestCase {
    static /* synthetic */ Class class$test$sig$dss$TestOfDSSKeyGeneration;

    public TestOfDSSKeyGeneration(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestOfDSSKeyGeneration.suite());
    }

    public static Test suite() {
        return new TestSuite(class$test$sig$dss$TestOfDSSKeyGeneration == null ? (class$test$sig$dss$TestOfDSSKeyGeneration = TestOfDSSKeyGeneration.class$("test.sig.dss.TestOfDSSKeyGeneration")) : class$test$sig$dss$TestOfDSSKeyGeneration);
    }

    public void testKeyPairGeneration() {
        DSSKeyPairGenerator kpg = new DSSKeyPairGenerator();
        HashMap<String, Constable> map = new HashMap<String, Constable>();
        map.put("gnu.crypto.dss.L", new Integer(530));
        try {
            kpg.setup(map);
            Assert.fail((String)"L should be <= 1024 and of the form 512 + 64n");
        }
        catch (IllegalArgumentException x) {
            Assert.assertTrue((String)"L should be <= 1024 and of the form 512 + 64n", (boolean)true);
        }
        map.put("gnu.crypto.dss.L", new Integer(512));
        map.put("gnu.crypto.dss.use.defaults", new Boolean(false));
        kpg.setup(map);
        KeyPair kp = kpg.generate();
        BigInteger p1 = ((DSAPublicKey)kp.getPublic()).getParams().getP();
        BigInteger p2 = ((DSAPrivateKey)kp.getPrivate()).getParams().getP();
        Assert.assertTrue((String)"p1.equals(p2)", (boolean)p1.equals(p2));
        BigInteger q1 = ((DSAPublicKey)kp.getPublic()).getParams().getQ();
        BigInteger q2 = ((DSAPrivateKey)kp.getPrivate()).getParams().getQ();
        Assert.assertTrue((String)"q1.equals(q2)", (boolean)q1.equals(q2));
        BigInteger g1 = ((DSAPublicKey)kp.getPublic()).getParams().getG();
        BigInteger g2 = ((DSAPrivateKey)kp.getPrivate()).getParams().getG();
        Assert.assertTrue((String)"g1.equals(g2)", (boolean)g1.equals(g2));
        Assert.assertTrue((String)"q is probable prime", (boolean)Prime.isProbablePrime((BigInteger)q1, (boolean)true));
        Assert.assertTrue((String)"p is probable prime", (boolean)Prime.isProbablePrime((BigInteger)p1, (boolean)true));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

