/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.Consumer;
import gnu.lists.IntSequence;
import gnu.lists.SimpleVector;

public class F32Vector
extends SimpleVector<Float>
implements Comparable {
    float[] data;
    protected static float[] empty = new float[0];

    public F32Vector() {
        this.data = empty;
    }

    public F32Vector(int size, float value) {
        float[] array = new float[size];
        this.data = array;
        if (value != 0.0f) {
            while (--size >= 0) {
                array[size] = value;
            }
        }
    }

    public F32Vector(int size) {
        this(new float[size]);
    }

    public F32Vector(float[] data) {
        this.data = data;
    }

    public F32Vector(float[] data, IntSequence indexes) {
        this.data = data;
        this.indexes = indexes;
    }

    public F32Vector(float[] values, int offset, int length) {
        this(length);
        System.arraycopy(values, offset, this.data, 0, length);
    }

    @Override
    public int getBufferLength() {
        return this.data.length;
    }

    @Override
    public void setBufferLength(int length) {
        int oldLength = this.data.length;
        if (oldLength != length) {
            float[] tmp = new float[length];
            System.arraycopy(this.data, 0, tmp, 0, oldLength < length ? oldLength : length);
            this.data = tmp;
        }
    }

    public float[] getBuffer() {
        return this.data;
    }

    @Override
    protected void setBuffer(Object buffer) {
        this.data = (float[])buffer;
    }

    public final float floatAt(int index) {
        if (this.indexes != null) {
            index = this.indexes.intAt(index);
        }
        return this.data[index];
    }

    public final float floatAtBuffer(int index) {
        return this.data[index];
    }

    @Override
    public final Float get(int index) {
        if (this.indexes != null) {
            index = this.indexes.intAt(index);
        }
        return Float.valueOf(this.data[index]);
    }

    @Override
    public final Float getBuffer(int index) {
        return Float.valueOf(this.data[index]);
    }

    public final void setFloatAt(int index, float value) {
        this.checkCanWrite();
        if (this.indexes != null) {
            index = this.indexes.intAt(index);
        }
        this.data[index] = value;
    }

    public final void setFloatAtBuffer(int index, float value) {
        this.data[index] = value;
    }

    @Override
    public final void setBuffer(int index, Float value) {
        this.data[index] = value.floatValue();
    }

    public void add(float v) {
        int sz = this.size();
        this.addSpace(sz, 1);
        this.setFloatAt(sz, v);
    }

    @Override
    protected void clearBuffer(int start, int count) {
        float[] d = this.data;
        while (--count >= 0) {
            d[start++] = 0.0f;
        }
    }

    protected F32Vector withIndexes(IntSequence ind) {
        return new F32Vector(this.data, ind);
    }

    @Override
    public F32Vector subList(int fromIx, int toIx) {
        return new F32Vector(this.data, this.indexesSubList(fromIx, toIx));
    }

    public int getElementKind() {
        return 25;
    }

    @Override
    public String getTag() {
        return "f32";
    }

    @Override
    public void consumePosRange(int iposStart, int iposEnd, Consumer out) {
        if (out.ignoring()) {
            return;
        }
        int end = this.nextIndex(iposEnd);
        for (int i = this.nextIndex(iposStart); i < end; ++i) {
            out.writeFloat(this.floatAt(i));
        }
    }

    public int compareTo(Object obj) {
        F32Vector vec2 = (F32Vector)obj;
        float[] arr1 = this.data;
        float[] arr2 = vec2.data;
        int n1 = this.size();
        int n2 = vec2.size();
        IntSequence inds1 = this.getIndexesForce();
        IntSequence inds2 = vec2.getIndexesForce();
        int n = n1 > n2 ? n2 : n1;
        for (int i = 0; i < n; ++i) {
            float v2;
            float v1 = arr1[inds1.intAt(i)];
            if (v1 == (v2 = arr2[inds2.intAt(i)])) continue;
            return v1 > v2 ? 1 : -1;
        }
        return n1 - n2;
    }
}

