/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.vectorgraphics2d.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public abstract class DataUtils {
    protected DataUtils() {
        throw new UnsupportedOperationException();
    }

    public static <K, V> Map<K, V> map(K[] keys, V[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Cannot create a Map: The number of keys and values differs.");
        }
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            K key = keys[i];
            V value = values[i];
            map.put(key, value);
        }
        return map;
    }

    public static String join(String separator, List<?> elements) {
        if (elements == null || elements.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(elements.size() * 3);
        int i = 0;
        for (Object elem : elements) {
            if (separator.length() > 0 && i++ > 0) {
                sb.append(separator);
            }
            sb.append(DataUtils.format(elem));
        }
        return sb.toString();
    }

    public static String join(String separator, Object[] elements) {
        if (elements == null || elements.length == 0) {
            return "";
        }
        return DataUtils.join(separator, Arrays.asList(elements));
    }

    public static String join(String separator, double[] elements) {
        if (elements == null || elements.length == 0) {
            return "";
        }
        ArrayList<Double> list = new ArrayList<Double>(elements.length);
        double[] dArray = elements;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            Double element = dArray[i];
            list.add(element);
        }
        return DataUtils.join(separator, list);
    }

    public static String join(String separator, float[] elements) {
        if (elements == null || elements.length == 0) {
            return "";
        }
        ArrayList<Float> list = new ArrayList<Float>(elements.length);
        float[] fArray = elements;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            Float element = Float.valueOf(fArray[i]);
            list.add(element);
        }
        return DataUtils.join(separator, list);
    }

    public static int max(int ... values) {
        int max = values[0];
        for (int i = 1; i < values.length; ++i) {
            if (values[i] <= max) continue;
            max = values[i];
        }
        return max;
    }

    public static void transfer(InputStream in, OutputStream out, int bufferSize) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[bufferSize];
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
    }

    public static String format(Number number) {
        String formatted = number instanceof Double || number instanceof Float ? Double.toString(number.doubleValue()).replaceAll("\\.0+$", "").replaceAll("(\\.[0-9]*[1-9])0+$", "$1") : number.toString();
        return formatted;
    }

    public static String format(Object obj) {
        if (obj instanceof Number) {
            return DataUtils.format((Number)obj);
        }
        return obj.toString();
    }

    public static List<Float> asList(float[] elements) {
        int size = elements != null ? elements.length : 0;
        ArrayList<Float> list = new ArrayList<Float>(size);
        if (elements != null) {
            float[] fArray = elements;
            int n = fArray.length;
            for (int i = 0; i < n; ++i) {
                Float elem = Float.valueOf(fArray[i]);
                list.add(elem);
            }
        }
        return list;
    }

    public static List<Double> asList(double[] elements) {
        int size = elements != null ? elements.length : 0;
        ArrayList<Double> list = new ArrayList<Double>(size);
        if (elements != null) {
            double[] dArray = elements;
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                Double elem = dArray[i];
                list.add(elem);
            }
        }
        return list;
    }

    public static String stripTrailing(String s, String substr) {
        return s.replaceAll("(" + Pattern.quote(substr) + ")+$", "");
    }
}

