/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.vectorgraphics2d.pdf;

import de.erichseifert.vectorgraphics2d.pdf.PDFObject;
import de.erichseifert.vectorgraphics2d.util.DataUtils;
import de.erichseifert.vectorgraphics2d.util.GraphicsUtils;
import java.awt.Font;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

class Resources
extends PDFObject {
    private static final String KEY_PROC_SET = "ProcSet";
    private static final String KEY_TRANSPARENCY = "ExtGState";
    private static final String KEY_FONT = "Font";
    private static final String KEY_IMAGE = "XObject";
    private static final String[] VALUE_PROC_SET = new String[]{"PDF", "Text", "ImageB", "ImageC", "ImageI"};
    private static final String PREFIX_FONT = "Fnt";
    private static final String PREFIX_IMAGE = "Img";
    private static final String PREFIX_TRANSPARENCY = "Trp";
    private final Map<Font, String> fonts;
    private final Map<PDFObject, String> images;
    private final Map<Double, String> transparencies;
    private final AtomicInteger currentFontId = new AtomicInteger();
    private final AtomicInteger currentImageId = new AtomicInteger();
    private final AtomicInteger currentTransparencyId = new AtomicInteger();

    public Resources(int id, int version) {
        super(id, version, null, null, false);
        this.fonts = new HashMap<Font, String>();
        this.images = new HashMap<PDFObject, String>();
        this.transparencies = new HashMap<Double, String>();
        this.dict.put(KEY_PROC_SET, VALUE_PROC_SET);
    }

    private <T> String getResourceId(Map<T, String> resources, T resource, String idPrefix, AtomicInteger idCounter) {
        String id = resources.get(resource);
        if (id == null) {
            id = String.format("%s%d", idPrefix, idCounter.getAndIncrement());
            resources.put(resource, id);
        }
        return id;
    }

    public String getId(Font font) {
        LinkedHashMap<String, Map<String, Object>> dictEntry = (LinkedHashMap<String, Map<String, Object>>)this.dict.get(KEY_FONT);
        if (dictEntry == null) {
            dictEntry = new LinkedHashMap<String, Map<String, Object>>();
            this.dict.put(KEY_FONT, dictEntry);
        }
        font = GraphicsUtils.getPhysicalFont(font);
        String resourceId = this.getResourceId(this.fonts, font, PREFIX_FONT, this.currentFontId);
        String fontName = font.getPSName();
        String fontEncoding = "WinAnsiEncoding";
        dictEntry.put(resourceId, DataUtils.map(new String[]{"Type", "Subtype", "Encoding", "BaseFont"}, new Object[]{KEY_FONT, "TrueType", fontEncoding, fontName}));
        return resourceId;
    }

    public String getId(PDFObject image) {
        LinkedHashMap<String, PDFObject> dictEntry = (LinkedHashMap<String, PDFObject>)this.dict.get(KEY_IMAGE);
        if (dictEntry == null) {
            dictEntry = new LinkedHashMap<String, PDFObject>();
            this.dict.put(KEY_IMAGE, dictEntry);
        }
        String resourceId = this.getResourceId(this.images, image, PREFIX_IMAGE, this.currentImageId);
        dictEntry.put(resourceId, image);
        return resourceId;
    }

    public String getId(Double transparency) {
        LinkedHashMap<String, Map<String, Object>> dictEntry = (LinkedHashMap<String, Map<String, Object>>)this.dict.get(KEY_TRANSPARENCY);
        if (dictEntry == null) {
            dictEntry = new LinkedHashMap<String, Map<String, Object>>();
            this.dict.put(KEY_TRANSPARENCY, dictEntry);
        }
        String resourceId = this.getResourceId(this.transparencies, transparency, PREFIX_TRANSPARENCY, this.currentTransparencyId);
        dictEntry.put(resourceId, DataUtils.map(new String[]{"Type", "ca", "CA"}, new Object[]{KEY_TRANSPARENCY, transparency, transparency}));
        return resourceId;
    }
}

