/*
 * Decompiled with CFR 0.152.
 */
package kawa.lang;

import gnu.bytecode.ClassType;
import gnu.bytecode.Field;
import gnu.bytecode.Type;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.mapping.ProcedureN;
import gnu.mapping.WrappedException;
import gnu.mapping.WrongArguments;
import kawa.lang.GenericError;

public class RecordConstructor
extends ProcedureN {
    ClassType type;
    Field[] fields;

    public RecordConstructor(ClassType classType, Field[] fieldArray) {
        this.type = classType;
        this.fields = fieldArray;
    }

    public RecordConstructor(Class clazz, Field[] fieldArray) {
        this((ClassType)Type.make(clazz), fieldArray);
    }

    public RecordConstructor(Class clazz) {
        this.init((ClassType)Type.make(clazz));
    }

    public RecordConstructor(ClassType classType) {
        this.init(classType);
    }

    private void init(ClassType classType) {
        this.type = classType;
        Field field = classType.getFields();
        int n = 0;
        for (Field field2 = field; field2 != null; field2 = field2.getNext()) {
            if ((field2.getModifiers() & 9) != 1) continue;
            ++n;
        }
        this.fields = new Field[n];
        int n2 = 0;
        for (Field field3 = field; field3 != null; field3 = field3.getNext()) {
            if ((field3.getModifiers() & 9) != 1) continue;
            this.fields[n2++] = field3;
        }
    }

    public RecordConstructor(Class clazz, Object object2) {
        this((ClassType)Type.make(clazz), object2);
    }

    public RecordConstructor(ClassType classType, Object object2) {
        this.type = classType;
        if (object2 == null) {
            this.init(classType);
        } else {
            int n = LList.listLength(object2, false);
            this.fields = new Field[n];
            Field field = classType.getFields();
            for (int i = 0; i < n; ++i) {
                Pair pair = (Pair)object2;
                String string = pair.getCar().toString();
                Field field2 = field;
                while (true) {
                    if (field2 == null) {
                        throw new RuntimeException("no such field " + string + " in " + classType.getName());
                    }
                    if (field2.getSourceName() == string) break;
                    field2 = field2.getNext();
                }
                this.fields[i] = field2;
                object2 = pair.getCdr();
            }
        }
    }

    public int numArgs() {
        int n = this.fields.length;
        return n << 12 | n;
    }

    public String getName() {
        return this.type.getName() + " constructor";
    }

    public Object applyN(Object[] objectArray) {
        Object t;
        try {
            t = this.type.getReflectClass().newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new GenericError(instantiationException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new GenericError(illegalAccessException.toString());
        }
        if (objectArray.length != this.fields.length) {
            throw new WrongArguments(this, objectArray.length);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            Field field = this.fields[i];
            try {
                field.getReflectField().set(t, objectArray[i]);
                continue;
            }
            catch (Exception exception) {
                throw new WrappedException("illegal access for field " + field.getName(), exception);
            }
        }
        return t;
    }
}

