/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.mapping.Symbol;
import gnu.mapping.SymbolRef;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.Hashtable;

public class Namespace
implements Externalizable {
    static final Hashtable nsTable = new Hashtable(50);
    public static final Namespace EmptyNamespace = Namespace.getInstance("");
    String name;
    protected SymbolRef[] table;
    int log2Size;
    private int mask;
    int num_bindings;

    public final String getName() {
        return this.name;
    }

    public final void setName(String string) {
        this.name = string;
    }

    public Namespace() {
        this(64);
    }

    public Namespace(int n) {
        this.log2Size = 4;
        while (n > 1 << this.log2Size) {
            ++this.log2Size;
        }
        n = 1 << this.log2Size;
        this.table = new SymbolRef[n];
        this.mask = n - 1;
    }

    protected Namespace(String string, int n) {
        this.name = string;
    }

    public static Namespace getDefault() {
        return EmptyNamespace;
    }

    public static Symbol getDefaultSymbol(String string) {
        return EmptyNamespace.getSymbol(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Namespace getInstance(String string) {
        if (string == null) {
            string = "";
        }
        Hashtable hashtable = nsTable;
        synchronized (hashtable) {
            Namespace namespace = (Namespace)nsTable.get(string);
            if (namespace != null) {
                return namespace;
            }
            namespace = new Namespace();
            namespace.setName(string);
            nsTable.put(string, namespace);
            return namespace;
        }
    }

    public Symbol getSymbol(String string) {
        return this.lookup(string, string.hashCode(), true);
    }

    public Symbol lookup(String string) {
        return this.lookup(string, string.hashCode(), false);
    }

    protected final Symbol lookupInternal(String string, int n) {
        int n2 = n & this.mask;
        SymbolRef symbolRef = null;
        SymbolRef symbolRef2 = this.table[n2];
        while (symbolRef2 != null) {
            SymbolRef symbolRef3 = symbolRef2.next;
            Symbol symbol = symbolRef2.getSymbol();
            if (symbol == null) {
                if (symbolRef == null) {
                    this.table[n2] = symbolRef3;
                } else {
                    symbolRef.next = symbolRef3;
                }
                --this.num_bindings;
            } else {
                if (symbol.name.equals(string)) {
                    return symbol;
                }
                symbolRef = symbolRef2;
            }
            symbolRef2 = symbolRef3;
        }
        return null;
    }

    public Symbol add(Symbol symbol, int n) {
        int n2 = n & this.mask;
        SymbolRef symbolRef = new SymbolRef(symbol, this);
        symbol.namespace = this;
        symbolRef.next = this.table[n2];
        this.table[n2] = symbolRef;
        ++this.num_bindings;
        if (this.num_bindings >= this.table.length) {
            this.rehash();
        }
        return symbol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Symbol lookup(String string, int n, boolean bl) {
        Namespace namespace = this;
        synchronized (namespace) {
            Symbol symbol = this.lookupInternal(string, n);
            if (symbol != null) {
                return symbol;
            }
            if (bl) {
                return this.add(new Symbol(string), n);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Symbol symbol) {
        Namespace namespace = this;
        synchronized (namespace) {
            String string = symbol.name;
            int n = string.hashCode();
            int n2 = n & this.mask;
            SymbolRef symbolRef = null;
            SymbolRef symbolRef2 = this.table[n2];
            while (symbolRef2 != null) {
                SymbolRef symbolRef3 = symbolRef2.next;
                Symbol symbol2 = symbolRef2.getSymbol();
                if (symbol2 == null || symbol2 == symbol) {
                    if (symbolRef == null) {
                        this.table[n2] = symbolRef3;
                    } else {
                        symbolRef.next = symbolRef3;
                    }
                    --this.num_bindings;
                    if (symbol2 != null) {
                        return true;
                    }
                } else {
                    symbolRef = symbolRef2;
                }
                symbolRef2 = symbolRef3;
            }
            return false;
        }
    }

    protected void rehash() {
        int n = this.table.length;
        int n2 = 2 * n;
        int n3 = n2 - 1;
        int n4 = 0;
        SymbolRef[] symbolRefArray = this.table;
        SymbolRef[] symbolRefArray2 = new SymbolRef[n2];
        int n5 = n;
        while (--n5 >= 0) {
            SymbolRef symbolRef = symbolRefArray[n5];
            while (symbolRef != null) {
                SymbolRef symbolRef2 = symbolRef.next;
                Symbol symbol = symbolRef.getSymbol();
                if (symbol != null) {
                    String string = symbol.getName();
                    int n6 = string.hashCode();
                    int n7 = n6 & n3;
                    ++n4;
                    symbolRef.next = symbolRefArray2[n7];
                    symbolRefArray2[n7] = symbolRef;
                }
                symbolRef = symbolRef2;
            }
        }
        this.table = symbolRefArray2;
        ++this.log2Size;
        this.mask = n3;
        this.num_bindings = n4;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.getName());
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.setName((String)objectInput.readObject());
    }

    public Object readResolve() throws ObjectStreamException {
        String string = this.getName();
        if (string != null) {
            Namespace namespace = (Namespace)nsTable.get(string);
            if (namespace != null) {
                return namespace;
            }
            nsTable.put(string, this);
        }
        return this;
    }

    public String toString() {
        return "ns[" + this.name + "@" + Integer.toHexString(System.identityHashCode(this)) + "]";
    }
}

