/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.xml;

import gnu.lists.Consumable;
import gnu.lists.Consumer;
import gnu.lists.FilterConsumer;
import gnu.lists.UnescapedData;
import gnu.mapping.OutPort;
import gnu.mapping.Symbol;
import gnu.xml.XMLPrinter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;

public class HttpPrinter
extends FilterConsumer {
    Vector headers = new Vector();
    StringBuffer sbuf = new StringBuffer(100);
    Object currentHeader;
    private int seenBeginDocument;
    protected String sawContentType;
    private int groupNesting;
    protected OutputStream ostream;
    OutPort writer;
    boolean seenXmlHeader;

    public HttpPrinter(OutputStream out) {
        super(null);
        this.ostream = out;
    }

    public HttpPrinter(OutPort out) {
        super(null);
        this.writer = out;
    }

    public static HttpPrinter make(OutPort out) {
        return new HttpPrinter(out);
    }

    private void writeRaw(String str) throws IOException {
        if (this.writer != null) {
            this.writer.write(str);
        } else {
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                this.ostream.write((byte)str.charAt(i));
            }
        }
    }

    public void printHeader(String label, String value) throws IOException {
        this.writeRaw(label);
        this.writeRaw(": ");
        this.writeRaw(value);
        this.writeRaw("\n");
    }

    public void printHeaders() throws IOException {
        int num = this.headers.size();
        for (int i = 0; i < num; i += 2) {
            this.printHeader(this.headers.elementAt(i).toString(), this.headers.elementAt(i + 1).toString());
        }
        this.writeRaw("\n");
    }

    public void addHeader(String label, String value) {
        if (label.equalsIgnoreCase("Content-type")) {
            this.sawContentType = value;
        }
        this.headers.addElement(label);
        this.headers.addElement(value);
    }

    public void beginAttribute(Object attrType) {
        if (this.base == null) {
            this.currentHeader = attrType;
        } else {
            this.base.beginAttribute(attrType);
        }
    }

    public void endAttribute() {
        if (this.currentHeader != null) {
            this.addHeader(this.currentHeader.toString(), this.sbuf.toString());
            this.sbuf.setLength(0);
            this.currentHeader = null;
        } else {
            this.base.endAttribute();
        }
    }

    public void beginData() {
        if (this.base == null) {
            if (this.sawContentType == null) {
                this.addHeader("Content-type", "text/html");
            }
            if (this.writer == null) {
                this.writer = new OutPort(this.ostream);
            }
            String style = null;
            if ("text/html".equalsIgnoreCase(this.sawContentType)) {
                style = "html";
            } else if ("text/xhtml".equalsIgnoreCase(this.sawContentType)) {
                style = "xhtml";
            } else if ("text/plain".equalsIgnoreCase(this.sawContentType)) {
                style = "plain";
            }
            this.base = XMLPrinter.make(this.writer, style);
            if (this.seenBeginDocument == 0) {
                this.base.beginDocument();
                this.seenBeginDocument = 1;
            }
            try {
                this.printHeaders();
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex.toString());
            }
        }
        this.append(this.sbuf);
        this.sbuf.setLength(0);
    }

    public void beginGroup(Object type) {
        if (this.sawContentType == null) {
            String mimeType = !this.seenXmlHeader ? "text/html" : (type instanceof Symbol && "html".equals(((Symbol)type).getLocalPart()) ? "text/xhtml" : "text/xml");
            this.addHeader("Content-type", mimeType);
        }
        this.beginData();
        this.base.beginGroup(type);
        ++this.groupNesting;
    }

    public void endGroup() {
        super.endGroup();
        --this.groupNesting;
        if (this.groupNesting == 0 && this.seenBeginDocument == 1) {
            this.endDocument();
        }
    }

    public void writeObject(Object v) {
        if (v instanceof Consumable && !(v instanceof UnescapedData)) {
            ((Consumable)v).consume(this);
        } else {
            this.beginData();
            super.writeObject(v);
        }
    }

    public Consumer append(CharSequence csq, int start, int end) {
        if (this.base == null) {
            if (csq == null) {
                csq = "null";
            }
            this.sbuf.append(((Object)csq.subSequence(start, end)).toString());
        } else {
            this.base.write(csq, start, end);
        }
        return this;
    }

    public Consumer append(CharSequence csq) {
        if (this.base == null) {
            this.sbuf.append(((Object)csq).toString());
        } else if (csq == null) {
            this.base.write("null");
        } else {
            this.base.write(csq, 0, csq.length());
        }
        return this;
    }

    public void write(char[] buf, int off, int len) {
        if (this.base == null) {
            this.sbuf.append(buf, off, len);
        } else {
            this.base.write(buf, off, len);
        }
    }

    public void beginDocument() {
        if (this.base != null) {
            this.base.beginDocument();
        }
        this.seenBeginDocument = 2;
    }

    public void endDocument() {
        if (this.base != null) {
            this.base.endDocument();
        }
        try {
            if (this.writer != null) {
                this.writer.close();
            }
            if (this.ostream != null) {
                this.ostream.flush();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

