/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.swing;

import gnu.jemacs.buffer.Signal;
import gnu.jemacs.swing.GapPosition;
import gnu.jemacs.swing.GapUndoableEdit;
import gnu.lists.CharBuffer;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.undo.UndoableEdit;

public class BufferContent
extends CharBuffer
implements AbstractDocument.Content {
    public BufferContent() {
        this(100);
    }

    public BufferContent(int n) {
        super(n);
        this.gapEnd = n - 1;
        this.getArray()[this.gapEnd] = 10;
    }

    protected int getChars(int n, int n2) throws BadLocationException {
        int n3 = this.length();
        if (n < 0 || n > n3) {
            throw new BadLocationException("bad location (in getChars)", n);
        }
        if (n2 < 0) {
            n2 = 0;
        } else if (n + n2 > n3) {
            n2 = n3 - n;
        }
        if (n + n2 <= this.gapStart) {
            return n;
        }
        if (n >= this.gapStart) {
            return n + (this.gapEnd - this.gapStart);
        }
        if (this.gapStart - n > n2 >> 1) {
            this.shiftGap(n + n2);
            return n;
        }
        this.shiftGap(n);
        return n + (this.gapEnd - this.gapStart);
    }

    public void getChars(int n, int n2, Segment segment) throws BadLocationException {
        segment.offset = this.getChars(n, n2);
        segment.array = this.getArray();
        segment.count = n2;
    }

    public String getString(int n, int n2) throws BadLocationException {
        return new String(this.getArray(), this.getChars(n, n2), n2);
    }

    public UndoableEdit remove(int n, int n2) throws BadLocationException {
        if (n2 < 0 || n < 0 || n + n2 > this.length()) {
            throw new BadLocationException("invalid remove", n);
        }
        this.delete(n, n2);
        GapUndoableEdit gapUndoableEdit = new GapUndoableEdit(n);
        gapUndoableEdit.content = this;
        gapUndoableEdit.data = new String(this.getArray(), this.gapEnd - n2, n2);
        gapUndoableEdit.nitems = n2;
        gapUndoableEdit.isInsertion = false;
        return gapUndoableEdit;
    }

    public UndoableEdit insertString(int n, String string, boolean bl) throws BadLocationException {
        if (n < 0 || n > this.length()) {
            throw new BadLocationException("bad insert", n);
        }
        this.insert(n, string, bl);
        GapUndoableEdit gapUndoableEdit = new GapUndoableEdit(n);
        gapUndoableEdit.content = this;
        gapUndoableEdit.data = string;
        gapUndoableEdit.nitems = string.length();
        gapUndoableEdit.isInsertion = true;
        return gapUndoableEdit;
    }

    public UndoableEdit insertString(int n, String string) throws BadLocationException {
        return this.insertString(n, string, false);
    }

    public Position createPosition(int n) throws BadLocationException {
        boolean bl;
        boolean bl2 = bl = n != 0;
        if (n < 0 || n > this.length()) {
            throw new BadLocationException("bad offset to createPosition", n);
        }
        return new GapPosition(this, n, bl);
    }

    public void dump() {
        System.err.println("Buffer Content dump.  size:" + this.size() + "  buffer:" + this.getArray().length);
        System.err.print("before gap: \"");
        System.err.print(new String(this.getArray(), 0, this.gapStart));
        System.err.println("\" (gapStart:" + this.gapStart + " gapEnd:" + this.gapEnd + ')');
        System.err.print("after gap: \"");
        System.err.print(new String(this.getArray(), this.gapEnd, this.getArray().length - this.gapEnd));
        System.err.println("\"");
        int n = this.positions == null ? 0 : this.positions.length;
        System.err.println("Positions (size: " + n + " free:" + this.free + "):");
        for (int i = 0; i < n; ++i) {
            int n2 = this.positions[i];
            if (!(this.free == -2 ? n2 != -2 : n2 != 0)) continue;
            System.err.println("position#" + i + ": " + (n2 >> 1) + " isAfter:" + (n2 & 1));
        }
    }

    public static int indexOf(char[] cArray, int n, int n2, char c) {
        for (int i = n; i < n2; ++i) {
            if (cArray[i] != c) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(char[] cArray, int n, int n2, char c) {
        for (int i = n; i >= n2; --i) {
            if (cArray[i] != c) continue;
            return i;
        }
        return -1;
    }

    public final long scan(char c, int n, int n2, int n3, boolean bl) {
        int n4;
        int n5 = n4 = n2 > this.gapStart ? n2 + this.gapEnd - this.gapStart : n2;
        if (n > this.gapStart) {
            n += this.gapEnd - this.gapStart;
        }
        if (n3 > 0) {
            while (n < n4 && n3 > 0) {
                int n6;
                if (n == this.gapStart) {
                    n = this.gapEnd;
                }
                int n7 = n < this.gapStart && n4 > this.gapStart ? this.gapStart : n4;
                if (bl) {
                    if (n7 - n > 5000) {
                        n7 = n + 5000;
                    }
                    Signal.checkQuit();
                }
                if ((n6 = BufferContent.indexOf(this.getArray(), n, n7, c)) >= 0) {
                    --n3;
                    n = n6 + 1;
                    continue;
                }
                n = n7;
            }
            if (n > this.gapEnd) {
                n -= this.gapEnd - this.gapStart;
            }
            return (long)n3 << 32 | (long)n;
        }
        while (n > n4 && n3 < 0) {
            int n8;
            if (n == this.gapEnd) {
                n = this.gapStart;
            }
            int n9 = n <= this.gapStart || n4 >= this.gapEnd ? n4 : this.gapEnd;
            if (bl) {
                if (n - n9 > 5000) {
                    n9 = n - 5000;
                }
                Signal.checkQuit();
            }
            if ((n8 = BufferContent.lastIndexOf(this.getArray(), n - 1, n9, c)) >= 0) {
                ++n3;
                n = n8;
                continue;
            }
            n = n9;
        }
        if (n >= this.gapEnd) {
            n -= this.gapEnd - this.gapStart;
        }
        if (n3 != 0) {
            return (long)(-n3) << 32 | (long)n;
        }
        return n + 1;
    }
}

