/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef CFG_GPIO_H
#define CFG_GPIO_H

#include <gpio.h>

static const struct pad_config gpio_table[] = {

	/* ------- GPIO Community 1 ------- */

	/* ------- GPIO Group GPP_G ------- */
	PAD_NC(GPP_G0, NONE),	/* GPIO */
	PAD_NC(GPP_G1, NONE),	/* GPIO */
	PAD_NC(GPP_G2, NONE),	/* GPIO */
	PAD_NC(GPP_G3, NONE),	/* GPIO */
	PAD_NC(GPP_G4, NONE),	/* GPIO */
	PAD_NC(GPP_G5, NONE),	/* GPIO */
	PAD_NC(GPP_G6, NONE),	/* GPIO */
	PAD_NC(GPP_G7, NONE),	/* GPIO */

	/* ------- GPIO Community 2 ------- */

	/* ------- GPIO Group HVMOS ------- */

	/* ------- GPIO Group GPP_E ------- */
	PAD_NC(GPP_E0, NONE),	/* GPIO */
	/* GPP_E1 - ACCL_1_INT_N */
	PAD_CFG_GPI_TRIG_OWN(GPP_E1, NONE, PLTRST, OFF, DRIVER),	/* GPIO */
	PAD_NC(GPP_E2, NONE),	/* GPIO */
	PAD_NC(GPP_E3, NONE),	/* GPIO */
	PAD_NC(GPP_E4, NONE),	/* GPIO */
	PAD_NC(GPP_E5, NONE),	/* GPIO */
	PAD_NC(GPP_E6, NONE),	/* GPIO */
	PAD_NC(GPP_E7, NONE),	/* GPIO */
	/* GPP_E8 - UART_BT_WAKE_N */
	//PAD_CFG_GPI_SCI(GPP_E8, NONE, DEEP, LEVEL, INVERT),	/* GPIO */
	PAD_NC(GPP_E8, NONE),
	PAD_NC(GPP_E9, NONE),	/* GPIO */
	PAD_NC(GPP_E10, NONE),	/* GPIO */
	PAD_NC(GPP_E11, NONE),	/* GPIO */
	PAD_NC(GPP_E12, NONE),	/* GPIO */
	PAD_NC(GPP_E13, NONE),	/* GPIO */
	PAD_NC(GPP_E14, NONE),	/* GPIO */
	PAD_NC(GPP_E15, NONE),	/* GPIO */
	PAD_NC(GPP_E16, NONE),	/* GPIO */
	PAD_NC(GPP_E17, NONE),	/* GPIO */
	PAD_NC(GPP_E18, NONE),	/* GPIO */
	PAD_NC(GPP_E19, NONE),	/* GPIO */
	PAD_CFG_NF(GPP_E20, NONE, DEEP, NF1),	/* CNV_BRI_DT */
	PAD_CFG_NF(GPP_E21, UP_20K, DEEP, NF1),	/* CNV_BRI_RSP */
	PAD_CFG_NF(GPP_E22, NONE, DEEP, NF1),	/* CNV_RGI_DT */
	PAD_CFG_NF(GPP_E23, UP_20K, DEEP, NF1),	/* CNV_RGI_RSP */

	/* ------- GPIO Community 4 ------- */

	/* ------- GPIO Group GPD ------- */
	PAD_CFG_NF(GPD0, NONE, RSMRST, NF1),	/* GPIO_BATLOWB */
	PAD_CFG_NF(GPD1, NATIVE, RSMRST, NF1),	/* GPIO_ACPRESENT */
	/* GPD2 - SMC_WAKE_SCI_N */
	PAD_CFG_GPI_SCI(GPD2, NONE, DEEP, LEVEL, INVERT),	/* GPIO */
	PAD_CFG_NF(GPD3, UP_20K, RSMRST, NF1),	/* GPIO_PWRBTNB */
	PAD_CFG_NF(GPD4, NONE, RSMRST, NF1),	/* GPIO_SLP_S3B */
	PAD_CFG_NF(GPD5, NONE, RSMRST, NF1),	/* GPIO_SLP_S4B */
	PAD_CFG_NF(GPD6, NONE, DEEP, NF1),	/* GPIO_SLP_AB */
	PAD_NC(GPD7, NONE),	/* GPIO */
	PAD_CFG_NF(GPD8, NONE, RSMRST, NF1),	/* GPIO_SUSCLK */
	PAD_CFG_NF(GPD9, NONE, DEEP, NF1),	/* GPIO_SLP_WLANB */
	PAD_CFG_NF(GPD10, NONE, DEEP, NF1),	/* GPIO_SLP_S5B */

	/* ------- GPIO Community 5 ------- */

	/* ------- GPIO Group GPP_H ------- */
	/* GPP_H0 - FPS_INT_N */
	PAD_CFG_GPI_APIC(GPP_H0, NONE, PLTRST, LEVEL, INVERT),	/* GPIO */
	PAD_NC(GPP_H1, NONE),	/* GPIO */
	PAD_CFG_NF(GPP_H2, NONE, DEEP, NF3),	/* MODEM_CLKREQ */
	PAD_NC(GPP_H3, NONE),	/* GPIO */
	PAD_CFG_NF(GPP_H4, NONE, DEEP, NF1),	/* I2C2_SDA */
	PAD_CFG_NF(GPP_H5, NONE, DEEP, NF1),	/* I2C2_SCL */
	PAD_CFG_NF(GPP_H6, NONE, DEEP, NF1),	/* I2C3_SDA */
	PAD_CFG_NF(GPP_H7, NONE, DEEP, NF1),	/* I2C3_SCL */
	PAD_NC(GPP_H8, NONE),	/* GPIO */
	PAD_NC(GPP_H9, NONE),	/* GPIO */
	PAD_NC(GPP_H10, NONE),	/* GPIO */
	PAD_NC(GPP_H11, NONE),	/* GPIO */
	PAD_CFG_NF(GPP_H12, NONE, DEEP, NF2),	/* CNV_RF_RESETB */
	PAD_NC(GPP_H13, NONE),	/* GPIO */
	PAD_NC(GPP_H14, NONE),	/* GPIO */
	PAD_NC(GPP_H15, NONE),	/* GPIO */
	/* GPP_H16 - FPS_RST_N */
	PAD_CFG_GPO(GPP_H16, 1, PLTRST),	/* GPIO */
	PAD_NC(GPP_H17, NONE),	/* GPIO */
	PAD_NC(GPP_H18, NONE),	/* GPIO */
	PAD_NC(GPP_H19, NONE),	/* GPIO */
	PAD_NC(GPP_H20, NONE),	/* GPIO */
	PAD_NC(GPP_H21, NONE),	/* GPIO */
	PAD_NC(GPP_H22, NONE),	/* GPIO */
	PAD_NC(GPP_H23, NONE),	/* GPIO */

	/* ------- GPIO Group GPP_D ------- */
	PAD_NC(GPP_D0, NONE),	/* GPIO */
	PAD_NC(GPP_D1, NONE),	/* GPIO */
	/* GPP_D2 - EC_SMI_N */
	PAD_CFG_GPI_SMI(GPP_D2, NONE, PLTRST, LEVEL, INVERT),	/* GPIO */
	PAD_NC(GPP_D3, NONE),	/* GPIO */
	/* GPP_D4 - GPIO_DK (keyboard dock sense) */
	PAD_CFG_GPI_SCI(GPP_D4, NONE, DEEP, EDGE_BOTH, NONE),	/* GPIO */
	/* GPP_D5 - SSD_RST_N (NVMe PERESET#) */
	PAD_CFG_GPO(GPP_D5, 1, PLTRST),	/* GPIO */
	/* GPP_D6 - TCH_PNL_RST_N */
	PAD_CFG_GPO(GPP_D6, 1, PLTRST),	/* GPIO */
	PAD_NC(GPP_D7, NONE),	/* GPIO */
	PAD_NC(GPP_D8, NONE),	/* GPIO */
	PAD_NC(GPP_D9, NONE),	/* GPIO */
	PAD_NC(GPP_D10, NONE),	/* GPIO */
	PAD_NC(GPP_D11, NONE),	/* GPIO */
	PAD_NC(GPP_D12, NONE),	/* GPIO */
	PAD_NC(GPP_D13, NONE),	/* GPIO */
	PAD_NC(GPP_D14, NONE),	/* GPIO */
	PAD_NC(GPP_D15, NONE),	/* GPIO */
	PAD_NC(GPP_D16, NONE),	/* GPIO */
	PAD_NC(GPP_D17, NONE),	/* GPIO */
	PAD_NC(GPP_D18, NONE),	/* GPIO */
	PAD_NC(GPP_D19, NONE),	/* GPIO */
	PAD_NC(GPP_D20, NONE),	/* GPIO */
	PAD_NC(GPP_D21, NONE),	/* GPIO */
	PAD_NC(GPP_D22, NONE),	/* GPIO */
	PAD_NC(GPP_D23, NONE),	/* GPIO */

	/* ------- GPIO Group VGPIO5 ------- */
	PAD_NC(VGPIO_0, NONE),	/* GPIO */
	PAD_NC(VGPIO_3, NONE),	/* GPIO */
	PAD_NC(VGPIO_4, NONE),	/* GPIO */
	PAD_NC(VGPIO_5, NONE),	/* GPIO */
	PAD_NC(VGPIO_6, NONE),	/* GPIO */
	PAD_NC(VGPIO_7, NONE),	/* GPIO */
	PAD_NC(VGPIO_8, NONE),	/* GPIO */
	PAD_NC(VGPIO_9, NONE),	/* GPIO */
	PAD_NC(VGPIO_10, NONE),	/* GPIO */
	PAD_NC(VGPIO_11, NONE),	/* GPIO */
	PAD_NC(VGPIO_12, NONE),	/* GPIO */
	PAD_NC(VGPIO_13, NONE),	/* GPIO */
	PAD_NC(VGPIO_18, NONE),	/* GPIO */
	PAD_NC(VGPIO_19, NONE),	/* GPIO */
	PAD_NC(VGPIO_20, NONE),	/* GPIO */
	PAD_NC(VGPIO_21, NONE),	/* GPIO */
	PAD_NC(VGPIO_22, NONE),	/* GPIO */
	PAD_NC(VGPIO_23, NONE),	/* GPIO */
	PAD_NC(VGPIO_24, NONE),	/* GPIO */
	PAD_NC(VGPIO_25, NONE),	/* GPIO */
	PAD_NC(VGPIO_30, NONE),	/* GPIO */
	PAD_NC(VGPIO_31, NONE),	/* GPIO */
	PAD_NC(VGPIO_32, NONE),	/* GPIO */
	PAD_NC(VGPIO_33, NONE),	/* GPIO */
	PAD_NC(VGPIO_34, NONE),	/* GPIO */
	PAD_NC(VGPIO_35, NONE),	/* GPIO */
	PAD_NC(VGPIO_36, NONE),	/* GPIO */
	PAD_NC(VGPIO_37, NONE),	/* GPIO */
	PAD_NC(VGPIO_39, NONE),	/* GPIO */

	/* ------- GPIO Group GPP_C ------- */
	PAD_NC(GPP_C0, NONE),	/* GPIO */
	PAD_NC(GPP_C1, NONE),	/* GPIO */
	PAD_NC(GPP_C2, NONE),	/* GPIO */
	PAD_NC(GPP_C3, NONE),	/* GPIO */
	PAD_NC(GPP_C4, NONE),	/* GPIO */
	PAD_NC(GPP_C5, NONE),	/* GPIO */
	PAD_NC(GPP_C6, NONE),	/* GPIO */
	PAD_NC(GPP_C7, NONE),	/* GPIO */
	PAD_CFG_GPO(GPP_C8, 1, PLTRST),	/* GPIO */
	PAD_NC(GPP_C9, NONE),	/* GPIO */
	PAD_NC(GPP_C10, NONE),	/* GPIO */
	PAD_NC(GPP_C11, NONE),	/* GPIO */
	/* GPP_C12 - TCH_PNL_INT_N */
	PAD_CFG_GPI_TRIG_OWN(GPP_C12, NONE, PLTRST, EDGE_SINGLE, DRIVER),	/* GPIO */
	PAD_NC(GPP_C13, NONE),	/* GPIO */
	PAD_NC(GPP_C14, NONE),	/* GPIO */
	PAD_NC(GPP_C15, NONE),	/* GPIO */
	PAD_NC(GPP_C16, NONE),	/* GPIO */
	PAD_NC(GPP_C17, NONE),	/* GPIO */
	PAD_NC(GPP_C18, NONE),	/* GPIO */
	PAD_NC(GPP_C19, NONE),	/* GPIO */
	/* GPP_C20, GPP_C21 configured in bootblock for UART2 */
	PAD_NC(GPP_C22, NONE),	/* GPIO */
	PAD_NC(GPP_C23, NONE),	/* GPIO */

	/* ------- GPIO Community 6 ------- */

	/* ------- GPIO Group GPP_F ------- */
	PAD_NC(GPP_F0, NONE),	/* GPIO */
	PAD_NC(GPP_F1, NONE),	/* GPIO */
	PAD_NC(GPP_F2, NONE),	/* GPIO */
	PAD_NC(GPP_F3, NONE),	/* GPIO */
	PAD_NC(GPP_F4, NONE),	/* GPIO */
	PAD_NC(GPP_F5, NONE),	/* GPIO */
	PAD_NC(GPP_F6, NONE),	/* GPIO */
	PAD_NC(GPP_F7, NONE),	/* GPIO */
	PAD_NC(GPP_F8, NONE),	/* GPIO */
	PAD_NC(GPP_F9, NONE),	/* GPIO */
	PAD_NC(GPP_F10, NONE),	/* GPIO */
	PAD_NC(GPP_F11, NONE),	/* GPIO */
	PAD_NC(GPP_F12, NONE),	/* GPIO */
	PAD_NC(GPP_F13, NONE),	/* GPIO */
	PAD_NC(GPP_F14, NONE),	/* GPIO */
	PAD_NC(GPP_F15, NONE),	/* GPIO */
	PAD_NC(GPP_F16, NONE),	/* GPIO */
	PAD_NC(GPP_F17, NONE),	/* GPIO */
	PAD_NC(GPP_F18, NONE),	/* GPIO */
	PAD_NC(GPP_F19, NONE),	/* GPIO */

	/* ------- GPIO Group GPP_SPI ------- */

	/* ------- GPIO Group GPP_B ------- */
	PAD_CFG_NF(GPP_B0, NONE, DEEP, NF1),	/* GPIO_CORE_VID0 */
	PAD_CFG_NF(GPP_B1, NONE, DEEP, NF1),	/* GPIO_CORE_VID1 */
	PAD_NC(GPP_B2, NONE),	/* GPIO */
	PAD_NC(GPP_B3, NONE),	/* GPIO */
	PAD_NC(GPP_B4, NONE),	/* GPIO */
	PAD_CFG_NF(GPP_B5, NONE, DEEP, NF1),	/* PCIE_CLKREQ0B */
	PAD_CFG_NF(GPP_B6, NONE, DEEP, NF1),	/* PCIE_CLKREQ1B */
	PAD_NC(GPP_B7, NONE),	/* GPIO */
	PAD_NC(GPP_B8, NONE),	/* GPIO */
	PAD_NC(GPP_B9, NONE),	/* GPIO */
	PAD_NC(GPP_B10, NONE),	/* GPIO */
	PAD_NC(GPP_B11, NONE),	/* GPIO */
	PAD_CFG_NF(GPP_B12, NONE, DEEP, NF1),	/* GPIO_SLP_S0B */
	PAD_CFG_NF(GPP_B13, NONE, DEEP, NF1),	/* GPIO_PLTRSTB */
	PAD_NC(GPP_B14, NONE),	/* GPIO */
	PAD_NC(GPP_B15, NONE),	/* GPIO */
	PAD_NC(GPP_B16, NONE),	/* GPIO */
	/* GPP_B17 - PCIE_WLAN_RST_N_R */
	PAD_CFG_GPO(GPP_B17, 1, PLTRST),	/* GPIO */
	PAD_NC(GPP_B18, NONE),	/* GPIO */
	PAD_CFG_NF(GPP_B19, NONE, DEEP, NF1),	/* GSPI1_CS0B */
	PAD_CFG_NF(GPP_B20, NONE, DEEP, NF1),	/* GSPI1_CLK */
	PAD_CFG_NF(GPP_B21, NONE, DEEP, NF1),	/* GSPI1_MISO */
	PAD_CFG_NF(GPP_B22, NONE, DEEP, NF1),	/* GSPI1_MOSI */
	PAD_CFG_NF(GPP_B23, NONE, DEEP, NF1),	/* DDI2_HPD */

	/* ------- GPIO Group GPP_A ------- */
	PAD_CFG_NF(GPP_A0, UP_20K, DEEP, NF1),	/* ESPI_IO_0 */
	PAD_CFG_NF(GPP_A1, UP_20K, DEEP, NF1),	/* ESPI_IO_1 */
	PAD_CFG_NF(GPP_A2, UP_20K, DEEP, NF1),	/* ESPI_IO_2 */
	PAD_CFG_NF(GPP_A3, UP_20K, DEEP, NF1),	/* ESPI_IO_3 */
	PAD_CFG_NF(GPP_A4, UP_20K, DEEP, NF1),	/* ESPI_CSB */
	PAD_CFG_NF(GPP_A5, DN_20K, DEEP, NF1),	/* ESPI_CLK */
	PAD_CFG_NF(GPP_A6, NONE, DEEP, NF1),	/* ESPI_RESETB */
	PAD_NC(GPP_A7, NONE),	/* GPIO */
	PAD_NC(GPP_A8, NONE),	/* GPIO */
	PAD_NC(GPP_A9, NONE),	/* GPIO */
	PAD_NC(GPP_A10, NONE),	/* GPIO */
	PAD_NC(GPP_A11, NONE),	/* GPIO */
	PAD_NC(GPP_A12, NONE),	/* GPIO */
	PAD_NC(GPP_A13, NONE),	/* GPIO */
	PAD_NC(GPP_A14, NONE),	/* GPIO */
	PAD_NC(GPP_A15, NONE),	/* GPIO */
	PAD_CFG_NF(GPP_A16, NONE, DEEP, NF1),	/* DDI1_HPD */
	PAD_CFG_NF(GPP_A17, NONE, DEEP, NF1),	/* DDI0_HPD */
	PAD_NC(GPP_A18, NONE),	/* GPIO */
	/* GPP_A19 - WWAN_DISABLE_3P3_N (actually for WLAN despite name) */
	PAD_CFG_GPO(GPP_A19, 1, PLTRST),	/* GPIO */

	/* ------- GPIO Group GPP_S ------- */
	PAD_NC(GPP_S0, NONE),	/* GPIO */
	PAD_NC(GPP_S1, NONE),	/* GPIO */
	PAD_NC(GPP_S2, NONE),	/* GPIO */
	PAD_NC(GPP_S3, NONE),	/* GPIO */
	PAD_NC(GPP_S4, NONE),	/* GPIO */
	PAD_NC(GPP_S5, NONE),	/* GPIO */
	PAD_NC(GPP_S6, NONE),	/* GPIO */
	PAD_NC(GPP_S7, NONE),	/* GPIO */

	/* ------- GPIO Group GPP_R ------- */
	PAD_CFG_NF(GPP_R0, NONE, DEEP, NF1),	/* HDA_BCLK */
	PAD_CFG_NF(GPP_R1, NATIVE, DEEP, NF1),	/* HDA_SYNC */
	PAD_CFG_NF(GPP_R2, NATIVE, DEEP, NF1),	/* HDA_SD0 */
	PAD_CFG_NF(GPP_R3, NATIVE, DEEP, NF1),	/* HDA_SDI0 */
	PAD_CFG_NF(GPP_R4, NONE, DEEP, NF1),	/* HDA_RSTB */
	PAD_NC(GPP_R5, NONE),	/* GPIO */
	PAD_NC(GPP_R6, NONE),	/* GPIO */
	PAD_NC(GPP_R7, NONE),	/* GPIO */
};

#endif /* CFG_GPIO_H */
