/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.CurrentReadable;
import com.sun.electric.tool.simulation.test.Equipment;
import com.sun.electric.tool.simulation.test.Infrastructure;
import com.sun.electric.tool.simulation.test.VoltageReadable;

public class HP34401A
extends Equipment
implements CurrentReadable,
VoltageReadable {
    public static final float MAX_AMPS = 3.0f;
    private String voltageRange = "DEF";
    private static final int NUM_TIMING_READS = 100;
    private String voltageResolution = "DEF";
    private String voltageNPLC = "DEF";
    private static final String[] ALLOWED_WORDS = new String[]{"DEFAULT", "MINIMUM", "MAXIMUM"};
    private int lastFunction = -1;
    private static final int FUNCTION_UNDEFINED = -1;
    private static final int FUNCTION_VOLTAGE = 0;
    private static final int FUNCTION_CURRENT = 1;

    public HP34401A(String name) {
        super(name);
        HP34401A.logInit("Initialized HP34401A named " + name);
    }

    public void setVoltageRange(String voltageRange) {
        this.testParameter(this.voltageResolution);
        this.voltageRange = voltageRange;
        if (this.lastFunction == 0) {
            this.lastFunction = -1;
        }
    }

    public String getVoltageRange() {
        return this.voltageRange;
    }

    public float readVoltageRange() {
        this.write("VOLT:DC:RANG?");
        return this.readFloat(40);
    }

    public void setVoltageResolution(String voltageResolution) {
        this.testParameter(voltageResolution);
        this.voltageResolution = voltageResolution;
        this.voltageNPLC = "DEF";
        if (this.lastFunction == 0) {
            this.lastFunction = -1;
        }
    }

    public String getVoltageResolution() {
        return this.voltageResolution;
    }

    public float readVoltageResolution() {
        this.write("VOLT:DC:RES?");
        return this.readFloat(40);
    }

    public void setVoltageNPLC(String voltageNPLC) {
        this.testParameter(this.voltageResolution);
        this.voltageNPLC = voltageNPLC;
        if (this.lastFunction == 0) {
            this.lastFunction = -1;
        }
    }

    public String getVoltageNPLC() {
        return this.voltageNPLC;
    }

    public float readVoltageNPLC() {
        this.write("VOLT:DC:NPLC?");
        return this.readFloat(40);
    }

    private void testParameter(String parameter) {
        try {
            Float.parseFloat(parameter);
            return;
        }
        catch (NumberFormatException numberFormatException) {
            String cased = parameter.trim().toUpperCase();
            int length = cased.length();
            for (int ind = 0; ind < ALLOWED_WORDS.length; ++ind) {
                if (!cased.equals(ALLOWED_WORDS[ind].substring(0, length))) continue;
                return;
            }
            Infrastructure.fatal("Invalid measurement parameter " + parameter + ".  Use \"MINimum\", \"MAXimum\", \"DEFault\", or a number.");
            return;
        }
    }

    @Override
    public float readVoltage() {
        if (this.lastFunction != 0) {
            this.logSet("Configuring voltage " + this.getVoltageRange() + ", " + this.getVoltageResolution() + ", " + this.getVoltageNPLC());
            this.write("CONF:VOLT:DC " + this.getVoltageRange() + "," + this.getVoltageResolution());
            if (!this.getVoltageNPLC().startsWith("DEF")) {
                this.logSet("FYI, non-default NPLC: " + this.getVoltageNPLC());
                this.write("VOLT:DC:NPLC " + this.getVoltageNPLC());
            }
        }
        this.write("READ?");
        this.lastFunction = 0;
        return this.readFloat(40);
    }

    @Override
    public float readCurrent() {
        this.write("MEAS:CURR:DC?");
        this.lastFunction = 1;
        return this.readFloat(40);
    }

    @Override
    public float readCurrent(float ampsExpected, float ampsResolution) {
        if (ampsExpected > 3.0f) {
            Infrastructure.nonfatal("WARNING: ampsExpected=" + ampsExpected + ", limiting to maximum: 3.0 A");
            this.write("MEAS:CURR:DC? MAX," + ampsResolution);
        } else {
            this.write("MEAS:CURR:DC? " + ampsExpected + "," + ampsResolution);
        }
        String s = this.read(40);
        return Float.parseFloat(s);
    }

    private long timeReadVoltage() {
        System.out.println(this.readVoltageRange() + "," + this.readVoltageResolution() + "," + this.readVoltageNPLC());
        long startTime = System.currentTimeMillis();
        for (int ind = 0; ind < 100; ++ind) {
            this.readVoltage();
        }
        long endTime = System.currentTimeMillis();
        System.out.println("dt = " + (endTime - startTime));
        return endTime - startTime;
    }

    private void timeVoltageReads() {
        System.out.println("\nFast:");
        this.setVoltageRange("DEF");
        this.setVoltageResolution("MAX");
        this.setVoltageNPLC("0.02");
        long time0_02 = this.timeReadVoltage();
        System.out.println("\nSame, but NPLC = 0.2");
        this.setVoltageNPLC("0.2");
        long time0_2 = this.timeReadVoltage();
        System.out.println("\nNPLC=0.2, resolution=DEF");
        this.setVoltageResolution("DEF");
        this.setVoltageNPLC("0.2");
        long timeDef0_02 = this.timeReadVoltage();
        System.out.println("\nSame, but NPLC = 1.0");
        this.setVoltageNPLC("1");
        long time1_0 = this.timeReadVoltage();
        System.out.println("\nMAX resolution times for 200 reads, as function of NPLC:");
        System.out.println("0.02: " + time0_02);
        System.out.println("0.20: " + time0_2 + "; DEF-res: " + timeDef0_02);
        System.out.println("1.00: " + time1_0);
    }

    private void testVoltageParameters() {
        System.out.println(this.readVoltageRange() + "," + this.readVoltageResolution() + "," + this.readVoltageNPLC());
        this.setVoltageRange("1");
        this.reportReadReport();
        this.setVoltageResolution("0.1");
        this.reportReadReport();
        this.setVoltageNPLC("1.353");
        this.reportReadReport();
        this.setVoltageNPLC("1");
        this.reportReadReport();
        this.setVoltageResolution("MAX");
        this.reportReadReport();
        this.setVoltageResolution("DEFRAG");
        this.reportReadReport();
        this.setVoltageResolution("0.00000J1");
        this.reportReadReport();
    }

    private void reportReadReport() {
        System.out.println(this.readVoltageRange() + "," + this.readVoltageResolution() + "," + this.readVoltageNPLC());
        System.out.println(this.readVoltage() + " V");
        System.out.println(this.readVoltageRange() + "," + this.readVoltageResolution() + "," + this.readVoltageNPLC());
    }

    public static void main(String[] args) {
        Infrastructure.gpibControllers = new int[]{1};
        HP34401A dvm = new HP34401A("hBotDMM");
        dvm.setAllLogging(true);
        dvm.testVoltageParameters();
    }
}

