/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.seaOfGates;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.constraint.Layout;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.ExportId;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.CellName;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.routing.Routing;
import com.sun.electric.tool.routing.SeaOfGates;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesCellBuilder;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesEngine;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesEngineFactory;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.util.math.FixpCoord;
import com.sun.electric.util.math.FixpRectangle;
import com.sun.electric.util.math.Orientation;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SeaOfGatesHandlers {
    private static final boolean USEMUTABLE = false;
    private static final Save SAVE_DEFAULT = Save.SAVE_PERIODIC;

    private SeaOfGatesHandlers() {
    }

    public static void startInJob(Cell cell, Collection<ArcInst> selected, SeaOfGatesEngineFactory.SeaOfGatesEngineType version) {
        SeaOfGatesHandlers.startInJob(cell, selected, version, SAVE_DEFAULT);
    }

    public static void startInJob(Cell cell, Collection<ArcInst> selected, SeaOfGatesEngineFactory.SeaOfGatesEngineType version, Save save) {
        new SeaOfGatesJob(cell, selected, version, save).startJob();
    }

    public static SeaOfGatesEngine.Handler getDefault(Cell cell, String resultCellName, Routing.SoGContactsStrategy contactPlacementAction, Job job, EditingPreferences ep) {
        return SeaOfGatesHandlers.getDefault(cell, resultCellName, contactPlacementAction, job, ep, SAVE_DEFAULT);
    }

    public static SeaOfGatesEngine.Handler getDefault(Cell cell, String resultCellName, Routing.SoGContactsStrategy contactPlacementAction, Job job, EditingPreferences ep, Save save) {
        return new DefaultSeaOfGatesHook(cell, resultCellName, contactPlacementAction, job, ep, save);
    }

    public static SeaOfGatesEngine.Handler getDummy(EditingPreferences ep, PrintStream out) {
        return new DummySeaOfGatesHandler(ep, out);
    }

    public static enum Save {
        SAVE_ONCE,
        SAVE_PERIODIC,
        SAVE_SNAPSHOTS;

    }

    private static class SeaOfGatesJob
    extends Job {
        private final Cell cell;
        private final int[] arcIdsToRoute;
        private final SeaOfGates.SeaOfGatesOptions prefs = new SeaOfGates.SeaOfGatesOptions();
        private final SeaOfGatesEngineFactory.SeaOfGatesEngineType version;
        private final Save save;

        protected SeaOfGatesJob(Cell cell, Collection<ArcInst> arcsToRoute, SeaOfGatesEngineFactory.SeaOfGatesEngineType version, Save save) {
            super("Sea-Of-Gates Route", Routing.getRoutingTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            if (arcsToRoute != null) {
                this.arcIdsToRoute = new int[arcsToRoute.size()];
                Iterator<ArcInst> it = arcsToRoute.iterator();
                for (int i = 0; i < arcsToRoute.size(); ++i) {
                    this.arcIdsToRoute[i] = it.next().getArcId();
                }
            } else {
                this.arcIdsToRoute = null;
            }
            this.prefs.getOptionsFromPreferences(false);
            this.version = version;
            this.save = save;
        }

        @Override
        public boolean doIt() throws JobException {
            SeaOfGatesEngine router = SeaOfGatesEngineFactory.createSeaOfGatesEngine(this.version);
            router.setPrefs(this.prefs);
            Layout.changesQuiet(true);
            SeaOfGatesEngine.Handler handler = SeaOfGatesHandlers.getDefault(this.cell, router.getPrefs().resultCellName, router.getPrefs().contactPlacementAction, this, this.getEditingPreferences(), this.save);
            if (this.arcIdsToRoute != null) {
                ArrayList<ArcInst> arcsToRoute = new ArrayList<ArcInst>();
                for (int arcId : this.arcIdsToRoute) {
                    arcsToRoute.add(this.cell.getArcById(arcId));
                }
                router.routeIt(handler, this.cell, false, arcsToRoute);
            } else {
                router.routeIt(handler, this.cell, false);
            }
            return true;
        }

        @Override
        public void showSnapshot() {
            if (this.save != Save.SAVE_ONCE) {
                super.showSnapshot();
            }
        }
    }

    private static class DefaultSeaOfGatesHook
    implements SeaOfGatesEngine.Handler {
        private final EDatabase database;
        private final Job job;
        private final EditingPreferences ep;
        private final Save save;
        private final SeaOfGatesCellBuilder cellBuilder;
        private final UserInterface ui = Job.getUserInterface();
        private int periodicCounter;

        private DefaultSeaOfGatesHook(Cell cell, String resultCellName, Routing.SoGContactsStrategy contactPlacementAction, Job job, EditingPreferences ep, Save save) {
            this.database = cell.getDatabase();
            this.job = job;
            this.ep = ep;
            this.save = save;
            this.cellBuilder = new SeaOfGatesCellBuilder(this.database.backup(), cell.getId(), resultCellName, contactPlacementAction, ep);
            this.periodicCounter = 0;
        }

        @Override
        public EditingPreferences getEditingPreferences() {
            return this.ep;
        }

        @Override
        public boolean checkAbort() {
            return this.job != null && this.job.checkAbort();
        }

        @Override
        public void trace(String msg) {
            this.printMessage(msg, true);
        }

        @Override
        public void debug(String msg) {
            if (Job.getDebug()) {
                this.printMessage(msg, true);
            }
        }

        @Override
        public void info(String msg) {
            this.printMessage(msg, true);
        }

        @Override
        public void warn(String msg) {
            this.printMessage("WARNING: " + msg, true);
        }

        @Override
        public void error(String msg) {
            this.printMessage("ERROR: " + msg, true);
        }

        private void printMessage(String s, boolean newLine) {
            if (newLine) {
                System.out.println(s);
            } else {
                System.out.print(s);
            }
        }

        @Override
        public void termLogging(ErrorLogger errorLogger) {
            errorLogger.termLogging(true);
        }

        @Override
        public void startProgressDialog(String msg) {
            this.ui.startProgressDialog(msg, null);
        }

        @Override
        public void stopProgressDialog() {
            this.ui.stopProgressDialog();
        }

        @Override
        public void setProgressNote(String message) {
            this.ui.setProgressNote(message);
            if (Job.getDebug()) {
                System.out.println(message);
            }
        }

        @Override
        public void setProgressValue(long done, long total) {
            int val = (int)(done * 100L / total);
            this.ui.setProgressValue(val);
        }

        @Override
        public void instantiate(SeaOfGatesEngine.RouteResolution resolution) {
            this.cellBuilder.instantiate(resolution);
        }

        @Override
        public String getRoutingCellName() {
            return this.cellBuilder.resultCellName;
        }

        @Override
        public void flush(boolean force) {
            switch (this.save) {
                case SAVE_SNAPSHOTS: {
                    force = true;
                    break;
                }
                case SAVE_PERIODIC: {
                    if (this.periodicCounter++ <= 100) break;
                    this.periodicCounter = 0;
                    force = true;
                    break;
                }
            }
            if (force) {
                Snapshot snapshot = this.cellBuilder.commit();
                this.database.checkChanging();
                this.database.lowLevelSetCanUndoing(true);
                this.database.undo(snapshot);
                this.database.lowLevelSetCanUndoing(false);
                this.database.getCell(this.cellBuilder.cellId).getLibrary().setChanged();
                if (this.job instanceof SeaOfGatesJob) {
                    ((SeaOfGatesJob)this.job).showSnapshot();
                }
            }
        }
    }

    private static class DummySeaOfGatesHandler
    implements SeaOfGatesEngine.Handler {
        private final EditingPreferences ep;
        private final PrintStream out;

        private DummySeaOfGatesHandler(EditingPreferences ep, PrintStream out) {
            this.ep = ep;
            this.out = out;
        }

        @Override
        public EditingPreferences getEditingPreferences() {
            return this.ep;
        }

        @Override
        public boolean checkAbort() {
            return false;
        }

        @Override
        public void trace(String msg) {
        }

        @Override
        public void debug(String msg) {
            this.out.println(msg);
        }

        @Override
        public void info(String msg) {
            this.out.println(msg);
        }

        @Override
        public void warn(String msg) {
            this.out.println("WARN: " + msg);
        }

        @Override
        public void error(String msg) {
            this.out.println("ERROR: " + msg);
        }

        @Override
        public void termLogging(ErrorLogger errorLogger) {
        }

        @Override
        public void startProgressDialog(String msg) {
        }

        @Override
        public void stopProgressDialog() {
        }

        @Override
        public void setProgressNote(String message) {
        }

        @Override
        public void setProgressValue(long done, long total) {
        }

        @Override
        public void instantiate(SeaOfGatesEngine.RouteResolution resolution) {
        }

        @Override
        public String getRoutingCellName() {
            return null;
        }

        @Override
        public void flush(boolean force) {
        }
    }

    private static class MutableSeaOfGatesHook
    implements SeaOfGatesEngine.Handler {
        private final Cell originalCell;
        private final Cell cell;
        private final String resultCellName;
        private final Routing.SoGContactsStrategy contactPlacementAction;
        private final Job job;
        private final EditingPreferences ep;
        private final UserInterface ui = Job.getUserInterface();
        private Map<ContactKey, ContactTemplate> contactTemplates = new HashMap<ContactKey, ContactTemplate>();

        private MutableSeaOfGatesHook(Cell cell, String resultCellName, Routing.SoGContactsStrategy contactPlacementAction, Job job, EditingPreferences ep) {
            this.originalCell = cell;
            if (resultCellName == null) {
                this.cell = cell;
            } else {
                this.cell = Cell.makeInstance(ep, cell.getLibrary(), resultCellName + "{lay}");
                NodeInst.makeInstance(this.cell, ep, new Point2D.Double(0.0, 0.0), 0.0, 0.0, this.originalCell);
            }
            this.resultCellName = resultCellName;
            this.contactPlacementAction = contactPlacementAction;
            this.job = job;
            this.ep = ep;
        }

        @Override
        public EditingPreferences getEditingPreferences() {
            return this.ep;
        }

        @Override
        public boolean checkAbort() {
            return this.job != null && this.job.checkAbort();
        }

        @Override
        public void trace(String msg) {
            this.printMessage(msg, true);
        }

        @Override
        public void debug(String msg) {
            if (Job.getDebug()) {
                this.printMessage(msg, true);
            }
        }

        @Override
        public void info(String msg) {
            this.printMessage(msg, true);
        }

        @Override
        public void warn(String msg) {
            this.printMessage("WARNING: " + msg, true);
        }

        @Override
        public void error(String msg) {
            this.printMessage("ERROR: " + msg, true);
        }

        private void printMessage(String s, boolean newLine) {
            if (newLine) {
                System.out.println(s);
            } else {
                System.out.print(s);
            }
        }

        @Override
        public void termLogging(ErrorLogger errorLogger) {
            errorLogger.termLogging(true);
        }

        @Override
        public void startProgressDialog(String msg) {
            this.ui.startProgressDialog(msg, null);
        }

        @Override
        public void stopProgressDialog() {
            this.ui.stopProgressDialog();
        }

        @Override
        public void setProgressNote(String message) {
            this.ui.setProgressNote(message);
            if (Job.getDebug()) {
                System.out.println(message);
            }
        }

        @Override
        public void setProgressValue(long done, long total) {
            int val = (int)(done * 100L / total);
            this.ui.setProgressValue(val);
        }

        @Override
        public void instantiate(SeaOfGatesEngine.RouteResolution resolution) {
            for (Integer aiKillID : resolution.arcsIDsToKill) {
                ArcInst aiKill = this.originalCell.getArcById(aiKillID);
                if (aiKill == null || !aiKill.isLinked()) continue;
                aiKill.kill();
            }
            for (Integer niKillID : resolution.nodesIDsToKill) {
                NodeInst niKill = this.originalCell.getNodeById(niKillID);
                niKill.kill();
            }
            if (this.contactPlacementAction != Routing.SoGContactsStrategy.SOGCONTACTSATTOPLEVEL) {
                for (SeaOfGatesEngine.RouteNode rn : resolution.nodesToRoute) {
                    ContactTemplate contactTemplate;
                    PrimitiveNode pNp;
                    if (rn.exists() || !(pNp = (PrimitiveNode)rn.getProto()).getFunction().isContact() || (contactTemplate = this.getTemplateForContact(pNp, rn.getSize(), rn.getTechBits())) != null) continue;
                    this.makeTemplateForContact(pNp, rn.getSize(), rn.getTechBits());
                }
            }
            for (SeaOfGatesEngine.RouteNode rn : resolution.nodesToRoute) {
                PrimitiveNode pNp;
                ContactTemplate contactTemplate;
                if (rn.exists()) continue;
                NodeProto np = rn.getProto();
                Orientation orient = rn.getOrient();
                if (np.getFunction().isContact() && (contactTemplate = this.getTemplateForContact(pNp = (PrimitiveNode)np, rn.getSize(), rn.getTechBits())) != null) {
                    np = contactTemplate.getCell(this.cell.getLibrary());
                    orient = contactTemplate.orient;
                }
                NodeInst ni = null;
                if (this.resultCellName == null || !(np instanceof PrimitiveNode)) {
                    ni = NodeInst.makeInstance(np, this.ep, (Point2D)rn.getLoc(), rn.getWidth(), rn.getHeight(), this.cell, orient, null, rn.getTechBits());
                } else {
                    NodeInst dummyNi = NodeInst.makeDummyInstance(np, this.ep, rn.getTechBits(), rn.getLoc(), rn.getWidth(), rn.getHeight(), orient);
                    Poly[] polys = np.getTechnology().getShapeOfNode(dummyNi);
                    for (int i = 0; i < polys.length; ++i) {
                        Poly poly = polys[i];
                        PrimitiveNode pNp2 = poly.getLayer().getPureLayerNode();
                        FixpRectangle bounds = poly.getBounds2D();
                        Point2D.Double ctr = new Point2D.Double(((RectangularShape)bounds).getCenterX(), ((RectangularShape)bounds).getCenterY());
                        NodeInst niPoss = NodeInst.makeInstance(pNp2, this.ep, ctr, ((RectangularShape)bounds).getWidth(), ((RectangularShape)bounds).getHeight(), this.cell);
                        if (ni != null) continue;
                        ni = niPoss;
                    }
                }
                if (ni == null) continue;
                rn.setPi(ni.getOnlyPortInst());
                rn.setTapConnection(ni.getD());
            }
            for (SeaOfGatesEngine.RouteArc ra : resolution.arcsToRoute) {
                if (ra.getHead().getPi() == null || ra.getTail().getPi() == null) continue;
                if (this.resultCellName == null) {
                    ArcInst ai = ArcInst.makeInstanceBase(ra.getProto(), this.ep, ra.getWidth(), ra.getHead().getPi(), ra.getTail().getPi(), ra.getHead().getPi().getCenter(), ra.getTail().getPi().getCenter(), ra.getName());
                    if (ai != null) continue;
                    System.out.println("****FAILED TO ROUTE ARC " + ra.getProto().describe());
                    continue;
                }
                EPoint headPt = ra.getHead().getPi().getCenter();
                EPoint tailPt = ra.getTail().getPi().getCenter();
                double lX = Math.min(headPt.getX(), tailPt.getX()) - ra.getWidth() / 2.0;
                double hX = Math.max(headPt.getX(), tailPt.getX()) + ra.getWidth() / 2.0;
                double lY = Math.min(headPt.getY(), tailPt.getY()) - ra.getWidth() / 2.0;
                double hY = Math.max(headPt.getY(), tailPt.getY()) + ra.getWidth() / 2.0;
                Technology.ArcLayer[] arcLayers = ra.getProto().getArcLayers();
                PrimitiveNode pNp = arcLayers[0].getLayer().getPureLayerNode();
                Point2D.Double ctr = new Point2D.Double((lX + hX) / 2.0, (lY + hY) / 2.0);
                NodeInst.makeInstance(pNp, this.ep, ctr, hX - lX, hY - lY, this.cell);
            }
            if (this.resultCellName == null) {
                for (SeaOfGatesEngine.RouteAddUnrouted rau : resolution.unroutedToAdd.keySet()) {
                    String name = resolution.unroutedToAdd.get(rau);
                    PortInst piA = rau.getTailPort();
                    PortInst piB = rau.getHeadPort();
                    ArcInst.makeInstance(Generic.tech().unrouted_arc, this.ep, piA, piB, piA.getCenter(), piB.getCenter(), name);
                }
            }
        }

        ContactTemplate getTemplateForContact(PrimitiveNode pNp, EPoint size, int techBits) {
            ContactKey contactKey = new ContactKey(pNp, size, techBits);
            return this.contactTemplates.get(contactKey);
        }

        private boolean doesCellMatch(Cell contactCell, Poly[] shapeNodes) {
            BitSet matched = new BitSet();
            Iterator<NodeInst> it = contactCell.getNodes();
            while (it.hasNext()) {
                PrimitiveNode pn;
                NodeInst ni = it.next();
                if (ni.isCellInstance() || (pn = (PrimitiveNode)ni.getProto()).getTechnology() == Generic.tech()) continue;
                if (pn.getFunction() != PrimitiveNode.Function.NODE) {
                    return false;
                }
                if (ni.getTrace() != null) {
                    return false;
                }
                Poly[] pureLayers = pn.getTechnology().getShapeOfNode(ni);
                Layer lay = pureLayers[0].getLayer();
                boolean foundMatch = false;
                for (int i = 0; i < shapeNodes.length; ++i) {
                    Poly sn;
                    if (matched.get(i) || lay != (sn = shapeNodes[i]).getLayer()) continue;
                    FixpRectangle bounds = sn.getBounds2D();
                    if (ni.getXSize() != ((RectangularShape)bounds).getWidth() || ni.getYSize() != ((RectangularShape)bounds).getHeight() || ni.getAnchorCenterX() != ((RectangularShape)bounds).getCenterX() || ni.getAnchorCenterY() != ((RectangularShape)bounds).getCenterY()) continue;
                    matched.set(i);
                    foundMatch = true;
                    break;
                }
                if (foundMatch) continue;
                return false;
            }
            return matched.cardinality() == shapeNodes.length;
        }

        private void makeTemplateForContact(PrimitiveNode pNp, EPoint size, int techBits) {
            Poly[] conShape;
            NodeInst ni;
            assert (pNp.getFunction().isContact());
            ContactKey contactKey = new ContactKey(pNp, size, techBits);
            Library lib = this.cell.getLibrary();
            Cell contactCell = null;
            Orientation contactTemplateOrientation = Orientation.IDENT;
            if (this.contactPlacementAction != Routing.SoGContactsStrategy.SOGCONTACTSFORCESUBCELLS) {
                ni = NodeInst.makeDummyInstance(pNp, this.ep, EPoint.ORIGIN, size.getX(), size.getY(), Orientation.IDENT);
                conShape = pNp.getTechnology().getShapeOfNode(ni);
                NodeInst niRot = NodeInst.makeDummyInstance(pNp, this.ep, EPoint.ORIGIN, size.getX(), size.getY(), Orientation.R);
                Poly[] conShapeRot = pNp.getTechnology().getShapeOfNode(niRot);
                Iterator<Cell> it = lib.getCells();
                while (it.hasNext()) {
                    Cell cell = it.next();
                    if (this.doesCellMatch(cell, conShape)) {
                        contactCell = cell;
                        break;
                    }
                    if (!this.doesCellMatch(cell, conShapeRot)) continue;
                    contactCell = cell;
                    contactTemplateOrientation = Orientation.R;
                    break;
                }
            }
            if (contactCell != null) {
                if (!contactCell.getExports().hasNext()) {
                    pNp = Generic.tech().universalPinNode;
                    ni = NodeInst.makeInstance(pNp, this.ep, EPoint.ORIGIN, pNp.getDefaultLambdaBaseWidth(this.ep), pNp.getDefaultLambdaBaseHeight(this.ep), contactCell);
                    Export.newInst(contactCell, ni.getOnlyPortInst(), "port", this.ep);
                }
                ExportId eId = contactCell.getExports().next().getId();
                ContactTemplate contactTemplate = new ContactTemplate(contactCell.getId(), contactTemplateOrientation, eId);
                this.contactTemplates.put(contactKey, contactTemplate);
                return;
            }
            if (this.contactPlacementAction == Routing.SoGContactsStrategy.SOGCONTACTSUSEEXISTINGSUBCELLS) {
                return;
            }
            contactCell = Cell.makeInstance(this.ep, lib, contactKey.getDefaultCellName().getName());
            ni = NodeInst.makeDummyInstance(pNp, this.ep, EPoint.ORIGIN, size.getX() + pNp.getDefWidth(this.ep), size.getY() + pNp.getDefHeight(this.ep), contactTemplateOrientation);
            conShape = pNp.getTechnology().getShapeOfNode(ni);
            for (int i = 0; i < conShape.length; ++i) {
                Poly shape = conShape[i];
                Layer lay = shape.getLayer();
                PrimitiveNode pureNp = lay.getPureLayerNode();
                FixpRectangle bounds = shape.getBounds2D();
                Point2D.Double ctr = new Point2D.Double(((RectangularShape)bounds).getCenterX(), ((RectangularShape)bounds).getCenterY());
                NodeInst.makeInstance(pureNp, this.ep, ctr, ((RectangularShape)bounds).getWidth(), ((RectangularShape)bounds).getHeight(), contactCell);
            }
            pNp = Generic.tech().universalPinNode;
            ni = NodeInst.makeInstance(pNp, this.ep, EPoint.ORIGIN, pNp.getDefaultLambdaBaseWidth(this.ep), pNp.getDefaultLambdaBaseHeight(this.ep), contactCell);
            Export e = Export.newInst(contactCell, ni.getOnlyPortInst(), "port", this.ep);
            ContactTemplate contactTemplate = new ContactTemplate(contactCell.getId(), contactTemplateOrientation, e.getId());
            this.contactTemplates.put(contactKey, contactTemplate);
        }

        @Override
        public String getRoutingCellName() {
            return this.resultCellName;
        }

        @Override
        public void flush(boolean force) {
        }
    }

    static class ContactKey {
        final PrimitiveNode pNp;
        final EPoint size;
        final int techBits;

        ContactKey(PrimitiveNode pNp, EPoint size, int techBits) {
            if (pNp == null || size == null) {
                throw new NullPointerException();
            }
            this.pNp = pNp;
            this.size = size;
            this.techBits = techBits;
        }

        public boolean equals(Object o) {
            if (o instanceof ContactKey) {
                ContactKey that = (ContactKey)o;
                return this.pNp.equals(that.pNp) && this.size.equals(that.size) && this.techBits == that.techBits;
            }
            return false;
        }

        public int hashCode() {
            return 89 * this.pNp.hashCode() + this.size.hashCode() + this.techBits;
        }

        public String toString() {
            assert (this.pNp instanceof PrimitiveNode);
            PrimitiveNode pn = this.pNp;
            double scale = pn.getTechnology().getScale();
            double[] xExt = new double[2];
            double[] yExt = new double[2];
            double[] viaSize = new double[2];
            double[] viaSpacing = new double[2];
            String[] names = new String[2];
            int count = 0;
            for (Technology.NodeLayer node : pn.getNodeLayers()) {
                Layer l = node.getLayer();
                if (l.getFunction().isContact()) {
                    viaSize[0] = FixpCoord.fixpToLambda(node.getMulticutSizeX().getFixp());
                    viaSize[1] = FixpCoord.fixpToLambda(node.getMulticutSizeY().getFixp());
                    viaSpacing[0] = FixpCoord.fixpToLambda(node.getMulticutSep1D().getFixp());
                    viaSpacing[1] = FixpCoord.fixpToLambda(node.getMulticutSep1D().getFixp());
                    continue;
                }
                String tmp = l.getName();
                assert (count < 2);
                tmp = tmp.replaceAll("_MASK_1", "CA");
                names[(count + 1) % 2] = tmp = tmp.replaceAll("_MASK_2", "CB");
                EdgeH leftEdge = node.getLeftEdge();
                EdgeH rightEdge = node.getRightEdge();
                EdgeV topEdge = node.getTopEdge();
                EdgeV bottomEdge = node.getBottomEdge();
                long portLowX = leftEdge.getFixpValue(this.size);
                long portHighX = rightEdge.getFixpValue(this.size);
                long portLowY = bottomEdge.getFixpValue(this.size);
                long portHighY = topEdge.getFixpValue(this.size);
                xExt[count] = FixpCoord.fixpToLambda(portHighX - portLowX);
                yExt[count] = FixpCoord.fixpToLambda(portHighY - portLowY);
                ++count;
            }
            for (int i = 0; i < 2; ++i) {
                xExt[i] = (xExt[i] - viaSize[0]) * scale / 2.0;
                yExt[i] = (yExt[i] - viaSize[1]) * scale / 2.0;
            }
            String newName = names[0] + "_" + names[1] + "_";
            newName = newName + "X_" + TextUtils.formatDouble(viaSize[0] * scale, -1) + "_" + TextUtils.formatDouble(viaSize[1] * scale, -1) + "_1_1_" + TextUtils.formatDouble(viaSpacing[0] * scale, -1) + "_" + TextUtils.formatDouble(viaSpacing[1] * scale, -1) + "_" + TextUtils.formatDouble(xExt[0], -1) + "_" + TextUtils.formatDouble(yExt[0], -1) + "_" + TextUtils.formatDouble(xExt[1], -1) + "_" + TextUtils.formatDouble(yExt[1], -1);
            return newName;
        }

        CellName getDefaultCellName() {
            return CellName.parseName(this + ";1{lay}");
        }
    }

    static class ContactTemplate {
        final CellId cellId;
        Cell cell;
        final Orientation orient;
        final ExportId exportId;

        ContactTemplate(CellId cellId, Orientation orient, ExportId exportId) {
            this.cellId = cellId;
            this.cell = null;
            this.orient = orient;
            this.exportId = exportId;
        }

        Cell getCell(Library lib) {
            if (this.cell == null) {
                Iterator<Cell> it = lib.getCells();
                while (it.hasNext()) {
                    Cell c = it.next();
                    if (c.getId() != this.cellId) continue;
                    this.cell = c;
                    break;
                }
            }
            return this.cell;
        }
    }
}

