/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalAStar2.storage;

import com.sun.electric.tool.routing.experimentalAStar2.algorithm.AStarMapBase;
import com.sun.electric.tool.routing.experimentalAStar2.algorithm.AStarNodeBase;
import com.sun.electric.tool.routing.experimentalAStar2.algorithm.AStarOpenListBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;

public class AStarOpenListCheapList<T extends AStarNodeBase<T>>
implements AStarOpenListBase<T> {
    private int CHEAPLIST_INIT_SIZE = 15;
    LinkedList<T> openList = new LinkedList();
    CheapList cheapList = new CheapList();
    AStarMapBase<T> map;

    public void setMap(AStarMapBase<T> map) {
        this.map = map;
    }

    public void reinitializeCheapList(int fillingSize) {
        Collections.sort(this.openList);
        for (int i = 0; i < fillingSize && !this.openList.isEmpty(); ++i) {
            this.cheapList.forcedInsert((AStarNodeBase)this.openList.removeFirst());
        }
    }

    @Override
    public void addNodeToOpenList(T node) {
        if (this.cheapList.isEmpty()) {
            this.reinitializeCheapList(this.CHEAPLIST_INIT_SIZE);
        }
        if (this.cheapList.isEmpty() || !this.cheapList.cheapInsert(node)) {
            this.openList.add(node);
        }
        ((AStarNodeBase)node).markAsOpen();
    }

    public Collection<T> dumpOpenList() {
        ArrayList dump = new ArrayList(this.cheapList.dump());
        dump.addAll(this.openList);
        this.openList.clear();
        return dump;
    }

    @Override
    public void clearOpenList() {
        this.cheapList.clear();
        for (AStarNodeBase node : this.openList) {
            node.markAsNoList();
        }
        this.openList.clear();
    }

    @Override
    public T findOpenNode(int x, int y, int z) {
        T node = this.map.nodeAt(x, y, z);
        if (node != null && ((AStarNodeBase)node).isOpen()) {
            return node;
        }
        return null;
    }

    @Override
    public boolean isOpenListEmpty() {
        if (this.cheapList.head != null) {
            return false;
        }
        return this.openList.isEmpty();
    }

    @Override
    public T removeCheapestOpenNode() {
        if (this.cheapList.isEmpty()) {
            this.reinitializeCheapList(this.CHEAPLIST_INIT_SIZE);
        }
        Object result = this.cheapList.pop();
        if (this.cheapList.isEmpty()) {
            this.reinitializeCheapList(this.CHEAPLIST_INIT_SIZE);
        }
        if (result != null) {
            ((AStarNodeBase)result).markAsNoList();
        }
        return result;
    }

    @Override
    public void removeNodeFromOpenList(T node) {
        if (this.cheapList.remove(node)) {
            if (this.cheapList.isEmpty()) {
                this.reinitializeCheapList(this.CHEAPLIST_INIT_SIZE);
            }
        } else {
            this.openList.remove(node);
        }
        ((AStarNodeBase)node).markAsNoList();
    }

    class CheapList
    extends ADoubleLinkedList<T> {
        CheapList() {
        }

        public boolean cheapInsert(T node) {
            ADoubleLinkedList.AElement elementToInsert = new ADoubleLinkedList.AElement(node);
            if (this.head == null && this.tail == null) {
                this.head = elementToInsert;
                this.tail = elementToInsert;
                return true;
            }
            if (((AStarNodeBase)node).getTotalCost() > ((AStarNodeBase)this.tail.data).getTotalCost()) {
                return false;
            }
            ADoubleLinkedList.AElement current = this.head;
            while (current != null) {
                if (((AStarNodeBase)node).getTotalCost() < ((AStarNodeBase)current.data).getTotalCost()) {
                    if (current.hasPrev()) {
                        current.prev.next = elementToInsert;
                        elementToInsert.prev = current.prev;
                    } else {
                        this.head = elementToInsert;
                    }
                    current.prev = elementToInsert;
                    elementToInsert.next = current;
                    return true;
                }
                current = current.next;
            }
            if (((AStarNodeBase)node).getTotalCost() == ((AStarNodeBase)this.tail.data).getTotalCost()) {
                this.tail.next = elementToInsert;
                elementToInsert.prev = this.tail;
                this.tail = elementToInsert;
                return true;
            }
            return false;
        }

        public boolean forcedInsert(T node) {
            ADoubleLinkedList.AElement elementToInsert = new ADoubleLinkedList.AElement(node);
            if (this.head == null && this.tail == null) {
                this.head = elementToInsert;
                this.tail = elementToInsert;
                return true;
            }
            if (((AStarNodeBase)node).getTotalCost() >= ((AStarNodeBase)this.tail.data).getTotalCost()) {
                this.tail.next = elementToInsert;
                elementToInsert.prev = this.tail;
                this.tail = elementToInsert;
                return true;
            }
            ADoubleLinkedList.AElement current = this.head;
            while (current != null) {
                if (((AStarNodeBase)node).getTotalCost() < ((AStarNodeBase)current.data).getTotalCost()) {
                    if (current.hasPrev()) {
                        current.prev.next = elementToInsert;
                        elementToInsert.prev = current.prev;
                    } else {
                        this.head = elementToInsert;
                    }
                    current.prev = elementToInsert;
                    elementToInsert.next = current;
                    return true;
                }
                current = current.next;
            }
            return false;
        }

        public void print() {
            ADoubleLinkedList.AElement current = this.head;
            while (current != null) {
                System.err.print("(" + ((AStarNodeBase)current.data).getX() + "," + ((AStarNodeBase)current.data).getY() + "),");
                current = current.next;
            }
        }

        public ArrayList<T> dump() {
            ArrayList<AStarNodeBase> list = new ArrayList<AStarNodeBase>();
            while (this.head != null) {
                AStarNodeBase currentHead = (AStarNodeBase)this.head.data;
                list.add(currentHead);
                this.remove(currentHead);
            }
            return list;
        }

        public void clear() {
            while (this.head != null) {
                AStarNodeBase currentHead = (AStarNodeBase)this.head.data;
                currentHead.markAsNoList();
                this.remove(currentHead);
            }
        }

        public T pop() {
            if (this.head == null) {
                return null;
            }
            AStarNodeBase currentHead = (AStarNodeBase)this.head.data;
            this.remove(currentHead);
            return currentHead;
        }

        public boolean isEmpty() {
            return this.head == null;
        }

        public T getNode(int x, int y, int z) {
            ADoubleLinkedList.AElement current = this.head;
            while (current != null) {
                if (((AStarNodeBase)current.data).getX() == x && ((AStarNodeBase)current.data).getY() == y && ((AStarNodeBase)current.data).getZ() == z) {
                    return (AStarNodeBase)current.data;
                }
                current = current.next;
            }
            return null;
        }
    }

    class ADoubleLinkedList<S> {
        AElement head = null;
        AElement tail = null;

        ADoubleLinkedList() {
        }

        public boolean insert(S data) {
            AElement elementToInsert = new AElement(data);
            if (this.head == null && this.tail == null) {
                this.head = elementToInsert;
                this.head.next = this.tail = elementToInsert;
                this.tail.prev = this.head;
            } else {
                this.tail.next = elementToInsert;
                this.tail = elementToInsert;
            }
            return true;
        }

        public boolean remove(S data) {
            AElement current = this.head;
            boolean found = false;
            while (current != null) {
                if (current.data.equals(data)) {
                    found = true;
                    if (current.hasPrev()) {
                        current.prev.next = current.next;
                        if (!current.hasNext()) {
                            this.tail = current.prev;
                        }
                    }
                    if (current.hasNext()) {
                        current.next.prev = current.prev;
                        if (!current.hasPrev()) {
                            this.head = current.next;
                        }
                    }
                    if (current.hasNext() || current.hasPrev()) break;
                    this.head = null;
                    this.tail = null;
                    break;
                }
                current = current.next;
            }
            return found;
        }

        class AElement {
            AElement prev = null;
            AElement next = null;
            S data;

            public AElement(S data) {
                this.data = data;
            }

            public boolean hasNext() {
                return this.next != null;
            }

            public boolean hasPrev() {
                return this.prev != null;
            }
        }
    }
}

