/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.HP6624AChannel;
import com.sun.electric.tool.simulation.test.Infrastructure;
import com.sun.electric.tool.simulation.test.LogicSettable;
import com.sun.electric.tool.simulation.test.ManualPowerChannel;
import com.sun.electric.tool.simulation.test.PowerChannel;

public class LogicLevel
extends PowerChannel
implements LogicSettable {
    private final PowerChannel vddChannel;
    private final PowerChannel logicChannel;
    private boolean logicState;
    public static final float MAX_VOLTS_DEVIATION = 0.2f;
    private String logicName;

    public LogicLevel(PowerChannel vddChannel, PowerChannel logicChannel, boolean logicState) {
        this.name = vddChannel.getName();
        this.vddChannel = vddChannel;
        this.logicName = logicChannel.getName();
        this.logicChannel = logicChannel;
        this.setLogicState(logicState);
        LogicLevel.logInit("Initializing LogicLevel " + this.name + " with " + this.logicName + " in the " + logicState + " state");
    }

    @Override
    public String toString() {
        Infrastructure.nonfatal("Please change toString() reference to getState()");
        return this.getState();
    }

    @Override
    public String getState() {
        return super.getState() + "; " + this.getLogicName() + ": " + this.isLogicStateHigh();
    }

    public String getLogicName() {
        return this.logicName;
    }

    @Override
    public float readVoltage() {
        return this.vddChannel.readVoltage();
    }

    @Override
    public float getVoltageSetpoint() {
        return this.vddChannel.getVoltageSetpoint();
    }

    @Override
    public void setVoltageNoWait(float volts) {
        float vdd;
        this.logSet("LogicLevel setting " + this.getName() + " to " + volts + " V (nowait)");
        if (!this.isLogicStateHigh()) {
            this.vddChannel.setVoltageNoWait(volts);
            return;
        }
        float logicVolts = vdd = this.vddChannel.getVoltageSetpoint();
        float step0 = volts - vdd >= 0.0f ? 0.2f : -0.2f;
        float step = step0;
        System.out.print("LogicLevel setting " + this.getName() + " to " + volts + " V...");
        while (Math.abs(vdd - volts) > 0.2f) {
            vdd = this.nextVoltage(vdd, step, volts);
            this.vddChannel.setVoltageNoWait(vdd);
            step = 2.0f * step0;
            logicVolts = this.nextVoltage(logicVolts, step, volts);
            this.logicChannel.setVoltageNoWait(logicVolts);
            System.out.print(".");
        }
        this.logicChannel.setVoltageNoWait(volts);
        this.vddChannel.setVoltageNoWait(volts);
        System.out.println(".done");
    }

    private float nextVoltage(float old, float step, float end) {
        float next = old + step;
        next = step > 0.0f ? Math.min(next, end) : Math.max(next, end);
        return next;
    }

    @Override
    public void setVoltageWait(float volts) {
        this.logSet("LogicLevel setting " + this.getName() + " to " + volts + " V (wait)");
        this.setVoltageNoWait(volts);
        if (this.isLogicStateHigh()) {
            this.logicChannel.waitForVoltage(volts);
        }
        this.vddChannel.waitForVoltage(volts);
    }

    @Override
    public float readCurrent() {
        return this.vddChannel.readCurrent();
    }

    @Override
    public void setCurrent(float amps) {
        this.logSet("LogicLevel set " + this.getName() + " current limit to " + amps);
        this.vddChannel.setCurrent(amps);
    }

    @Override
    public float getCurrentSetpoint() {
        return this.vddChannel.getCurrentSetpoint();
    }

    @Override
    public boolean isLogicStateHigh() {
        return this.logicState;
    }

    @Override
    public void setLogicState(boolean logicState) {
        this.logSet("LogicLevel setting " + this.getLogicName() + " to " + logicState);
        this.logicState = logicState;
        if (!logicState) {
            this.logicChannel.setVoltageWait(0.0f);
        } else {
            float volts = this.vddChannel.getVoltageSetpoint();
            this.logicChannel.setVoltageWait(volts);
        }
    }

    public float readLogicCurrent() {
        return this.logicChannel.readCurrent();
    }

    public float getLogicVoltageSetpoint() {
        return this.logicChannel.getVoltageSetpoint();
    }

    public static void main(String[] args) {
        PowerChannel vddChannel = new ManualPowerChannel("vdd", false);
        PowerChannel logicChannel = new ManualPowerChannel("log1", false);
        ManualPowerChannel logicChannel2 = new ManualPowerChannel("log2", false);
        LogicLevel level = new LogicLevel(vddChannel, logicChannel, false);
        LogicLevel level2 = new LogicLevel(level, logicChannel2, false);
        level.setLogicState(true);
        level2.setLogicState(true);
        level2.setVoltageWait(1.2f);
        level2.setLogicState(false);
        level.setLogicState(false);
        System.out.println("Hit return to move on to real supply:");
        Infrastructure.readln();
        Infrastructure.gpibControllers = new int[]{1};
        vddChannel = new HP6624AChannel("vdd", "hHP6624A", 1);
        logicChannel = new HP6624AChannel("log", "hHP6624A", 3);
        level = new LogicLevel(vddChannel, logicChannel, false);
        System.out.println(level.getState());
        level.setLogicState(false);
        level.setVoltageWait(1.0f);
        System.out.println("After false ramp down: " + level.getState());
        System.out.println("  logic: " + logicChannel.getVoltageSetpoint() + " V, " + logicChannel.readCurrent() + " A");
        level.setLogicState(true);
        level.setVoltageWait(1.75f);
        System.out.println("After true ramp up: " + level.getState());
        System.out.println("  logic: " + logicChannel.getVoltageSetpoint() + " V, " + logicChannel.readCurrent() + " A");
        level.setVoltageWait(1.1f);
        System.out.println("After true ramp down: " + level.getState());
        System.out.println("  logic: " + logicChannel.getVoltageSetpoint() + " V, " + logicChannel.readCurrent() + " A");
    }
}

