/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.routing.Routing;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesEngine;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesEngineFactory;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesHandlers;
import com.sun.electric.util.ElapseTimer;
import com.sun.electric.util.TextUtils;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class SeaOfGates {
    public static void seaOfGatesRoute(boolean justSubCells) {
        if (justSubCells) {
            UserInterface ui = Job.getUserInterface();
            Cell cell = ui.needCurrentCell();
            if (cell == null) {
                return;
            }
            HashSet<Cell> subCells = new HashSet<Cell>();
            Iterator<NodeInst> it = cell.getNodes();
            while (it.hasNext()) {
                NodeInst ni = it.next();
                if (!ni.isCellInstance()) continue;
                subCells.add((Cell)ni.getProto());
            }
            for (Cell subCell : subCells) {
                ArrayList<ArcInst> selected = new ArrayList<ArcInst>();
                Iterator<ArcInst> it2 = subCell.getArcs();
                while (it2.hasNext()) {
                    ArcInst ai = it2.next();
                    if (ai.getProto() != Generic.tech().unrouted_arc) continue;
                    selected.add(ai);
                }
                if (selected.isEmpty()) continue;
                SeaOfGatesHandlers.startInJob(subCell, selected, SeaOfGatesEngineFactory.SeaOfGatesEngineType.defaultVersion);
            }
        } else {
            SeaOfGates.seaOfGatesRoute(SeaOfGatesEngineFactory.SeaOfGatesEngineType.defaultVersion);
        }
    }

    public static void seaOfGatesRoute(SeaOfGatesEngineFactory.SeaOfGatesEngineType version) {
        UserInterface ui = Job.getUserInterface();
        Cell cell = ui.needCurrentCell();
        if (cell == null) {
            return;
        }
        List<ArcInst> selected = SeaOfGates.getSelected();
        if (selected == null) {
            return;
        }
        if (selected.isEmpty()) {
            ui.showErrorMessage("There are no Unrouted Arcs in this cell", "Routing Error");
            return;
        }
        SeaOfGatesHandlers.startInJob(cell, selected, version);
    }

    public static void seaOfGatesRoute(EditingPreferences ep, SeaOfGatesEngine router) {
        if (router == null) {
            throw new NullPointerException();
        }
        UserInterface ui = Job.getUserInterface();
        Cell cell = ui.needCurrentCell();
        if (cell == null) {
            return;
        }
        List<ArcInst> selected = SeaOfGates.getSelected();
        if (selected.isEmpty()) {
            ui.showErrorMessage("There are no Unrouted Arcs in this cell", "Routing Error");
            return;
        }
        Job job = Job.getRunningJob();
        router.routeIt(SeaOfGatesHandlers.getDefault(cell, router.getPrefs().resultCellName, job, ep), cell, false, selected);
    }

    private static List<ArcInst> getSelected() {
        EditWindow_ wnd = Job.getUserInterface().getCurrentEditWindow_();
        if (wnd == null) {
            return null;
        }
        Cell cell = wnd.getCell();
        if (cell == null) {
            return null;
        }
        ArrayList<ArcInst> selected = new ArrayList<ArcInst>();
        List<Geometric> highlighted = wnd.getHighlightedEObjs(false, true);
        for (Geometric h : highlighted) {
            ArcInst ai = (ArcInst)h;
            if (ai.getProto() != Generic.tech().unrouted_arc) continue;
            selected.add(ai);
        }
        if (selected.isEmpty()) {
            Iterator<ArcInst> it = cell.getArcs();
            while (it.hasNext()) {
                ArcInst ai = it.next();
                if (ai.getProto() != Generic.tech().unrouted_arc) continue;
                selected.add(ai);
            }
        }
        return selected;
    }

    public static class SeaOfGatesCellParameters
    implements Serializable {
        private Cell cell;
        private boolean steinerDone;
        private boolean forceHorVer;
        private boolean favorHorVer;
        private boolean horEven;
        private boolean canRotateContacts;
        private Map<ArcProto, String> gridSpacing;
        private Set<ArcProto> preventedArcs;
        private Set<ArcProto> favoredArcs;
        private Map<ArcProto, SeaOfGatesArcProperties> overrides;
        private Map<String, List<ArcProto>> netsAndArcsToRoute;
        private Map<String, Map<ArcProto, SeaOfGatesArcProperties>> netAndArcOverrides;
        private String ignorePrimitives;
        private String acceptOnlyPrimitives;
        private static final Variable.Key ROUTING_SOG_PARAMETERS_KEY = Variable.newKey("ATTR_ROUTING_SOG_PARAMETERS");

        public void clear() {
            this.steinerDone = false;
            this.forceHorVer = false;
            this.favorHorVer = true;
            this.horEven = false;
            this.canRotateContacts = true;
            this.gridSpacing = new HashMap<ArcProto, String>();
            this.preventedArcs = new HashSet<ArcProto>();
            this.favoredArcs = new HashSet<ArcProto>();
            this.overrides = new HashMap<ArcProto, SeaOfGatesArcProperties>();
            this.netsAndArcsToRoute = new TreeMap<String, List<ArcProto>>();
            this.netAndArcOverrides = new HashMap<String, Map<ArcProto, SeaOfGatesArcProperties>>();
            this.ignorePrimitives = null;
            this.acceptOnlyPrimitives = null;
        }

        public SeaOfGatesCellParameters(Cell cell) {
            this.cell = cell;
            this.clear();
            Variable var = cell.getVar(ROUTING_SOG_PARAMETERS_KEY);
            if (var != null) {
                String[] lines2 = (String[])var.getObject();
                for (int i = 0; i < lines2.length; ++i) {
                    Map<ArcProto, SeaOfGatesArcProperties> arcs;
                    SeaOfGatesArcProperties sogap;
                    String[] parts = lines2[i].split(" ");
                    if (parts.length <= 0 || parts[0].startsWith(";")) continue;
                    if (parts[0].equalsIgnoreCase("SteinerTreesDone")) {
                        this.steinerDone = true;
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("NoContactRotation")) {
                        this.canRotateContacts = false;
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("AcceptContacts")) {
                        int spacePos = lines2[i].indexOf(32);
                        if (spacePos <= 0) continue;
                        this.acceptOnlyPrimitives = lines2[i].substring(spacePos + 1);
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("IgnoreContacts")) {
                        int spacePos = lines2[i].indexOf(32);
                        if (spacePos <= 0) continue;
                        this.ignorePrimitives = lines2[i].substring(spacePos + 1);
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("ForceHorVer")) {
                        this.forceHorVer = true;
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("IgnoreHorVer")) {
                        this.favorHorVer = false;
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("HorizontalEven")) {
                        this.horEven = true;
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("ArcGrid") && parts.length >= 3) {
                        ArcProto ap = this.parseArcName(parts[1]);
                        if (ap == null) continue;
                        this.gridSpacing.put(ap, parts[2]);
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("ArcAvoid") && parts.length >= 2) {
                        ArcProto ap = this.parseArcName(parts[1]);
                        if (ap == null) continue;
                        this.preventedArcs.add(ap);
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("ArcFavor") && parts.length >= 2) {
                        ArcProto ap = this.parseArcName(parts[1]);
                        if (ap == null) continue;
                        this.favoredArcs.add(ap);
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("ArcWidthOverride") && parts.length >= 3) {
                        ArcProto ap = this.parseArcName(parts[1]);
                        if (ap == null) continue;
                        sogap = this.overrides.get(ap);
                        if (sogap == null) {
                            sogap = new SeaOfGatesArcProperties();
                            this.overrides.put(ap, sogap);
                        }
                        sogap.setWidthOverride(TextUtils.atof(parts[2]));
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("ArcSpacingOverride") && parts.length >= 3) {
                        ArcProto ap = this.parseArcName(parts[1]);
                        if (ap == null) continue;
                        sogap = this.overrides.get(ap);
                        if (sogap == null) {
                            sogap = new SeaOfGatesArcProperties();
                            this.overrides.put(ap, sogap);
                        }
                        sogap.setSpacingOverride(TextUtils.atof(parts[2]));
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("Network") && parts.length >= 2) {
                        String netName = parts[1];
                        arcs = this.netsAndArcsToRoute.get(netName);
                        if (arcs == null) {
                            arcs = new ArrayList<ArcProto>();
                            this.netsAndArcsToRoute.put(netName, (List<ArcProto>)((Object)arcs));
                        }
                        for (int p = 2; p < parts.length; ++p) {
                            ArcProto ap = this.parseArcName(parts[p]);
                            arcs.add(ap);
                        }
                        continue;
                    }
                    if (!parts[0].equalsIgnoreCase("NetworkOverride") || parts.length < 2) continue;
                    String netName = parts[1];
                    arcs = this.netAndArcOverrides.get(netName);
                    if (arcs == null) {
                        arcs = new HashMap();
                        this.netAndArcOverrides.put(netName, arcs);
                    }
                    SeaOfGatesArcProperties curOverrides = null;
                    for (int p = 2; p < parts.length; ++p) {
                        if (parts[p].startsWith("W=")) {
                            if (curOverrides == null) continue;
                            curOverrides.setWidthOverride(TextUtils.atof(parts[p].substring(2)));
                            continue;
                        }
                        if (parts[p].startsWith("S=")) {
                            if (curOverrides == null) continue;
                            curOverrides.setSpacingOverride(TextUtils.atof(parts[p].substring(2)));
                            continue;
                        }
                        ArcProto ap = this.parseArcName(parts[p]);
                        curOverrides = (SeaOfGatesArcProperties)arcs.get(ap);
                        if (curOverrides != null) continue;
                        curOverrides = new SeaOfGatesArcProperties();
                        arcs.put(ap, curOverrides);
                    }
                }
            }
        }

        public void importData(String fileName, Technology curTech) {
            URL url = TextUtils.makeURLToFile(fileName);
            try {
                String buf;
                URLConnection urlCon = url.openConnection();
                InputStreamReader is = new InputStreamReader(urlCon.getInputStream());
                LineNumberReader lineReader = new LineNumberReader(is);
                this.clear();
                ArrayList<ArcProto> layersToOverride = new ArrayList<ArcProto>();
                HashMap<ArcProto, Double> widthsToOverride = new HashMap<ArcProto, Double>();
                HashMap<ArcProto, Double> spacingsToOverride = new HashMap<ArcProto, Double>();
                boolean figuredOutAlternation = false;
                this.forceHorVer = true;
                this.canRotateContacts = false;
                while ((buf = lineReader.readLine()) != null) {
                    int level;
                    ArcProto ap;
                    String[] parts;
                    if (buf.length() == 0 || buf.startsWith(";") || (parts = buf.split(" ")).length <= 0 || parts[0].equalsIgnoreCase("Project") || parts[0].equalsIgnoreCase("Library")) continue;
                    if (parts[0].equalsIgnoreCase("Cell")) {
                        if (this.getCell().getName().equals(parts[1])) continue;
                        System.out.println("WARNING: Cell name " + parts[1] + " on line " + lineReader.getLineNumber() + " doesn't match current cell (" + this.getCell().describe(false) + ")");
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("View") || parts[0].equalsIgnoreCase("PowerNets")) continue;
                    if (parts[0].equalsIgnoreCase("HorizontalEven")) {
                        this.horEven = true;
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("ContactInclusion")) {
                        if (parts.length > 1 && !parts[1].isEmpty()) {
                            this.acceptOnlyPrimitives = parts[1];
                            continue;
                        }
                        System.out.println("WARNING: no regular expression for ContactInclusion on line " + lineReader.getLineNumber());
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("HorizontalMetals")) {
                        assert (parts.length > 1);
                        ap = this.getArcProto(parts[1], lineReader.getLineNumber(), curTech);
                        if (ap == null) continue;
                        level = ap.getFunction().getLevel();
                        boolean bl = this.horEven = level % 2 == 0;
                    }
                    if (parts[0].equalsIgnoreCase("VerticalMetals")) {
                        assert (parts.length > 1);
                        ap = this.getArcProto(parts[1], lineReader.getLineNumber(), curTech);
                        if (ap == null) continue;
                        level = ap.getFunction().getLevel();
                        boolean bl = this.horEven = level % 2 != 0;
                    }
                    if (parts[0].equalsIgnoreCase("DefaultRouteMetals")) {
                        ArcProto ap2;
                        HashSet<ArcProto> allowed = new HashSet<ArcProto>();
                        for (int i = 1; i < parts.length; ++i) {
                            ap2 = this.getArcProto(parts[i], lineReader.getLineNumber(), curTech);
                            if (ap2 == null) continue;
                            allowed.add(ap2);
                        }
                        Iterator<ArcProto> it = curTech.getArcs();
                        while (it.hasNext()) {
                            this.setPrevented(ap2, !allowed.contains(ap2 = it.next()));
                        }
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("DefaultMetalWS") && parts.length >= 4) {
                        ap = this.getArcProto(parts[1], lineReader.getLineNumber(), curTech);
                        double width = TextUtils.atof(parts[2]);
                        width = TextUtils.convertFromDistance(width, curTech, TextUtils.UnitScale.MICRO);
                        double spacing = TextUtils.atof(parts[3]);
                        spacing = TextUtils.convertFromDistance(spacing, curTech, TextUtils.UnitScale.MICRO);
                        this.setDefaultWidthOverride(ap, width);
                        this.setDefaultSpacingOverride(ap, spacing);
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("Track")) {
                        boolean wantHorEven;
                        ap = this.getArcProto(parts[1], lineReader.getLineNumber(), curTech);
                        int arcLevel = ap.getFunction().getLevel();
                        if (parts[2].equalsIgnoreCase("t")) {
                            wantHorEven = arcLevel % 2 == 0;
                        } else {
                            boolean bl = wantHorEven = arcLevel % 2 != 0;
                        }
                        if (figuredOutAlternation) {
                            if (wantHorEven != this.horEven) {
                                System.out.println("Warning: Horizontal layers are " + (this.horEven ? "" : " not") + " even but metal " + parts[1] + " has horizontal set to " + parts[2]);
                            }
                        } else {
                            this.horEven = wantHorEven;
                            figuredOutAlternation = true;
                        }
                        double coord = TextUtils.atof(parts[3]);
                        coord = TextUtils.convertFromDistance(coord, curTech, TextUtils.UnitScale.MICRO);
                        double spacing = TextUtils.atof(parts[4]);
                        spacing = TextUtils.convertFromDistance(spacing, curTech, TextUtils.UnitScale.MICRO);
                        int numTracks = TextUtils.atoi(parts[5]);
                        TreeSet<Double> gridValues = new TreeSet<Double>();
                        String formerGrid = this.gridSpacing.get(ap);
                        if (formerGrid != null) {
                            String[] gridParts = formerGrid.split(",");
                            for (int i = 0; i < gridParts.length; ++i) {
                                String part = gridParts[i].trim();
                                if (part.length() == 0) continue;
                                double val = TextUtils.atof(part);
                                gridValues.add(new Double(val));
                            }
                        }
                        for (int i = 0; i < numTracks; ++i) {
                            gridValues.add(new Double(coord));
                            coord += spacing;
                        }
                        String newGrid = "";
                        for (Double v : gridValues) {
                            if (newGrid.length() > 0) {
                                newGrid = newGrid + ",";
                            }
                            newGrid = newGrid + v;
                        }
                        this.gridSpacing.put(ap, newGrid);
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("NET")) {
                        parts[1] = parts[1].replace("<", "[").replace(">", "]");
                        this.addNetToRoute(parts[1]);
                        for (ArcProto ap3 : layersToOverride) {
                            this.addArcToNet(parts[1], ap3);
                        }
                        for (ArcProto ap4 : widthsToOverride.keySet()) {
                            Double width = (Double)widthsToOverride.get(ap4);
                            this.setWidthOverrideForArcOnNet(parts[1], ap4, width);
                        }
                        for (ArcProto ap5 : spacingsToOverride.keySet()) {
                            Double spacing = (Double)spacingsToOverride.get(ap5);
                            this.setSpacingOverrideForArcOnNet(parts[1], ap5, spacing);
                        }
                        layersToOverride.clear();
                        widthsToOverride.clear();
                        spacingsToOverride.clear();
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("layers")) {
                        for (int i = 1; i < parts.length; ++i) {
                            ArcProto ap6 = this.getArcProto(parts[i], lineReader.getLineNumber(), curTech);
                            if (ap6 == null) continue;
                            layersToOverride.add(ap6);
                        }
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("width")) {
                        for (int i = 1; i < parts.length; i += 2) {
                            ArcProto ap7 = this.getArcProto(parts[i], lineReader.getLineNumber(), curTech);
                            if (ap7 == null) continue;
                            double v = TextUtils.atof(parts[i + 1]);
                            v = TextUtils.convertFromDistance(v, curTech, TextUtils.UnitScale.MICRO);
                            widthsToOverride.put(ap7, new Double(v));
                        }
                        continue;
                    }
                    if (!parts[0].equalsIgnoreCase("spacing")) continue;
                    for (int i = 1; i < parts.length; i += 2) {
                        ArcProto ap8 = this.getArcProto(parts[i], lineReader.getLineNumber(), curTech);
                        if (ap8 == null) continue;
                        double v = TextUtils.atof(parts[i + 1]);
                        v = TextUtils.convertFromDistance(v, curTech, TextUtils.UnitScale.MICRO);
                        spacingsToOverride.put(ap8, new Double(v));
                    }
                }
                lineReader.close();
            }
            catch (IOException e) {
                System.out.println("Error reading " + fileName);
                return;
            }
        }

        private ArcProto getArcProto(String name, int lineNumber, Technology tech) {
            if (!name.startsWith("M")) {
                System.out.println("ERROR: Unrecognized layer name on line " + lineNumber + ": " + name);
                return null;
            }
            int metNum = TextUtils.atoi(name.substring(1));
            if (metNum <= 0 || metNum > tech.getNumArcs()) {
                System.out.println("ERROR: Unrecognized metal number on line " + lineNumber + ": " + name);
                return null;
            }
            ArcProto found = null;
            Iterator<ArcProto> it = tech.getArcs();
            while (it.hasNext()) {
                ArcProto ap = it.next();
                if (ap.getFunction().getLevel() != metNum) continue;
                found = ap;
                break;
            }
            if (found == null) {
                System.out.println("ERROR: Unrecognized metal layer on line " + lineNumber + ": " + name);
                return null;
            }
            return found;
        }

        private ArcProto parseArcName(String name) {
            int colonPos = name.indexOf(58);
            if (colonPos < 0) {
                return null;
            }
            String techName = name.substring(0, colonPos);
            String layerName = name.substring(colonPos + 1);
            Technology tech = Technology.findTechnology(techName);
            ArcProto ap = tech.findArcProto(layerName);
            return ap;
        }

        public void saveParameters(EditingPreferences ep) {
            Object arcs;
            String line;
            ArrayList<String> strings = new ArrayList<String>();
            strings.add("; Parameters for Cell " + this.cell.describe(false));
            if (this.steinerDone) {
                strings.add("SteinerTreesDone");
            }
            if (!this.canRotateContacts) {
                strings.add("NoContactRotation");
            }
            if (this.ignorePrimitives != null && this.ignorePrimitives.length() > 0) {
                strings.add("IgnoreContacts " + this.ignorePrimitives);
            }
            if (this.acceptOnlyPrimitives != null && this.acceptOnlyPrimitives.length() > 0) {
                strings.add("AcceptContacts " + this.acceptOnlyPrimitives);
            }
            if (!this.favorHorVer) {
                strings.add("IgnoreHorVer");
            }
            if (this.forceHorVer) {
                strings.add("ForceHorVer");
            }
            if (this.horEven) {
                strings.add("HorizontalEven");
            }
            for (ArcProto ap : this.gridSpacing.keySet()) {
                String grid = this.gridSpacing.get(ap);
                strings.add("ArcGrid " + ap.getTechnology().getTechName() + ":" + ap.getName() + " " + grid);
            }
            for (ArcProto ap : this.preventedArcs) {
                strings.add("ArcAvoid " + ap.getTechnology().getTechName() + ":" + ap.getName());
            }
            for (ArcProto ap : this.favoredArcs) {
                strings.add("ArcFavor " + ap.getTechnology().getTechName() + ":" + ap.getName());
            }
            for (ArcProto ap : this.overrides.keySet()) {
                SeaOfGatesArcProperties sogap = this.overrides.get(ap);
                if (sogap.getWidthOverride() != null) {
                    strings.add("ArcWidthOverride " + ap.getTechnology().getTechName() + ":" + ap.getName() + " " + sogap.getWidthOverride());
                }
                if (sogap.getSpacingOverride() == null) continue;
                strings.add("ArcSpacingOverride " + ap.getTechnology().getTechName() + ":" + ap.getName() + " " + sogap.getSpacingOverride());
            }
            for (String netName : this.netsAndArcsToRoute.keySet()) {
                line = "Network " + netName;
                arcs = this.netsAndArcsToRoute.get(netName);
                if (arcs != null) {
                    Iterator<ArcProto> i$ = arcs.iterator();
                    while (i$.hasNext()) {
                        ArcProto ap = i$.next();
                        line = line + " " + ap.getTechnology().getTechName() + ":" + ap.getName();
                    }
                }
                strings.add(line);
            }
            for (String netName : this.netAndArcOverrides.keySet()) {
                line = "NetworkOverride " + netName;
                arcs = this.netAndArcOverrides.get(netName);
                if (arcs != null) {
                    for (ArcProto ap : arcs.keySet()) {
                        SeaOfGatesArcProperties overrides = (SeaOfGatesArcProperties)arcs.get(ap);
                        if (overrides == null) continue;
                        line = line + " " + ap.getTechnology().getTechName() + ":" + ap.getName();
                        if (overrides.getWidthOverride() != null) {
                            line = line + " W=" + overrides.getWidthOverride();
                        }
                        if (overrides.getSpacingOverride() == null) continue;
                        line = line + " S=" + overrides.getSpacingOverride();
                    }
                }
                strings.add(line);
            }
            String[] paramArray = new String[strings.size()];
            for (int i = 0; i < strings.size(); ++i) {
                paramArray[i] = (String)strings.get(i);
            }
            this.cell.newVar(ROUTING_SOG_PARAMETERS_KEY, (Object)paramArray, ep);
        }

        public Cell getCell() {
            return this.cell;
        }

        public void setSteinerDone(boolean sd) {
            this.steinerDone = sd;
        }

        public boolean isSteinerDone() {
            return this.steinerDone;
        }

        public void setFavorHorVer(boolean f2) {
            this.favorHorVer = f2;
        }

        public boolean isFavorHorVer() {
            return this.favorHorVer;
        }

        public void setForceHorVer(boolean f2) {
            this.forceHorVer = f2;
        }

        public boolean isForceHorVer() {
            return this.forceHorVer;
        }

        public void setHorizontalEven(boolean he) {
            this.horEven = he;
        }

        public boolean isHorizontalEven() {
            return this.horEven;
        }

        public void setContactsRotate(boolean he) {
            this.canRotateContacts = he;
        }

        public boolean isContactsRotate() {
            return this.canRotateContacts;
        }

        public void setPrevented(ArcProto ap, boolean prevent) {
            if (prevent) {
                this.preventedArcs.add(ap);
            } else {
                this.preventedArcs.remove(ap);
            }
        }

        public boolean isPrevented(ArcProto ap) {
            return this.preventedArcs.contains(ap);
        }

        public void setFavored(ArcProto ap, boolean f2) {
            if (f2) {
                this.favoredArcs.add(ap);
            } else {
                this.favoredArcs.remove(ap);
            }
        }

        public boolean isFavored(ArcProto ap) {
            return this.favoredArcs.contains(ap);
        }

        public Double getDefaultWidthOverride(ArcProto ap) {
            SeaOfGatesArcProperties sogap = this.overrides.get(ap);
            if (sogap == null) {
                return null;
            }
            return sogap.overrideWidth;
        }

        public void setDefaultWidthOverride(ArcProto ap, Double w) {
            SeaOfGatesArcProperties sogap = this.overrides.get(ap);
            if (sogap == null) {
                sogap = new SeaOfGatesArcProperties();
                this.overrides.put(ap, sogap);
            }
            sogap.setWidthOverride(w);
        }

        public Double getDefaultSpacingOverride(ArcProto ap) {
            SeaOfGatesArcProperties sogap = this.overrides.get(ap);
            if (sogap == null) {
                return null;
            }
            return sogap.overrideSpacing;
        }

        public void setDefaultSpacingOverride(ArcProto ap, Double s) {
            SeaOfGatesArcProperties sogap = this.overrides.get(ap);
            if (sogap == null) {
                sogap = new SeaOfGatesArcProperties();
                this.overrides.put(ap, sogap);
            }
            sogap.setSpacingOverride(s);
        }

        public Set<String> getNetsToRoute() {
            return this.netsAndArcsToRoute.keySet();
        }

        public void addNetToRoute(String netName) {
            List<ArcProto> arcs = this.netsAndArcsToRoute.get(netName);
            if (arcs == null) {
                arcs = new ArrayList<ArcProto>();
                this.netsAndArcsToRoute.put(netName, arcs);
            }
        }

        public void removeNetToRoute(String netName) {
            List<ArcProto> arcs = this.netsAndArcsToRoute.get(netName);
            if (arcs != null) {
                this.netsAndArcsToRoute.remove(netName);
            }
        }

        public List<ArcProto> getArcsOnNet(String net) {
            List<ArcProto> arcsOnNet = this.netsAndArcsToRoute.get(net);
            if (arcsOnNet == null) {
                return null;
            }
            return arcsOnNet;
        }

        public void addArcToNet(String net, ArcProto ap) {
            List<ArcProto> arcsOnNet = this.netsAndArcsToRoute.get(net);
            if (arcsOnNet == null) {
                arcsOnNet = new ArrayList<ArcProto>();
                this.netsAndArcsToRoute.put(net, arcsOnNet);
            }
            arcsOnNet.add(ap);
        }

        public void removeArcFromNet(String net, ArcProto ap) {
            List<ArcProto> arcsOnNet = this.netsAndArcsToRoute.get(net);
            if (arcsOnNet == null) {
                return;
            }
            arcsOnNet.remove(ap);
        }

        public SeaOfGatesArcProperties getOverridesForArcsOnNet(String net, ArcProto ap) {
            Map<ArcProto, SeaOfGatesArcProperties> arcsOnNet = this.netAndArcOverrides.get(net);
            if (arcsOnNet == null) {
                return null;
            }
            SeaOfGatesArcProperties sogap = arcsOnNet.get(ap);
            return sogap;
        }

        public void setWidthOverrideForArcOnNet(String net, ArcProto ap, Double width) {
            SeaOfGatesArcProperties sogap;
            Map<ArcProto, SeaOfGatesArcProperties> arcsOnNet = this.netAndArcOverrides.get(net);
            if (arcsOnNet == null) {
                arcsOnNet = new HashMap<ArcProto, SeaOfGatesArcProperties>();
                this.netAndArcOverrides.put(net, arcsOnNet);
            }
            if ((sogap = arcsOnNet.get(ap)) == null) {
                sogap = new SeaOfGatesArcProperties();
                arcsOnNet.put(ap, sogap);
            }
            sogap.setWidthOverride(width);
        }

        public void setSpacingOverrideForArcOnNet(String net, ArcProto ap, Double spacing) {
            SeaOfGatesArcProperties sogap;
            Map<ArcProto, SeaOfGatesArcProperties> arcsOnNet = this.netAndArcOverrides.get(net);
            if (arcsOnNet == null) {
                arcsOnNet = new HashMap<ArcProto, SeaOfGatesArcProperties>();
                this.netAndArcOverrides.put(net, arcsOnNet);
            }
            if ((sogap = arcsOnNet.get(ap)) == null) {
                sogap = new SeaOfGatesArcProperties();
                arcsOnNet.put(ap, sogap);
            }
            sogap.setSpacingOverride(spacing);
        }

        public String getGrid(ArcProto ap) {
            String v = this.gridSpacing.get(ap);
            return v;
        }

        public void setGrid(ArcProto ap, String grid) {
            if (grid == null) {
                this.gridSpacing.remove(ap);
            } else {
                this.gridSpacing.put(ap, grid);
            }
        }

        public String getAcceptOnlyPrimitives() {
            return this.acceptOnlyPrimitives;
        }

        public void setAcceptOnlyPrimitive(String s) {
            this.acceptOnlyPrimitives = s;
        }

        public String getIgnorePrimitives() {
            return this.ignorePrimitives;
        }

        public void setIgnorePrimitive(String s) {
            this.ignorePrimitives = s;
        }
    }

    public static class SeaOfGatesArcProperties
    implements Serializable {
        private Double overrideWidth = null;
        private Double overrideSpacing = null;

        public void setWidthOverride(Double w) {
            this.overrideWidth = w;
        }

        public Double getWidthOverride() {
            return this.overrideWidth;
        }

        public void setSpacingOverride(Double s) {
            this.overrideSpacing = s;
        }

        public Double getSpacingOverride() {
            return this.overrideSpacing;
        }
    }

    public static class SeaOfGatesOptions
    implements Serializable {
        public boolean useParallelFromToRoutes = true;
        public boolean useParallelRoutes = false;
        public double maxArcWidth = 10.0;
        public int complexityLimit = 200000;
        public int rerunComplexityLimit = 400000;
        public boolean useGlobalRouter = false;
        public boolean reRunFailedRoutes = false;
        public boolean enableSpineRouting = false;
        public int forcedNumberOfThreads = 0;
        public String resultCellName = null;
        public ElapseTimer theTimer;

        public void getOptionsFromPreferences(boolean factory) {
            if (factory) {
                this.useParallelFromToRoutes = Routing.isFactorySeaOfGatesUseParallelFromToRoutes();
                this.useParallelRoutes = Routing.isFactorySeaOfGatesUseParallelRoutes();
                this.maxArcWidth = Routing.getFactorySeaOfGatesMaxWidth();
                this.complexityLimit = Routing.getFactorySeaOfGatesComplexityLimit();
                this.rerunComplexityLimit = Routing.getFactorySeaOfGatesRerunComplexityLimit();
                this.useGlobalRouter = Routing.isFactorySeaOfGatesUseGlobalRouting();
                this.reRunFailedRoutes = Routing.isFactorySeaOfGatesRerunFailedRoutes();
                this.enableSpineRouting = Routing.isFactorySeaOfGatesEnableSpineRouting();
                this.forcedNumberOfThreads = Routing.getFactorySeaOfGatesForcedProcessorCount();
            } else {
                this.useParallelFromToRoutes = Routing.isSeaOfGatesUseParallelFromToRoutes();
                this.useParallelRoutes = Routing.isSeaOfGatesUseParallelRoutes();
                this.maxArcWidth = Routing.getSeaOfGatesMaxWidth();
                this.complexityLimit = Routing.getSeaOfGatesComplexityLimit();
                this.rerunComplexityLimit = Routing.getSeaOfGatesRerunComplexityLimit();
                this.useGlobalRouter = Routing.isSeaOfGatesUseGlobalRouting();
                this.reRunFailedRoutes = Routing.isSeaOfGatesRerunFailedRoutes();
                this.enableSpineRouting = Routing.isSeaOfGatesEnableSpineRouting();
                this.forcedNumberOfThreads = Routing.getSeaOfGatesForcedProcessorCount();
            }
        }
    }
}

