/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.network;

import com.sun.electric.database.CellTree;
import com.sun.electric.database.EquivPorts;
import com.sun.electric.database.ImmutableNet;
import com.sun.electric.database.ImmutableNetLayout;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Global;
import com.sun.electric.database.network.NetSchem;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.NetlistImpl;
import com.sun.electric.database.network.NetlistShorted;
import com.sun.electric.database.network.NetworkManager;
import com.sun.electric.database.network.NetworkTool;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.util.math.MutableInteger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class NetCell {
    static final int VALID = 1;
    static final int LOCALVALID = 2;
    static final char PORT_SEPARATOR = '.';
    final NetworkManager networkManager;
    final EDatabase database;
    final boolean isSchem;
    final Cell cell;
    int flags;
    WeakReference<Snapshot> expectedSnapshot;
    WeakReference<CellTree> expectedCellTree;
    int[] equivPortsN;
    int[] equivPortsP;
    int[] equivPortsA;
    int[] ni_pi;
    int arcsOffset;
    private int[] headConn;
    private int[] tailConn;
    int[] drawns;
    int numDrawns;
    int numExportedDrawns;
    int numConnectedDrawns;
    HashMap<Name, MutableInteger> netNames = new HashMap();
    private int netNameCount;
    int exportedNetNameCount;
    NetlistImpl netlistN;
    NetlistShorted netlistP;
    NetlistShorted netlistA;
    private static PortProto busPinPort = Schematics.tech().busPinNode.getPort(0);
    private static ArcProto busArc = Schematics.tech().bus_arc;
    private ArrayList<PortInst> stack;

    NetCell(Cell cell) {
        this.database = cell.getDatabase();
        this.networkManager = this.database.getNetworkManager();
        this.isSchem = this instanceof NetSchem;
        if (this.isSchem) {
            this.expectedSnapshot = new WeakReference<Object>(null);
        } else {
            this.expectedCellTree = new WeakReference<Object>(null);
        }
        this.cell = cell;
    }

    public static NetCell newInstance(Cell cell) {
        return cell.isIcon() || cell.isSchematic() ? new NetSchem(cell) : new NetCell(cell);
    }

    public Netlist getNetlist(Netlist.ShortResistors shortResistors) {
        if (this.isSchem) {
            if (this.database.backup() != this.expectedSnapshot.get()) {
                ((NetSchem)this).updateSchematic();
            }
        } else if (this.cell.tree() != this.expectedCellTree.get()) {
            this.updateLayout();
        }
        switch (shortResistors) {
            case NO: {
                return this.netlistN;
            }
            case PARASITIC: {
                return this.netlistP;
            }
            case ALL: {
                return this.netlistA;
            }
        }
        throw new AssertionError();
    }

    Iterator<Nodable> getNodables() {
        return this.cell.getNodables();
    }

    Global.Set getGlobals() {
        return Global.Set.empty;
    }

    int getNetMapOffset(Global global) {
        return -1;
    }

    int getNetMapOffset(Nodable no, Global global) {
        return -1;
    }

    int getNetMapOffset(Nodable no, int equivPortIndex) {
        NodeInst ni = (NodeInst)no;
        return this.drawns[this.ni_pi[ni.getNodeId()] + equivPortIndex];
    }

    int getNetMapOffset(Nodable no, PortProto portProto, int busIndex) {
        NodeInst ni = (NodeInst)no;
        return this.drawns[this.ni_pi[ni.getNodeId()] + portProto.getPortIndex()];
    }

    int getNetMapOffset(Nodable no, Name portName) {
        PortProto portProto;
        NodeInst ni = (NodeInst)no;
        if (ni.isCellInstance()) {
            Cell subCell = (Cell)ni.getProto();
            assert (!subCell.isIcon() && !subCell.isSchematic());
        }
        if ((portProto = ni.getProto().findPortProto(portName)) == null) {
            return -1;
        }
        return this.drawns[this.ni_pi[ni.getNodeId()] + portProto.getPortIndex()];
    }

    int getBusWidth(Nodable no, PortProto portProto) {
        return 1;
    }

    int getNetMapOffset(Export export, int busIndex) {
        return this.drawns[export.getPortIndex()];
    }

    int getNetMapOffset(Name exportName) {
        Export export = this.cell.findExport(exportName);
        return export != null ? this.drawns[export.getPortIndex()] : -1;
    }

    int getNetMapOffset(ArcInst ai, int busIndex) {
        return this.getArcDrawn(ai);
    }

    Name getBusName(ArcInst ai) {
        return null;
    }

    int getBusWidth(ArcInst ai) {
        int drawn = this.getArcDrawn(ai);
        if (drawn < 0) {
            return 0;
        }
        return 1;
    }

    int getArcDrawn(ArcInst ai) {
        assert (ai.getParent() == this.cell);
        int arcIndex = this.cell.backup().cellRevision.getArcIndexByArcId(ai.getArcId());
        return this.drawns[this.arcsOffset + arcIndex];
    }

    private void initConnections() {
        int i;
        int numPorts = this.cell.getNumPorts();
        int maxNodeId = this.cell.backup().cellRevision.getMaxNodeId();
        int numArcs = this.cell.getNumArcs();
        if (this.ni_pi == null || this.ni_pi.length != maxNodeId + 1) {
            this.ni_pi = new int[maxNodeId + 1];
        }
        int offset = numPorts;
        for (int nodeId = 0; nodeId <= maxNodeId; ++nodeId) {
            this.ni_pi[nodeId] = offset;
            NodeInst ni = this.cell.getNodeById(nodeId);
            if (ni == null) continue;
            offset += ni.getProto().getNumPorts();
        }
        this.arcsOffset = offset;
        if (this.headConn == null || this.headConn.length != (offset += numArcs)) {
            this.headConn = new int[offset];
            this.tailConn = new int[offset];
            this.drawns = new int[offset];
        }
        for (i = numPorts; i < this.arcsOffset; ++i) {
            this.headConn[i] = i;
            this.tailConn[i] = i;
        }
        for (i = 0; i < numPorts; ++i) {
            int portOffset = i;
            Export export = this.cell.getPort(i);
            int orig = this.getPortInstOffset(export.getOriginalPort());
            this.headConn[portOffset] = this.headConn[orig];
            this.headConn[orig] = portOffset;
            this.tailConn[portOffset] = -1;
        }
        Iterator<ArcInst> it = this.cell.getArcs();
        for (int arcIndex = 0; arcIndex < numArcs; ++arcIndex) {
            ArcInst ai = it.next();
            int arcOffset = this.arcsOffset + arcIndex;
            int head2 = this.getPortInstOffset(ai.getHeadPortInst());
            this.headConn[arcOffset] = this.headConn[head2];
            this.headConn[head2] = arcOffset;
            int tail = this.getPortInstOffset(ai.getTailPortInst());
            this.tailConn[arcOffset] = this.tailConn[tail];
            this.tailConn[tail] = arcOffset;
        }
    }

    private void addToDrawn1(PortInst pi) {
        ArcProto ap;
        ArcInst ai;
        int piOffset = this.getPortInstOffset(pi);
        if (this.drawns[piOffset] >= 0) {
            return;
        }
        PortProto pp = pi.getPortProto();
        if (pp instanceof PrimitivePort && ((PrimitivePort)pp).isIsolated()) {
            return;
        }
        this.drawns[piOffset] = this.numDrawns;
        if (NetworkTool.debug) {
            System.out.println(this.numDrawns + ": " + pi);
        }
        int k = piOffset;
        while (this.headConn[k] != piOffset) {
            PortInst tpi;
            if (this.drawns[k = this.headConn[k]] >= 0) continue;
            if (k < this.arcsOffset) {
                this.drawns[k] = this.numDrawns;
                if (!NetworkTool.debug) continue;
                System.out.println(this.numDrawns + ": " + this.cell.getPort(k));
                continue;
            }
            ai = this.cell.getArc(k - this.arcsOffset);
            ap = ai.getProto();
            if (ap.getFunction() == ArcProto.Function.NONELEC || pp == busPinPort && ap != busArc) continue;
            this.drawns[k] = this.numDrawns;
            if (NetworkTool.debug) {
                System.out.println(this.numDrawns + ": " + ai);
            }
            if ((tpi = ai.getTailPortInst()).getPortProto() == busPinPort && ap != busArc) continue;
            this.stack.add(tpi);
        }
        k = piOffset;
        while (this.tailConn[k] != piOffset) {
            PortInst hpi;
            if (this.drawns[k = this.tailConn[k]] >= 0 || (ap = (ai = this.cell.getArc(k - this.arcsOffset)).getProto()).getFunction() == ArcProto.Function.NONELEC || pp == busPinPort && ap != busArc) continue;
            this.drawns[k] = this.numDrawns;
            if (NetworkTool.debug) {
                System.out.println(this.numDrawns + ": " + ai);
            }
            if ((hpi = ai.getHeadPortInst()).getPortProto() == busPinPort && ap != busArc) continue;
            this.stack.add(hpi);
        }
    }

    private void addToDrawn(PortInst pi) {
        assert (this.stack.isEmpty());
        this.stack.add(pi);
        while (!this.stack.isEmpty()) {
            pi = this.stack.remove(this.stack.size() - 1);
            PortProto pp = pi.getPortProto();
            NodeProto np = pp.getParent();
            int numPorts = np.getNumPorts();
            if (numPorts == 1 || np instanceof Cell) {
                this.addToDrawn1(pi);
                continue;
            }
            NodeInst ni = pi.getNodeInst();
            int topology = ((PrimitivePort)pp).getTopology();
            for (int i = 0; i < numPorts; ++i) {
                if (((PrimitivePort)np.getPort(i)).getTopology() != topology) continue;
                this.addToDrawn1(ni.getPortInst(i));
            }
        }
    }

    void makeDrawns() {
        int i;
        this.initConnections();
        Arrays.fill(this.drawns, -1);
        this.stack = new ArrayList();
        this.numDrawns = 0;
        int numPorts = this.cell.getNumPorts();
        for (i = 0; i < numPorts; ++i) {
            if (this.drawns[i] >= 0) continue;
            this.drawns[i] = this.numDrawns++;
            Export export = this.cell.getPort(i);
            this.addToDrawn(export.getOriginalPort());
        }
        this.numExportedDrawns = this.numDrawns;
        int numArcs = this.cell.getNumArcs();
        for (i = 0; i < numArcs; ++i) {
            PortInst tpi;
            PortInst hpi;
            ArcInst ai;
            ArcProto ap;
            if (this.drawns[this.arcsOffset + i] >= 0 || (ap = (ai = this.cell.getArc(i)).getProto()).getFunction() == ArcProto.Function.NONELEC) continue;
            this.drawns[this.arcsOffset + i] = this.numDrawns;
            if (NetworkTool.debug) {
                System.out.println(this.numDrawns + ": " + ai);
            }
            if ((hpi = ai.getHeadPortInst()).getPortProto() != busPinPort || ap == busArc) {
                this.addToDrawn(hpi);
            }
            if ((tpi = ai.getTailPortInst()).getPortProto() != busPinPort || ap == busArc) {
                this.addToDrawn(tpi);
            }
            ++this.numDrawns;
        }
        this.numConnectedDrawns = this.numDrawns;
        int numNodes = this.cell.getNumNodes();
        for (i = 0; i < numNodes; ++i) {
            NodeInst ni = this.cell.getNode(i);
            NodeProto np = ni.getProto();
            if (ni.isIconOfParent() || np.getFunction() == PrimitiveNode.Function.ART && np != Generic.tech().simProbeNode || np == Artwork.tech().pinNode || np == Generic.tech().invisiblePinNode) continue;
            int numPortInsts = np.getNumPorts();
            for (int j = 0; j < numPortInsts; ++j) {
                PortInst pi = ni.getPortInst(j);
                int piOffset = this.getPortInstOffset(pi);
                if (this.drawns[piOffset] >= 0 || pi.getPortProto() instanceof PrimitivePort && ((PrimitivePort)pi.getPortProto()).isIsolated()) continue;
                this.addToDrawn(pi);
                ++this.numDrawns;
            }
        }
        this.stack = null;
        this.tailConn = null;
        this.headConn = null;
        if (Job.getDebug()) {
            this.checkDrawns();
        }
    }

    private void checkDrawns() {
        ImmutableNet nets = new ImmutableNet(this.cell.tree());
        assert (this.numExportedDrawns == nets.numExportedDrawns);
        assert (this.numConnectedDrawns == nets.numConnectedDrawns);
        assert (this.numDrawns == nets.numDrawns);
        for (int exportIndex = 0; exportIndex < this.cell.getNumPorts(); ++exportIndex) {
            Export e = this.cell.getPort(exportIndex);
            assert (this.drawns[exportIndex] == nets.getDrawn(e.getId()));
        }
        for (int nodeIndex = 0; nodeIndex < this.cell.getNumNodes(); ++nodeIndex) {
            NodeInst ni = this.cell.getNode(nodeIndex);
            int mapOffset = this.ni_pi[ni.getNodeId()];
            NodeProto np = ni.getProto();
            for (int portIndex = 0; portIndex < np.getNumPorts(); ++portIndex) {
                assert (this.drawns[mapOffset + portIndex] == nets.getDrawn(ni.getD(), np.getPort(portIndex).getId()));
            }
        }
        for (int arcIndex = 0; arcIndex < this.cell.getNumArcs(); ++arcIndex) {
            ArcInst ai = this.cell.getArc(arcIndex);
            assert (this.drawns[this.arcsOffset + arcIndex] == nets.getDrawn(ai.getD()));
        }
    }

    void showDrawns() {
        PrintWriter out;
        String filePath = "tttt";
        try {
            out = new PrintWriter(new BufferedWriter(new FileWriter(filePath, true)));
        }
        catch (IOException e) {
            System.out.println("Error opening " + filePath);
            return;
        }
        out.println("Drawns " + this.cell);
        int numPorts = this.cell.getNumPorts();
        for (int drawn = 0; drawn < this.numDrawns; ++drawn) {
            for (int i = 0; i < this.drawns.length; ++i) {
                int nodeId;
                if (this.drawns[i] != drawn) continue;
                if (i < numPorts) {
                    out.println(drawn + ": " + this.cell.getPort(i));
                    continue;
                }
                if (i >= this.arcsOffset) {
                    out.println(drawn + ": " + this.cell.getArc(i - this.arcsOffset));
                    continue;
                }
                for (nodeId = 1; nodeId < this.ni_pi.length && this.ni_pi[nodeId] <= i; ++nodeId) {
                }
                NodeInst ni = this.cell.getNodeById(--nodeId);
                PortInst pi = ni.getPortInst(i - this.ni_pi[nodeId]);
                out.println(drawn + ": " + pi);
            }
        }
        out.close();
    }

    void initNetnames() {
        Object e;
        for (MutableInteger nn : this.netNames.values()) {
            nn.setValue(-1);
        }
        this.netNameCount = 0;
        Iterator<Object> it = this.cell.getExports();
        while (it.hasNext()) {
            e = it.next();
            this.addNetNames(((Export)e).getNameKey(), (Export)e, null);
        }
        this.exportedNetNameCount = this.netNameCount;
        it = this.cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            if (ai.getProto().getFunction() == ArcProto.Function.NONELEC) continue;
            if (ai.getNameKey().isBus() && ai.getProto() != busArc) {
                String msg = "Network: " + this.cell + " has bus name <" + ai.getNameKey() + "> on arc that is not a bus";
                System.out.println(msg);
                this.networkManager.pushHighlight(ai);
                this.networkManager.logError(msg, 0);
            }
            if (!ai.isUsernamed()) continue;
            this.addNetNames(ai.getNameKey(), null, ai);
        }
        it = this.netNames.entrySet().iterator();
        while (it.hasNext()) {
            e = (Map.Entry)it.next();
            Name name = (Name)e.getKey();
            int index = ((MutableInteger)e.getValue()).intValue();
            if (index < 0) {
                it.remove();
                continue;
            }
            if (!NetworkTool.debug) continue;
            System.out.println("NetName " + name + " " + index);
        }
        assert (this.netNameCount == this.netNames.size());
    }

    void addNetNames(Name name, Export e, ArcInst ai) {
        if (name.isBus()) {
            System.out.println("Network: Layout " + this.cell + " has bus port/arc " + name);
        }
        this.addNetName(name, e, ai);
    }

    void addNetName(Name name, Export e, ArcInst ai) {
        MutableInteger nn = this.netNames.get(name);
        if (nn == null) {
            nn = new MutableInteger(-1);
            this.netNames.put(name, nn);
        }
        if (nn.intValue() < 0) {
            nn.setValue(this.netNameCount++);
        }
    }

    private void internalConnections(int[] netMapN, int[] netMapP, int[] netMapA) {
        Iterator<NodeInst> it = this.cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            int nodeOffset = this.ni_pi[ni.getNodeId()];
            if (!ni.isCellInstance()) {
                PrimitiveNode.Function fun = ni.getFunction();
                if (fun == PrimitiveNode.Function.RESIST) {
                    Netlist.connectMap(netMapP, this.drawns[nodeOffset], this.drawns[nodeOffset + 1]);
                    Netlist.connectMap(netMapA, this.drawns[nodeOffset], this.drawns[nodeOffset + 1]);
                    continue;
                }
                if (!fun.isComplexResistor()) continue;
                Netlist.connectMap(netMapA, this.drawns[nodeOffset], this.drawns[nodeOffset + 1]);
                continue;
            }
            Cell subCell = (Cell)ni.getProto();
            if (subCell.isIcon() || subCell.isSchematic()) continue;
            EquivPorts eq2 = subCell.tree().getEquivPorts();
            int[] eqN = eq2.getEquivPortsN();
            int[] eqP = eq2.getEquivPortsP();
            int[] eqA = eq2.getEquivPortsA();
            for (int i = 0; i < eqN.length; ++i) {
                if (eqN[i] != i) {
                    Netlist.connectMap(netMapN, this.drawns[nodeOffset + i], this.drawns[nodeOffset + eqN[i]]);
                }
                if (eqP[i] != i) {
                    Netlist.connectMap(netMapP, this.drawns[nodeOffset + i], this.drawns[nodeOffset + eqP[i]]);
                }
                if (eqA[i] == i) continue;
                Netlist.connectMap(netMapA, this.drawns[nodeOffset + i], this.drawns[nodeOffset + eqA[i]]);
            }
        }
        Netlist.closureMap(netMapN);
        Netlist.closureMap(netMapP);
        Netlist.closureMap(netMapA);
        if (Job.getDebug()) {
            ImmutableNetLayout immutableNetlist = new ImmutableNetLayout(this.cell.tree());
            assert (Arrays.equals(netMapN, immutableNetlist.getNetMap(Netlist.ShortResistors.NO)));
            assert (Arrays.equals(netMapP, immutableNetlist.getNetMap(Netlist.ShortResistors.PARASITIC)));
            assert (Arrays.equals(netMapA, immutableNetlist.getNetMap(Netlist.ShortResistors.ALL)));
        }
    }

    final int getPortInstOffset(PortInst pi) {
        return this.ni_pi[pi.getNodeInst().getNodeId()] + pi.getPortProto().getPortIndex();
    }

    NetSchem getSchem() {
        return null;
    }

    private void buildNetworkList(int[] netMapN) {
        int i;
        int drawn;
        ArcInst ai;
        int arcIndex;
        this.netlistN = new NetlistImpl(this, this.numExportedDrawns, netMapN);
        int[] netNameToNetIndex = new int[this.netNames.size()];
        Arrays.fill(netNameToNetIndex, -1);
        int numPorts = this.cell.getNumPorts();
        for (int i2 = 0; i2 < numPorts; ++i2) {
            Export e = this.cell.getPort(i2);
            int drawn2 = this.drawns[i2];
            this.setNetName(netNameToNetIndex, drawn2, e.getNameKey(), true);
            this.netlistN.setEquivPortIndexByNetIndex(i2, this.netlistN.getNetIndex(e, 0));
        }
        int numArcs = this.cell.getNumArcs();
        Iterator<ArcInst> it = this.cell.getArcs();
        for (arcIndex = 0; arcIndex < numArcs; ++arcIndex) {
            ai = it.next();
            if (!ai.isUsernamed() || (drawn = this.drawns[this.arcsOffset + arcIndex]) < 0) continue;
            this.setNetName(netNameToNetIndex, drawn, ai.getNameKey(), false);
        }
        it = this.cell.getArcs();
        for (arcIndex = 0; arcIndex < numArcs; ++arcIndex) {
            int netIndexN;
            ai = it.next();
            drawn = this.drawns[this.arcsOffset + arcIndex];
            if (drawn < 0 || this.netlistN.hasNames(netIndexN = this.netlistN.getNetIndexByMap(drawn))) continue;
            this.netlistN.addTempName(netIndexN, ai.getName());
        }
        for (i = 0; i < this.cell.getNumNodes(); ++i) {
            NodeInst ni = this.cell.getNode(i);
            int nodeId = ni.getNodeId();
            for (int j = 0; j < ni.getProto().getNumPorts(); ++j) {
                int netIndexN;
                int drawn3 = this.drawns[this.ni_pi[nodeId] + j];
                if (drawn3 < 0 || this.netlistN.hasNames(netIndexN = this.netlistN.getNetIndexByMap(drawn3))) continue;
                this.netlistN.addTempName(netIndexN, ni.getName() + '.' + ni.getProto().getPort(j).getName());
            }
        }
        int numNetworks = this.netlistN.getNumNetworks();
        for (i = 0; i < numNetworks; ++i) {
            assert (this.netlistN.hasNames(i));
            assert (this.netlistN.isExported(i) == i < this.netlistN.getNumExternalNetworks());
            if (!this.netlistN.isExported(i)) continue;
            int equivPortIndex = this.netlistN.getEquivPortIndexByNetIndex(i);
            assert (equivPortIndex >= 0 && equivPortIndex < numPorts);
        }
    }

    private void setNetName(int[] netNamesToNetIndex, int drawn, Name name, boolean exported) {
        int netIndexN = this.netlistN.getNetIndexByMap(drawn);
        assert (netIndexN >= 0);
        MutableInteger nn = this.netNames.get(name);
        if (netNamesToNetIndex[nn.intValue()] >= 0) {
            if (netNamesToNetIndex[nn.intValue()] == netIndexN) {
                return;
            }
            String msg = "Network: Layout " + this.cell + " has nets with same name " + name;
            System.out.println(msg);
            int numPorts = this.cell.getNumPorts();
            for (int i = 0; i < numPorts; ++i) {
                Export e = this.cell.getPort(i);
                if (!e.getName().equals(name.toString())) continue;
                this.networkManager.pushHighlight(this.cell.getPort(i));
            }
            Iterator<ArcInst> it = this.cell.getArcs();
            while (it.hasNext()) {
                ArcInst ai = it.next();
                if (!ai.isUsernamed() || !ai.getName().equals(name.toString())) continue;
                this.networkManager.pushHighlight(ai);
            }
            this.networkManager.logError(msg, 0);
        } else {
            netNamesToNetIndex[nn.intValue()] = netIndexN;
        }
        this.netlistN.addUserName(netIndexN, name, exported);
    }

    private boolean updateInterface() {
        boolean changed = false;
        int numPorts = this.cell.getNumPorts();
        if (this.equivPortsN == null || this.equivPortsN.length != numPorts) {
            changed = true;
            this.equivPortsN = new int[numPorts];
            this.equivPortsP = new int[numPorts];
            this.equivPortsA = new int[numPorts];
        }
        int[] netToPortN = new int[numPorts];
        int[] netToPortP = new int[numPorts];
        int[] netToPortA = new int[numPorts];
        Arrays.fill(netToPortN, -1);
        Arrays.fill(netToPortP, -1);
        Arrays.fill(netToPortA, -1);
        for (int i = 0; i < numPorts; ++i) {
            int netA;
            int netP;
            int netN = this.netlistN.netMap[this.drawns[i]];
            if (netToPortN[netN] < 0) {
                netToPortN[netN] = i;
            }
            if (this.equivPortsN[i] != netToPortN[netN]) {
                changed = true;
                this.equivPortsN[i] = netToPortN[netN];
            }
            if (netToPortP[netP = this.netlistP.netMap[this.drawns[i]]] < 0) {
                netToPortP[netP] = i;
            }
            if (this.equivPortsP[i] != netToPortP[netP]) {
                changed = true;
                this.equivPortsP[i] = netToPortP[netP];
            }
            if (netToPortA[netA = this.netlistA.netMap[this.drawns[i]]] < 0) {
                netToPortA[netA] = i;
            }
            if (this.equivPortsA[i] == netToPortA[netA]) continue;
            changed = true;
            this.equivPortsA[i] = netToPortA[netA];
        }
        if (Job.getDebug()) {
            EquivPorts equivPorts = this.cell.tree().getEquivPorts();
            assert (Arrays.equals(this.equivPortsN, equivPorts.getEquivPortsN()));
            assert (Arrays.equals(this.equivPortsP, equivPorts.getEquivPortsP()));
            assert (Arrays.equals(this.equivPortsA, equivPorts.getEquivPortsA()));
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLayout() {
        NetworkManager networkManager = this.networkManager;
        synchronized (networkManager) {
            CellTree oldCellTree = (CellTree)this.expectedCellTree.get();
            CellTree newCellTree = this.cell.tree();
            if (oldCellTree == newCellTree) {
                return;
            }
            if (oldCellTree == null || !newCellTree.sameNetlist(oldCellTree)) {
                this.networkManager.startErrorLogging(this.cell);
                try {
                    this.makeDrawns();
                    this.initNetnames();
                    this.redoNetworks1();
                }
                finally {
                    this.networkManager.finishErrorLogging();
                }
            }
            this.expectedCellTree = new WeakReference<CellTree>(newCellTree);
        }
    }

    boolean redoNetworks1() {
        int[] netMapN = Netlist.initMap(this.numDrawns);
        int[] netMapP = (int[])netMapN.clone();
        int[] netMapA = (int[])netMapN.clone();
        this.internalConnections(netMapN, netMapP, netMapA);
        this.buildNetworkList(netMapN);
        this.netlistP = new NetlistShorted(this.netlistN, Netlist.ShortResistors.PARASITIC, netMapP);
        this.netlistA = new NetlistShorted(this.netlistN, Netlist.ShortResistors.ALL, netMapA);
        return this.updateInterface();
    }

    boolean obsolete(Netlist netlist) {
        Netlist newNetlist = this.getNetlist(netlist.shortResistors);
        this.netlistP.expectedCellTree = this.netlistA.expectedCellTree = this.expectedCellTree;
        this.netlistN.expectedCellTree = this.netlistA.expectedCellTree;
        return newNetlist != netlist;
    }
}

