/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.util.memory;

import java.text.DecimalFormat;

public class Memory {
    public static String formatMemorySize(long memorySizeBytes) {
        StringBuilder builder = new StringBuilder();
        MemSize best = MemSize.getBestMemSize(memorySizeBytes);
        double value2 = MemSize.getBestMemSizeValue(memorySizeBytes, best);
        DecimalFormat df = new DecimalFormat("##.#");
        builder.append(df.format(value2));
        builder.append(best.entity);
        return builder.toString();
    }

    public static enum MemSize {
        none(1, "B"),
        kilo(1024, "kB"),
        mega(0x100000, "MB"),
        giga(0x40000000, "GB");

        private int value;
        private String entity;

        private MemSize(int value2, String entity) {
            this.value = value2;
            this.entity = entity;
        }

        public MemSize enlarge() {
            for (MemSize tmp : MemSize.values()) {
                if (tmp.value != this.value * 1024) continue;
                return tmp;
            }
            return this;
        }

        public MemSize ensmall() {
            for (MemSize tmp : MemSize.values()) {
                if (tmp.value != this.value / 1024) continue;
                return tmp;
            }
            return this;
        }

        public static MemSize getBestMemSize(Long memory) {
            MemSize result2 = none;
            double minimum = Double.MAX_VALUE;
            for (MemSize tmp : MemSize.values()) {
                double value2 = (double)memory.longValue() / (double)tmp.value;
                if (!(value2 >= 1.0) || Math.min(minimum, value2) != value2) continue;
                result2 = tmp;
            }
            return result2;
        }

        public static double getBestMemSizeValue(Long memory, MemSize bestMemSize) {
            double value2 = 0.0;
            value2 = (double)memory.longValue() / (double)bestMemSize.value;
            return value2;
        }
    }
}

