/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry;

import com.sun.electric.util.collections.ImmutableArrayList;
import com.sun.electric.util.math.AbstractFixpRectangle;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.ECoord;
import com.sun.electric.util.math.FixpCoord;
import com.sun.electric.util.math.GenMath;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class ERectangle
extends AbstractFixpRectangle
implements Serializable {
    public static final ERectangle ORIGIN = new ERectangle(0L, 0L, 0L, 0L);
    public static final ERectangle[] NULL_ARRAY = new ERectangle[0];
    public static final ImmutableArrayList<ERectangle> EMPTY_LIST = new ImmutableArrayList<ERectangle>(NULL_ARRAY);
    private final long gridMinX;
    private final long gridMinY;
    private final long gridMaxX;
    private final long gridMaxY;

    private ERectangle(long gridX, long gridY, long gridWidth, long gridHeight) {
        this.gridMinX = gridX;
        this.gridMinY = gridY;
        this.gridMaxX = gridX + gridWidth;
        this.gridMaxY = gridY + gridHeight;
    }

    public static ERectangle fromLambda(double x2, double y, double w, double h) {
        return new ERectangle(DBMath.lambdaToGrid(x2), DBMath.lambdaToGrid(y), DBMath.lambdaToGrid(w), DBMath.lambdaToGrid(h));
    }

    public static ERectangle fromFixp(long x2, long y, long w, long h) {
        long gridMinX = GenMath.roundToMultipleFloor(x2, 0x100000L) >> 20;
        long gridMinY = GenMath.roundToMultipleFloor(y, 0x100000L) >> 20;
        long gridMaxX = GenMath.roundToMultipleCeiling(x2 + w, 0x100000L) >> 20;
        long gridMaxY = GenMath.roundToMultipleCeiling(y + w, 0x100000L) >> 20;
        return ERectangle.fromGrid(gridMinX, gridMinY, gridMaxX - gridMinX, gridMaxY - gridMinY);
    }

    public static ERectangle fromGrid(long x2, long y, long w, long h) {
        return new ERectangle(x2, y, w, h);
    }

    public static ERectangle fromLambda(Rectangle2D r) {
        if (r instanceof ERectangle) {
            return (ERectangle)r;
        }
        return ERectangle.fromLambda(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public static ERectangle fromFixp(Rectangle2D r) {
        long x1 = (long)Math.floor(r.getMinX());
        long y1 = (long)Math.floor(r.getMinY());
        long x2 = (long)Math.ceil(r.getMaxX());
        long y2 = (long)Math.ceil(r.getMaxY());
        return ERectangle.fromFixp(x1, y1, x2 - x1, y2 - y1);
    }

    public static ERectangle fromGrid(Rectangle2D r) {
        long x1 = (long)Math.floor(r.getMinX());
        long y1 = (long)Math.floor(r.getMinY());
        long x2 = (long)Math.ceil(r.getMaxX());
        long y2 = (long)Math.ceil(r.getMaxY());
        return ERectangle.fromGrid(x1, y1, x2 - x1, y2 - y1);
    }

    @Override
    public ECoord getCoordWidth() {
        return ECoord.fromGrid(this.gridMaxX - this.gridMinX);
    }

    @Override
    public ECoord getCoordHeight() {
        return ECoord.fromGrid(this.gridMaxY - this.gridMinY);
    }

    @Override
    public ECoord getCoordMinX() {
        return ECoord.fromGrid(this.gridMinX);
    }

    @Override
    public ECoord getCoordMinY() {
        return ECoord.fromGrid(this.gridMinY);
    }

    @Override
    public ECoord getCoordMaxX() {
        return ECoord.fromGrid(this.gridMaxX);
    }

    @Override
    public ECoord getCoordMaxY() {
        return ECoord.fromGrid(this.gridMaxY);
    }

    @Override
    public FixpCoord getCoordCenterX() {
        return FixpCoord.fromFixp(this.gridMinX + this.gridMaxX << 19);
    }

    @Override
    public FixpCoord getCoordCenterY() {
        return FixpCoord.fromFixp(this.gridMinY + this.gridMaxY << 19);
    }

    @Override
    public long getFixpX() {
        return this.gridMinX << 20;
    }

    @Override
    public long getFixpY() {
        return this.gridMinY << 20;
    }

    @Override
    public long getFixpWidth() {
        return this.gridMaxX - this.gridMinX << 20;
    }

    @Override
    public long getFixpHeight() {
        return this.gridMaxY - this.gridMinY << 20;
    }

    @Override
    public long getFixpMinX() {
        return this.gridMinX << 20;
    }

    @Override
    public long getFixpMinY() {
        return this.gridMinY << 20;
    }

    @Override
    public long getFixpMaxX() {
        return this.gridMaxX << 20;
    }

    @Override
    public long getFixpMaxY() {
        return this.gridMaxY << 20;
    }

    @Override
    public long getFixpCenterX() {
        return this.gridMinX + this.gridMaxX << 19;
    }

    @Override
    public long getFixpCenterY() {
        return this.gridMinY + this.gridMaxY << 19;
    }

    public long getGridX() {
        return this.gridMinX;
    }

    public long getGridY() {
        return this.gridMinY;
    }

    public long getGridWidth() {
        return this.gridMaxX - this.gridMinX;
    }

    public long getGridHeight() {
        return this.gridMaxY - this.gridMinY;
    }

    public long getGridMinX() {
        return this.gridMinX;
    }

    public long getGridMinY() {
        return this.gridMinY;
    }

    public long getGridMaxX() {
        return this.gridMaxX;
    }

    public long getGridMaxY() {
        return this.gridMaxY;
    }

    public double getGridCenterX() {
        return this.gridMinX + this.gridMaxX >> 1;
    }

    public double getGridCenterY() {
        return this.gridMinY + this.gridMaxY >> 1;
    }

    @Override
    public boolean isEmpty() {
        return this.gridMinX >= this.gridMaxX || this.gridMinY >= this.gridMaxY;
    }

    @Override
    public void setRect(double x2, double y, double w, double h) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFixp(long fixpMinX, long fixpMinY, long fixpMaxX, long fixpMaxY) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ERectangle createFixp(long fixpMinX, long fixpMinY, long fixpMaxX, long fixpMaxY) {
        return ERectangle.fromFixp(fixpMinX, fixpMinY, fixpMaxX - fixpMinX, fixpMaxY - fixpMinY);
    }

    @Override
    public int outcode(double x2, double y) {
        int out = 0;
        if (this.gridMinX >= this.gridMaxX) {
            out |= 5;
        } else if (x2 * 400.0 < (double)this.gridMinX) {
            out |= 1;
        } else if (x2 * 400.0 > (double)this.gridMaxX) {
            out |= 4;
        }
        if (this.gridMinY >= this.gridMaxY) {
            out |= 0xA;
        } else if (y * 400.0 < (double)this.gridMinY) {
            out |= 2;
        } else if (y * 400.0 > (double)this.gridMaxY) {
            out |= 8;
        }
        return out;
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this;
    }

    @Override
    public Rectangle2D createIntersection(Rectangle2D r) {
        if (r instanceof ERectangle) {
            ERectangle src = (ERectangle)r;
            long x1 = Math.max(this.gridMinX, src.gridMinX);
            long y1 = Math.max(this.gridMinY, src.gridMinY);
            long x2 = Math.min(this.gridMaxX, src.gridMaxX);
            long y2 = Math.min(this.gridMaxY, src.gridMaxY);
            if (x1 == this.gridMinX && y1 == this.gridMinY && x2 == this.gridMaxX && y2 == this.gridMaxY) {
                return this;
            }
            if (x1 == src.gridMinX && y1 == src.gridMinY && x2 == src.gridMaxX && y2 == src.gridMaxY) {
                return src;
            }
            return new ERectangle(x1, y1, x2 - x1, y2 - y1);
        }
        Rectangle2D.Double dest = new Rectangle2D.Double();
        Rectangle2D.intersect(this, r, dest);
        return dest;
    }

    @Override
    public Rectangle2D createUnion(Rectangle2D r) {
        if (r instanceof ERectangle) {
            ERectangle src = (ERectangle)r;
            long x1 = Math.min(this.gridMinX, src.gridMinX);
            long y1 = Math.min(this.gridMinY, src.gridMinY);
            long x2 = Math.max(this.gridMaxX, src.gridMaxX);
            long y2 = Math.max(this.gridMaxY, src.gridMaxY);
            if (x1 == this.gridMinX && y1 == this.gridMinY && x2 == this.gridMaxX && y2 == this.gridMaxY) {
                return this;
            }
            if (x1 == src.gridMinX && y1 == src.gridMinY && x2 == src.gridMaxX && y2 == src.gridMaxY) {
                return src;
            }
            return new ERectangle(x1, y1, x2 - x1, y2 - 1L);
        }
        Rectangle2D.Double dest = new Rectangle2D.Double();
        Rectangle2D.union(this, r, dest);
        return dest;
    }
}

