/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Global;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.CodeExpression;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.generator.sclibrary.SCLibraryGen;
import com.sun.electric.tool.io.input.verilog.VerilogReader;
import com.sun.electric.tool.io.output.CellModelPrefs;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.tool.io.output.Topology;
import com.sun.electric.tool.simulation.SimulationTool;
import com.sun.electric.tool.user.CompileVerilogStruct;
import com.sun.electric.tool.user.dialogs.BusParameters;
import com.sun.electric.util.TextUtils;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Verilog
extends Topology {
    private static final int MAXDECLARATIONWIDTH = 80;
    private static final String IMPLICITINVERTERNODENAME = "Imp";
    private static final String IMPLICITINVERTERSIGNAME = "ImpInv";
    public static final Variable.Key VERILOG_CODE_KEY = Variable.newKey("VERILOG_code");
    public static final Variable.Key VERILOG_DECLARATION_KEY = Variable.newKey("VERILOG_declaration");
    public static final Variable.Key VERILOG_PARAMETER_KEY = Variable.newKey("VERILOG_parameter");
    public static final Variable.Key VERILOG_EXTERNAL_CODE_KEY = Variable.newKey("VERILOG_external_code");
    public static final Variable.Key WIRE_TYPE_KEY = Variable.newKey("SIM_verilog_wire_type");
    public static final Variable.Key VERILOG_TEMPLATE_KEY = Variable.newKey("ATTR_verilog_template");
    public static final Variable.Key VERILOG_DEFPARAM_KEY = Variable.newKey("ATTR_verilog_defparam");
    public static final Variable.Key VERILOG_BEHAVE_FILE_KEY = Variable.newKey("SIM_verilog_behave_file");
    private Set<Cell> modelOverrides = new HashSet<Cell>();
    private Map<String, String> definedModules = new HashMap<String, String>();
    private Map<Cell, CompileVerilogStruct.VModule> definedPrimitivesNew = new HashMap<Cell, CompileVerilogStruct.VModule>();
    private SCLibraryGen.StandardCellHierarchy standardCells = new SCLibraryGen.StandardCellHierarchy();
    private String filePath;
    private Set<String> reservedWords;
    private Set<Cell> externalCodeWritten;
    private VerilogPreferences localPrefs;
    private StringBuffer sim_verDeclarationLine;
    private int sim_verdeclarationprefix;
    private static final String[] verilogGates = new String[]{"and", "nand", "or", "nor", "xor", "xnor", "buf", "bufif0", "bufif1", "not", "notif0", "notif1", "pulldown", "pullup", "nmos", "rnmos", "pmos", "rpmos", "cmos", "rcmos", "tran", "rtran", "tranif0", "rtranif0", "tranif1", "rtranif1"};

    Verilog(VerilogPreferences vp) {
        this.localPrefs = vp;
        this.reservedWords = new HashSet<String>();
        this.reservedWords.add("always");
        this.reservedWords.add("and");
        this.reservedWords.add("assign");
        this.reservedWords.add("attribute");
        this.reservedWords.add("begin");
        this.reservedWords.add("buf");
        this.reservedWords.add("bufif0");
        this.reservedWords.add("bufif1");
        this.reservedWords.add("case");
        this.reservedWords.add("casex");
        this.reservedWords.add("casez");
        this.reservedWords.add("cmos");
        this.reservedWords.add("deassign");
        this.reservedWords.add("default");
        this.reservedWords.add("defpram");
        this.reservedWords.add("disable");
        this.reservedWords.add("edge");
        if (this.localPrefs.useVerilogA) {
            this.reservedWords.add("electrical");
        }
        this.reservedWords.add("else");
        this.reservedWords.add("end");
        this.reservedWords.add("endattribute");
        this.reservedWords.add("endcase");
        this.reservedWords.add("endfunction");
        this.reservedWords.add("endmodule");
        this.reservedWords.add("endprimitive");
        this.reservedWords.add("endspecify");
        this.reservedWords.add("endtable");
        this.reservedWords.add("endtask");
        this.reservedWords.add("event");
        this.reservedWords.add("for");
        this.reservedWords.add("force");
        this.reservedWords.add("forever");
        this.reservedWords.add("fork");
        this.reservedWords.add("function");
        this.reservedWords.add("highz0");
        this.reservedWords.add("highz1");
        this.reservedWords.add("if");
        this.reservedWords.add("initial");
        this.reservedWords.add("inout");
        this.reservedWords.add("input");
        this.reservedWords.add("integer");
        this.reservedWords.add("join");
        this.reservedWords.add("large");
        this.reservedWords.add("macromodule");
        this.reservedWords.add("meduim");
        this.reservedWords.add("module");
        this.reservedWords.add("nand");
        this.reservedWords.add("negedge");
        this.reservedWords.add("nmos");
        this.reservedWords.add("nor");
        this.reservedWords.add("not");
        this.reservedWords.add("notif0");
        this.reservedWords.add("notif1");
        this.reservedWords.add("or");
        this.reservedWords.add("output");
        this.reservedWords.add("parameter");
        this.reservedWords.add("pmos");
        this.reservedWords.add("posedge");
        this.reservedWords.add("primitive");
        this.reservedWords.add("pull0");
        this.reservedWords.add("pull1");
        this.reservedWords.add("pulldown");
        this.reservedWords.add("pullup");
        this.reservedWords.add("rcmos");
        this.reservedWords.add("real");
        this.reservedWords.add("realtime");
        this.reservedWords.add("reg");
        this.reservedWords.add("release");
        this.reservedWords.add("repeat");
        this.reservedWords.add("rtranif1");
        this.reservedWords.add("scalared");
        this.reservedWords.add("signed");
        this.reservedWords.add("small");
        this.reservedWords.add("specify");
        this.reservedWords.add("specpram");
        this.reservedWords.add("strength");
        this.reservedWords.add("strong0");
        this.reservedWords.add("strong1");
        this.reservedWords.add("supply0");
        this.reservedWords.add("supply1");
        this.reservedWords.add("table");
        this.reservedWords.add("task");
        this.reservedWords.add("time");
        this.reservedWords.add("tran");
        this.reservedWords.add("tranif0");
        this.reservedWords.add("tranif1");
        this.reservedWords.add("tri");
        this.reservedWords.add("tri0");
        this.reservedWords.add("tri1");
        this.reservedWords.add("triand");
        this.reservedWords.add("trior");
        this.reservedWords.add("trireg");
        this.reservedWords.add("unsigned");
        this.reservedWords.add("vectored");
        this.reservedWords.add("wait");
        this.reservedWords.add("wand");
        this.reservedWords.add("weak0");
        this.reservedWords.add("weak1");
        this.reservedWords.add("while");
        this.reservedWords.add("wire");
        this.reservedWords.add("wor");
        this.reservedWords.add("xnor");
        this.reservedWords.add("xor");
        if (this.localPrefs.useVerilogA) {
            this.reservedWords.add("PCNFET");
        }
        if (this.localPrefs.useVerilogA) {
            this.reservedWords.add("NCNFET");
        }
    }

    @Override
    protected void start() {
        this.setOutputWidth(80, false);
        this.setContinuationString("      ");
        String typeOfVerilog = this.localPrefs.useVerilogA ? "VerilogA" : "Verilog";
        this.printWriter.println("/* " + typeOfVerilog + " for " + this.topCell + " from " + this.topCell.getLibrary() + " */");
        this.emitCopyright("/* ", " */");
        if (this.localPrefs.includeDateAndVersionInOutput) {
            this.printWriter.println("/* Created on " + TextUtils.formatDate(this.topCell.getCreationDate()) + " */");
            this.printWriter.println("/* Last revised on " + TextUtils.formatDate(this.topCell.getRevisionDate()) + " */");
            this.printWriter.println("/* Written on " + TextUtils.formatDate(new Date()) + " by Electric VLSI Design System, version " + Version.getVersion() + " */");
        } else {
            this.printWriter.println("/* Written by Electric VLSI Design System */");
        }
        this.externalCodeWritten = new HashSet<Cell>();
        this.includeTypedCode(this.topCell, VERILOG_EXTERNAL_CODE_KEY, "external code");
        if (this.localPrefs.stopAtStandardCells) {
            HierarchyEnumerator.enumerateCell(this.topCell, VarContext.globalContext, (HierarchyEnumerator.Visitor)this.standardCells);
            if (!this.localPrefs.netlistNonstandardCells) {
                for (Cell acell : this.standardCells.getDoesNotContainStandardCellsInHier()) {
                    this.reportWarning("Warning: Not netlisting cell " + acell.describe(false) + " because it does not contain any standard cells.");
                }
            }
            if (this.standardCells.getNameConflict()) {
                System.out.println("Name conflicts found, please see above messages");
            }
        }
    }

    @Override
    protected void done() {
    }

    @Override
    protected boolean skipCellAndSubcells(Cell cell) {
        if (this.localPrefs.stopAtStandardCells) {
            if (SCLibraryGen.isStandardCell(cell)) {
                return true;
            }
            if (!this.localPrefs.netlistNonstandardCells) {
                return !this.standardCells.containsStandardCell(cell);
            }
        }
        if (cell.getVar(VERILOG_TEMPLATE_KEY) != null) {
            return true;
        }
        String unfilteredFileName = this.localPrefs.modelFiles.get(cell);
        if (CellModelPrefs.isUseModelFromFile(unfilteredFileName)) {
            String fileName = CellModelPrefs.getModelFile(unfilteredFileName);
            if (this.filePath.equals(fileName)) {
                this.reportError("Error: Use Model From File file path for cell " + cell.describe(false) + " is the same as the file being written, skipping.");
                return false;
            }
            File f2 = new File(fileName);
            CompileVerilogStruct cvs = new CompileVerilogStruct(f2, false);
            if (cvs.hadErrors()) {
                this.reportError("Error reading include file: " + fileName);
                return false;
            }
            if (!this.checkIncludedData(cvs, cell, fileName)) {
                return false;
            }
            if (!this.modelOverrides.contains(cell)) {
                this.printWriter.println("`include \"" + fileName + "\"");
                this.modelOverrides.add(cell);
            }
            return true;
        }
        Cell verViewCell = cell.otherView(View.VERILOG);
        if (verViewCell != null && CellModelPrefs.verilogModelPrefs.isUseVerilogView(cell)) {
            String[] stringArray = verViewCell.getTextViewContents();
            if (stringArray != null) {
                String line;
                if (stringArray.length > 0 && (line = stringArray[0].toLowerCase()).startsWith("do not use")) {
                    return false;
                }
                CompileVerilogStruct cvs = new CompileVerilogStruct(stringArray, false);
                if (cvs.hadErrors()) {
                    this.reportError("Error parsing Verilog View for cell " + cell.describe(false));
                    return false;
                }
                if (!this.checkIncludedData(cvs, cell, null)) {
                    return false;
                }
                System.out.println("Info: Netlisting Verilog view of " + cell.describe(false));
                this.printWriter.println();
                this.printWriter.println("/* Verilog view of " + verViewCell.libDescribe() + " */");
                for (int i = 0; i < stringArray.length; ++i) {
                    this.printWriter.println(stringArray[i]);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean isWriteCopyForEachIcon() {
        return this.localPrefs.writeModuleForEachIcon;
    }

    @Override
    protected void writeCellTopology(Cell cell, String cellName, Topology.CellNetInfo cni, VarContext context, Topology.MyCellInfo info) {
        String wireType;
        Iterator<Serializable> it;
        if (cell == this.topCell) {
            Global global;
            int i;
            Netlist netList = cni.getNetList();
            Global.Set globals = netList.getGlobals();
            int globalSize = globals.size();
            ArrayList<Global> globalsToWrite = new ArrayList<Global>();
            for (i = 0; i < globalSize; ++i) {
                global = globals.get(i);
                if (global == Global.power || global == Global.ground) continue;
                globalsToWrite.add(global);
            }
            if (globalsToWrite.size() > 0) {
                this.printWriter.println("\nmodule glbl();");
                for (i = 0; i < globalsToWrite.size(); ++i) {
                    global = (Global)globalsToWrite.get(i);
                    String sigType = this.localPrefs.useTrireg ? "trireg" : "wire";
                    if (this.localPrefs.useVerilogA) {
                        sigType = "electrical";
                    }
                    this.printWriter.println("    " + sigType + " " + global.getName() + ";");
                }
                this.printWriter.println("endmodule");
            }
        }
        HashMap<ArcInst, Integer> implicitHeadInverters = new HashMap<ArcInst, Integer>();
        HashMap<ArcInst, Integer> implicitTailInverters = new HashMap<ArcInst, Integer>();
        int impInvCount = 0;
        Iterator<ArcInst> it2 = cell.getArcs();
        while (it2.hasNext()) {
            ArcInst ai = it2.next();
            for (int e = 0; e < 2; ++e) {
                PortInst pi;
                NodeInst ni;
                if (!ai.isNegated(e) || ((ni = (pi = ai.getPortInst(e)).getNodeInst()).getProto() == Schematics.tech().bufferNode || ni.getProto() == Schematics.tech().andNode || ni.getProto() == Schematics.tech().orNode || ni.getProto() == Schematics.tech().xorNode) && (this.localPrefs.useAssign || pi.getPortProto().getName().equals("y"))) continue;
                if (e == 1) {
                    implicitHeadInverters.put(ai, new Integer(impInvCount));
                } else {
                    implicitTailInverters.put(ai, new Integer(impInvCount));
                }
                if (ai.getProto() != Schematics.tech().bus_arc) {
                    ++impInvCount;
                    continue;
                }
                int wid = cni.getNetList().getBusWidth(ai);
                impInvCount += wid;
            }
        }
        Netlist netList = cni.getNetList();
        this.includeTypedCode(cell, VERILOG_EXTERNAL_CODE_KEY, "external code");
        this.printWriter.println();
        StringBuffer sb = new StringBuffer();
        sb.append("module " + cellName + "(");
        boolean first = true;
        int flagvdd = 0;
        int flaggnd = 0;
        Iterator<Topology.CellAggregateSignal> it3 = cni.getCellAggregateSignals();
        while (it3.hasNext()) {
            Topology.CellAggregateSignal cas = it3.next();
            if (cas.getExport() == null) continue;
            if (cas.getName() == "vdd") {
                ++flagvdd;
            }
            if (cas.getName() == "gnd") {
                ++flaggnd;
            }
            if (cas.getLowIndex() <= cas.getHighIndex() && cas.getIndices() != null) {
                int[] indices = cas.getIndices();
                for (int i = 0; i < indices.length; ++i) {
                    int ind = i;
                    if (cas.isDescending()) {
                        ind = indices.length - i - 1;
                    }
                    if (!first) {
                        sb.append(",");
                    }
                    sb.append(" \\" + cas.getName() + "[" + indices[ind] + "] ");
                    first = false;
                }
                continue;
            }
            if (!first) {
                sb.append(", ");
            }
            sb.append(cas.getName());
            first = false;
        }
        if (this.localPrefs.useVerilogA) {
            if (flagvdd == 0) {
                sb.append(", vdd");
            }
            if (flaggnd == 0) {
                sb.append(", gnd");
            }
        }
        sb.append(");\n");
        this.writeWidthLimited(sb.toString());
        this.definedModules.put(cellName, "Cell " + cell.libDescribe());
        HashSet<String> knownParameterNames = new HashSet<String>();
        HashSet<String> knownParameterNamesLC = new HashSet<String>();
        if (!this.localPrefs.parameterizeModuleNames && this.localPrefs.useBehavioralConstructs) {
            it = cell.getParameters();
            while (it.hasNext()) {
                Variable var = (Variable)it.next();
                String eval = var.describe(context, cell);
                int equalPos = eval.indexOf(61);
                String pureNum = equalPos >= 0 ? eval.substring(equalPos + 1) : eval;
                try {
                    Number n = TextUtils.parsePostFixNumber(pureNum, null);
                    double v = n.doubleValue();
                    if (v != 0.0) {
                        eval = eval.substring(0, equalPos) + "=" + v;
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                if (eval.trim().length() <= 0) continue;
                this.writeWidthLimited("  parameter " + eval + ";\n");
                knownParameterNames.add(var.getTrueName());
                knownParameterNamesLC.add(var.getTrueName().toLowerCase());
            }
        }
        this.includeTypedCode(cell, VERILOG_PARAMETER_KEY, "parameters");
        it = cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            Variable var = ai.getVar(WIRE_TYPE_KEY);
            if (var == null) continue;
            String wireType2 = var.getObject().toString();
            int overrideValue = 0;
            if (wireType2.equalsIgnoreCase("wire")) {
                overrideValue = 1;
            } else if (wireType2.equalsIgnoreCase("trireg")) {
                overrideValue = 2;
            }
            int busWidth = netList.getBusWidth(ai);
            for (int i = 0; i < busWidth; ++i) {
                Network net = netList.getNetwork(ai, i);
                Topology.CellSignal cs = cni.getCellSignal(net);
                if (cs == null) continue;
                cs.getAggregateSignal().setFlags(overrideValue);
            }
        }
        if (this.localPrefs.useVerilogA) {
            first = true;
            int flagvdd1 = 0;
            int flaggnd1 = 0;
            Iterator<Topology.CellAggregateSignal> it4 = cni.getCellAggregateSignals();
            while (it4.hasNext()) {
                Topology.CellAggregateSignal cas = it4.next();
                Export pp = cas.getExport();
                if (pp == null) continue;
                String portType = "input";
                if (pp.getCharacteristic() == PortCharacteristic.PWR) {
                    ++flagvdd1;
                }
                if (pp.getCharacteristic() == PortCharacteristic.GND) {
                    ++flaggnd1;
                }
                if (pp.getCharacteristic() == PortCharacteristic.UNKNOWN) {
                    portType = "unknown";
                }
                if (pp.getCharacteristic() == PortCharacteristic.REFIN) {
                    portType = "refin";
                }
                if (pp.getCharacteristic() == PortCharacteristic.REFBASE) {
                    portType = "refbase";
                }
                if (pp.getCharacteristic() == PortCharacteristic.OUT || pp.getCharacteristic() == PortCharacteristic.BIDIR || pp.getCharacteristic() == PortCharacteristic.REFOUT) continue;
                sb = new StringBuffer();
                sb.append("  " + portType);
                if (cas.getLowIndex() > cas.getHighIndex()) {
                    if (pp.getCharacteristic() == PortCharacteristic.PWR) {
                        sb.append(" vdd;");
                    } else if (pp.getCharacteristic() == PortCharacteristic.GND) {
                        sb.append(" gnd;");
                    } else {
                        sb.append(" " + cas.getName() + ";");
                    }
                } else {
                    int[] indices = cas.getIndices();
                    if (indices != null) {
                        for (int i = 0; i < indices.length; ++i) {
                            int ind = i;
                            if (cas.isDescending()) {
                                ind = indices.length - i - 1;
                            }
                            if (i != 0) {
                                sb.append(",");
                            }
                            sb.append(" \\" + cas.getName() + "[" + indices[ind] + "] ");
                        }
                        sb.append(";");
                    } else {
                        int low = cas.getLowIndex();
                        int high = cas.getHighIndex();
                        if (cas.isDescending()) {
                            low = cas.getHighIndex();
                            high = cas.getLowIndex();
                        }
                        sb.append(" [" + low + ":" + high + "] " + cas.getName() + ";");
                    }
                }
                if (cas.getFlags() != 0) {
                    sb.append("  electrical " + cas.getName() + ";");
                }
                sb.append("\n");
                this.writeWidthLimited(sb.toString());
                first = false;
            }
            if (flagvdd1 == 0) {
                this.printWriter.println("  input vdd;");
            }
            if (flaggnd1 == 0) {
                this.printWriter.println("  input gnd;");
            }
        }
        first = true;
        Iterator<Topology.CellAggregateSignal> it22 = cni.getCellAggregateSignals();
        while (it22.hasNext()) {
            String portType;
            Topology.CellAggregateSignal cas = it22.next();
            Export pp = cas.getExport();
            if (pp == null) continue;
            if (this.localPrefs.useVerilogA) {
                if (pp.getCharacteristic() == PortCharacteristic.IN || pp.getCharacteristic() == PortCharacteristic.PWR || pp.getCharacteristic() == PortCharacteristic.GND || pp.getCharacteristic() == PortCharacteristic.CLK || pp.getCharacteristic() == PortCharacteristic.C1 || pp.getCharacteristic() == PortCharacteristic.C2 || pp.getCharacteristic() == PortCharacteristic.C3 || pp.getCharacteristic() == PortCharacteristic.C4 || pp.getCharacteristic() == PortCharacteristic.C5 || pp.getCharacteristic() == PortCharacteristic.C6 || pp.getCharacteristic() == PortCharacteristic.UNKNOWN || pp.getCharacteristic() == PortCharacteristic.REFIN || pp.getCharacteristic() == PortCharacteristic.REFBASE) continue;
                portType = "output";
                if (pp.getCharacteristic() == PortCharacteristic.OUT) {
                    portType = "output";
                }
                if (pp.getCharacteristic() == PortCharacteristic.BIDIR) {
                    portType = "inout";
                }
                if (pp.getCharacteristic() == PortCharacteristic.REFOUT) {
                    portType = "refout";
                }
            } else {
                portType = "input";
                if (pp.getCharacteristic() == PortCharacteristic.OUT) {
                    portType = "output";
                }
                if (pp.getCharacteristic() == PortCharacteristic.BIDIR) {
                    portType = "inout";
                }
            }
            sb = new StringBuffer();
            sb.append("  " + portType);
            if (cas.getLowIndex() > cas.getHighIndex()) {
                sb.append(" " + cas.getName() + ";");
            } else {
                int[] indices = cas.getIndices();
                if (indices != null) {
                    for (int i = 0; i < indices.length; ++i) {
                        int ind = i;
                        if (cas.isDescending()) {
                            ind = indices.length - i - 1;
                        }
                        if (i != 0) {
                            sb.append(",");
                        }
                        sb.append(" \\" + cas.getName() + "[" + indices[ind] + "] ");
                    }
                    sb.append(";");
                } else {
                    int low = cas.getLowIndex();
                    int high = cas.getHighIndex();
                    if (cas.isDescending()) {
                        low = cas.getHighIndex();
                        high = cas.getLowIndex();
                    }
                    sb.append(" [" + low + ":" + high + "] " + cas.getName() + ";");
                }
            }
            if (cas.getFlags() != 0) {
                if (this.localPrefs.useVerilogA) {
                    sb.append("  electrical");
                } else if (cas.getFlags() == 1) {
                    sb.append("  wire");
                } else {
                    sb.append("  trireg");
                }
                sb.append(" " + cas.getName() + ";");
            }
            sb.append("\n");
            this.writeWidthLimited(sb.toString());
            first = false;
        }
        int flagvdd2 = 0;
        int flaggnd2 = 0;
        if (this.localPrefs.useVerilogA) {
            Iterator<Topology.CellAggregateSignal> it5 = cni.getCellAggregateSignals();
            while (it5.hasNext()) {
                Topology.CellAggregateSignal cas = it5.next();
                Export pp = cas.getExport();
                if (pp == null) continue;
                String portType = "electrical";
                if (pp.getCharacteristic() == PortCharacteristic.PWR) {
                    ++flagvdd2;
                } else if (pp.getCharacteristic() == PortCharacteristic.GND) {
                    ++flaggnd2;
                }
                StringBuffer sb2 = new StringBuffer();
                sb2.append("  " + portType);
                if (cas.getLowIndex() > cas.getHighIndex()) {
                    sb2.append(" " + cas.getName() + ";");
                } else {
                    int[] indices = cas.getIndices();
                    if (indices != null) {
                        for (int i = 0; i < indices.length; ++i) {
                            int ind = i;
                            if (cas.isDescending()) {
                                ind = indices.length - i - 1;
                            }
                            if (i != 0) {
                                sb2.append(",");
                            }
                            sb2.append(" \\" + cas.getName() + "[" + indices[ind] + "] ");
                        }
                        sb2.append(";");
                    } else {
                        int low = cas.getLowIndex();
                        int high = cas.getHighIndex();
                        if (cas.isDescending()) {
                            low = cas.getHighIndex();
                            high = cas.getLowIndex();
                        }
                        sb2.append(" [" + low + ":" + high + "] " + cas.getName() + ";");
                    }
                }
                if (cas.getFlags() != 0) {
                    if (cas.getFlags() == 1) {
                        sb2.append("  electrical");
                    } else {
                        sb2.append("  electrical");
                    }
                    sb2.append(" " + cas.getName() + ";");
                }
                sb2.append("\n");
                this.writeWidthLimited(sb2.toString());
                first = false;
            }
        }
        if (!first) {
            this.printWriter.println();
        }
        if (this.localPrefs.stopAtStandardCells && SCLibraryGen.isStandardCell(cell)) {
            this.printWriter.println("endmodule   /* " + cellName + " */");
            return;
        }
        if (this.localPrefs.useVerilogA) {
            if (flagvdd2 == 0) {
                this.printWriter.println("  electrical vdd;");
            }
            if (flaggnd2 == 0) {
                this.printWriter.println("  electrical gnd;");
            }
        } else {
            if (cni.getPowerNet() != null) {
                this.printWriter.println("  supply1 vdd;");
            }
            if (cni.getGroundNet() != null) {
                this.printWriter.println("  supply0 gnd;");
            }
        }
        if (this.localPrefs.useVerilogA) {
            wireType = "electrical";
        } else {
            wireType = "wire";
            if (this.localPrefs.useTrireg) {
                wireType = "trireg";
            }
        }
        int localWires = 0;
        for (int wt = 0; wt < 2; ++wt) {
            first = true;
            Iterator<Topology.CellAggregateSignal> it6 = cni.getCellAggregateSignals();
            while (it6.hasNext()) {
                Topology.CellAggregateSignal cas = it6.next();
                if (cas.getExport() != null || cas.isSupply() || cas.getLowIndex() <= cas.getHighIndex() || cas.isGlobal()) continue;
                String impSigName = wireType;
                if (cas.getFlags() != 0) {
                    impSigName = this.localPrefs.useVerilogA ? "electrical" : (cas.getFlags() == 1 ? "wire" : "trireg");
                }
                if (!(wt == 0 ^ !wireType.equals(impSigName))) continue;
                if (first) {
                    this.initDeclaration("  " + impSigName);
                }
                this.addDeclaration(cas.getName());
                ++localWires;
                first = false;
            }
            if (first) continue;
            this.termDeclaration();
        }
        Iterator<Topology.CellAggregateSignal> it7 = cni.getCellAggregateSignals();
        while (it7.hasNext()) {
            Topology.CellAggregateSignal cas = it7.next();
            if (cas.getExport() != null || cas.isSupply() || cas.getLowIndex() > cas.getHighIndex() || cas.isGlobal()) continue;
            int[] indices = cas.getIndices();
            if (indices != null) {
                for (int i = 0; i < indices.length; ++i) {
                    int ind = i;
                    if (cas.isDescending()) {
                        ind = indices.length - i - 1;
                    }
                    this.printWriter.println("  " + wireType + " \\" + cas.getName() + "[" + indices[ind] + "] ;");
                }
            } else if (cas.isDescending()) {
                this.printWriter.println("  " + wireType + " [" + cas.getHighIndex() + ":" + cas.getLowIndex() + "] " + cas.getName() + ";");
            } else {
                this.printWriter.println("  " + wireType + " [" + cas.getLowIndex() + ":" + cas.getHighIndex() + "] " + cas.getName() + ";");
            }
            ++localWires;
        }
        if (localWires != 0) {
            this.printWriter.println();
        }
        if (impInvCount > 0) {
            this.initDeclaration("  " + wireType);
            for (int i = 0; i < impInvCount; ++i) {
                String impsigname = IMPLICITINVERTERSIGNAME + i;
                this.addDeclaration(impsigname);
            }
            this.termDeclaration();
        }
        if (!this.localPrefs.stopAtStandardCells || this.localPrefs.netlistNonstandardCells) {
            first = this.includeTypedCode(cell, VERILOG_DECLARATION_KEY, "declarations");
            if (!(first |= this.includeTypedCode(cell, VERILOG_CODE_KEY, "code"))) {
                String verilogType = this.localPrefs.useVerilogA ? "VerilogA" : "Verilog";
                this.printWriter.println("  /* automatically generated " + verilogType + " */");
            }
        }
        HashMap<Network, List<Export>> instancePortsOnNet = new HashMap<Network, List<Export>>();
        Iterator<Nodable> nIt = netList.getNodables();
        while (nIt.hasNext()) {
            Variable varDefparamTemplate;
            String[] lines2;
            Nodable no = nIt.next();
            NodeProto niProto = no.getProto();
            PrimitiveNode.Function nodeType = PrimitiveNode.Function.UNKNOWN;
            if (!no.isCellInstance()) {
                NodeInst ni = (NodeInst)no;
                Iterator<PortInst> pIt = ni.getPortInsts();
                if (pIt.hasNext()) {
                    boolean allConnected = true;
                    PortInst firstPi = pIt.next();
                    Network firstNet = netList.getNetwork(firstPi);
                    while (pIt.hasNext()) {
                        PortInst pi = pIt.next();
                        Network thisNet = netList.getNetwork(pi);
                        if (thisNet == firstNet) continue;
                        allConnected = false;
                        break;
                    }
                    if (allConnected) continue;
                }
                if ((nodeType = ni.getFunction()).isResistor() || nodeType.isCapacitor() || nodeType == PrimitiveNode.Function.INDUCT || nodeType == PrimitiveNode.Function.DIODE || nodeType == PrimitiveNode.Function.DIODEZ) continue;
            }
            if (no.isCellInstance()) {
                if (this.localPrefs.stopAtStandardCells && !this.localPrefs.netlistNonstandardCells && !this.standardCells.containsStandardCell((Cell)niProto) && !SCLibraryGen.isStandardCell((Cell)niProto)) continue;
                Variable varTemplate = ((Cell)niProto).getVar(VERILOG_TEMPLATE_KEY);
                if (varTemplate != null) {
                    if (varTemplate.getObject() instanceof String[]) {
                        lines2 = (String[])varTemplate.getObject();
                        this.writeWidthLimited("  /* begin Verilog_template for " + no.getProto().describe(false) + "*/\n");
                        for (int i = 0; i < lines2.length; ++i) {
                            this.writeTemplate((Cell)niProto, cell, lines2[i], no, cni, context, knownParameterNames, knownParameterNamesLC);
                        }
                        this.writeWidthLimited("  // end Verilog_template\n");
                        continue;
                    }
                    if (((String)varTemplate.getObject()).equals("//")) continue;
                    this.writeWidthLimited("  /* begin Verilog_template for " + no.getProto().describe(false) + "*/\n");
                    this.writeTemplate((Cell)niProto, cell, (String)varTemplate.getObject(), no, cni, context, knownParameterNames, knownParameterNamesLC);
                    this.writeWidthLimited("  // end Verilog_template\n");
                    continue;
                }
            }
            if (no.isCellInstance() && (varDefparamTemplate = ((Cell)niProto).getVar(VERILOG_DEFPARAM_KEY)) != null) {
                if (varDefparamTemplate.getObject() instanceof String[]) {
                    lines2 = (String[])varDefparamTemplate.getObject();
                    boolean firstDefparam = true;
                    for (int i = 0; i < lines2.length; ++i) {
                        String defparam = new String();
                        defparam = this.writeDefparam(lines2[i], no, context);
                        if (defparam.length() == 0) continue;
                        if (firstDefparam) {
                            this.writeWidthLimited("  /* begin Verilog_defparam for " + no.getProto().describe(false) + " */\n");
                            firstDefparam = false;
                        }
                        this.writeWidthLimited(defparam);
                    }
                    if (!firstDefparam) {
                        this.writeWidthLimited("  // end Verilog_defparam\n");
                    }
                } else if (!((String)varDefparamTemplate.getObject()).equals("//")) {
                    String defparam = new String();
                    defparam = this.writeDefparam((String)varDefparamTemplate.getObject(), no, context);
                    if (defparam.length() != 0) {
                        this.writeWidthLimited("  /* begin Verilog_defparam for " + no.getProto().describe(false) + "*/\n");
                        this.writeWidthLimited(defparam);
                        this.writeWidthLimited("  // end Verilog_defparam\n");
                    }
                }
            }
            if (this.localPrefs.useAssign && (nodeType == PrimitiveNode.Function.GATEAND || nodeType == PrimitiveNode.Function.GATEOR || nodeType == PrimitiveNode.Function.GATEXOR || nodeType == PrimitiveNode.Function.BUFFER)) {
                String op = "";
                if (nodeType == PrimitiveNode.Function.GATEAND) {
                    op = " & ";
                } else if (nodeType == PrimitiveNode.Function.GATEOR) {
                    op = " | ";
                } else if (nodeType == PrimitiveNode.Function.GATEXOR) {
                    op = " ^ ";
                }
                StringBuffer infstr = new StringBuffer();
                boolean wholeNegated = false;
                first = true;
                NodeInst ni = (NodeInst)no;
                block32: for (int i = 0; i < 2; ++i) {
                    Iterator<Connection> cIt = ni.getConnections();
                    while (cIt.hasNext()) {
                        Connection con = cIt.next();
                        PortInst pi = con.getPortInst();
                        if (i == 0 ? !pi.getPortProto().getName().equals("y") : !pi.getPortProto().getName().equals("a")) continue;
                        ArcInst ai = con.getArc();
                        Network net = netList.getNetwork(ai, 0);
                        Topology.CellSignal cs = cni.getCellSignal(net);
                        String sigName = this.getSignalName(cs);
                        boolean isNegated = false;
                        if (ai.isTailNegated() || ai.isHeadNegated()) {
                            isNegated = true;
                        }
                        if (i == 0) {
                            infstr.append("assign " + sigName + " = ");
                            if (!isNegated) continue block32;
                            infstr.append("~(");
                            wholeNegated = true;
                            continue block32;
                        }
                        if (!first) {
                            infstr.append(op);
                        }
                        first = false;
                        if (isNegated) {
                            infstr.append("~");
                        }
                        infstr.append(sigName);
                    }
                }
                if (wholeNegated) {
                    infstr.append(")");
                }
                infstr.append(";\n");
                this.writeWidthLimited(infstr.toString());
                continue;
            }
            int implicitPorts = 0;
            boolean dropBias = false;
            String nodeName = "";
            String trueNodeName = "";
            if (no.isCellInstance()) {
                String alternateSubCellName;
                if (((Cell)niProto).isIcon()) continue;
                nodeName = trueNodeName = this.parameterizedName(no, context);
                NodeInst ni = no.getNodeInst();
                if (ni != null && (alternateSubCellName = this.getIconCellName((Cell)ni.getProto())) != null) {
                    nodeName = alternateSubCellName;
                }
                if (this.definedPrimitivesNew.containsKey(niProto)) {
                    implicitPorts = 3;
                }
            } else {
                Variable varWeakNode;
                PrimitiveNode.Function threePortEquiv = nodeType.make3PortTransistor();
                if (threePortEquiv != null) {
                    nodeType = threePortEquiv;
                    dropBias = true;
                }
                if (nodeType.isNTypeTransistor()) {
                    implicitPorts = 2;
                    nodeName = "tranif1";
                    if (nodeType == PrimitiveNode.Function.TRANMOSCN) {
                        nodeName = "NCNFET";
                    }
                    if ((varWeakNode = ((NodeInst)no).getVar(SimulationTool.WEAK_NODE_KEY)) != null) {
                        nodeName = "rtranif1";
                    }
                } else if (nodeType.isPTypeTransistor()) {
                    implicitPorts = 2;
                    nodeName = "tranif0";
                    if (nodeType == PrimitiveNode.Function.TRAPMOSCN) {
                        nodeName = "PCNFET";
                    }
                    if ((varWeakNode = ((NodeInst)no).getVar(SimulationTool.WEAK_NODE_KEY)) != null) {
                        nodeName = "rtranif0";
                    }
                } else if (nodeType == PrimitiveNode.Function.GATEAND) {
                    implicitPorts = 1;
                    nodeName = this.chooseNodeName((NodeInst)no, "and", "nand");
                } else if (nodeType == PrimitiveNode.Function.GATEOR) {
                    implicitPorts = 1;
                    nodeName = this.chooseNodeName((NodeInst)no, "or", "nor");
                } else if (nodeType == PrimitiveNode.Function.GATEXOR) {
                    implicitPorts = 1;
                    nodeName = this.chooseNodeName((NodeInst)no, "xor", "xnor");
                } else if (nodeType == PrimitiveNode.Function.BUFFER) {
                    implicitPorts = 1;
                    nodeName = this.chooseNodeName((NodeInst)no, "buf", "not");
                }
                trueNodeName = nodeName;
            }
            if (nodeName.length() == 0) continue;
            StringBuffer infstr = new StringBuffer();
            String instName = this.nameNoIndices(no.getName());
            boolean clean = false;
            while (!clean) {
                clean = true;
                Iterator<Topology.CellAggregateSignal> it8 = cni.getCellAggregateSignals();
                while (it8.hasNext()) {
                    Topology.CellAggregateSignal cas = it8.next();
                    if (!cas.getName().equals(instName)) continue;
                    clean = false;
                    break;
                }
                if (clean) continue;
                instName = instName + "_";
            }
            infstr.append("  " + nodeName + " ");
            if (!this.canParameterizeNames()) {
                boolean found = false;
                Iterator<Variable> it9 = no.getDefinedParameters();
                while (it9.hasNext()) {
                    int eqPos;
                    Variable var = it9.next();
                    String eval = var.describe(context, no.getNodeInst());
                    if (eval == null || (eqPos = eval.indexOf("=")) < 0) continue;
                    String varName = eval.substring(0, eqPos);
                    if ((!no.isCellInstance() || this.localPrefs.useBehavioralConstructs || !SCLibraryGen.isStandardCell((Cell)no.getProto())) && !varName.equalsIgnoreCase("delay")) continue;
                    if (!found) {
                        infstr.append("#(");
                    } else {
                        infstr.append(",");
                    }
                    found = true;
                    infstr.append("." + varName + "(" + eval.substring(eqPos + 1) + ")");
                }
                if (found) {
                    infstr.append(") ");
                }
            }
            infstr.append(instName + "(");
            first = true;
            NodeInst ni = null;
            switch (implicitPorts) {
                case 0: {
                    Topology.CellNetInfo subCni = this.getCellNetInfo(trueNodeName);
                    Iterator<Topology.CellAggregateSignal> sIt = subCni.getCellAggregateSignals();
                    while (sIt.hasNext()) {
                        Topology.CellAggregateSignal cas = sIt.next();
                        Export pp = cas.getExport();
                        if (pp == null) continue;
                        if (first) {
                            first = false;
                        } else {
                            infstr.append(", ");
                        }
                        if (cas.getLowIndex() > cas.getHighIndex()) {
                            infstr.append("." + cas.getName() + "(");
                            Network net = netList.getNetwork(no, pp, cas.getExportIndex());
                            Topology.CellSignal cs = cni.getCellSignal(net);
                            infstr.append(this.getSignalName(cs));
                            infstr.append(")");
                            Verilog.accumulatePortConnectivity(instancePortsOnNet, net, pp);
                            continue;
                        }
                        int[] indices = cas.getIndices();
                        if (indices != null) {
                            for (int i = 0; i < indices.length; ++i) {
                                int ind = i;
                                if (cas.isDescending()) {
                                    ind = indices.length - i - 1;
                                }
                                Topology.CellSignal cInnerSig = cas.getSignal(ind);
                                Network net = netList.getNetwork(no, cInnerSig.getExport(), cInnerSig.getExportIndex());
                                Topology.CellSignal outerSignal = cni.getCellSignal(net);
                                Verilog.accumulatePortConnectivity(instancePortsOnNet, net, pp);
                                if (i > 0) {
                                    infstr.append(", ");
                                }
                                infstr.append(".\\" + cas.getName() + "[" + indices[ind] + "] (");
                                infstr.append(this.getSignalName(outerSignal));
                                infstr.append(")");
                            }
                            continue;
                        }
                        int total = cas.getNumSignals();
                        Topology.CellSignal[] outerSignalList = new Topology.CellSignal[total];
                        for (int j = 0; j < total; ++j) {
                            Topology.CellSignal cInnerSig = cas.getSignal(j);
                            Export e = cas.getExport();
                            if (cInnerSig.getExport() != null) {
                                e = cInnerSig.getExport();
                            }
                            int ind = cInnerSig.getExportIndex();
                            Network net = netList.getNetwork(no, e, ind);
                            outerSignalList[j] = cni.getCellSignal(net);
                            Verilog.accumulatePortConnectivity(instancePortsOnNet, net, pp);
                        }
                        this.writeBus(outerSignalList, total, cas.isDescending(), cas.getName(), cni.getPowerNet(), cni.getGroundNet(), infstr);
                    }
                    infstr.append(");");
                    break;
                }
                case 1: {
                    String sigName;
                    ni = (NodeInst)no;
                    for (int i = 0; i < 2; ++i) {
                        Iterator<Connection> cIt = ni.getConnections();
                        while (cIt.hasNext()) {
                            Integer invIndex;
                            Connection con = cIt.next();
                            PortInst pi = con.getPortInst();
                            if (i != 0 ? !pi.getPortProto().getName().equals("a") : !pi.getPortProto().getName().equals("y")) continue;
                            if (first) {
                                first = false;
                            } else {
                                infstr.append(", ");
                            }
                            ArcInst ai = con.getArc();
                            Network net = netList.getNetwork(ai, 0);
                            Topology.CellSignal cs = cni.getCellSignal(net);
                            if (cs == null) continue;
                            sigName = this.getSignalName(cs);
                            if (i != 0 && con.isNegated() && (invIndex = con.getEndIndex() == 1 ? (Integer)implicitHeadInverters.get(ai) : (Integer)implicitTailInverters.get(ai)) != null) {
                                String invSigName = IMPLICITINVERTERSIGNAME + invIndex;
                                this.printWriter.println("  inv Imp" + invIndex + " (" + invSigName + ", " + sigName + ");");
                                sigName = invSigName;
                            }
                            infstr.append(sigName);
                        }
                    }
                    infstr.append(");");
                    break;
                }
                case 2: {
                    String sigName;
                    ni = (NodeInst)no;
                    Network gateNet = netList.getNetwork(ni.getTransistorGatePort());
                    for (int i = 0; i < 2; ++i) {
                        boolean didGate = false;
                        Iterator<PortInst> pIt = ni.getPortInsts();
                        while (pIt.hasNext()) {
                            Topology.CellSignal cs;
                            PortInst pi = pIt.next();
                            Network net = netList.getNetwork(pi);
                            if (dropBias && pi.getPortProto().getName().equals("b") || (cs = cni.getCellSignal(net)) == null) continue;
                            if (i == 0) {
                                if (net == gateNet) {
                                    continue;
                                }
                            } else {
                                if (net != gateNet || didGate) continue;
                                didGate = true;
                            }
                            if (first) {
                                first = false;
                            } else {
                                infstr.append(", ");
                            }
                            sigName = this.getSignalName(cs);
                            infstr.append(sigName);
                        }
                    }
                    if (this.localPrefs.useVerilogA) {
                        if (nodeType.isNTypeTransistor()) {
                            infstr.append(", gnd");
                        }
                        if (nodeType.isPTypeTransistor()) {
                            infstr.append(", vdd");
                        }
                    }
                    infstr.append(");");
                    break;
                }
                case 3: {
                    ni = no.getNodeInst();
                    CompileVerilogStruct.VModule module = this.definedPrimitivesNew.get(niProto);
                    if (module == null) break;
                    System.out.print(cell.getName() + " ports: ");
                    for (CompileVerilogStruct.VExport port : module.getPorts()) {
                        if (port.isBus()) {
                            this.reportError("Error: bussed ports not allowed on Verilog primitives: " + niProto.getName());
                            continue;
                        }
                        String portName = port.getName();
                        PortInst pi = ni.findPortInst(portName);
                        Network net = netList.getNetwork(no, pi.getPortProto().getNameKey().subname(0));
                        Topology.CellSignal cs = cni.getCellSignal(net);
                        String sigName = this.getSignalName(cs);
                        if (first) {
                            first = false;
                        } else {
                            infstr.append(", ");
                        }
                        infstr.append(sigName);
                        System.out.print(portName + " ");
                    }
                    System.out.println();
                    infstr.append(");");
                }
            }
            infstr.append("\n");
            this.writeWidthLimited(infstr.toString());
        }
        this.printWriter.println("endmodule   /* " + cellName + " */");
        Iterator<Export> it10 = cell.getExports();
        while (it10.hasNext()) {
            Export ex = it10.next();
            PortCharacteristic type = ex.getCharacteristic();
            if (type == PortCharacteristic.BIDIR) continue;
            for (int i = 0; i < ex.getNameKey().busWidth(); ++i) {
                Network net = netList.getNetwork(ex, i);
                List subports = (List)instancePortsOnNet.get(net);
                if (subports == null) continue;
                for (Export subex : subports) {
                    PortCharacteristic subtype = subex.getCharacteristic();
                    if (type == subtype) continue;
                    this.reportWarning("Warning: Port Direction Inconsistency in cell " + cell.describe(false) + " between export " + ex.getNameKey().subname(i) + " (" + (Object)((Object)type) + ") and instance port " + subex.getParent().noLibDescribe() + " - " + subex.getName() + " (" + (Object)((Object)subtype) + ")");
                }
            }
        }
    }

    private String getSignalName(Topology.CellSignal cs) {
        Topology.CellAggregateSignal cas = cs.getAggregateSignal();
        if (cas == null) {
            return cs.getName();
        }
        if (cas.getIndices() == null) {
            return cs.getName();
        }
        return " \\" + cs.getName() + " ";
    }

    private String chooseNodeName(NodeInst ni, String positive, String negative) {
        Iterator<Connection> aIt = ni.getConnections();
        while (aIt.hasNext()) {
            Connection con = aIt.next();
            if (!con.isNegated() || !con.getPortInst().getPortProto().getName().equals("y")) continue;
            return negative;
        }
        return positive;
    }

    private void writeTemplate(Cell subCell, Cell cell, String line, Nodable no, Topology.CellNetInfo cni, VarContext context, Set<String> knownParameterNames, Set<String> knownParameterNamesLC) {
        Netlist netList = cni.getNetList();
        StringBuffer infstr = new StringBuffer();
        infstr.append("  ");
        for (int pt = 0; pt < line.length(); ++pt) {
            Iterator<Object> it;
            int startpt;
            char chr = line.charAt(pt);
            if (chr != '$' || pt + 1 >= line.length() || line.charAt(pt + 1) != '(') {
                infstr.append(chr);
                continue;
            }
            for (pt = startpt = pt + 2; pt < line.length() && line.charAt(pt) != ')'; ++pt) {
            }
            String paramName = line.substring(startpt, pt);
            PortProto pp = no.getProto().findPortProto(paramName);
            String nodeName = this.parameterizedName(no, context);
            Topology.CellNetInfo subCni = this.getCellNetInfo(nodeName);
            Topology.CellAggregateSignal cas = null;
            Topology.CellSignal netcs = null;
            if (pp != null) {
                it = subCni.getCellAggregateSignals();
                while (it.hasNext()) {
                    Topology.CellAggregateSignal cas2 = (Topology.CellAggregateSignal)it.next();
                    if (cas2.getExport() == pp) {
                        cas = cas2;
                    } else {
                        if (!netList.sameNetwork(no, pp, no, cas2.getExport())) continue;
                        cas = cas2;
                    }
                    break;
                }
            } else {
                it = no.getProto().getPorts();
                block3: while (it.hasNext()) {
                    PortProto ppcheck = (PortProto)it.next();
                    for (int i = 0; i < ppcheck.getNameKey().busWidth(); ++i) {
                        if (!paramName.equals(ppcheck.getNameKey().subname(i).toString())) continue;
                        Network net = netList.getNetwork(no, ppcheck, i);
                        netcs = cni.getCellSignal(net);
                        continue block3;
                    }
                }
            }
            if (cas != null) {
                if (cas.getLowIndex() > cas.getHighIndex()) {
                    Network net = netList.getNetwork(no, pp, cas.getExportIndex());
                    Topology.CellSignal cs = cni.getCellSignal(net);
                    infstr.append(this.getSignalName(cs));
                    continue;
                }
                int total = cas.getNumSignals();
                Topology.CellSignal[] outerSignalList = new Topology.CellSignal[total];
                for (int j = 0; j < total; ++j) {
                    Topology.CellSignal cInnerSig = cas.getSignal(j);
                    Network net = netList.getNetwork(no, cas.getExport(), cInnerSig.getExportIndex());
                    outerSignalList[j] = cni.getCellSignal(net);
                }
                this.writeBus(outerSignalList, total, cas.isDescending(), null, cni.getPowerNet(), cni.getGroundNet(), infstr);
                continue;
            }
            if (netcs != null) {
                infstr.append(this.getSignalName(netcs));
                continue;
            }
            if (paramName.equalsIgnoreCase("node_name")) {
                infstr.append(this.getSafeNetName(no.getName(), true));
                continue;
            }
            Variable var = null;
            Variable.Key varKey = Variable.findKey("ATTR_" + paramName);
            if (varKey != null) {
                var = no.getParameterOrVariable(varKey);
            }
            if (var == null) {
                infstr.append("??");
                continue;
            }
            String varName = var.getTrueName();
            boolean useValue = true;
            if (this.localPrefs.useBehavioralConstructs) {
                if (knownParameterNames.contains(varName)) {
                    useValue = false;
                }
                if (useValue && knownParameterNamesLC.contains(varName.toLowerCase())) {
                    String trueVarName = null;
                    for (String tvn : knownParameterNames) {
                        if (!tvn.toLowerCase().equals(varName.toLowerCase())) continue;
                        trueVarName = tvn;
                    }
                    System.out.println("WARNING: Template for cell " + subCell.describe(false) + " uses variable '" + varName + "' but calling cell " + cell.describe(false) + " has variable '" + trueVarName + "'");
                }
            }
            if (useValue) {
                infstr.append(context.evalVar(var));
                continue;
            }
            infstr.append(varName);
        }
        infstr.append("\n");
        this.writeWidthLimited(infstr.toString());
    }

    private String writeDefparam(String line, Nodable no, VarContext context) {
        StringBuffer infstr = new StringBuffer();
        infstr.append("  defparam ");
        infstr.append(this.getSafeNetName(no.getName(), true));
        infstr.append(".");
        for (int pt = 0; pt < line.length(); ++pt) {
            int startpt;
            char chr = line.charAt(pt);
            if (chr != '$' || pt + 1 >= line.length() || line.charAt(pt + 1) != '(') {
                infstr.append(chr);
                continue;
            }
            for (pt = startpt = pt + 2; pt < line.length() && line.charAt(pt) != ')'; ++pt) {
            }
            String paramName = line.substring(startpt, pt);
            if (!(no.getProto() instanceof Cell)) {
                this.reportError("Illegal attempt to replace a variable.");
                return "";
            }
            String defaultValue = this.replaceVariable(paramName, (Cell)no.getProto());
            String paramValue = this.replaceVariable(paramName, no, context);
            if (paramValue == "" || paramValue.equals(defaultValue)) {
                return "";
            }
            infstr.append(paramName);
            infstr.append(" = ");
            infstr.append(paramValue);
            infstr.append(";");
        }
        infstr.append("\n");
        return infstr.toString();
    }

    private String replaceVariable(String varName, Nodable no, VarContext context) {
        if (varName.equalsIgnoreCase("node_name")) {
            return this.getSafeNetName(no.getName(), true);
        }
        Variable var = null;
        Variable.Key varKey = Variable.findKey("ATTR_" + varName);
        if (varKey != null && (var = no.getVar(varKey)) == null) {
            var = no.getParameter(varKey);
        }
        if (var == null) {
            return "";
        }
        String val = String.valueOf(context.evalVar(var));
        return this.replaceVarInString(val, no.getParent());
    }

    private String replaceVariable(String varName, Cell cell) {
        if (varName.equalsIgnoreCase("node_name")) {
            return this.getSafeNetName(cell.getName(), true);
        }
        Variable var = null;
        Variable.Key varKey = Variable.findKey("ATTR_" + varName);
        if (varKey != null && (var = cell.getVar(varKey)) == null) {
            var = cell.getParameter(varKey);
        }
        if (var == null) {
            return "";
        }
        CodeExpression.Code code = var.getCode();
        Object value2 = var.getObject();
        if (code == CodeExpression.Code.JAVA || code == CodeExpression.Code.TCL || code == CodeExpression.Code.SPICE) {
            return "";
        }
        return String.valueOf(value2);
    }

    private String replaceVarInString(String line, Cell cell) {
        StringBuffer infstr = new StringBuffer();
        for (int pt = 0; pt < line.length(); ++pt) {
            int startpt;
            char chr = line.charAt(pt);
            if (chr != '$' || pt + 1 >= line.length() || line.charAt(pt + 1) != '(') {
                infstr.append(chr);
                continue;
            }
            for (pt = startpt = pt + 2; pt < line.length() && line.charAt(pt) != ')'; ++pt) {
            }
            String paramName = line.substring(startpt, pt);
            String paramValue = this.replaceVariable(paramName, cell);
            if (paramValue != "") {
                infstr.append(paramValue);
                continue;
            }
            paramValue = BusParameters.replaceBusParameterInt("$(" + paramName + ")");
            if (paramValue != "") {
                infstr.append(paramValue);
                continue;
            }
            infstr.append("$(");
            infstr.append(paramName);
            infstr.append(")");
        }
        return infstr.toString();
    }

    private void writeBus(Topology.CellSignal[] outerSignalList, int total, boolean descending, String name, Network pwrNet, Network gndNet, StringBuffer infstr) {
        Topology.CellSignal cs;
        int j;
        boolean breakBus = false;
        int numExported = 0;
        int numInternal = 0;
        for (j = 0; j < total; ++j) {
            cs = outerSignalList[j];
            Topology.CellAggregateSignal cas = cs.getAggregateSignal();
            if (cas != null && cas.getIndices() != null) {
                breakBus = true;
                break;
            }
            if (cs.isPower() || cs.isGround()) {
                breakBus = true;
                break;
            }
            if (cs.isExported()) {
                ++numExported;
                continue;
            }
            ++numInternal;
        }
        if (numExported > 0 && numInternal > 0) {
            breakBus = true;
        }
        if (!breakBus) {
            for (j = 1; j < total; ++j) {
                Topology.CellSignal oCs;
                int k;
                cs = outerSignalList[j];
                for (k = 0; k < j && cs != (oCs = outerSignalList[k]); ++k) {
                }
                if (k < j) break;
            }
            if (j < total) {
                breakBus = true;
            } else {
                String lastnetname = null;
                for (j = 0; j < total; ++j) {
                    int openSquare;
                    Topology.CellSignal wl = outerSignalList[j];
                    String thisnetname = this.getSignalName(wl);
                    if ((!wl.isDescending() ? descending : !descending) || (openSquare = thisnetname.indexOf(91)) < 0) break;
                    if (j > 0) {
                        int lastIndex;
                        int thisIndex;
                        int li;
                        for (li = 0; li < lastnetname.length() && thisnetname.charAt(li) == lastnetname.charAt(li) && lastnetname.charAt(li) != '['; ++li) {
                        }
                        if (lastnetname.charAt(li) != '[' || thisnetname.charAt(li) != '[' || (thisIndex = TextUtils.atoi(thisnetname.substring(li + 1))) != (lastIndex = TextUtils.atoi(lastnetname.substring(li + 1))) + 1) break;
                    }
                    lastnetname = thisnetname;
                }
                if (j < total) {
                    breakBus = true;
                }
            }
        }
        if (name != null) {
            infstr.append("." + name + "(");
        }
        if (breakBus) {
            infstr.append("{");
            int start = 0;
            int end = total - 1;
            int order = 1;
            if (descending) {
                start = total - 1;
                end = 0;
                order = -1;
            }
            int j2 = start;
            while (true) {
                if (j2 != start) {
                    infstr.append(", ");
                }
                Topology.CellSignal cs2 = outerSignalList[j2];
                infstr.append(this.getSignalName(cs2));
                if (j2 == end) break;
                j2 += order;
            }
            infstr.append("}");
        } else {
            int second;
            int first;
            int i;
            Topology.CellSignal lastCs = outerSignalList[0];
            String lastNetName = this.getSignalName(lastCs);
            int openSquare = lastNetName.indexOf(91);
            Topology.CellSignal cs3 = outerSignalList[total - 1];
            String netName = this.getSignalName(cs3);
            for (i = 0; i < netName.length() && netName.charAt(i) != '['; ++i) {
                infstr.append(netName.charAt(i));
            }
            if (descending) {
                first = TextUtils.atoi(netName.substring(i + 1));
                second = TextUtils.atoi(lastNetName.substring(openSquare + 1));
                infstr.append("[" + first + ":" + second + "]");
            } else {
                first = TextUtils.atoi(netName.substring(i + 1));
                second = TextUtils.atoi(lastNetName.substring(openSquare + 1));
                infstr.append("[" + second + ":" + first + "]");
            }
        }
        if (name != null) {
            infstr.append(")");
        }
    }

    private boolean includeTypedCode(Cell cell, Variable.Key verilogkey, String descript) {
        if (verilogkey == VERILOG_EXTERNAL_CODE_KEY) {
            if (this.externalCodeWritten.contains(cell)) {
                return false;
            }
            this.externalCodeWritten.add(cell);
        }
        boolean first = true;
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            Object obj;
            Variable var;
            NodeInst ni = it.next();
            if (ni.getProto() != Generic.tech().invisiblePinNode || (var = ni.getVar(verilogkey)) == null || !var.isDisplay() || !((obj = var.getObject()) instanceof String) && !(obj instanceof String[])) continue;
            if (first) {
                first = false;
                this.printWriter.println("  /* user-specified Verilog " + descript + " */");
            }
            if (obj instanceof String) {
                String tmp = this.replaceVarInString((String)obj, cell);
                this.printWriter.println("  " + tmp);
                continue;
            }
            String[] stringArray = (String[])obj;
            int len = stringArray.length;
            for (int i = 0; i < len; ++i) {
                String tmp = this.replaceVarInString(stringArray[i], cell);
                this.printWriter.println("  " + tmp);
            }
        }
        if (!first) {
            this.printWriter.println();
        }
        return first;
    }

    private void initDeclaration(String header) {
        this.sim_verDeclarationLine = new StringBuffer();
        this.sim_verDeclarationLine.append(header);
        this.sim_verdeclarationprefix = header.length();
    }

    private void addDeclaration(String signame) {
        if (this.sim_verDeclarationLine.length() + signame.length() + 3 > 80) {
            this.printWriter.println(this.sim_verDeclarationLine.toString() + ";");
            this.sim_verDeclarationLine.delete(this.sim_verdeclarationprefix, this.sim_verDeclarationLine.length());
        }
        if (this.sim_verDeclarationLine.length() != this.sim_verdeclarationprefix) {
            this.sim_verDeclarationLine.append(",");
        }
        this.sim_verDeclarationLine.append(" " + signame);
    }

    private void termDeclaration() {
        this.printWriter.println(this.sim_verDeclarationLine.toString() + ";");
    }

    private String nameNoIndices(String p) {
        StringBuffer sb = new StringBuffer();
        if (TextUtils.isDigit(p.charAt(0))) {
            sb.append('_');
        }
        for (int i = 0; i < p.length(); ++i) {
            int chr = p.charAt(i);
            if (!TextUtils.isLetterOrDigit((char)chr) && chr != 95 && chr != 36) {
                chr = 95;
            }
            sb.append((char)chr);
        }
        return sb.toString();
    }

    @Override
    protected String getSafeCellName(String name) {
        String n = this.getSafeNetName(name, false);
        return n.replaceAll("[\\[\\]]", "_");
    }

    @Override
    protected String getPowerName(Network net) {
        return "vdd";
    }

    @Override
    protected String getGroundName(Network net) {
        return "gnd";
    }

    @Override
    protected String getGlobalName(Global glob) {
        return "glbl." + glob.getName();
    }

    @Override
    protected boolean isNetworksUseExportedNames() {
        return true;
    }

    @Override
    protected boolean isLibraryNameAlwaysAddedToCellName() {
        return true;
    }

    @Override
    protected boolean isAggregateNamesSupported() {
        return true;
    }

    @Override
    protected boolean isAggregateNameGapsSupported() {
        return true;
    }

    @Override
    protected boolean isSeparateInputAndOutput() {
        return true;
    }

    @Override
    protected boolean isCaseSensitive() {
        return true;
    }

    @Override
    protected String getSafeNetName(String name, boolean bus) {
        boolean allAlnum = true;
        int len = name.length();
        if (len == 0) {
            return name;
        }
        int openSquareCount = 0;
        int openSquarePos = 0;
        for (int i = 0; i < len; ++i) {
            char chr = name.charAt(i);
            if (chr == '[') {
                ++openSquareCount;
                openSquarePos = i;
            }
            if (!TextUtils.isLetterOrDigit(chr)) {
                allAlnum = false;
            }
            if (i != 0 || !TextUtils.isDigit(chr)) continue;
            allAlnum = false;
        }
        if (!allAlnum || !Character.isLetter(name.charAt(0))) {
            if (!(openSquareCount != 1 || openSquarePos + 1 < name.length() && Character.isDigit(name.charAt(openSquarePos + 1)))) {
                openSquareCount = 0;
            }
            if (bus) {
                openSquareCount = 0;
            }
            StringBuffer sb = new StringBuffer();
            for (int t = 0; t < name.length(); ++t) {
                char chr = name.charAt(t);
                if (chr == '[' || chr == ']') {
                    if (openSquareCount == 1) {
                        sb.append(chr);
                        continue;
                    }
                    sb.append('_');
                    continue;
                }
                if (t == 0 && TextUtils.isDigit(chr)) {
                    sb.append('_');
                }
                if (TextUtils.isLetterOrDigit(chr) || chr == '$') {
                    sb.append(chr);
                    continue;
                }
                sb.append('_');
            }
            name = sb.toString();
        }
        if (this.reservedWords.contains(name)) {
            name = "_" + name;
        }
        return name;
    }

    @Override
    protected Netlist.ShortResistors getShortResistors() {
        return Netlist.ShortResistors.PARASITIC;
    }

    @Override
    protected boolean canParameterizeNames() {
        if (this.localPrefs.stopAtStandardCells && !this.localPrefs.netlistNonstandardCells) {
            return false;
        }
        return this.localPrefs.parameterizeModuleNames;
    }

    private boolean checkIncludedData(CompileVerilogStruct data2, Cell cell, String includeFile) {
        List<CompileVerilogStruct.VModule> modules = data2.getModules();
        CompileVerilogStruct.VModule main2 = null;
        CompileVerilogStruct.VModule alternative = null;
        for (CompileVerilogStruct.VModule mod : modules) {
            if (mod.getName().equals(this.getVerilogName(cell))) {
                main2 = mod;
                continue;
            }
            Cell.CellGroup grp = cell.getCellGroup();
            if (grp == null || !mod.getName().equals(grp.getName())) continue;
            alternative = mod;
        }
        if (main2 == null) {
            main2 = alternative;
        }
        if (main2 == null) {
            this.reportError("Error! Expected Verilog module definition '" + this.getVerilogName(cell) + " in Verilog View: " + cell.libDescribe());
            return false;
        }
        if (main2.isPrimitive()) {
            this.definedPrimitivesNew.put(cell, main2);
        }
        String source = includeFile == null ? "Verilog View for " + cell.libDescribe() : "Include file: " + includeFile;
        for (CompileVerilogStruct.VModule mod : modules) {
            String prevSource = this.definedModules.get(mod.getName());
            if (mod.getCell() == null) continue;
            if (prevSource != null) {
                this.reportError("Error, module " + mod.getName() + " already defined from: " + prevSource);
                continue;
            }
            this.definedModules.put(mod.getName(), source);
        }
        for (CompileVerilogStruct.VModule mod : modules) {
            for (CompileVerilogStruct.VInstance inst : mod.getInstances()) {
                String moduleName;
                String found;
                CompileVerilogStruct.VModule instMod = inst.getModule();
                if (instMod.getCell() != null) continue;
                boolean primitiveGate = false;
                for (String s : verilogGates) {
                    if (!s.equals(instMod.getName().toLowerCase())) continue;
                    primitiveGate = true;
                    break;
                }
                if (primitiveGate || (found = this.definedModules.get(moduleName = instMod.getName())) != null || includeFile != null) continue;
                Cell missingCell = Verilog.findCell(moduleName, View.VERILOG);
                if (missingCell == null) {
                    this.reportError("Error: Undefined reference to module " + moduleName + ", and no matching cell found");
                    continue;
                }
                System.out.println("Info: Netlisting cell " + missingCell.libDescribe() + " as instanced in: " + source);
                HierarchyEnumerator.enumerateCell(missingCell, VarContext.globalContext, (HierarchyEnumerator.Visitor)new Topology.Visitor(this), this.getShortResistors());
            }
        }
        return true;
    }

    private String getVerilogName(Cell cell) {
        String uniqueCellName = this.getUniqueCellName(cell);
        if (uniqueCellName != null) {
            return uniqueCellName;
        }
        String safeCellName = this.getSafeCellName(cell.getName());
        if (!safeCellName.startsWith("_")) {
            safeCellName = "__" + safeCellName;
        }
        return cell.getLibrary().getName() + safeCellName;
    }

    public static Cell findCell(String verilogName, View preferredView) {
        Cell preferred;
        Cell cell = null;
        String[] parts = verilogName.split("__");
        if (parts.length == 2) {
            Library lib = Library.findLibrary(parts[0]);
            if (lib == null) {
                System.out.println("Cannot find library " + parts[0] + " for Verilog-style module name: " + verilogName);
                return null;
            }
            if (preferredView == null) {
                preferredView = View.SCHEMATIC;
            }
            if ((cell = lib.findNodeProto(parts[1])) == null) {
                System.out.println("Cannot find Cell " + parts[1] + " in Library " + parts[0] + " for Verilog-style module name: " + verilogName);
                return null;
            }
        } else {
            cell = Library.findCellInLibraries(verilogName, View.SCHEMATIC, null);
            if (cell == null) {
                System.out.println("Cannot find Cell '" + verilogName + "' for Verilog-style module name: " + verilogName);
                return null;
            }
        }
        if ((preferred = cell.otherView(preferredView)) != null) {
            return preferred;
        }
        preferred = cell.getCellGroup().getMainSchematics();
        if (preferred != null) {
            return preferred;
        }
        return cell;
    }

    private static void accumulatePortConnectivity(Map<Network, List<Export>> instancePortsOnNet, Network net, Export ex) {
        List<Export> list2 = instancePortsOnNet.get(net);
        if (list2 == null) {
            list2 = new ArrayList<Export>();
            instancePortsOnNet.put(net, list2);
        }
        if (!list2.contains(ex)) {
            list2.add(ex);
        }
    }

    public static class VerilogPreferences
    extends Output.OutputPreferences {
        public boolean useTrireg = SimulationTool.getVerilogUseTrireg();
        public boolean useAssign = SimulationTool.getVerilogUseAssign();
        public boolean useVerilogA = false;
        public boolean useBehavioralConstructs = false;
        public boolean stopAtStandardCells = SimulationTool.getFactoryVerilogStopAtStandardCells();
        public boolean netlistNonstandardCells = SimulationTool.getFactoryVerilogNetlistNonstandardCells();
        public boolean parameterizeModuleNames = SimulationTool.getFactoryVerilogParameterizeModuleNames();
        public boolean writeModuleForEachIcon = SimulationTool.isFactoryVerilogWriteModuleForEachIcon();
        public Map<Cell, String> modelFiles = Collections.emptyMap();
        public VerilogReader.VerilogPreferences inputPrefs;

        public VerilogPreferences(boolean useVerilogA) {
            this(false, useVerilogA);
        }

        public VerilogPreferences(boolean factory, boolean useVerilogA) {
            super(factory);
            this.inputPrefs = new VerilogReader.VerilogPreferences(factory);
            this.useVerilogA = useVerilogA;
            if (!factory) {
                this.fillPrefs();
            }
        }

        private void fillPrefs() {
            this.stopAtStandardCells = SimulationTool.getVerilogStopAtStandardCells();
            this.netlistNonstandardCells = SimulationTool.getVerilogNetlistNonstandardCells();
            this.parameterizeModuleNames = SimulationTool.getVerilogParameterizeModuleNames();
            this.writeModuleForEachIcon = SimulationTool.isVerilogWriteModuleForEachIcon();
            this.modelFiles = CellModelPrefs.verilogModelPrefs.getUnfilteredFileNames(EDatabase.clientDatabase());
        }

        @Override
        public Output doOutput(Cell cell, VarContext context, String filePath) {
            Verilog out = new Verilog(this);
            if (out.openTextOutputStream(filePath)) {
                return out.finishWrite();
            }
            out.filePath = filePath;
            if (out.writeCell(cell, context)) {
                return out.finishWrite();
            }
            if (out.closeTextOutputStream()) {
                return out.finishWrite();
            }
            System.out.println(filePath + " written");
            return out.finishWrite();
        }
    }
}

