/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.forceDirected2.forceDirected.staged;

import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.forceDirected2.AdditionalNodeData;
import com.sun.electric.tool.placement.forceDirected2.PlacementForceDirectedStaged;
import com.sun.electric.tool.placement.forceDirected2.forceDirected.SpringForce;
import com.sun.electric.tool.placement.forceDirected2.forceDirected.staged.PlacementDTO;
import com.sun.electric.tool.placement.forceDirected2.forceDirected.util.CheckboardingField;
import com.sun.electric.tool.placement.forceDirected2.forceDirected.util.Force2D;
import com.sun.electric.tool.placement.forceDirected2.utils.concurrent.EmptyException;
import com.sun.electric.tool.placement.forceDirected2.utils.concurrent.StageWorker;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalculateForcesStageWorker
extends StageWorker {
    protected Map<PlacementFrame.PlacementNode, Map<PlacementFrame.PlacementNode, GenMath.MutableInteger>> connectivityMap;
    protected List<PlacementFrame.PlacementNetwork> allNetworks;

    public CalculateForcesStageWorker(Map<PlacementFrame.PlacementNode, Map<PlacementFrame.PlacementNode, GenMath.MutableInteger>> connectivity, List<PlacementFrame.PlacementNetwork> allNetworks) {
        this.connectivityMap = connectivity;
        this.allNetworks = allNetworks;
    }

    private Force2D calculateForces(PlacementFrame.PlacementNode node) {
        Force2D result = new Force2D();
        boolean newList = false;
        AdditionalNodeData data = PlacementForceDirectedStaged.getNodeData().get(node);
        if (data.getNetworks() == null) {
            data.setNetworks(new HashMap<PlacementFrame.PlacementNetwork, PlacementFrame.PlacementPort>());
            newList = true;
        }
        if (newList) {
            for (PlacementFrame.PlacementNetwork network : this.allNetworks) {
                for (PlacementFrame.PlacementPort port : network.getPortsOnNet()) {
                    if (!node.equals(port.getPlacementNode()) || !newList) continue;
                    data.getNetworks().put(network, port);
                }
            }
        }
        result = new Force2D();
        for (PlacementFrame.PlacementNetwork network : data.getNetworks().keySet()) {
            for (PlacementFrame.PlacementPort port : network.getPortsOnNet()) {
                if (node == port.getPlacementNode()) continue;
                result = result.add(SpringForce.calculate(data.getNetworks().get(network), port, 1.0, 0.0));
            }
        }
        return result;
    }

    @Override
    public void run() {
        while (!this.abort.booleanValue()) {
            try {
                PlacementDTO data = this.stage.getInput(this).get();
                List<CheckboardingField> fields = data.getFieldsList();
                if (fields != null) {
                    for (CheckboardingField field : fields) {
                        if (field == null || field.getNode() == null) continue;
                        Force2D force = this.calculateForces(field.getNode());
                        data.getForces().put(field.getNode(), force);
                    }
                }
                this.stage.sendToNextStage(data);
            }
            catch (EmptyException ex) {
                Thread.yield();
            }
        }
    }
}

