/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.plugins.j3d.utils;

import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.plugins.j3d.utils.J3DUtils;
import com.sun.electric.technology.Layer;
import com.sun.electric.tool.user.User;
import java.awt.Color;
import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Material;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Tuple3f;

public class J3DAppearance
extends Appearance {
    private final Layer layer;
    public static J3DAppearance cellApp;
    public static J3DAppearance highlightApp;
    public static J3DAppearance[] axisApps;
    static final /* synthetic */ boolean $assertionsDisabled;

    public J3DAppearance(Layer layer, boolean visible) {
        this.layer = layer;
        EGraphics graphics = layer.getGraphics();
        this.setOtherAppearanceValues(graphics.getTransparencyMode().mode, (float)graphics.getTransparencyFactor(), graphics.getColor(), visible);
    }

    private J3DAppearance(int mode, float factor, Color color) {
        this.layer = null;
        this.setOtherAppearanceValues(mode, factor, color, true);
    }

    public Layer getLayer() {
        return this.layer;
    }

    public void setGraphics(EGraphics graphics) {
        EGraphics.J3DTransparencyOption op = graphics.getTransparencyMode();
        TransparencyAttributes ta = this.getTransparencyAttributes();
        ta.setTransparency((float)graphics.getTransparencyFactor());
        ta.setTransparencyMode(op.mode);
        this.setTransparencyAndRenderingAttributes(ta, op != EGraphics.J3DTransparencyOption.NONE);
        this.set3DColor(null, graphics.getColor());
    }

    private void setOtherAppearanceValues(int mode, float factor, Color color, boolean visible) {
        TransparencyAttributes ta = new TransparencyAttributes(mode, factor);
        ta.setCapability(2);
        ta.setCapability(3);
        ta.setCapability(0);
        ta.setCapability(1);
        this.setTransparencyAttributes(ta);
        this.setCapability(10);
        this.setCapability(11);
        this.setCapability(0);
        this.setCapability(1);
        this.setCapability(12);
        this.setCapability(13);
        this.setCapability(8);
        this.setCapability(9);
        if (this.layer != null) {
            RenderingAttributes ra = new RenderingAttributes();
            ra.setCapability(5);
            ra.setCapability(6);
            ra.setCapability(4);
            ra.setCapability(11);
            ra.setVisible(visible);
            this.setRenderingAttributes(ra);
            if (mode != 4) {
                ra.setDepthBufferEnable(true);
            }
        }
        if (color != null) {
            Color3f objColor = new Color3f(color);
            Material mat = new Material(objColor, J3DUtils.black, objColor, J3DUtils.plastic, 17.0f);
            mat.setLightingEnable(true);
            mat.setCapability(0);
            mat.setCapability(1);
            mat.setCapability(4);
            this.setMaterial(mat);
        }
    }

    public static void setCellVisibility(boolean value) {
        if (!$assertionsDisabled && cellApp == null) {
            throw new AssertionError();
        }
        cellApp.getRenderingAttributes().setVisible(value);
    }

    public static void setAxesVisibility(boolean value) {
        for (int i = 0; i < axisApps.length; ++i) {
            axisApps[i].getRenderingAttributes().setVisible(value);
        }
    }

    public void setTransparencyAndRenderingAttributes(TransparencyAttributes transparencyAttributes, boolean rendering) {
        super.setTransparencyAttributes(transparencyAttributes);
        super.getRenderingAttributes().setDepthBufferEnable(rendering);
    }

    public void set3DVisibility(boolean visible) {
        if (this.getRenderingAttributes() == null) {
            System.out.println("Error in J3DAppearance.set3DVisibility");
        } else {
            this.getRenderingAttributes().setVisible(visible);
        }
    }

    public void set3DColor(Object material, Color color) {
        Material mat = material == null ? this.getMaterial() : (Material)material;
        Color3f objColor = new Color3f(color);
        mat.setDiffuseColor(objColor);
        mat.setAmbientColor(objColor);
        if (this.getColoringAttributes() != null) {
            this.getColoringAttributes().setColor(objColor);
        }
    }

    public static void setAxisAppearanceValues(Object initValue) {
        int[] colors = J3DUtils.get3DColorAxes();
        for (int i = 0; i < axisApps.length; ++i) {
            Color userColor = new Color(colors[i]);
            if (axisApps[i] == null) {
                J3DAppearance.axisApps[i] = new J3DAppearance(4, 0.5f, userColor);
                PolygonAttributes polygonAttributes = new PolygonAttributes();
                polygonAttributes.setCullFace(0);
                LineAttributes lineAttributes = new LineAttributes();
                lineAttributes.setLineWidth(3.0f);
                ColoringAttributes colorAttrib = new ColoringAttributes();
                colorAttrib.setColor(new Color3f(userColor));
                colorAttrib.setCapability(0);
                colorAttrib.setCapability(1);
                axisApps[i].setColoringAttributes(colorAttrib);
                axisApps[i].setPolygonAttributes(polygonAttributes);
                axisApps[i].setLineAttributes(lineAttributes);
                axisApps[i].setCapability(8);
                axisApps[i].setCapability(9);
                RenderingAttributes ra = new RenderingAttributes();
                ra.setCapability(5);
                ra.setCapability(6);
                ra.setVisible(J3DUtils.is3DAxesOn());
                axisApps[i].setRenderingAttributes(ra);
                continue;
            }
            if (initValue != null) continue;
            axisApps[i].set3DColor(null, userColor);
        }
    }

    public static void setHighlightedAppearanceValues(Object initValue) {
        Color userColor = new Color(User.getColor(User.ColorPrefType.HIGHLIGHT_3D));
        if (highlightApp == null) {
            highlightApp = new J3DAppearance(2, 0.5f, userColor);
        } else if (initValue == null) {
            highlightApp.set3DColor(null, userColor);
        }
    }

    public static void setCellAppearanceValues(Object initValue) {
        Color3f userColor = new Color3f(new Color(User.getColor(User.ColorPrefType.INSTANCE_3D)));
        if (cellApp == null) {
            cellApp = new J3DAppearance(3, 0.0f, null);
            RenderingAttributes ra = new RenderingAttributes();
            ra.setCapability(5);
            ra.setCapability(6);
            ra.setVisible(J3DUtils.is3DCellBndOn());
            cellApp.setRenderingAttributes(ra);
            PolygonAttributes pa = new PolygonAttributes();
            pa.setCullFace(0);
            pa.setPolygonMode(1);
            cellApp.setPolygonAttributes(pa);
            LineAttributes lineAttr = new LineAttributes();
            lineAttr.setLineAntialiasingEnable(true);
            cellApp.setLineAttributes(lineAttr);
            ColoringAttributes ca = new ColoringAttributes();
            ca.setCapability(1);
            ca.setCapability(0);
            ca.setColor(userColor);
            cellApp.setColoringAttributes(ca);
            cellApp.setCapability(8);
            cellApp.setCapability(9);
        } else if (initValue == null) {
            ColoringAttributes ca = cellApp.getColoringAttributes();
            Color3f curColor = new Color3f();
            ca.getColor(curColor);
            if (!userColor.equals((Tuple3f)curColor)) {
                ca.setColor(userColor);
            }
        }
    }

    static {
        boolean bl = $assertionsDisabled = !J3DAppearance.class.desiredAssertionStatus();
        if (!$assertionsDisabled && EGraphics.J3DTransparencyOption.FASTEST.mode != 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && EGraphics.J3DTransparencyOption.NICEST.mode != 1) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && EGraphics.J3DTransparencyOption.BLENDED.mode != 2) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && EGraphics.J3DTransparencyOption.SCREEN_DOOR.mode != 3) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && EGraphics.J3DTransparencyOption.NONE.mode != 4) {
            throw new AssertionError();
        }
        axisApps = new J3DAppearance[3];
    }
}

