/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortOriginal;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.tool.user.User;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;

public class LEF
extends Output {
    private Layer io_lefoutcurlayer;
    private HashSet<NodeInst> nodesSeen;
    private HashSet<ArcInst> arcsSeen;

    public static void writeLEFFile(Cell cell, VarContext context, String filePath) {
        LEF out = new LEF();
        if (out.openTextOutputStream(filePath)) {
            return;
        }
        Netlist netlist = cell.getNetlist(Netlist.ShortResistors.ALL);
        out.init(netlist);
        HierarchyEnumerator.enumerateCell(netlist, context, (HierarchyEnumerator.Visitor)new Visitor(out));
        out.term(cell);
        if (out.closeTextOutputStream()) {
            return;
        }
        System.out.println(filePath + " written");
    }

    LEF() {
    }

    private void init(Netlist netList) {
        int i;
        if (User.isIncludeDateAndVersionInOutput()) {
            this.printWriter.println("# Electric VLSI Design System, version " + Version.getVersion());
            this.printWriter.println("# " + TextUtils.formatDate(new Date()));
        } else {
            this.printWriter.println("# Electric VLSI Design System");
        }
        this.emitCopyright("# ", "");
        this.printWriter.println("");
        this.printWriter.println("NAMESCASESENSITIVE ON ;");
        this.printWriter.println("UNITS");
        this.printWriter.println("  DATABASE MICRONS 1 ;");
        this.printWriter.println("END UNITS");
        this.printWriter.println("");
        for (i = 0; i < 8; ++i) {
            this.printWriter.println("LAYER METAL" + (i + 1));
            this.printWriter.println("  TYPE ROUTING ;");
            this.printWriter.println("END METAL" + (i + 1));
            this.printWriter.println("");
        }
        this.printWriter.println("LAYER CONT");
        this.printWriter.println("  TYPE CUT ;");
        this.printWriter.println("END CONT");
        this.printWriter.println("");
        for (i = 0; i < 3; ++i) {
            this.printWriter.println("LAYER VIA" + (i + 1) + (i + 2));
            this.printWriter.println("  TYPE CUT ;");
            this.printWriter.println("END VIA: " + (i + 1) + (i + 2));
            this.printWriter.println("");
        }
        for (i = 0; i < 3; ++i) {
            this.printWriter.println("LAYER POLY" + (i + 1));
            this.printWriter.println("  TYPE MASTERSLICE ;");
            this.printWriter.println("END POLY" + (i + 1));
            this.printWriter.println("");
        }
        this.printWriter.println("LAYER PDIFF");
        this.printWriter.println("  TYPE MASTERSLICE ;");
        this.printWriter.println("END PDIFF");
        this.printWriter.println("");
        this.printWriter.println("LAYER NDIFF");
        this.printWriter.println("  TYPE MASTERSLICE ;");
        this.printWriter.println("END NDIFF");
        this.printWriter.println("");
        Cell cell = netList.getCell();
        this.printWriter.println("MACRO " + cell.getName());
        this.printWriter.println("  FOREIGN " + cell.getName() + " ;");
        ERectangle bounds = cell.getBounds();
        double width = TextUtils.convertDistance(((RectangularShape)bounds).getWidth(), cell.getTechnology(), TextUtils.UnitScale.MICRO);
        double height = TextUtils.convertDistance(((RectangularShape)bounds).getHeight(), cell.getTechnology(), TextUtils.UnitScale.MICRO);
        this.printWriter.println("  SIZE " + TextUtils.formatDouble(width) + " BY " + TextUtils.formatDouble(height) + " ;");
        this.printWriter.println("  SITE " + cell.getName() + " ;");
        this.nodesSeen = new HashSet();
        this.arcsSeen = new HashSet();
        boolean first = true;
        Iterator<PortProto> it = cell.getPorts();
        while (it.hasNext()) {
            PrimitiveNode np;
            Technology.NodeLayer[] nls;
            Export e = (Export)it.next();
            if (first) {
                first = false;
            } else {
                this.printWriter.println("");
            }
            this.printWriter.println("  PIN " + e.getName());
            PortOriginal fp = new PortOriginal(e.getOriginalPort());
            NodeInst rni = fp.getBottomNodeInst();
            PrimitivePort rpp = fp.getBottomPortProto();
            AffineTransform trans = fp.getTransformToTop();
            this.printWriter.println("    PORT");
            this.io_lefoutcurlayer = null;
            Technology tech = rni.getProto().getTechnology();
            Poly[] polys = tech.getShapeOfNode(rni, true, false, null);
            if (polys.length == 0 && (nls = (np = (PrimitiveNode)rni.getProto()).getLayers()).length > 0) {
                polys = new Poly[]{new Poly(rni.getAnchorCenterX(), rni.getAnchorCenterY(), rni.getXSize(), rni.getYSize())};
                polys[0].setLayer(nls[0].getLayer().getNonPseudoLayer());
                polys[0].setPort(rpp);
            }
            for (int i2 = 0; i2 < polys.length; ++i2) {
                Poly poly = polys[i2];
                if (poly.getPort() != rpp) continue;
                this.io_lefwritepoly(poly, trans, tech);
            }
            Network net = netList.getNetwork(e, 0);
            this.io_lefoutspread(cell, net, e.getOriginalPort().getNodeInst(), netList);
            this.printWriter.println("    END");
            if (e.getCharacteristic() == PortCharacteristic.PWR) {
                this.printWriter.println("    USE POWER ;");
            }
            if (e.getCharacteristic() == PortCharacteristic.GND) {
                this.printWriter.println("    USE GROUND ;");
            }
            this.printWriter.println("  END " + e.getName());
        }
        this.printWriter.println("");
        this.printWriter.println("  OBS");
        this.io_lefoutcurlayer = null;
    }

    private void term(Cell cell) {
        this.printWriter.println("  END");
        this.printWriter.println("");
        this.printWriter.println("END " + cell.getName());
        this.printWriter.println("");
        this.printWriter.println("END LIBRARY");
    }

    private void writeCellContents(HierarchyEnumerator.CellInfo info) {
        Cell cell = info.getCell();
        AffineTransform trans = info.getTransformToRoot();
        Iterator<Geometric> it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            if (ni.isCellInstance() || info.isRootCell() && this.nodesSeen.contains(ni)) continue;
            AffineTransform rot = ni.rotateOut(trans);
            Technology tech = ni.getProto().getTechnology();
            Poly[] polys = tech.getShapeOfNode(ni);
            for (int i = 0; i < polys.length; ++i) {
                Poly poly = polys[i];
                this.io_lefwritepoly(poly, rot, tech);
            }
        }
        it = cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            if (info.isRootCell() && this.arcsSeen.contains(ai)) continue;
            Technology tech = ai.getProto().getTechnology();
            Poly[] polys = tech.getShapeOfArc(ai);
            for (int i = 0; i < polys.length; ++i) {
                Poly poly = polys[i];
                this.io_lefwritepoly(poly, trans, tech);
            }
        }
    }

    void io_lefoutspread(Cell cell, Network net, NodeInst ignore, Netlist netList) {
        Iterator<Geometric> it = cell.getNodes();
        while (it.hasNext()) {
            PrimitiveNode.Function fun;
            NodeInst ni = it.next();
            if (ni.isCellInstance() || ni == ignore || (fun = ni.getFunction()) != PrimitiveNode.Function.PIN && fun != PrimitiveNode.Function.CONTACT && fun != PrimitiveNode.Function.NODE && fun != PrimitiveNode.Function.WELL && fun != PrimitiveNode.Function.SUBSTRATE && fun != PrimitiveNode.Function.CONNECT) continue;
            boolean found = true;
            Iterator<PortInst> pIt = ni.getPortInsts();
            while (pIt.hasNext()) {
                PortInst pi = pIt.next();
                Network pNet = netList.getNetwork(pi);
                if (pNet == net) continue;
                found = false;
                break;
            }
            if (!found) continue;
            this.nodesSeen.add(ni);
            AffineTransform trans = ni.rotateOut();
            Technology tech = ni.getProto().getTechnology();
            Poly[] polys = tech.getShapeOfNode(ni);
            for (int i = 0; i < polys.length; ++i) {
                Poly poly = polys[i];
                this.io_lefwritepoly(poly, trans, tech);
            }
        }
        it = cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            Network aNet = netList.getNetwork(ai, 0);
            if (aNet != net) continue;
            this.arcsSeen.add(ai);
            Technology tech = ai.getProto().getTechnology();
            Poly[] polys = tech.getShapeOfArc(ai);
            for (int i = 0; i < polys.length; ++i) {
                Poly poly = polys[i];
                this.io_lefwritepoly(poly, GenMath.MATID, tech);
            }
        }
    }

    private void io_lefwritepoly(Poly poly, AffineTransform trans, Technology tech) {
        Layer layer = poly.getLayer();
        if (layer == null) {
            return;
        }
        String layername = this.io_lefoutlayername(layer);
        if (layername.length() == 0) {
            return;
        }
        poly.transform(trans);
        Rectangle2D polyBounds = poly.getBox();
        if (polyBounds == null) {
            return;
        }
        double flx = TextUtils.convertDistance(polyBounds.getMinX(), tech, TextUtils.UnitScale.MICRO);
        double fly = TextUtils.convertDistance(polyBounds.getMinY(), tech, TextUtils.UnitScale.MICRO);
        double fhx = TextUtils.convertDistance(polyBounds.getMaxX(), tech, TextUtils.UnitScale.MICRO);
        double fhy = TextUtils.convertDistance(polyBounds.getMaxY(), tech, TextUtils.UnitScale.MICRO);
        if (layer != this.io_lefoutcurlayer) {
            this.printWriter.println("    LAYER " + layername + " ;");
            this.io_lefoutcurlayer = layer;
        }
        this.printWriter.println("    RECT " + TextUtils.formatDouble(flx) + " " + TextUtils.formatDouble(fly) + " " + TextUtils.formatDouble(fhx) + " " + TextUtils.formatDouble(fhy) + " ;");
    }

    private String io_lefoutlayername(Layer layer) {
        Layer.Function fun = (layer = layer.getNonPseudoLayer()).getFunction();
        if (fun.isMetal()) {
            return "METAL" + fun.getLevel();
        }
        if (fun == Layer.Function.GATE) {
            return "POLY1";
        }
        if (fun.isPoly()) {
            return "POLY" + fun.getLevel();
        }
        if (fun == Layer.Function.CONTACT1) {
            return "CONT";
        }
        if (fun == Layer.Function.CONTACT2) {
            return "VIA12";
        }
        if (fun == Layer.Function.CONTACT3) {
            return "VIA23";
        }
        if (fun == Layer.Function.CONTACT4) {
            return "VIA34";
        }
        if (fun == Layer.Function.CONTACT5) {
            return "VIA45";
        }
        if (fun == Layer.Function.CONTACT6) {
            return "VIA56";
        }
        if (fun == Layer.Function.CONTACT7) {
            return "VIA67";
        }
        if (fun == Layer.Function.CONTACT8) {
            return "VIA78";
        }
        if (fun == Layer.Function.CONTACT9) {
            return "VIA89";
        }
        if (fun == Layer.Function.CONTACT10) {
            return "VIA9";
        }
        if (fun == Layer.Function.CONTACT11) {
            return "VIA10";
        }
        if (fun == Layer.Function.CONTACT12) {
            return "VIA11";
        }
        if (fun == Layer.Function.DIFFN) {
            return "NDIFF";
        }
        if (fun == Layer.Function.DIFFP) {
            return "PDIFF";
        }
        if (fun == Layer.Function.DIFF) {
            return "DIFF";
        }
        return "";
    }

    private static class Visitor
    extends HierarchyEnumerator.Visitor {
        private LEF generator;

        public Visitor(LEF generator) {
            this.generator = generator;
        }

        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            this.generator.writeCellContents(info);
            return true;
        }

        public void exitCell(HierarchyEnumerator.CellInfo info) {
        }

        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            return true;
        }
    }
}

