/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.CellId;
import com.sun.electric.database.ExportId;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.LibId;
import com.sun.electric.database.TechId;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.NodeProtoId;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.io.ELIBConstants;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.input.LibraryFiles;
import com.sun.electric.tool.ncc.basic.TransitiveRelation;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ELIB
extends LibraryFiles {
    private int magic;
    private boolean bytesSwapped;
    private int sizeOfBig;
    private int sizeOfSmall;
    private int sizeOfChar;
    private int clippedIntegers;
    private int toolCount;
    private int toolBCount;
    private Tool[] toolList;
    private String[] toolError;
    private int techCount;
    private Technology[] techList;
    private String[] techError;
    private HashMap<Technology, Double> techScale = new HashMap();
    private int arcProtoCount;
    private ArcProto[] arcProtoList;
    private String[] arcProtoError;
    private int primNodeProtoCount;
    private PrimitiveNode[] primNodeProtoList;
    private boolean[] primNodeProtoError;
    private String[] primNodeProtoOrig;
    private int[] primNodeProtoTech;
    private int primPortProtoCount;
    private PrimitivePort[] primPortProtoList;
    private String[] primPortProtoError;
    private int cellCount;
    private FakeCell[] fakeCellList;
    private int[] nodeCounts;
    private int[] firstNodeIndex;
    private int[] arcCounts;
    private int[] firstArcIndex;
    private int[] portCounts;
    private int[] firstPortIndex;
    private int[] cellXOff;
    private int[] cellYOff;
    private boolean[] xLibRefSatisfied;
    private HashMap<Integer, View> viewMapping;
    private int nodeCount;
    private LibraryFiles.NodeInstList nodeInstList;
    private int arcCount;
    private ArcInst[] arcList;
    private ArcProto[] arcTypeList;
    private String[] arcNameList;
    private TextDescriptor[] arcNameDescriptorList;
    private int[] arcWidthList;
    private int[] arcHeadXPosList;
    private int[] arcHeadYPosList;
    private int[] arcHeadNodeList;
    private int[] arcHeadPortList;
    private int[] arcTailXPosList;
    private int[] arcTailYPosList;
    private int[] arcTailNodeList;
    private int[] arcTailPortList;
    private int[] arcUserBits;
    private Variable[][] arcVariables;
    private int exportCount;
    private int exportIndex;
    private Object[] exportList;
    private int[] exportSubNodeList;
    private int[] exportSubPortList;
    private String[] exportNameList;
    private TextDescriptor[] exportNameDescriptors;
    private int[] exportUserbits;
    private Variable[][] exportVariables;
    private int geomCount;
    private boolean[] geomType;
    private int[] geomMoreUp;
    private String[] varNames;
    private Variable.Key[] varKeys;
    private boolean convertTextDescriptors;
    private boolean alwaysTextDescriptors;
    private static ByteBuffer bb = ByteBuffer.allocateDirect(8);
    private static byte[] rawData = new byte[8];

    ELIB() {
    }

    @Override
    protected boolean readProjectSettings() {
        try {
            return this.readTheLibrary(true);
        }
        catch (IOException e) {
            System.out.println("End of file reached while reading " + this.filePath);
            return true;
        }
    }

    @Override
    protected boolean readLib() {
        try {
            return this.readTheLibrary(false);
        }
        catch (IOException e) {
            System.out.println("End of file reached while reading " + this.filePath);
            return true;
        }
    }

    private boolean readTheLibrary(boolean onlyProjectSettings) throws IOException {
        int i;
        int i2;
        int i3;
        this.clippedIntegers = 0;
        this.byteCount = 0L;
        if (this.readHeader()) {
            System.out.println("Error reading header");
            return true;
        }
        this.toolCount = this.readBigInteger();
        this.techCount = this.readBigInteger();
        this.primNodeProtoCount = this.readBigInteger();
        this.primPortProtoCount = this.readBigInteger();
        this.arcProtoCount = this.readBigInteger();
        this.nodeProtoCount = this.readBigInteger();
        this.nodeCount = this.readBigInteger();
        this.exportCount = this.readBigInteger();
        this.arcCount = this.readBigInteger();
        this.geomCount = this.readBigInteger();
        this.cellCount = this.magic <= -1589 && this.magic >= -1593 ? this.readBigInteger() : this.nodeProtoCount;
        this.readBigInteger();
        String versionString = this.magic <= -1587 ? this.readString() : "3.35";
        this.version = Version.parseVersion(versionString);
        this.convertMosisCmosTechnologies = this.version.compareTo(Version.parseVersion("6.03q")) < 0;
        this.convertTextDescriptors = this.version.compareTo(Version.parseVersion("6.04c")) < 0;
        this.alwaysTextDescriptors = this.version.compareTo(Version.parseVersion("6.05x")) >= 0;
        this.scaleLambdaBy20 = this.version.compareTo(Version.parseVersion("5")) < 0;
        this.rotationMirrorBits = this.version.compareTo(Version.parseVersion("7.01")) >= 0;
        this.viewMapping = new HashMap();
        this.viewMapping.put(new Integer(-1), View.UNKNOWN);
        this.viewMapping.put(new Integer(-2), View.LAYOUT);
        this.viewMapping.put(new Integer(-3), View.SCHEMATIC);
        this.viewMapping.put(new Integer(-4), View.ICON);
        this.viewMapping.put(new Integer(-5), View.DOCWAVE);
        this.viewMapping.put(new Integer(-6), View.LAYOUTSKEL);
        this.viewMapping.put(new Integer(-7), View.VHDL);
        this.viewMapping.put(new Integer(-8), View.NETLIST);
        this.viewMapping.put(new Integer(-9), View.DOC);
        this.viewMapping.put(new Integer(-10), View.NETLISTNETLISP);
        this.viewMapping.put(new Integer(-11), View.NETLISTALS);
        this.viewMapping.put(new Integer(-12), View.NETLISTQUISC);
        this.viewMapping.put(new Integer(-13), View.NETLISTRSIM);
        this.viewMapping.put(new Integer(-14), View.NETLISTSILOS);
        this.viewMapping.put(new Integer(-15), View.VERILOG);
        this.viewMapping.put(new Integer(-16), View.LAYOUTCOMP);
        if (this.magic <= -1589) {
            int numExtraViews = this.readBigInteger();
            for (i3 = 0; i3 < numExtraViews; ++i3) {
                String viewName = this.readString();
                String viewShortName = this.readString();
                View view = View.findView(viewName);
                if (view == null && (view = this.findOldViewName(viewName)) == null && !onlyProjectSettings && (view = View.newInstance(viewName, viewShortName)) == null) {
                    return true;
                }
                this.viewMapping.put(new Integer(i3 + 1), view);
            }
        }
        this.toolBCount = this.magic <= -1577 && this.magic >= -1583 ? this.readBigInteger() : this.toolCount;
        if (!onlyProjectSettings) {
            this.lib.erase();
        }
        this.techList = new Technology[this.techCount];
        this.techError = new String[this.techCount];
        this.arcProtoList = new ArcProto[this.arcProtoCount];
        this.arcProtoError = new String[this.arcProtoCount];
        this.primNodeProtoList = new PrimitiveNode[this.primNodeProtoCount];
        this.primNodeProtoError = new boolean[this.primNodeProtoCount];
        this.primNodeProtoOrig = new String[this.primNodeProtoCount];
        this.primNodeProtoTech = new int[this.primNodeProtoCount];
        this.primPortProtoList = new PrimitivePort[this.primPortProtoCount];
        this.primPortProtoError = new String[this.primPortProtoCount];
        this.toolList = new Tool[this.toolCount];
        this.toolError = new String[this.toolCount];
        this.nodeProtoList = new Cell[this.nodeProtoCount];
        this.nodeCounts = new int[this.nodeProtoCount];
        this.firstNodeIndex = new int[this.nodeProtoCount + 1];
        this.arcCounts = new int[this.nodeProtoCount];
        this.firstArcIndex = new int[this.nodeProtoCount + 1];
        this.portCounts = new int[this.nodeProtoCount];
        this.firstPortIndex = new int[this.nodeProtoCount];
        this.cellLambda = new double[this.nodeProtoCount];
        this.cellXOff = new int[this.nodeProtoCount];
        this.cellYOff = new int[this.nodeProtoCount];
        this.xLibRefSatisfied = new boolean[this.nodeProtoCount];
        boolean hasAnchor = this.magic <= -1597;
        this.nodeInstList = new LibraryFiles.NodeInstList(this.nodeCount, hasAnchor);
        this.arcList = new ArcInst[this.arcCount];
        this.arcTypeList = new ArcProto[this.arcCount];
        this.arcNameList = new String[this.arcCount];
        this.arcNameDescriptorList = new TextDescriptor[this.arcCount];
        this.arcWidthList = new int[this.arcCount];
        this.arcHeadXPosList = new int[this.arcCount];
        this.arcHeadYPosList = new int[this.arcCount];
        this.arcHeadNodeList = new int[this.arcCount];
        this.arcHeadPortList = new int[this.arcCount];
        this.arcTailXPosList = new int[this.arcCount];
        this.arcTailYPosList = new int[this.arcCount];
        this.arcTailNodeList = new int[this.arcCount];
        this.arcTailPortList = new int[this.arcCount];
        this.arcUserBits = new int[this.arcCount];
        this.arcVariables = new Variable[this.arcCount][];
        for (i3 = 0; i3 < this.arcCount; ++i3) {
            this.arcHeadNodeList[i3] = -1;
            this.arcHeadPortList[i3] = -1;
            this.arcTailNodeList[i3] = -1;
            this.arcTailPortList[i3] = -1;
            this.arcNameList[i3] = null;
            this.arcUserBits[i3] = 0;
        }
        this.exportList = new Object[this.exportCount];
        this.exportSubNodeList = new int[this.exportCount];
        this.exportSubPortList = new int[this.exportCount];
        this.exportNameList = new String[this.exportCount];
        this.exportNameDescriptors = new TextDescriptor[this.exportCount];
        this.exportUserbits = new int[this.exportCount];
        this.exportVariables = new Variable[this.exportCount][];
        if (this.magic <= -1589 && this.magic >= -1593) {
            this.fakeCellList = new FakeCell[this.cellCount];
            for (i3 = 0; i3 < this.cellCount; ++i3) {
                this.fakeCellList[i3] = new FakeCell();
            }
        }
        if (this.magic > -1581) {
            this.geomType = new boolean[this.geomCount];
            this.geomMoreUp = new int[this.geomCount];
        }
        if (this.magic != -1573) {
            int nodeInstPos = 0;
            int arcInstPos = 0;
            int portProtoPos = 0;
            for (int i4 = 0; i4 < this.nodeProtoCount; ++i4) {
                this.arcCounts[i4] = this.readBigInteger();
                this.nodeCounts[i4] = this.readBigInteger();
                this.portCounts[i4] = this.readBigInteger();
                if (this.arcCounts[i4] > 0 || this.nodeCounts[i4] > 0) {
                    arcInstPos += this.arcCounts[i4];
                    nodeInstPos += this.nodeCounts[i4];
                }
                portProtoPos += this.portCounts[i4];
            }
            if (nodeInstPos != this.nodeCount) {
                System.out.println("Error: cells have " + nodeInstPos + " nodes but library has " + this.nodeCount);
                return true;
            }
            if (arcInstPos != this.arcCount) {
                System.out.println("Error: cells have " + arcInstPos + " arcs but library has " + this.arcCount);
                return true;
            }
            if (portProtoPos != this.exportCount) {
                System.out.println("Error: cells have " + portProtoPos + " ports but library has " + this.exportCount);
                return true;
            }
        } else {
            this.arcCounts[0] = this.arcCount;
            this.nodeCounts[0] = this.nodeCount;
            this.portCounts[0] = this.exportCount;
            for (i3 = 1; i3 < this.nodeProtoCount; ++i3) {
                this.portCounts[i3] = 0;
                this.nodeCounts[i3] = 0;
                this.arcCounts[i3] = 0;
            }
        }
        this.primNodeProtoCount = 0;
        this.primPortProtoCount = 0;
        this.arcProtoCount = 0;
        for (int techIndex = 0; techIndex < this.techCount; ++techIndex) {
            String name = this.readString();
            Technology tech = this.findTechnologyName(name);
            boolean imosconv = false;
            if (name.equals("imos")) {
                tech = Technology.getMocmosTechnology();
                imosconv = true;
            }
            if (tech == null) {
                tech = Generic.tech;
                this.techError[techIndex] = name;
            } else {
                this.techError[techIndex] = null;
            }
            this.techList[techIndex] = tech;
            int numPrimNodes = this.readBigInteger();
            for (int j = 0; j < numPrimNodes; ++j) {
                PrimitiveNode pnp;
                this.primNodeProtoOrig[this.primNodeProtoCount] = null;
                this.primNodeProtoError[this.primNodeProtoCount] = false;
                name = this.readString();
                if (imosconv) {
                    name = name.substring(6);
                }
                if ((pnp = tech.findNodeProto(name)) == null && name.equals("Active-Node")) {
                    pnp = tech.findNodeProto("P-Active-Node");
                }
                if (pnp == null) {
                    String primName;
                    PrimitiveNode opnp;
                    boolean advise = true;
                    Iterator<PrimitiveNode> it = tech.getNodes();
                    while (it.hasNext()) {
                        opnp = it.next();
                        primName = opnp.getName();
                        if (!primName.startsWith(name) && !name.startsWith(primName)) continue;
                        pnp = opnp;
                        break;
                    }
                    if (pnp == null) {
                        it = tech.getNodes();
                        while (it.hasNext()) {
                            opnp = it.next();
                            primName = opnp.getName();
                            if (!primName.endsWith(name) && !name.endsWith(primName)) continue;
                            pnp = opnp;
                            break;
                        }
                    }
                    if (pnp == null && (pnp = tech.convertOldNodeName(name)) != null) {
                        advise = false;
                    }
                    if (pnp == null) {
                        it = tech.getNodes();
                        pnp = it.next();
                    }
                    if (advise) {
                        String errorMessage = this.techError[techIndex] != null ? this.techError[techIndex] : tech.getTechName();
                        this.primNodeProtoOrig[this.primNodeProtoCount] = errorMessage = errorMessage + ":" + name;
                        this.primNodeProtoError[this.primNodeProtoCount] = true;
                    }
                }
                this.primNodeProtoTech[this.primNodeProtoCount] = techIndex;
                this.primNodeProtoList[this.primNodeProtoCount] = pnp;
                int numPrimPorts = this.readBigInteger();
                for (int i5 = 0; i5 < numPrimPorts; ++i5) {
                    Iterator<PrimitivePort> it;
                    this.primPortProtoError[this.primPortProtoCount] = null;
                    name = this.readString();
                    PrimitivePort pp = (PrimitivePort)pnp.findPortProto(name);
                    if (pp == null) {
                        pp = tech.convertOldPortName(name, pnp);
                    }
                    if (pp == null && (it = pnp.getPrimitivePorts()).hasNext()) {
                        pp = it.next();
                        if (!this.primNodeProtoError[this.primNodeProtoCount]) {
                            String errorMessage = name + " on ";
                            if (this.primNodeProtoOrig[this.primNodeProtoCount] != null) {
                                errorMessage = errorMessage + this.primNodeProtoOrig[this.primNodeProtoCount];
                            } else {
                                errorMessage = this.techError[techIndex] != null ? errorMessage + this.techError[techIndex] : errorMessage + tech.getTechName();
                                errorMessage = errorMessage + ":" + pnp.getName();
                            }
                            this.primPortProtoError[this.primPortProtoCount] = errorMessage;
                        }
                    }
                    this.primPortProtoList[this.primPortProtoCount++] = pp;
                }
                ++this.primNodeProtoCount;
            }
            int numArcProtos = this.readBigInteger();
            for (int j = 0; j < numArcProtos; ++j) {
                ArcProto ap;
                this.arcProtoError[this.arcProtoCount] = null;
                name = this.readString();
                if (imosconv) {
                    name = name.substring(6);
                }
                if ((ap = tech.findArcProto(name)) == null) {
                    ap = tech.convertOldArcName(name);
                }
                if (ap == null) {
                    Iterator<ArcProto> it = tech.getArcs();
                    ap = it.next();
                    String errorMessage = this.techError[techIndex] != null ? this.techError[techIndex] : tech.getTechName();
                    this.arcProtoError[this.arcProtoCount] = errorMessage = errorMessage + ":" + name;
                }
                this.arcProtoList[this.arcProtoCount++] = ap;
            }
        }
        for (i3 = 0; i3 < this.toolCount; ++i3) {
            String name = this.readString();
            this.toolError[i3] = null;
            Tool t = Tool.findTool(name);
            if (t == null) {
                this.toolError[i3] = name;
            }
            this.toolList[i3] = t;
        }
        if (this.magic <= -1577 && this.magic >= -1583) {
            for (i3 = 0; i3 < this.toolBCount; ++i3) {
                this.readString();
            }
        }
        int userBits = 0;
        if (this.magic <= -1585) {
            userBits = this.readBigInteger();
        } else {
            if (this.toolBCount >= 1) {
                userBits = this.readBigInteger();
            }
            for (int i6 = 1; i6 < this.toolBCount; ++i6) {
                this.readBigInteger();
            }
        }
        if (!onlyProjectSettings) {
            this.lib.lowLevelSetUserBits(userBits);
            this.lib.clearChanged();
            this.lib.setFromDisk();
            this.lib.setVersion(this.version);
        }
        for (int i7 = 0; i7 < this.techCount; ++i7) {
            int lambda = this.readBigInteger();
            if (this.techError[i7] != null) continue;
            Technology tech = this.techList[i7];
            if (this.scaleLambdaBy20) {
                lambda *= 20;
            }
            this.techScale.put(tech, Double.valueOf(lambda));
            String varName = tech.getScaleVariableName();
            Variable var = Variable.newInstance(Variable.newKey(varName), new Double(lambda / 2), TextDescriptor.EMPTY);
            this.realizeMeaningPrefs(tech, new Variable[]{var});
        }
        this.readNameSpace();
        Variable[] libVars = this.readVariables();
        for (i2 = 0; i2 < libVars.length; ++i2) {
            Object value;
            Variable var = libVars[i2];
            if (var == null || var.getKey() != Library.FONT_ASSOCIATIONS || !((value = var.getObject()) instanceof String[])) continue;
            this.setFontNames((String[])value);
            libVars[i2] = null;
        }
        if (!onlyProjectSettings) {
            this.realizeVariables(this.lib, libVars);
        }
        for (i2 = 0; i2 < this.toolCount; ++i2) {
            Tool tool = this.toolList[i2];
            Variable[] vars = this.readVariables();
            if (tool == null) continue;
            this.realizeMeaningPrefs(tool, vars);
        }
        for (i2 = 0; i2 < this.techCount; ++i2) {
            Technology tech = this.techList[i2];
            Variable[] vars = this.readVariables();
            if (tech == null) continue;
            this.realizeMeaningPrefs(tech, vars);
        }
        if (onlyProjectSettings) {
            return false;
        }
        for (i2 = 0; i2 < this.arcProtoCount; ++i2) {
            this.readVariables();
        }
        for (i2 = 0; i2 < this.primNodeProtoCount; ++i2) {
            this.readVariables();
        }
        for (i2 = 0; i2 < this.primPortProtoCount; ++i2) {
            this.readVariables();
        }
        if (this.magic <= -1589) {
            int count = this.readBigInteger();
            for (int i8 = 0; i8 < count; ++i8) {
                int j = this.readBigInteger();
                View v = this.getView(j);
                if (v == null) {
                    System.out.println("View index " + j + " not found");
                }
                this.readVariables();
            }
        }
        if (this.magic <= -1589 && this.magic >= -1593) {
            for (i2 = 0; i2 < this.cellCount; ++i2) {
                String thecellname = this.readString();
                this.readVariables();
                this.fakeCellList[i2].cellName = this.convertCellName(thecellname);
            }
        }
        this.exportIndex = 0;
        HashMap<Cell, Integer> nextInCellGroup = new HashMap<Cell, Integer>();
        for (int i9 = 0; i9 < this.nodeProtoCount; ++i9) {
            if (this.arcCounts[i9] < 0 && this.nodeCounts[i9] < 0) continue;
            this.xLibRefSatisfied[i9] = true;
            if (!this.readNodeProto(i9, nextInCellGroup)) continue;
            System.out.println("Error reading cell");
            return true;
        }
        TransitiveRelation<Object> transitive = new TransitiveRelation<Object>();
        HashMap<String, String> protoNames = new HashMap<String, String>();
        for (int cellIndex = 0; cellIndex < this.nodeProtoCount; ++cellIndex) {
            Cell cell = this.nodeProtoList[cellIndex];
            if (cell == null || cell.getLibrary() != this.lib) continue;
            String protoName = (String)protoNames.get(cell.getName());
            if (protoName == null) {
                protoName = cell.getName();
                protoNames.put(protoName, protoName);
            }
            transitive.theseAreRelated(cell, protoName);
            Cell otherCell = null;
            Integer nextInCell = nextInCellGroup.get(cell);
            if (nextInCell != null) {
                otherCell = this.nodeProtoList[nextInCell];
            }
            if (otherCell == null || cell.getLibrary() != this.lib) continue;
            transitive.theseAreRelated(cell, otherCell);
        }
        Iterator git = transitive.getSetsOfRelatives();
        while (git.hasNext()) {
            Set group = git.next();
            Cell firstCell = null;
            for (Object o : group) {
                if (!(o instanceof Cell)) continue;
                Cell cell = (Cell)o;
                if (firstCell == null) {
                    firstCell = cell;
                    continue;
                }
                cell.joinGroup(firstCell);
            }
        }
        for (i = 0; i < this.nodeProtoCount; ++i) {
            Cell cell = this.nodeProtoList[i];
            if (cell != null || !this.readExternalNodeProto(this.lib, i)) continue;
            System.out.println("Error reading external cell");
            return true;
        }
        this.fixExternalVariables(this.lib);
        for (i = 0; i < this.nodeProtoCount; ++i) {
            Cell cell = this.nodeProtoList[i];
            this.fixExternalVariables(cell);
        }
        int nodeIndex = 0;
        int arcIndex = 0;
        int geomIndex = 0;
        for (int cellIndex = 0; cellIndex < this.nodeProtoCount; ++cellIndex) {
            int j;
            Cell cell = this.nodeProtoList[cellIndex];
            this.firstNodeIndex[cellIndex] = nodeIndex;
            this.firstArcIndex[cellIndex] = arcIndex;
            if (this.magic > -1581) {
                j = geomIndex;
                this.readGeom(this.geomType, this.geomMoreUp, j);
                this.readGeom(this.geomType, this.geomMoreUp, ++j);
                int top = ++j;
                this.readGeom(this.geomType, this.geomMoreUp, j);
                int bot = ++j;
                this.readGeom(this.geomType, this.geomMoreUp, j);
                ++j;
                do {
                    this.readGeom(this.geomType, this.geomMoreUp, j);
                } while (this.geomMoreUp[++j - 1] != top);
                geomIndex = j;
                int look = bot;
                while (look != top) {
                    if (!this.geomType[look]) {
                        if (this.readArcInst(arcIndex)) {
                            System.out.println("Error reading arc");
                            Input.errorLogger.logError("Error reading arc index " + arcIndex, cell, 1);
                            return true;
                        }
                        ++arcIndex;
                    } else {
                        if (this.readNodeInst(nodeIndex, cellIndex)) {
                            System.out.println("Error reading node");
                            Input.errorLogger.logError("Error reading node index " + nodeIndex, cell, 1);
                            return true;
                        }
                        ++nodeIndex;
                    }
                    look = this.geomMoreUp[look];
                }
                continue;
            }
            for (j = 0; j < this.arcCounts[cellIndex]; ++j) {
                if (this.readArcInst(arcIndex)) {
                    System.out.println("Error reading arc");
                    Input.errorLogger.logError("Error reading arc index " + arcIndex, cell, 1);
                    return true;
                }
                ++arcIndex;
            }
            for (j = 0; j < this.nodeCounts[cellIndex]; ++j) {
                if (this.readNodeInst(nodeIndex, cellIndex)) {
                    System.out.println("Error reading node index " + nodeIndex + " in " + cell + " of " + this.lib);
                    Input.errorLogger.logError("Error reading node index " + nodeIndex + " in " + cell + " of " + this.lib, cell, 1);
                    return true;
                }
                ++nodeIndex;
            }
        }
        this.firstNodeIndex[this.nodeProtoCount] = nodeIndex;
        this.firstArcIndex[this.nodeProtoCount] = arcIndex;
        Iterator<Cell> it = this.lib.getCells();
        while (it.hasNext()) {
            Cell c = it.next();
            if (c.getVar(IO_DUMMY_OBJECT) == null) continue;
            System.out.println("WARNING: " + this.lib + " contains DUMMY cell " + c.noLibDescribe());
        }
        return false;
    }

    @Override
    protected void realizeCellsRecursively(Cell cell, HashSet<Cell> recursiveSetupFlag, String scaledCellName, double scale) {
        int i;
        boolean dummyCell;
        if (cell.getLibrary() != this.lib) {
            return;
        }
        boolean bl = dummyCell = cell.getVar(IO_DUMMY_OBJECT) != null;
        if (dummyCell) {
            return;
        }
        int cellIndex = cell.getTempInt();
        if (cellIndex + 1 >= this.firstNodeIndex.length) {
            return;
        }
        int startNode = this.firstNodeIndex[cellIndex];
        int endNode = this.firstNodeIndex[cellIndex + 1];
        block0: for (int i2 = startNode; i2 < endNode; ++i2) {
            Cell subCell;
            NodeProto np = this.nodeInstList.protoType[i2];
            if (np instanceof PrimitiveNode || (subCell = (Cell)np).getLibrary() == this.lib) continue;
            for (int cI = 0; cI < this.nodeProtoCount; ++cI) {
                LibraryFiles reader;
                if (this.nodeProtoList[cI] != subCell) continue;
                if (this.xLibRefSatisfied[cI]) continue block0;
                if (!recursiveSetupFlag.contains(subCell) && (reader = this.getReaderForLib(subCell.getLibrary())) != null) {
                    reader.realizeCellsRecursively(subCell, recursiveSetupFlag, null, 0.0);
                }
                int startPort = this.firstPortIndex[cI];
                int endPort = startPort + this.portCounts[cI];
                for (int j = startPort; j < endPort; ++j) {
                    Object obj = this.exportList[j];
                    Export pp = null;
                    Cell otherCell = null;
                    if (!(obj instanceof Cell) || (pp = (Export)ELIB.findPortProto(otherCell = (Cell)obj, this.exportNameList[j])) == null) continue;
                    this.exportList[j] = pp;
                }
                this.xLibRefSatisfied[cI] = true;
                continue block0;
            }
        }
        this.scanNodesForRecursion(cell, recursiveSetupFlag, this.nodeInstList.protoType, startNode, endNode);
        ELIB.setProgressValue(++cellsConstructed * 100 / totalCells);
        double lambda = this.cellLambda[cellIndex];
        if (scaledCellName != null) {
            Cell oldCell = cell;
            cell = Cell.newInstance(cell.getLibrary(), scaledCellName);
            cell.setTempInt(cellIndex);
            recursiveSetupFlag.add(cell);
            cell.joinGroup(oldCell);
            this.scaledCells.add(cell);
            lambda /= scale;
        } else {
            scale = 1.0;
        }
        int xoff = 0;
        int yoff = 0;
        for (i = startNode; i < endNode; ++i) {
            NodeProto np = this.nodeInstList.protoType[i];
            if (np != Generic.tech.cellCenterNode) continue;
            this.realizeNode(this.nodeInstList, i, xoff, yoff, lambda, cell, np);
            xoff = (this.nodeInstList.lowX[i] + this.nodeInstList.highX[i]) / 2;
            yoff = (this.nodeInstList.lowY[i] + this.nodeInstList.highY[i]) / 2;
            break;
        }
        this.cellXOff[cellIndex] = xoff;
        this.cellYOff[cellIndex] = yoff;
        for (i = startNode; i < endNode; ++i) {
            NodeProto np = this.nodeInstList.protoType[i];
            if (np == Generic.tech.cellCenterNode) continue;
            if (np instanceof Cell) {
                np = this.scaleCell(i, lambda, cell, recursiveSetupFlag);
            }
            this.realizeNode(this.nodeInstList, i, xoff, yoff, lambda, cell, np);
        }
        this.realizeExports(cell, cellIndex, scaledCellName);
        this.realizeArcs(cell, cellIndex, scaledCellName, scale);
        cell.loadExpandStatus();
    }

    @Override
    protected boolean spreadLambda(Cell cell, int cellIndex) {
        boolean changed = false;
        int startNode = this.firstNodeIndex[cellIndex];
        int endNode = this.firstNodeIndex[cellIndex + 1];
        double thisLambda = this.cellLambda[cellIndex];
        for (int i = startNode; i < endNode; ++i) {
            int subCellIndex;
            double subLambda;
            Cell subCell;
            NodeProto np = this.nodeInstList.protoType[i];
            if (np instanceof PrimitiveNode || (subCell = (Cell)np).getVar(IO_DUMMY_OBJECT) != null) continue;
            LibraryFiles reader = this;
            if (subCell.getLibrary() != this.lib && (reader = this.getReaderForLib(subCell.getLibrary())) == null || !((subLambda = reader.cellLambda[subCellIndex = subCell.getTempInt()]) < thisLambda) || !cell.isSchematic() || !subCell.isIcon()) continue;
            reader.cellLambda[subCellIndex] = thisLambda;
            changed = true;
        }
        return changed;
    }

    @Override
    protected void computeTech(Cell cell, Set uncomputedCells) {
        int cellIndex;
        uncomputedCells.remove(cell);
        for (cellIndex = 0; cellIndex < this.nodeProtoCount && this.nodeProtoList[cellIndex] != cell; ++cellIndex) {
        }
        if (cellIndex >= this.nodeProtoCount) {
            return;
        }
        int startNode = this.firstNodeIndex[cellIndex];
        int endNode = this.firstNodeIndex[cellIndex + 1];
        for (int i = startNode; i < endNode; ++i) {
            Cell subCell;
            LibraryFiles reader;
            NodeProto np = this.nodeInstList.protoType[i];
            if (!uncomputedCells.contains(np) || (reader = this.getReaderForLib((subCell = (Cell)np).getLibrary())) == null) continue;
            reader.computeTech(subCell, uncomputedCells);
        }
        int startArc = this.firstArcIndex[cellIndex];
        int endArc = this.firstArcIndex[cellIndex + 1];
        Technology cellTech = Technology.whatTechnology(cell, this.nodeInstList.protoType, startNode, endNode, this.arcTypeList, startArc, endArc);
        cell.setTechnology(cellTech);
    }

    @Override
    protected double computeLambda(Cell cell, int cellIndex) {
        Technology cellTech = cell.getTechnology();
        return cellTech != null ? this.getScale(cellTech) : 1.0;
    }

    private double getScale(Technology tech) {
        Double scale = this.techScale.get(tech);
        return scale != null ? scale.doubleValue() : tech.getScale();
    }

    @Override
    protected boolean canScale() {
        return true;
    }

    private void realizeExports(Cell cell, int cellIndex, String scaledCellName) {
        int startPort = this.firstPortIndex[cellIndex];
        int endPort = startPort + this.portCounts[cellIndex];
        CellId cellId = cell.getId();
        TreeSet<String> exportNames = new TreeSet<String>(TextUtils.STRING_NUMBER_ORDER);
        for (int i = startPort; i < endPort; ++i) {
            exportNames.add(this.exportNameList[i]);
        }
        for (String exportName : exportNames) {
            cellId.newExportId(exportName);
        }
        for (int i = startPort; i < endPort; ++i) {
            String msg;
            String exportName;
            exportName = this.exportNameList[i];
            int nodeIndex = this.exportSubNodeList[i];
            if (nodeIndex < 0) {
                System.out.println("ERROR: " + cell + ": cannot find the node on which export " + exportName + " resides");
                continue;
            }
            NodeInst subNodeInst = this.nodeInstList.theNode[nodeIndex];
            PortProto subPortProto = this.convertPortProto(this.exportSubPortList[i]);
            if (subNodeInst == null || subPortProto == null || subNodeInst.getParent() != cell || subNodeInst.getProto() != subPortProto.getParent()) {
                msg = "ERROR: " + cell + ": export " + this.exportNameList[i] + " could not be created";
                System.out.println(msg);
                Input.errorLogger.logError(msg, cell, 1);
                continue;
            }
            if (subNodeInst.getProto() == null) {
                msg = "ERROR: " + cell + ": export " + this.exportNameList[i] + " could not be created...proto bad!";
                System.out.println(msg);
                Input.errorLogger.logError(msg, cell, 1);
                continue;
            }
            PortInst pi = subNodeInst.findPortInst(subPortProto.getName());
            boolean alwaysDrawn = ImmutableExport.alwaysDrawnFromElib(this.exportUserbits[i]);
            boolean bodyOnly = ImmutableExport.bodyOnlyFromElib(this.exportUserbits[i]);
            PortCharacteristic characteristic = ImmutableExport.portCharacteristicFromElib(this.exportUserbits[i]);
            ExportId exportId = cellId.newExportId(Name.findName(exportName).toString());
            Export pp = Export.newInstance(cell, exportId, null, this.exportNameDescriptors[i], pi, alwaysDrawn, bodyOnly, characteristic, errorLogger);
            this.exportList[i] = pp;
            if (pp == null) continue;
            this.realizeVariables(pp, this.exportVariables[i]);
        }
    }

    private void realizeArcs(Cell cell, int cellIndex, String scaledCellName, double scale) {
        double lambda = this.cellLambda[cellIndex] / scale;
        int xoff = this.cellXOff[cellIndex];
        int yoff = this.cellYOff[cellIndex];
        int startArc = this.firstArcIndex[cellIndex];
        int endArc = this.firstArcIndex[cellIndex + 1];
        for (int i = startArc; i < endArc; ++i) {
            ArcInst ai;
            ArcProto ap = this.arcTypeList[i];
            String name = this.arcNameList[i];
            long gridExtendOverMin = this.getSizeCorrector(ap.getTechnology()).getExtendFromDisk(ap, (double)this.arcWidthList[i] / lambda);
            double headX = (double)(this.arcHeadXPosList[i] - xoff) / lambda;
            double headY = (double)(this.arcHeadYPosList[i] - yoff) / lambda;
            double tailX = (double)(this.arcTailXPosList[i] - xoff) / lambda;
            double tailY = (double)(this.arcTailYPosList[i] - yoff) / lambda;
            if (this.arcHeadNodeList[i] < 0) {
                System.out.println("ERROR: head of " + ap + " not known");
                continue;
            }
            NodeInst headNode = this.nodeInstList.theNode[this.arcHeadNodeList[i]];
            int headPortIntValue = this.arcHeadPortList[i];
            PortProto headPort = this.convertPortProto(headPortIntValue);
            String headname = "Port name not found";
            if (headPort != null) {
                headname = headPort.getName();
            } else if (headPortIntValue >= 0 && headPortIntValue < this.exportNameList.length) {
                headname = this.exportNameList[headPortIntValue];
            }
            if (this.arcTailNodeList[i] < 0) {
                System.out.println("ERROR: tail of " + ap + " not known");
                continue;
            }
            NodeInst tailNode = this.nodeInstList.theNode[this.arcTailNodeList[i]];
            int tailPortIntValue = this.arcTailPortList[i];
            PortProto tailPort = this.convertPortProto(tailPortIntValue);
            String tailname = "Port name not found";
            if (tailPort != null) {
                tailname = tailPort.getName();
            } else if (tailPortIntValue >= 0 && tailPortIntValue < this.exportNameList.length) {
                tailname = this.exportNameList[tailPortIntValue];
            }
            PortInst headPortInst = this.getArcEnd(ap, headNode, headname, headX, headY, cell);
            PortInst tailPortInst = this.getArcEnd(ap, tailNode, tailname, tailX, tailY, cell);
            if (headPortInst == null || tailPortInst == null) {
                System.out.println("Cannot create arc of type " + ap.getName() + " in cell " + cell.getName() + " because ends are unknown");
                continue;
            }
            this.arcList[i] = ai = ArcInst.newInstance(cell, ap, name, this.arcNameDescriptorList[i], headPortInst, tailPortInst, new EPoint(headX, headY), new EPoint(tailX, tailY), gridExtendOverMin, ImmutableArcInst.angleFromElib(this.arcUserBits[i]), ImmutableArcInst.flagsFromElib(this.arcUserBits[i]));
            if (ai == null) {
                String msg = "ERROR: " + cell + ": arc " + name + " could not be created";
                System.out.println(msg);
                Input.errorLogger.logError(msg, cell, 1);
                continue;
            }
            this.realizeVariables(ai, this.arcVariables[i]);
        }
    }

    private Cell scaleCell(int i, double lambda, Cell cell, HashSet<Cell> recursiveSetupFlag) {
        double scaleY;
        Cell subCell = (Cell)this.nodeInstList.protoType[i];
        ERectangle bounds = subCell.getBounds();
        double width = (double)(this.nodeInstList.highX[i] - this.nodeInstList.lowX[i]) / lambda;
        double height = (double)(this.nodeInstList.highY[i] - this.nodeInstList.lowY[i]) / lambda;
        if (Math.abs(((RectangularShape)bounds).getWidth() - width) <= 0.5 && Math.abs(((RectangularShape)bounds).getHeight() - height) <= 0.5) {
            return subCell;
        }
        LibraryFiles reader = this;
        if (subCell.getLibrary() != this.lib) {
            reader = this.getReaderForLib(subCell.getLibrary());
        }
        if (!(reader != null && reader.canScale() && cell.isSchematic() && subCell.isIcon())) {
            return subCell;
        }
        double scaleX = width / ((RectangularShape)bounds).getWidth();
        if (!GenMath.doublesClose(scaleX, scaleY = height / ((RectangularShape)bounds).getHeight())) {
            return subCell;
        }
        double scale = Math.sqrt(scaleX * scaleY);
        String scaledCellName = subCell.getName() + "-SCALED-BY-" + scale + subCell.getView().getAbbreviationExtension();
        Cell scaledCell = subCell.getLibrary().findNodeProto(scaledCellName);
        if (scaledCell == null) {
            if (reader != null) {
                reader.realizeCellsRecursively(subCell, recursiveSetupFlag, scaledCellName, scale);
            }
            if ((scaledCell = subCell.getLibrary().findNodeProto(scaledCellName)) == null) {
                System.out.println("Error scaling " + subCell + " by " + scale);
            }
        }
        return scaledCell != null ? scaledCell : subCell;
    }

    protected PortInst getArcEnd(ArcProto ap, NodeInst node, String portname, double x, double y, Cell cell) {
        PortInst pi = null;
        String whatHappenedToPort = "not found";
        String nodeName = "missing node";
        if (node != null) {
            pi = node.findPortInst(portname);
            nodeName = node.getName();
            if (pi != null) {
                return pi;
            }
            Iterator<PortInst> it = node.getPortInsts();
            while (it.hasNext()) {
                pi = it.next();
                Poly portLocation = pi.getPoly();
                if (portLocation.contains(x, y) && pi.getPortProto().connectsTo(ap)) {
                    String msg = cell + ": Port '" + portname + "' on '" + nodeName + "' not found, connecting to port '" + pi.getPortProto().getName() + "' at the same location";
                    System.out.println("ERROR: " + msg);
                    Input.errorLogger.logError(msg, cell, 0);
                    return pi;
                }
                pi = null;
            }
            whatHappenedToPort = "is missing";
            Cell c = null;
            if (node.getProto() != null && node.isCellInstance() && ((Cell)node.getProto()).getVar(IO_DUMMY_OBJECT) != null) {
                c = (Cell)node.getProto();
            }
            if (c != null) {
                double anchorX = node.getAnchorCenterX();
                double anchorY = node.getAnchorCenterY();
                Point2D expected = new Point2D.Double(x, y);
                PrimitiveNode pn = Generic.tech.universalPinNode;
                AffineTransform trans = node.rotateIn();
                expected = trans.transform(expected, expected);
                Point2D.Double center = new Point2D.Double(expected.getX() - anchorX, expected.getY() - anchorY);
                NodeInst ni = NodeInst.newInstance(pn, center, 0.0, 0.0, c, Orientation.IDENT, "", 0);
                Export ex = Export.newInstance(c, ni.getOnlyPortInst(), portname, false);
                if (ex != null) {
                    return node.findPortInst(portname);
                }
            }
        }
        String msg = cell + ": Port '" + portname + "' on " + node + " " + whatHappenedToPort + ": leaving arc disconnected";
        System.out.println("ERROR: " + msg);
        PrimitiveNode pn = ap.findOverridablePinProto();
        node = NodeInst.newInstance(pn, new Point2D.Double(x, y), pn.getDefWidth(), pn.getDefHeight(), cell);
        Input.errorLogger.logError(msg, node, cell, null, 0);
        return node.getOnlyPortInst();
    }

    private boolean readHeader() throws IOException {
        this.bytesSwapped = false;
        byte byte1 = this.readByte();
        byte byte2 = this.readByte();
        byte byte3 = this.readByte();
        byte byte4 = this.readByte();
        this.magic = (byte4 & 0xFF) << 24 | (byte3 & 0xFF) << 16 | (byte2 & 0xFF) << 8 | byte1 & 0xFF;
        if (this.magic != -1573 && this.magic != -1575 && this.magic != -1577 && this.magic != -1579 && this.magic != -1581 && this.magic != -1583 && this.magic != -1585 && this.magic != -1587 && this.magic != -1589 && this.magic != -1591 && this.magic != -1593 && this.magic != -1595 && this.magic != -1597) {
            this.magic = (byte1 & 0xFF) << 24 | (byte2 & 0xFF) << 16 | (byte3 & 0xFF) << 8 | byte4 & 0xFF;
            if (this.magic != -1573 && this.magic != -1575 && this.magic != -1577 && this.magic != -1579 && this.magic != -1581 && this.magic != -1583 && this.magic != -1585 && this.magic != -1587 && this.magic != -1589 && this.magic != -1591 && this.magic != -1593 && this.magic != -1595 && this.magic != -1597) {
                System.out.println("Bad file format: does not start with proper magic number");
                return true;
            }
            this.bytesSwapped = true;
        }
        if (this.magic <= -1591) {
            this.sizeOfSmall = this.readByte();
            this.sizeOfBig = this.readByte();
        } else {
            this.sizeOfSmall = 2;
            this.sizeOfBig = 4;
        }
        this.sizeOfChar = this.magic <= -1593 ? (int)this.readByte() : 1;
        return false;
    }

    private boolean readNodeProto(int cellIndex, HashMap<Cell, Integer> nextInCellGroup) throws IOException {
        Cell cell;
        String theProtoName;
        if (this.magic <= -1589) {
            int k;
            Integer nextInCell = null;
            if (this.magic >= -1593) {
                k = this.readBigInteger();
                theProtoName = this.fakeCellList[k].cellName;
            } else {
                theProtoName = this.convertCellName(this.readString());
                k = this.readBigInteger();
                if (k == -1) {
                    k = cellIndex;
                }
                nextInCell = k;
                k = this.readBigInteger();
            }
            View v = this.getView(this.readBigInteger());
            if (v == null) {
                v = View.UNKNOWN;
            }
            int version = this.readBigInteger();
            theProtoName = theProtoName + ";" + version + v.getAbbreviationExtension();
            cell = Cell.newInstance(this.lib, theProtoName);
            if (nextInCell != null) {
                nextInCellGroup.put(cell, nextInCell);
            }
            int creationDate = this.readBigInteger();
            int revisionDate = this.readBigInteger();
            cell.lowLevelSetCreationDate(ELIBConstants.secondsToDate(creationDate));
            cell.lowLevelSetRevisionDate(ELIBConstants.secondsToDate(revisionDate));
        } else {
            theProtoName = this.readString();
            cell = Cell.newInstance(this.lib, theProtoName);
        }
        this.nodeProtoList[cellIndex] = cell;
        assert (cell.getCellName() != null);
        this.readBigInteger();
        this.readBigInteger();
        this.readBigInteger();
        this.readBigInteger();
        if (this.magic >= -1581) {
            this.readBigInteger();
            this.readBigInteger();
        }
        this.firstPortIndex[cellIndex] = this.exportIndex;
        int portCount = this.readBigInteger();
        if (portCount != this.portCounts[cellIndex]) {
            System.out.println("Error! Cell header lists " + this.portCounts[cellIndex] + " exports, but body lists " + portCount);
        }
        for (int j = 0; j < portCount; ++j) {
            String exportName;
            this.exportSubNodeList[this.exportIndex] = -1;
            int whichNode = this.readBigInteger();
            if (whichNode >= 0 && whichNode < this.nodeCount) {
                this.exportSubNodeList[this.exportIndex] = whichNode;
            }
            this.exportSubPortList[this.exportIndex] = this.readBigInteger();
            this.exportNameList[this.exportIndex] = exportName = this.readString();
            if (this.exportSubNodeList[this.exportIndex] == -1) {
                System.out.println("Error: Export '" + exportName + "' of cell " + theProtoName + " cannot be read properly");
            }
            int descript0 = 0;
            int descript1 = 0;
            if (this.magic <= -1589) {
                if (this.convertTextDescriptors) {
                    descript0 = this.readBigInteger();
                    descript1 = 0;
                } else {
                    descript0 = this.readBigInteger();
                    descript1 = this.readBigInteger();
                }
            }
            this.exportNameDescriptors[this.exportIndex] = this.makeDescriptor(descript0, descript1);
            if (this.magic > -1589) {
                this.readBigInteger();
            }
            this.exportUserbits[this.exportIndex] = 0;
            if (this.magic <= -1585) {
                this.exportUserbits[this.exportIndex] = this.readBigInteger();
                if (this.magic >= -1587) {
                    this.readBigInteger();
                }
            } else {
                if (this.toolBCount >= 1) {
                    this.exportUserbits[this.exportIndex] = this.readBigInteger();
                }
                for (int i = 1; i < this.toolBCount; ++i) {
                    this.readBigInteger();
                }
            }
            this.exportVariables[this.exportIndex] = this.readVariables();
            ++this.exportIndex;
        }
        if (this.magic > -1581) {
            this.readBigInteger();
            this.readBigInteger();
            this.readBigInteger();
            this.readBigInteger();
            this.readBigInteger();
        }
        this.readBigInteger();
        int userBits = 0;
        if (this.magic <= -1585) {
            userBits = this.readBigInteger();
            if (this.magic >= -1587) {
                this.readBigInteger();
            }
        } else {
            if (this.toolBCount >= 1) {
                userBits = this.readBigInteger();
            }
            for (int i = 1; i < this.toolBCount; ++i) {
                this.readBigInteger();
            }
        }
        cell.lowLevelSetUserbits(userBits);
        this.realizeVariables(cell, this.readVariables());
        return false;
    }

    private boolean readExternalNodeProto(Library lib, int cellIndex) throws IOException {
        String theProtoName;
        if (this.magic >= -1593) {
            int k = this.readBigInteger();
            theProtoName = this.fakeCellList[k].cellName;
        } else {
            theProtoName = this.convertCellName(this.readString());
            this.readBigInteger();
            this.readBigInteger();
        }
        View v = this.getView(this.readBigInteger());
        if (v == null) {
            v = View.UNKNOWN;
        }
        int version = this.readBigInteger();
        String fullCellName = theProtoName + ";" + version + v.getAbbreviationExtension();
        if (version <= 1) {
            fullCellName = theProtoName + v.getAbbreviationExtension();
        }
        Date creationDate = ELIBConstants.secondsToDate(this.readBigInteger());
        Date revisionDate = ELIBConstants.secondsToDate(this.readBigInteger());
        int lowX = this.readBigInteger();
        int highX = this.readBigInteger();
        int lowY = this.readBigInteger();
        int highY = this.readBigInteger();
        Library elib = this.readExternalLibraryFromFilename(this.readString(), FileType.ELIB);
        int portCount = this.readBigInteger();
        String[] localPortNames = new String[portCount];
        for (int j = 0; j < portCount; ++j) {
            localPortNames[j] = this.readString();
        }
        Cell c = elib.findNodeProto(fullCellName);
        String dummyName = fullCellName;
        if (c == null) {
            c = elib.findNodeProto(dummyName);
        }
        if (c == null) {
            System.out.println("ERROR: Cannot find cell " + fullCellName + " in " + elib);
        }
        if (c != null && revisionDate.compareTo(c.getRevisionDate()) != 0) {
            System.out.println("Warning: cell " + c.noLibDescribe() + " in " + elib + " has changed since its use in " + lib);
        }
        if (c == null) {
            c = Cell.newInstance(elib, dummyName);
            if (c == null) {
                return true;
            }
            c.lowLevelSetCreationDate(creationDate);
            c.lowLevelSetRevisionDate(revisionDate);
            Technology tech = Technology.getMocmosTechnology();
            if (c.isIcon()) {
                tech = Artwork.tech;
            } else if (c.isSchematic()) {
                tech = Schematics.tech;
            }
            double lambda = this.getScale(tech);
            int cX = (lowX + highX) / 2;
            int cY = (lowY + highY) / 2;
            double width = (double)(highX - lowX) / lambda;
            double height = (double)(highY - lowY) / lambda;
            Point2D.Double center = new Point2D.Double((double)cX / lambda, (double)cY / lambda);
            NodeInst.newInstance(Generic.tech.drcNode, center, width, height, c);
            System.out.println("...Creating dummy cell '" + dummyName + "' in " + elib + ". Instances will be logged as Errors.");
            c.newVar(IO_TRUE_LIBRARY, (Object)elib.getName());
            c.newVar(IO_DUMMY_OBJECT, (Object)fullCellName);
        }
        this.nodeProtoList[cellIndex] = c;
        this.firstPortIndex[cellIndex] = this.exportIndex;
        if (portCount != this.portCounts[cellIndex]) {
            System.out.println("Error! Cell header lists " + this.portCounts[cellIndex] + " exports, but body lists " + portCount);
        }
        for (int j = 0; j < portCount; ++j) {
            String protoName = localPortNames[j];
            this.exportList[this.exportIndex] = c;
            this.exportNameList[this.exportIndex] = protoName;
            ++this.exportIndex;
        }
        return false;
    }

    private boolean readNodeInst(int nodeIndex, int cellIndex) throws IOException {
        String instName;
        int protoIndex = this.readBigInteger();
        NodeProto np = this.convertNodeProto(protoIndex);
        if (np == null) {
            return true;
        }
        this.nodeInstList.protoType[nodeIndex] = np;
        this.nodeInstList.lowX[nodeIndex] = this.readBigInteger();
        this.nodeInstList.lowY[nodeIndex] = this.readBigInteger();
        this.nodeInstList.highX[nodeIndex] = this.readBigInteger();
        this.nodeInstList.highY[nodeIndex] = this.readBigInteger();
        if (this.magic <= -1597 && np instanceof Cell) {
            this.nodeInstList.anchorX[nodeIndex] = this.readBigInteger();
            this.nodeInstList.anchorY[nodeIndex] = this.readBigInteger();
        }
        this.nodeInstList.transpose[nodeIndex] = this.readBigInteger();
        this.nodeInstList.rotation[nodeIndex] = (short)this.readBigInteger();
        this.nodeInstList.name[nodeIndex] = null;
        int descript0 = 0;
        int descript1 = 0;
        if (this.magic <= -1589) {
            if (this.convertTextDescriptors) {
                descript0 = this.readBigInteger();
            } else {
                descript0 = this.readBigInteger();
                descript1 = this.readBigInteger();
            }
        }
        this.nodeInstList.protoTextDescriptor[nodeIndex] = this.makeDescriptor(descript0, descript1);
        if (this.magic >= -1577 && (instName = this.readString()).length() > 0) {
            this.nodeInstList.name[nodeIndex] = instName;
        }
        if (this.magic > -1581) {
            this.readBigInteger();
        }
        int numPorts = this.readBigInteger();
        for (int j = 0; j < numPorts; ++j) {
            int k = this.readBigInteger();
            int arcIndex = k >> 1;
            if (k < 0 || arcIndex >= this.arcCount) {
                return true;
            }
            int portIndex = this.readBigInteger();
            if ((k & 1) == 0) {
                this.arcTailPortList[arcIndex] = portIndex;
            } else {
                this.arcHeadPortList[arcIndex] = portIndex;
            }
            this.readVariables();
        }
        int numExports = this.readBigInteger();
        for (int j = 0; j < numExports; ++j) {
            this.readBigInteger();
            this.readBigInteger();
            this.readVariables();
        }
        if (this.magic > -1589) {
            this.readBigInteger();
        }
        int userBits = 0;
        if (this.magic <= -1585) {
            userBits = this.readBigInteger();
        } else {
            if (this.toolBCount >= 1) {
                userBits = this.readBigInteger();
            }
            for (int i = 1; i < this.toolBCount; ++i) {
                this.readBigInteger();
            }
        }
        this.nodeInstList.userBits[nodeIndex] = userBits;
        Variable[] vars = this.readVariables();
        for (int j = 0; j < vars.length; ++j) {
            Object value;
            Variable var = vars[j];
            if (var == null || var.getKey() != NodeInst.NODE_NAME || !((value = var.getObject()) instanceof String)) continue;
            this.nodeInstList.name[nodeIndex] = ELIB.convertGeomName(value, var.isDisplay());
            this.nodeInstList.nameTextDescriptor[nodeIndex] = var.getTextDescriptor();
            vars[j] = null;
        }
        this.nodeInstList.vars[nodeIndex] = vars;
        return false;
    }

    private boolean readArcInst(int arcIndex) throws IOException {
        String instName;
        ArcProto ap;
        int protoIndex = this.readBigInteger();
        this.arcTypeList[arcIndex] = ap = this.convertArcProto(protoIndex);
        if (this.magic >= -1581) {
            this.readBigInteger();
        }
        this.arcWidthList[arcIndex] = this.readBigInteger();
        if (this.magic <= -1583 && this.magic >= -1587) {
            this.readBigInteger();
        }
        if (this.magic >= -1577 && (instName = this.readString()).length() > 0) {
            this.arcNameList[arcIndex] = instName;
        }
        this.arcTailXPosList[arcIndex] = this.readBigInteger();
        this.arcTailYPosList[arcIndex] = this.readBigInteger();
        int tailNodeIndex = this.readBigInteger();
        if (tailNodeIndex >= 0 && tailNodeIndex < this.nodeCount) {
            this.arcTailNodeList[arcIndex] = tailNodeIndex;
        }
        this.arcHeadXPosList[arcIndex] = this.readBigInteger();
        this.arcHeadYPosList[arcIndex] = this.readBigInteger();
        int headNodeIndex = this.readBigInteger();
        if (headNodeIndex >= 0 && headNodeIndex < this.nodeCount) {
            this.arcHeadNodeList[arcIndex] = headNodeIndex;
        }
        if (this.magic > -1581) {
            this.readBigInteger();
        }
        if (this.magic > -1589) {
            this.readBigInteger();
        }
        int userBits = 0;
        if (this.magic <= -1585) {
            userBits = this.readBigInteger();
            if (this.magic >= -1587) {
                this.readBigInteger();
            }
        } else {
            if (this.toolBCount >= 1) {
                userBits = this.readBigInteger();
            }
            for (int i = 1; i < this.toolBCount; ++i) {
                this.readBigInteger();
            }
        }
        this.arcUserBits[arcIndex] = userBits;
        Variable[] vars = this.readVariables();
        for (int i = 0; i < vars.length; ++i) {
            Object value;
            Variable var = vars[i];
            if (var == null || var.getKey() != ArcInst.ARC_NAME || !((value = var.getObject()) instanceof String)) continue;
            this.arcNameList[arcIndex] = ELIB.convertGeomName(value, var.isDisplay());
            this.arcNameDescriptorList[arcIndex] = var.getTextDescriptor();
            vars[i] = null;
        }
        this.arcVariables[arcIndex] = vars;
        return false;
    }

    private void readGeom(boolean[] isNode, int[] moreup, int index) throws IOException {
        int type = this.readBigInteger();
        isNode[index] = type != 0;
        if (isNode[index]) {
            this.readBigInteger();
        }
        this.readBigInteger();
        this.readBigInteger();
        this.readBigInteger();
        this.readBigInteger();
        this.readBigInteger();
        this.readBigInteger();
        this.readBigInteger();
        this.readBigInteger();
        moreup[index] = this.readBigInteger();
        this.readBigInteger();
        this.readBigInteger();
        this.readBigInteger();
        this.readVariables();
    }

    private void readNameSpace() throws IOException {
        int nameCount = this.readBigInteger();
        this.varNames = new String[nameCount];
        this.varKeys = new Variable.Key[nameCount];
        for (int i = 0; i < nameCount; ++i) {
            this.varNames[i] = this.readString();
        }
    }

    private void fixExternalVariables(ElectricObject obj) {
    }

    private Variable[] readVariables() throws IOException {
        int count = this.readBigInteger();
        if (count == 0) {
            return Variable.NULL_ARRAY;
        }
        Variable[] vars = new Variable[count];
        for (int i = 0; i < count; ++i) {
            NodeProtoId[] newAddr;
            short key = this.readSmallInteger();
            if (key < 0 || key >= this.varKeys.length) {
                String msg = "Bad variable index (" + key + ", limit is " + this.varKeys.length + ")";
                System.out.println(msg);
                throw new IOException(msg);
            }
            if (this.varKeys[key] == null) {
                this.varKeys[key] = Variable.newKey(this.varNames[key]);
            }
            int newtype = this.readBigInteger();
            int descript0 = 0;
            int descript1 = 0;
            if (this.magic <= -1589) {
                if (this.alwaysTextDescriptors) {
                    descript0 = this.readBigInteger();
                    descript1 = this.readBigInteger();
                } else if ((newtype & 0x40) != 0) {
                    if (this.convertTextDescriptors) {
                        descript0 = this.readBigInteger();
                    } else {
                        descript0 = this.readBigInteger();
                        descript1 = this.readBigInteger();
                    }
                }
            }
            TextDescriptor td = this.makeDescriptor(descript0, descript1, newtype);
            if ((newtype & 0x80) != 0) {
                int j;
                int len;
                int cou = len = this.readBigInteger();
                if ((newtype & 0x1FFFFE00) == 0) {
                    ++cou;
                }
                Object[] newAddrArray = null;
                switch (newtype & 0x1F) {
                    case 1: 
                    case 2: {
                        newAddrArray = new Integer[cou];
                        break;
                    }
                    case 5: 
                    case 19: {
                        newAddrArray = new Float[cou];
                        break;
                    }
                    case 6: {
                        newAddrArray = new Double[cou];
                        break;
                    }
                    case 25: {
                        newAddrArray = new Short[cou];
                        break;
                    }
                    case 30: {
                        newAddrArray = new Boolean[cou];
                        break;
                    }
                    case 3: {
                        newAddrArray = new Byte[cou];
                        break;
                    }
                    case 4: {
                        newAddrArray = new String[cou];
                        break;
                    }
                    case 8: {
                        newAddrArray = new NodeProtoId[cou];
                        break;
                    }
                    case 13: {
                        newAddrArray = new ArcProto[cou];
                        break;
                    }
                    case 11: {
                        newAddrArray = new ExportId[cou];
                        break;
                    }
                    case 16: {
                        newAddrArray = new TechId[cou];
                        break;
                    }
                    case 15: {
                        newAddrArray = new LibId[cou];
                        break;
                    }
                    case 17: {
                        newAddrArray = new Tool[cou];
                    }
                }
                newAddr = newAddrArray;
                if ((newtype & 0x1F) == 27) {
                    for (j = 0; j < len; j += 2) {
                        this.readBigInteger();
                        this.readBigInteger();
                        if (newAddrArray == null) continue;
                        newAddrArray[j] = null;
                    }
                } else {
                    for (j = 0; j < len; ++j) {
                        Object ret = this.getInVar(newtype);
                        if (newAddrArray == null) continue;
                        newAddrArray[j] = ret;
                    }
                }
                if (newAddrArray == null) {
                    String msg = "Cannot figure out the type for code " + (newtype & 0x1F);
                    System.out.println(msg);
                    continue;
                }
                if (newAddrArray instanceof NodeProtoId[]) {
                    int j2;
                    int numCells = 0;
                    int numPrims = 0;
                    for (int j3 = 0; j3 < newAddrArray.length; ++j3) {
                        if (newAddrArray[j3] == null) continue;
                        if (newAddrArray[j3] instanceof CellId) {
                            ++numCells;
                        }
                        if (!(newAddrArray[j3] instanceof PrimitiveNode)) continue;
                        ++numPrims;
                    }
                    if (numCells >= numPrims) {
                        CellId[] cellArray = new CellId[newAddrArray.length];
                        for (j2 = 0; j2 < cellArray.length; ++j2) {
                            if (!(newAddrArray[j2] instanceof CellId)) continue;
                            cellArray[j2] = (CellId)newAddrArray[j2];
                        }
                        newAddr = cellArray;
                    } else {
                        PrimitiveNode[] primArray = new PrimitiveNode[newAddrArray.length];
                        for (j2 = 0; j2 < primArray.length; ++j2) {
                            if (!(newAddrArray[j2] instanceof PrimitiveNode)) continue;
                            primArray[j2] = (PrimitiveNode)newAddrArray[j2];
                        }
                        newAddr = primArray;
                    }
                }
            } else {
                newAddr = this.getInVar(newtype);
            }
            if (newAddr == null) {
                System.out.println("Error reading variable " + this.varNames[key] + " type " + newtype);
                continue;
            }
            vars[i] = Variable.newInstance(this.varKeys[key], newAddr, td);
        }
        return vars;
    }

    private Object getInVar(int ty) throws IOException {
        if ((ty & 0x20000020) != 0) {
            ty = 4;
        }
        switch (ty & 0x1F) {
            case 1: 
            case 2: {
                return new Integer(this.readBigInteger());
            }
            case 19: {
                return new Float((float)this.readBigInteger() / 120.0f);
            }
            case 5: {
                return new Float(this.readFloat());
            }
            case 6: {
                return new Double(this.readDouble());
            }
            case 25: {
                return new Short(this.readSmallInteger());
            }
            case 30: {
                return new Boolean(this.readByte() != 0);
            }
            case 3: {
                return new Byte(this.readByte());
            }
            case 4: {
                return this.readString();
            }
            case 7: {
                int i = this.readBigInteger();
                System.out.println("Cannot read variable of type NodeInst");
                return null;
            }
            case 8: {
                int i = this.readBigInteger();
                NodeProto np = this.convertNodeProto(i);
                return np instanceof Cell ? ((Cell)np).getId() : (PrimitiveNode)np;
            }
            case 13: {
                int i = this.readBigInteger();
                return this.convertArcProto(i);
            }
            case 11: {
                int i = this.readBigInteger();
                PortProto pp = this.convertPortProto(i);
                if (!(pp instanceof Export)) {
                    return null;
                }
                return ((Export)pp).getId();
            }
            case 12: {
                int i = this.readBigInteger();
                System.out.println("Cannot read variable of type ArcInst");
                return null;
            }
            case 14: {
                this.readBigInteger();
                this.readBigInteger();
                System.out.println("Cannot read variable of type Geometric");
                return null;
            }
            case 16: {
                int i = this.readBigInteger();
                if (i == -1) {
                    System.out.println("Variable of type Technology has negative index");
                    return null;
                }
                return this.idManager.newTechId(this.getTechList(i).getTechName());
            }
            case 9: {
                this.readBigInteger();
                System.out.println("Cannot read variable of type PortArcInst");
                return null;
            }
            case 10: {
                this.readBigInteger();
                System.out.println("Cannot read variable of type PortExpInst");
                return null;
            }
            case 15: {
                String libName = this.readString();
                if (libName.length() == 0) {
                    return null;
                }
                return this.idManager.newLibId(libName);
            }
            case 17: {
                int i = this.readBigInteger();
                if (i < 0 || i >= this.toolCount) {
                    return null;
                }
                Tool tool = this.toolList[i];
                if (tool == null && this.toolError[i = 0] != null) {
                    System.out.println("WARNING: no tool called '" + this.toolError[i] + "', using 'user'");
                    this.toolError[i] = null;
                }
                return tool;
            }
            case 18: {
                this.readBigInteger();
                System.out.println("Cannot read variable of type RTNode");
                return null;
            }
        }
        System.out.println("Cannot read variable of type " + (ty & 0x1F));
        return null;
    }

    private NodeProto convertNodeProto(int i) {
        if (i == -1) {
            return null;
        }
        if (i < 0) {
            int nindex = -i - 2;
            if (nindex >= this.primNodeProtoCount) {
                System.out.println("Error: want primitive node index " + nindex + " when limit is " + this.primNodeProtoCount);
                return null;
            }
            return this.getPrimNodeProtoList(nindex);
        }
        if (i >= this.nodeProtoCount) {
            System.out.println("Error: want cell index " + i + " when limit is " + this.nodeProtoCount);
            return null;
        }
        return this.nodeProtoList[i];
    }

    private ArcProto convertArcProto(int i) {
        int aindex = -i - 2;
        if (aindex >= this.arcProtoCount || aindex < 0) {
            System.out.println("Want primitive arc index " + aindex + " when range is 0 to " + this.arcProtoCount);
            aindex = 0;
        }
        return this.getArcProtoList(aindex);
    }

    private PortProto convertPortProto(int i) {
        if (i < 0) {
            int pindex = -i - 2;
            if (pindex >= this.primPortProtoCount) {
                System.out.println("Error: want primitive port index " + pindex + " when limit is " + this.primPortProtoCount);
                pindex = 0;
            }
            return this.getPrimPortProtoList(pindex);
        }
        if (i >= this.exportCount) {
            System.out.println("Error: want port index " + i + " when limit is " + this.exportCount);
            i = 0;
        }
        if (this.exportList[i] instanceof Cell) {
            return null;
        }
        return (Export)this.exportList[i];
    }

    private NodeProto getPrimNodeProtoList(int i) {
        this.getTechList(this.primNodeProtoTech[i]);
        if (this.primNodeProtoError[i]) {
            System.out.println("Cannot find primitive '" + this.primNodeProtoOrig[i] + "', using " + this.primNodeProtoList[i].getName());
            this.primNodeProtoError[i] = false;
        }
        return this.primNodeProtoList[i];
    }

    private ArcProto getArcProtoList(int i) {
        if (this.arcProtoError[i] != null) {
            System.out.println("Cannot find arc '" + this.arcProtoError[i] + "', using " + this.arcProtoList[i].getName());
            this.arcProtoError[i] = null;
        }
        return this.arcProtoList[i];
    }

    private PortProto getPrimPortProtoList(int i) {
        if (this.primPortProtoError[i] != null) {
            System.out.println("WARNING: port " + this.primPortProtoError[i] + " not found, using " + this.primPortProtoList[i].getName());
            this.primPortProtoError[i] = null;
        }
        return this.primPortProtoList[i];
    }

    private Technology getTechList(int i) {
        if (this.techError[i] != null) {
            System.out.println("WARNING: technology '" + this.techError[i] + "' does not exist, using '" + this.techList[i].getTechName() + "'");
            this.techError[i] = null;
        }
        return this.techList[i];
    }

    private View getView(int i) {
        View v = this.viewMapping.get(new Integer(i));
        return v;
    }

    private byte readByte() throws IOException {
        int value = this.dataInputStream.read();
        if (value == -1) {
            throw new IOException();
        }
        this.updateProgressDialog(1);
        return (byte)value;
    }

    private int readBigInteger() throws IOException {
        if (this.sizeOfBig == 4) {
            this.updateProgressDialog(4);
            int data = this.dataInputStream.readInt();
            if (!this.bytesSwapped) {
                data = data >> 24 & 0xFF | data >> 8 & 0xFF00 | (data & 0xFF00) << 8 | (data & 0xFF) << 24;
            }
            return data;
        }
        this.readBytes(rawData, this.sizeOfBig, 4, true);
        if (this.bytesSwapped) {
            bb.put(0, rawData[0]);
            bb.put(1, rawData[1]);
            bb.put(2, rawData[2]);
            bb.put(3, rawData[3]);
        } else {
            bb.put(0, rawData[3]);
            bb.put(1, rawData[2]);
            bb.put(2, rawData[1]);
            bb.put(3, rawData[0]);
        }
        return bb.getInt(0);
    }

    private float readFloat() throws IOException {
        if (this.bytesSwapped) {
            this.updateProgressDialog(4);
            return this.dataInputStream.readFloat();
        }
        this.readBytes(rawData, this.sizeOfBig, 4, true);
        bb.put(0, rawData[3]);
        bb.put(1, rawData[2]);
        bb.put(2, rawData[1]);
        bb.put(3, rawData[0]);
        return bb.getFloat(0);
    }

    private double readDouble() throws IOException {
        if (this.bytesSwapped) {
            this.updateProgressDialog(8);
            return this.dataInputStream.readDouble();
        }
        this.readBytes(rawData, this.sizeOfBig, 8, true);
        bb.put(0, rawData[7]);
        bb.put(1, rawData[2]);
        bb.put(2, rawData[3]);
        bb.put(3, rawData[4]);
        bb.put(4, rawData[3]);
        bb.put(5, rawData[2]);
        bb.put(6, rawData[1]);
        bb.put(7, rawData[0]);
        return bb.getDouble(0);
    }

    private short readSmallInteger() throws IOException {
        if (this.sizeOfSmall == 2) {
            this.updateProgressDialog(2);
            int data = this.dataInputStream.readShort();
            if (!this.bytesSwapped) {
                data = data >> 8 & 0xFF | (data & 0xFF) << 8;
            }
            return (short)data;
        }
        this.readBytes(rawData, this.sizeOfSmall, 2, true);
        if (this.bytesSwapped) {
            bb.put(0, rawData[0]);
            bb.put(1, rawData[1]);
        } else {
            bb.put(0, rawData[1]);
            bb.put(1, rawData[0]);
        }
        return bb.getShort(0);
    }

    private String readString() throws IOException {
        if (this.sizeOfChar != 1) {
            System.out.println("Cannot handle library files with unicode strings");
            return null;
        }
        int len = this.readBigInteger();
        if (len <= 0) {
            return "";
        }
        if ((long)len > this.fileLength - this.byteCount) {
            System.out.println("Corrupt ELIB file requests string that is " + len + " long");
            throw new IOException();
        }
        byte[] stringBytes = new byte[len];
        int ret = this.dataInputStream.read(stringBytes, 0, len);
        if (ret != len) {
            throw new IOException();
        }
        this.updateProgressDialog(len);
        String theString = new String(stringBytes);
        return theString;
    }

    private void readBytes(byte[] data, int diskSize, int memorySize, boolean signExtend) throws IOException {
        if (diskSize == memorySize) {
            int ret = this.dataInputStream.read(data, 0, diskSize);
            if (ret != diskSize) {
                throw new IOException();
            }
        } else {
            int ret = this.dataInputStream.read(rawData, 0, diskSize);
            if (ret != diskSize) {
                throw new IOException();
            }
            if (diskSize > memorySize) {
                int i;
                for (i = 0; i < memorySize; ++i) {
                    data[i] = rawData[i];
                }
                for (i = memorySize; i < diskSize; ++i) {
                    if (rawData[i] == 0 || rawData[i] == 255) continue;
                    ++this.clippedIntegers;
                }
            } else {
                int i;
                if (!signExtend || (rawData[diskSize - 1] & 0x80) == 0) {
                    for (i = diskSize; i < memorySize; ++i) {
                        ELIB.rawData[i] = 0;
                    }
                } else {
                    for (i = diskSize; i < memorySize; ++i) {
                        ELIB.rawData[i] = -1;
                    }
                }
                for (i = 0; i < memorySize; ++i) {
                    data[i] = rawData[i];
                }
            }
        }
        this.updateProgressDialog(diskSize);
    }

    private static class FakeCell {
        String cellName;
        NodeProto firstInCell;

        private FakeCell() {
        }
    }
}

