/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.variable;

import com.sun.electric.database.CellId;
import com.sun.electric.database.ExportId;
import com.sun.electric.database.IdMapper;
import com.sun.electric.database.LibId;
import com.sun.electric.database.SnapshotReader;
import com.sun.electric.database.SnapshotWriter;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.EditWindow0;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.user.ActivityLogger;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;

public class Variable
implements Serializable {
    private static final HashMap<String, Key> varKeys = new HashMap();
    private static final HashMap<String, Key> varCanonicKeys = new HashMap();
    public static final Variable[] NULL_ARRAY = new Variable[0];
    private static final byte ARRAY = 1;
    private static final byte LIBRARY = 2;
    private static final byte CELL = 4;
    private static final byte EXPORT = 6;
    private static final byte STRING = 8;
    private static final byte DOUBLE = 10;
    private static final byte FLOAT = 12;
    private static final byte LONG = 14;
    private static final byte INTEGER = 16;
    private static final byte SHORT = 18;
    private static final byte BYTE = 20;
    private static final byte BOOLEAN = 22;
    private static final byte EPOINT = 24;
    private static final byte TOOL = 26;
    private static final byte TECHNOLOGY = 28;
    private static final byte PRIM_NODE = 30;
    private static final byte ARC_PROTO = 32;
    private static final HashMap<Class, Byte> validClasses = new HashMap();
    private final Key key;
    private final Object value;
    private final TextDescriptor descriptor;
    private final byte type;

    public static synchronized Key findKey(String name) {
        Key key = varKeys.get(name);
        if (key != null) {
            return key;
        }
        if (varKeys.containsKey(name)) {
            return null;
        }
        name = name.intern();
        varKeys.put(name, null);
        String canonicName = TextUtils.canonicString(name);
        key = varCanonicKeys.get(canonicName);
        if (key != null) {
            String msg = "WARNING: Variable \"" + name + "\" not found though variable \"" + key.getName() + "\" exists";
            ActivityLogger.logMessage(msg);
            System.out.println(msg);
        }
        return null;
    }

    public static synchronized Key newKey(String name) {
        return Variable.newKey(name, null);
    }

    public static synchronized Key newKey(String name, ElectricObject parent) {
        Key key = varKeys.get(name);
        if (key != null) {
            return key;
        }
        name = name.intern();
        key = new Key(name);
        varKeys.put(name, key);
        String canonicName = TextUtils.canonicString(name);
        Key key2 = varCanonicKeys.get(canonicName);
        if (key2 != null) {
            String ex = null;
            for (Library lib : Library.getVisibleLibraries()) {
                if (ex == null) {
                    ex = Variable.findVariable(lib, key2);
                }
                Iterator<Cell> cIt = lib.getCells();
                while (cIt.hasNext()) {
                    Cell cell = cIt.next();
                    if (ex == null) {
                        ex = Variable.findVariable(cell, key2);
                    }
                    Iterator<NodeInst> nIt = cell.getNodes();
                    while (nIt.hasNext()) {
                        NodeInst ni = nIt.next();
                        if (ex != null) continue;
                        ex = Variable.findVariable(ni, key2);
                    }
                    Iterator<ArcInst> aIt = cell.getArcs();
                    while (aIt.hasNext()) {
                        ArcInst ai = aIt.next();
                        if (ex != null) continue;
                        ex = Variable.findVariable(ai, key2);
                    }
                    Iterator<Export> eIt = cell.getExports();
                    while (eIt.hasNext()) {
                        Export e = eIt.next();
                        if (ex != null) continue;
                        ex = Variable.findVariable(e, key2);
                    }
                }
            }
            String msg = "WARNING: Variables with similar names are used: \"" + name + "\"";
            if (parent != null) {
                msg = msg + " (on " + Variable.getObjectName(parent) + ")";
            }
            msg = msg + " and \"" + key2.getName() + "\"";
            if (ex != null) {
                msg = msg + " (on " + ex + ")";
            }
            ActivityLogger.logMessage(msg);
            System.out.println(msg);
        } else {
            varCanonicKeys.put(canonicName.intern(), key);
        }
        return key;
    }

    private static String findVariable(ElectricObject eObj, Key key) {
        Iterator<Variable> it = eObj.getVariables();
        while (it.hasNext()) {
            Variable var = it.next();
            if (var.getKey() != key) continue;
            return Variable.getObjectName(eObj);
        }
        return null;
    }

    private static String getObjectName(ElectricObject eObj) {
        if (eObj instanceof Library) {
            return "Library " + ((Library)eObj).getName();
        }
        if (eObj instanceof Cell) {
            return "Cell " + ((Cell)eObj).describe(false);
        }
        if (eObj instanceof Export) {
            return "Export " + ((Export)eObj).getName() + " in Cell " + ((Export)eObj).getParent().describe(false);
        }
        if (eObj instanceof NodeInst) {
            return "Node " + ((NodeInst)eObj).describe(false) + " in Cell " + ((NodeInst)eObj).getParent().describe(false);
        }
        if (eObj instanceof ArcInst) {
            return "Arc " + ((ArcInst)eObj).describe(false) + " in Cell " + ((ArcInst)eObj).getParent().describe(false);
        }
        return eObj.toString();
    }

    private Variable(Key key, Object value, TextDescriptor descriptor, byte type) {
        this.key = key;
        this.value = value;
        this.descriptor = descriptor;
        this.type = type;
        this.check(true);
    }

    public static Variable newInstance(Key key, Object value, TextDescriptor descriptor) {
        byte type;
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (descriptor == null) {
            throw new NullPointerException("descriptor");
        }
        if (descriptor.isCode() && !(value instanceof String) && !(value instanceof String[])) {
            value = value.toString();
        }
        if (value instanceof Object[]) {
            Byte typeByte = validClasses.get(value.getClass().getComponentType());
            if (typeByte == null) {
                throw new IllegalArgumentException(value.getClass().toString());
            }
            value = ((Object[])value).clone();
            type = (byte)(typeByte | 1);
            if (!Variable.validValue(type, value)) {
                throw new IllegalArgumentException(value.toString());
            }
        } else {
            Byte typeByte = validClasses.get(value.getClass());
            if (typeByte == null) {
                throw new IllegalArgumentException(value.getClass().toString());
            }
            type = typeByte;
        }
        return new Variable(key, value, descriptor, type);
    }

    public void check(boolean paramAllowed) {
        assert (this.key != null);
        assert (this.value != null);
        if (this.value instanceof Object[]) {
            Byte typeByte = validClasses.get(this.value.getClass().getComponentType());
            assert (this.type == (byte)(typeByte | 1));
            assert (Variable.validValue(this.type, this.value));
        } else {
            Byte typeByte = validClasses.get(this.value.getClass());
            assert (this.type == typeByte);
        }
        assert (this.descriptor != null);
        if (this.descriptor.isCode()) assert (this.value instanceof String || this.value instanceof String[]);
        if (!paramAllowed) assert (!this.descriptor.isParam());
    }

    private static boolean validValue(byte type, Object value) {
        if ((type & 1) == 0) {
            return value != null;
        }
        type = (byte)(type & 0xFFFFFFFE);
        Object[] valueArr = (Object[])value;
        if (type >= 8 && type <= 24) {
            for (Object o : valueArr) {
                if (o != null) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isArray() {
        return (this.type & 1) != 0;
    }

    public boolean hasReferences() {
        return this.type < 8;
    }

    public int getLength() {
        return (this.type & 1) != 0 ? ((Object[])this.value).length : 1;
    }

    public Object getObject() {
        return (this.type & 1) != 0 ? ((Object[])this.value).clone() : this.value;
    }

    public void write(SnapshotWriter writer) throws IOException {
        writer.writeVariableKey(this.key);
        writer.writeTextDescriptor(this.descriptor);
        writer.writeByte(this.type);
        if (this.isArray()) {
            int length = this.getLength();
            writer.writeInt(length);
            for (int i = 0; i < length; ++i) {
                Object obj = this.getObject(i);
                writer.writeBoolean(obj != null);
                if (obj == null) continue;
                this.writeObj(writer, obj);
            }
        } else {
            this.writeObj(writer, this.getObject());
        }
    }

    private void writeObj(SnapshotWriter writer, Object obj) throws IOException {
        switch (this.type & 0xFFFFFFFE) {
            case 2: {
                writer.writeLibId((LibId)obj);
                break;
            }
            case 4: {
                writer.writeNodeProtoId((CellId)obj);
                break;
            }
            case 6: {
                writer.writePortProtoId((ExportId)obj);
                break;
            }
            case 8: {
                writer.writeString((String)obj);
                break;
            }
            case 10: {
                writer.writeDouble((Double)obj);
                break;
            }
            case 12: {
                writer.writeFloat(((Float)obj).floatValue());
                break;
            }
            case 14: {
                writer.writeLong((Long)obj);
                break;
            }
            case 16: {
                writer.writeInt((Integer)obj);
                break;
            }
            case 18: {
                writer.writeShort((Short)obj);
                break;
            }
            case 20: {
                writer.writeByte((Byte)obj);
                break;
            }
            case 22: {
                writer.writeBoolean((Boolean)obj);
                break;
            }
            case 24: {
                writer.writePoint((EPoint)obj);
                break;
            }
            case 26: {
                writer.writeTool((Tool)obj);
                break;
            }
            case 28: {
                writer.writeTechnology((Technology)obj);
                break;
            }
            case 30: {
                writer.writeNodeProtoId((PrimitiveNode)obj);
                break;
            }
            case 32: {
                writer.writeArcProto((ArcProto)obj);
            }
        }
    }

    public static Variable read(SnapshotReader reader) throws IOException {
        Object[] value;
        Key varKey = reader.readVariableKey();
        TextDescriptor td = reader.readTextDescriptor();
        int type = reader.readByte();
        if ((type & 1) != 0) {
            Object[] array;
            int length = reader.readInt();
            switch (type &= 0xFFFFFFFE) {
                case 2: {
                    array = new LibId[length];
                    break;
                }
                case 4: {
                    array = new CellId[length];
                    break;
                }
                case 6: {
                    array = new ExportId[length];
                    break;
                }
                case 8: {
                    array = new String[length];
                    break;
                }
                case 10: {
                    array = new Double[length];
                    break;
                }
                case 12: {
                    array = new Float[length];
                    break;
                }
                case 14: {
                    array = new Long[length];
                    break;
                }
                case 16: {
                    array = new Integer[length];
                    break;
                }
                case 18: {
                    array = new Short[length];
                    break;
                }
                case 20: {
                    array = new Byte[length];
                    break;
                }
                case 22: {
                    array = new Boolean[length];
                    break;
                }
                case 24: {
                    array = new EPoint[length];
                    break;
                }
                case 26: {
                    array = new Tool[length];
                    break;
                }
                case 28: {
                    array = new Technology[length];
                    break;
                }
                case 30: {
                    array = new PrimitiveNode[length];
                    break;
                }
                case 32: {
                    array = new ArcProto[length];
                    break;
                }
                default: {
                    throw new IOException("type");
                }
            }
            for (int i = 0; i < length; ++i) {
                boolean hasElem = reader.readBoolean();
                if (!hasElem) continue;
                array[i] = Variable.readObj(reader, type);
            }
            value = array;
        } else {
            value = Variable.readObj(reader, type);
        }
        return Variable.newInstance(varKey, value, td);
    }

    private static Object readObj(SnapshotReader reader, int type) throws IOException {
        switch (type) {
            case 2: {
                return reader.readLibId();
            }
            case 4: {
                return reader.readNodeProtoId();
            }
            case 6: {
                return reader.readPortProtoId();
            }
            case 8: {
                return reader.readString();
            }
            case 10: {
                return reader.readDouble();
            }
            case 12: {
                return Float.valueOf(reader.readFloat());
            }
            case 14: {
                return reader.readLong();
            }
            case 16: {
                return reader.readInt();
            }
            case 18: {
                return reader.readShort();
            }
            case 20: {
                return reader.readByte();
            }
            case 22: {
                return reader.readBoolean();
            }
            case 24: {
                return reader.readPoint();
            }
            case 26: {
                return reader.readTool();
            }
            case 28: {
                return reader.readTechnology();
            }
            case 30: {
                return reader.readNodeProtoId();
            }
            case 32: {
                return reader.readArcProto();
            }
        }
        throw new IllegalArgumentException();
    }

    public Variable withObject(Object value) {
        if (this.value.equals(value)) {
            return this;
        }
        if ((this.type & 1) != 0 && value instanceof Object[] && Arrays.equals((Object[])this.value, (Object[])value) && this.value.getClass().getComponentType() == value.getClass().getComponentType()) {
            return this;
        }
        return Variable.newInstance(this.key, value, this.descriptor);
    }

    public Variable withRenamedIds(IdMapper idMapper) {
        Serializable[] newValue = this.value;
        switch (this.type) {
            case 2: {
                newValue = idMapper.get((LibId)this.value);
                break;
            }
            case 4: {
                newValue = idMapper.get((CellId)this.value);
                break;
            }
            case 6: {
                newValue = idMapper.get((ExportId)this.value);
                break;
            }
            case 3: {
                LibId[] libIds = (LibId[])this.getObject();
                for (int i = 0; i < libIds.length; ++i) {
                    LibId libId;
                    if (libIds[i] == null || (libId = idMapper.get(libIds[i])) == libIds[i]) continue;
                    libIds[i] = libId;
                    newValue = libIds;
                }
                break;
            }
            case 5: {
                CellId[] cellIds = (CellId[])this.getObject();
                for (int i = 0; i < cellIds.length; ++i) {
                    CellId cellId;
                    if (cellIds[i] == null || (cellId = idMapper.get(cellIds[i])) == cellIds[i]) continue;
                    cellIds[i] = cellId;
                    newValue = cellIds;
                }
                break;
            }
            case 7: {
                ExportId[] exportIds = (ExportId[])this.getObject();
                for (int i = 0; i < exportIds.length; ++i) {
                    ExportId exportId;
                    if (exportIds[i] == null || (exportId = idMapper.get(exportIds[i])) == exportIds[i]) continue;
                    exportIds[i] = exportId;
                    newValue = exportIds;
                }
                break;
            }
        }
        return newValue != this.value ? this.withObject(newValue) : this;
    }

    public Object getObject(int index) {
        if ((this.type & 1) == 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return ((Object[])this.value)[index];
    }

    public Key getKey() {
        return this.key;
    }

    public boolean isLinked(ElectricObject owner) {
        return owner.isLinked() && owner.getVar(this.getKey()) == this;
    }

    public String getReadableName(ElectricObject owner) {
        String betterName;
        String trueName = "";
        String name = this.getKey().getName();
        trueName = name.startsWith("ATTR_") ? (owner.isParam(this.getKey()) ? trueName + "Parameter '" + name.substring(5) + "'" : trueName + "Attribute '" + name.substring(5) + "'") : ((betterName = Variable.betterVariableName(name)) != null ? trueName + betterName : trueName + "Variable '" + name + "'");
        return trueName;
    }

    public String getFullDescription(ElectricObject eobj) {
        String trueName = this.getReadableName(eobj);
        String description = null;
        if (eobj instanceof Export) {
            description = trueName + " on " + eobj;
        } else if (eobj instanceof PortInst) {
            PortInst pi = (PortInst)eobj;
            description = trueName + " on " + pi.getPortProto() + " of " + pi.getNodeInst().describe(true);
        } else if (eobj instanceof ArcInst) {
            description = trueName + " on " + eobj;
        } else if (eobj instanceof NodeInst) {
            String varName;
            String betterName;
            NodeInst ni = (NodeInst)eobj;
            description = trueName + " on " + ni;
            if (ni.getProto() == Generic.tech.invisiblePinNode && (betterName = Variable.betterVariableName(varName = this.getKey().getName())) != null) {
                description = betterName;
            }
        } else if (eobj instanceof Cell) {
            description = trueName + " of " + eobj;
        }
        return description;
    }

    public static String betterVariableName(String name) {
        if (name.equals("ARC_name")) {
            return "Arc Name";
        }
        if (name.equals("ARC_radius")) {
            return "Arc Radius";
        }
        if (name.equals("ART_color")) {
            return "Color";
        }
        if (name.equals("ART_degrees")) {
            return "Number of Degrees";
        }
        if (name.equals("ART_message")) {
            return "Annotation text";
        }
        if (name.equals("NET_ncc_match")) {
            return "NCC equivalence";
        }
        if (name.equals("NET_ncc_forcedassociation")) {
            return "NCC association";
        }
        if (name.equals("NODE_name")) {
            return "Node Name";
        }
        if (name.equals("SCHEM_capacitance")) {
            return "Capacitance";
        }
        if (name.equals("SCHEM_diode")) {
            return "Diode Size";
        }
        if (name.equals("SCHEM_global_name")) {
            return "Global Signal Name";
        }
        if (name.equals("SCHEM_inductance")) {
            return "Inductance";
        }
        if (name.equals("SCHEM_resistance")) {
            return "Resistance";
        }
        if (name.equals("SIM_fall_delay")) {
            return "Fall Delay";
        }
        if (name.equals("SIM_fasthenry_group_name")) {
            return "FastHenry Group";
        }
        if (name.equals("SIM_rise_delay")) {
            return "Rise Delay";
        }
        if (name.equals("SIM_spice_card")) {
            return "SPICE code";
        }
        if (name.equals("SIM_spice_declaration")) {
            return "SPICE declaration";
        }
        if (name.equals("SIM_spice_model")) {
            return "SPICE model";
        }
        if (name.equals("SIM_verilog_wire_type")) {
            return "Verilog Wire type";
        }
        if (name.equals("SIM_weak_node")) {
            return "Transistor Strength";
        }
        if (name.equals("transistor_width")) {
            return "Transistor Width";
        }
        if (name.equals("VERILOG_code")) {
            return "Verilog code";
        }
        if (name.equals("VERILOG_declaration")) {
            return "Verilog declaration";
        }
        return null;
    }

    public String getTrueName() {
        String name = this.getKey().getName();
        if (name.startsWith("ATTR_")) {
            return name.substring(5);
        }
        if (name.startsWith("ATTRP_")) {
            int i = name.lastIndexOf(95);
            return name.substring(i);
        }
        return name;
    }

    public String describe(VarContext context, Object eobj) {
        return this.describe(-1, context, eobj);
    }

    public String describe(int aindex) {
        return this.describe(aindex, VarContext.globalContext, null);
    }

    public String describe(int aindex, VarContext context, Object eobj) {
        AbstractTextDescriptor.Unit units = this.getUnit();
        StringBuffer returnVal = new StringBuffer();
        AbstractTextDescriptor.DispPos dispPos = this.getDispPart();
        if (this.isCode()) {
            if (context == null) {
                context = VarContext.globalContext;
            }
            Object val = null;
            try {
                val = context.evalVarRecurse(this, eobj);
            }
            catch (VarContext.EvalException e) {
                VarContext.printException(e, this, context, eobj);
                val = e.getMessage();
            }
            if (val == null) {
                val = "?";
            }
            returnVal.append(this.makeStringVar(val, units));
        } else {
            returnVal.append(this.getPureValue(aindex));
        }
        if (dispPos == AbstractTextDescriptor.DispPos.NAMEVALUE && (aindex < 0 || this.getLength() == 1)) {
            return this.getTrueName() + "=" + returnVal;
        }
        return returnVal.toString();
    }

    public String getPureValue(int aindex) {
        AbstractTextDescriptor.Unit units = this.getUnit();
        StringBuffer returnVal = new StringBuffer();
        Object thisAddr = this.getObject();
        if (thisAddr instanceof Object[]) {
            Object[] addrArray = (Object[])thisAddr;
            int len = addrArray.length;
            if (aindex >= 0) {
                if (aindex < len) {
                    returnVal.append(this.makeStringVar(addrArray[aindex], units));
                }
            } else {
                if (len > 1) {
                    returnVal.append("[");
                }
                for (int i = 0; i < len; ++i) {
                    if (i != 0) {
                        returnVal.append(",");
                    }
                    returnVal.append(this.makeStringVar(addrArray[i], units));
                }
                if (len > 1) {
                    returnVal.append("]");
                }
            }
        } else {
            returnVal.append(this.makeStringVar(thisAddr, units));
        }
        return returnVal.toString();
    }

    private String makeStringVar(Object addr, AbstractTextDescriptor.Unit units) {
        if (addr instanceof Integer) {
            return ((Integer)addr).toString();
        }
        if (addr instanceof Float) {
            return TextUtils.makeUnits(((Float)addr).floatValue(), units);
        }
        if (addr instanceof Double) {
            return TextUtils.makeUnits((Double)addr, units);
        }
        if (addr instanceof Short) {
            return ((Short)addr).toString();
        }
        if (addr instanceof Byte) {
            return ((Byte)addr).toString();
        }
        if (addr instanceof String) {
            return (String)addr;
        }
        if (addr instanceof Object[]) {
            StringBuffer buf = new StringBuffer();
            buf.append("[");
            Object[] objects = (Object[])addr;
            for (int i = 0; i < objects.length; ++i) {
                buf.append(this.makeStringVar(objects[i], units));
                buf.append(", ");
            }
            buf.replace(buf.length() - 2, buf.length(), "]");
            return buf.toString();
        }
        return "?";
    }

    public boolean compare(Object obj, StringBuffer buffer) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Variable var = (Variable)obj;
        boolean check = var.getTextDescriptor().equals(this.getTextDescriptor());
        if (!check && buffer != null) {
            buffer.append("No same variables detected in " + var + " and " + this + "\n");
        }
        return check;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Variable)) {
            return false;
        }
        Variable that = (Variable)o;
        if (this.key != that.key || !this.descriptor.equals(that.descriptor)) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        if ((this.type & 1) == 0) {
            return this.value.equals(that.value);
        }
        return Arrays.equals((Object[])this.value, (Object[])that.value);
    }

    public String toString() {
        return this.key.getName();
    }

    public TextDescriptor getTextDescriptor() {
        return this.descriptor;
    }

    public Variable withTextDescriptor(TextDescriptor descriptor) {
        if (this.descriptor == descriptor) {
            return this;
        }
        Object value = this.value;
        int type = this.type;
        if (descriptor.isCode() && !(value instanceof String) && !(value instanceof String[])) {
            value = value.toString();
            type = 8;
        }
        return new Variable(this.key, value, descriptor, (byte)type);
    }

    public Variable withDisplay(boolean state) {
        return this.withTextDescriptor(this.getTextDescriptor().withDisplay(state));
    }

    public boolean isDisplay() {
        return this.descriptor.isDisplay();
    }

    public AbstractTextDescriptor.Code getCode() {
        return this.descriptor.getCode();
    }

    public Variable withCode(AbstractTextDescriptor.Code code) {
        return this.withTextDescriptor(this.getTextDescriptor().withCode(code));
    }

    public boolean isJava() {
        return this.descriptor.isJava();
    }

    public boolean isCode() {
        return this.descriptor.isCode();
    }

    public boolean isAttribute() {
        return this.getKey().getName().startsWith("ATTR_");
    }

    public int getColorIndex() {
        return this.descriptor.getColorIndex();
    }

    public Variable withColorIndex(int colorIndex) {
        return this.withTextDescriptor(this.getTextDescriptor().withColorIndex(colorIndex));
    }

    public AbstractTextDescriptor.Position getPos() {
        return this.descriptor.getPos();
    }

    public Variable withPos(AbstractTextDescriptor.Position p) {
        return this.withTextDescriptor(this.getTextDescriptor().withPos(p));
    }

    public AbstractTextDescriptor.Size getSize() {
        return this.descriptor.getSize();
    }

    public double getTrueSize(EditWindow0 wnd) {
        return this.descriptor.getTrueSize(wnd);
    }

    public Variable withAbsSize(int s) {
        return this.withTextDescriptor(this.getTextDescriptor().withAbsSize(s));
    }

    public Variable withRelSize(double s) {
        return this.withTextDescriptor(this.getTextDescriptor().withRelSize(s));
    }

    public int getFace() {
        return this.descriptor.getFace();
    }

    public Variable withFace(int f) {
        return this.withTextDescriptor(this.getTextDescriptor().withFace(f));
    }

    public AbstractTextDescriptor.Rotation getRotation() {
        return this.descriptor.getRotation();
    }

    public Variable withRotation(AbstractTextDescriptor.Rotation r) {
        return this.withTextDescriptor(this.getTextDescriptor().withRotation(r));
    }

    public AbstractTextDescriptor.DispPos getDispPart() {
        return this.descriptor.getDispPart();
    }

    public Variable withDispPart(AbstractTextDescriptor.DispPos dispPos) {
        return this.withTextDescriptor(this.getTextDescriptor().withDispPart(dispPos));
    }

    public boolean isItalic() {
        return this.descriptor.isItalic();
    }

    public Variable withItalic(boolean state) {
        return this.withTextDescriptor(this.getTextDescriptor().withItalic(state));
    }

    public boolean isBold() {
        return this.descriptor.isBold();
    }

    public Variable withBold(boolean state) {
        return this.withTextDescriptor(this.getTextDescriptor().withBold(state));
    }

    public boolean isUnderline() {
        return this.descriptor.isUnderline();
    }

    public Variable withUnderline(boolean state) {
        return this.withTextDescriptor(this.getTextDescriptor().withUnderline(state));
    }

    public boolean isInterior() {
        return this.descriptor.isInterior();
    }

    public Variable withInterior(boolean state) {
        return this.withTextDescriptor(this.getTextDescriptor().withInterior(state));
    }

    public boolean isInherit() {
        return this.descriptor.isInherit();
    }

    public Variable withInherit(boolean state) {
        return this.withTextDescriptor(this.getTextDescriptor().withInherit(state));
    }

    public Variable withParam(boolean state) {
        return this.withTextDescriptor(this.getTextDescriptor().withParam(state));
    }

    public double getXOff() {
        return this.descriptor.getXOff();
    }

    public double getYOff() {
        return this.descriptor.getYOff();
    }

    public Variable withOff(double xd, double yd) {
        return this.withTextDescriptor(this.getTextDescriptor().withOff(xd, yd));
    }

    public AbstractTextDescriptor.Unit getUnit() {
        return this.descriptor.getUnit();
    }

    public Variable withUnit(AbstractTextDescriptor.Unit u) {
        return this.withTextDescriptor(this.getTextDescriptor().withUnit(u));
    }

    static {
        validClasses.put(String.class, new Byte(8));
        validClasses.put(Double.class, new Byte(10));
        validClasses.put(Float.class, new Byte(12));
        validClasses.put(Long.class, new Byte(14));
        validClasses.put(Integer.class, new Byte(16));
        validClasses.put(Short.class, new Byte(18));
        validClasses.put(Byte.class, new Byte(20));
        validClasses.put(Boolean.class, new Byte(22));
        validClasses.put(EPoint.class, new Byte(24));
        validClasses.put(Tool.class, new Byte(26));
        validClasses.put(Technology.class, new Byte(28));
        validClasses.put(PrimitiveNode.class, new Byte(30));
        validClasses.put(ArcProto.class, new Byte(32));
        validClasses.put(LibId.class, new Byte(2));
        validClasses.put(CellId.class, new Byte(4));
        validClasses.put(ExportId.class, new Byte(6));
    }

    public static final class Key
    implements Comparable<Key> {
        private final String name;

        Key(String name) {
            if (name == null) {
                throw new NullPointerException();
            }
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Key k) {
            return k == this || k != null && this.name.equals(k.getName());
        }

        @Override
        public int compareTo(Key that) {
            return TextUtils.STRING_NUMBER_ORDER.compare(this.name, that.name);
        }

        public String toString() {
            return this.name;
        }

        public static void printStatistics() {
            long keyLength = 0L;
            for (Key key : varKeys.values()) {
                keyLength += (long)key.getName().length();
            }
            int canonicCount = 0;
            long canonicLength = 0L;
            for (String canonic : varCanonicKeys.keySet()) {
                Key key = (Key)varCanonicKeys.get(canonic);
                if (key != null && key.getName() == canonic) continue;
                ++canonicCount;
                canonicLength += (long)canonic.length();
            }
            System.out.println(varKeys.size() + " variable keys with " + keyLength + " chars." + " Canonic " + varCanonicKeys.size() + " entries " + canonicCount + " strings with " + canonicLength + " chars.");
        }
    }
}

