/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.change.DatabaseChangeEvent;
import com.sun.electric.database.change.DatabaseChangeListener;
import com.sun.electric.database.change.Undo;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.HighlightListener;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class GetInfoOutline
extends EDialog
implements HighlightListener,
DatabaseChangeListener {
    private NodeInst ni;
    private JList list;
    private DefaultListModel model;
    private boolean changingCoordinates = false;
    private EditWindow wnd;
    private JButton apply;
    private JButton deletePoint;
    private ButtonGroup direction;
    private JButton done;
    private JButton duplicatePoint;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane pointPane;
    private JTextField xValue;
    private JTextField yValue;

    public static void showOutlinePropertiesDialog() {
        GetInfoOutline dialog = new GetInfoOutline(TopLevel.getCurrentJFrame());
        dialog.loadDialog();
        dialog.setVisible(true);
    }

    public GetInfoOutline(Frame parent) {
        super(parent, false);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.apply);
        Undo.addDatabaseChangeListener(this);
        this.model = new DefaultListModel();
        this.list = new JList(this.model);
        this.list.setSelectionMode(0);
        this.pointPane.setViewportView(this.list);
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                GetInfoOutline.this.listClick();
            }
        });
        this.xValue.getDocument().addDocumentListener(new OutlineDocumentListener(this));
        this.yValue.getDocument().addDocumentListener(new OutlineDocumentListener(this));
        this.finishInitialization();
    }

    private void loadDialog() {
        EditWindow curWnd = EditWindow.getCurrent();
        if (this.wnd != curWnd && curWnd != null) {
            if (this.wnd != null) {
                this.wnd.getHighlighter().removeHighlightListener(this);
            }
            curWnd.getHighlighter().addHighlightListener(this);
            this.wnd = curWnd;
        }
        this.apply.setEnabled(false);
        this.deletePoint.setEnabled(false);
        this.duplicatePoint.setEnabled(false);
        this.jLabel1.setEnabled(false);
        this.jLabel2.setEnabled(false);
        this.pointPane.setEnabled(false);
        this.xValue.setEditable(false);
        this.yValue.setEditable(false);
        EditWindow wnd = EditWindow.getCurrent();
        this.ni = (NodeInst)wnd.getHighlighter().getOneElectricObject(NodeInst.class);
        if (this.ni == null) {
            return;
        }
        Point2D[] points = this.ni.getTrace();
        if (points == null) {
            return;
        }
        this.apply.setEnabled(true);
        this.deletePoint.setEnabled(true);
        this.duplicatePoint.setEnabled(true);
        this.jLabel1.setEnabled(true);
        this.jLabel2.setEnabled(true);
        this.pointPane.setEnabled(true);
        this.xValue.setEditable(true);
        this.yValue.setEditable(true);
        Point2D[] dbSpacePoints = new Point2D[points.length];
        for (int i = 0; i < points.length; ++i) {
            dbSpacePoints[i] = new Point2D.Double(points[i].getX() + this.ni.getAnchorCenterX(), points[i].getY() + this.ni.getAnchorCenterY());
        }
        this.loadList(dbSpacePoints, 0);
        this.listClick();
    }

    private void loadList(Point2D[] newPoints, int index) {
        this.model.clear();
        for (int i = 0; i < newPoints.length; ++i) {
            this.model.addElement(this.makeLine(i, newPoints[i]));
        }
        if (index >= 0) {
            this.list.setSelectedIndex(index);
        }
    }

    protected void escapePressed() {
        this.done(null);
    }

    private void listClick() {
        this.changingCoordinates = true;
        String line = (String)this.list.getSelectedValue();
        Point2D clickedValue = this.getPointValue(line);
        this.xValue.setText(TextUtils.formatDouble(clickedValue.getX()));
        this.yValue.setText(TextUtils.formatDouble(clickedValue.getY()));
        this.changingCoordinates = false;
    }

    private String makeLine(int index, Point2D pt) {
        return index + ": (" + TextUtils.formatDouble(pt.getX()) + ", " + TextUtils.formatDouble(pt.getY()) + ")";
    }

    private void coordinatesChanged() {
        if (this.changingCoordinates) {
            return;
        }
        String line = (String)this.list.getSelectedValue();
        Point2D.Double typedValue = new Point2D.Double(TextUtils.atof(this.xValue.getText()), TextUtils.atof(this.yValue.getText()));
        int index = this.list.getSelectedIndex();
        this.model.set(index, this.makeLine(index, typedValue));
    }

    private Point2D getPointValue(String line) {
        double xV = 0.0;
        double yV = 0.0;
        int openPos = line.indexOf(40);
        int commaPos = line.indexOf(44, openPos);
        int closePos = line.indexOf(41, commaPos);
        if (openPos >= 0 && commaPos >= 0 && closePos >= 0) {
            xV = TextUtils.atof(line.substring(openPos + 1, commaPos));
            yV = TextUtils.atof(line.substring(commaPos + 1, closePos));
        }
        return new Point2D.Double(xV, yV);
    }

    public void highlightChanged(Highlighter which) {
        if (!this.isVisible()) {
            return;
        }
        this.loadDialog();
    }

    public void highlighterLostFocus(Highlighter highlighterGainedFocus) {
        if (!this.isVisible()) {
            return;
        }
        this.loadDialog();
    }

    public void databaseChanged(DatabaseChangeEvent e) {
        if (!this.isVisible()) {
            return;
        }
        if (e.objectChanged(this.ni)) {
            this.loadDialog();
        }
    }

    private void initComponents() {
        this.direction = new ButtonGroup();
        this.done = new JButton();
        this.pointPane = new JScrollPane();
        this.apply = new JButton();
        this.jLabel1 = new JLabel();
        this.xValue = new JTextField();
        this.jLabel2 = new JLabel();
        this.yValue = new JTextField();
        this.deletePoint = new JButton();
        this.duplicatePoint = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Outline Properties");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                GetInfoOutline.this.closeDialog(evt);
            }
        });
        this.done.setText("Done");
        this.done.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetInfoOutline.this.done(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.done, gridBagConstraints);
        this.pointPane.setMinimumSize(new Dimension(100, 150));
        this.pointPane.setPreferredSize(new Dimension(100, 150));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.pointPane, gridBagConstraints);
        this.apply.setText("Apply");
        this.apply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetInfoOutline.this.applyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.apply, gridBagConstraints);
        this.jLabel1.setText("X:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.xValue.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.xValue, gridBagConstraints);
        this.jLabel2.setText("Y:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.yValue.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.yValue, gridBagConstraints);
        this.deletePoint.setText("Delete Point");
        this.deletePoint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetInfoOutline.this.deletePointActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.deletePoint, gridBagConstraints);
        this.duplicatePoint.setText("Duplicate Point");
        this.duplicatePoint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetInfoOutline.this.duplicatePointActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.duplicatePoint, gridBagConstraints);
        this.pack();
    }

    private void applyActionPerformed(ActionEvent evt) {
        AdjustOutline job = new AdjustOutline(this);
    }

    private void duplicatePointActionPerformed(ActionEvent evt) {
        int index = this.list.getSelectedIndex();
        int newPointCount = this.model.size();
        Point2D[] newPoints = new Point2D[newPointCount + 1];
        int j = 0;
        for (int i = 0; i < newPointCount; ++i) {
            String line = (String)this.model.get(i);
            if (i == index) {
                newPoints[j++] = this.getPointValue(line);
            }
            newPoints[j++] = this.getPointValue(line);
        }
        this.loadList(newPoints, index);
    }

    private void deletePointActionPerformed(ActionEvent evt) {
        int index = this.list.getSelectedIndex();
        int newPointCount = this.model.size();
        Point2D[] newPoints = new Point2D[newPointCount - 1];
        int j = 0;
        for (int i = 0; i < newPointCount; ++i) {
            if (i == index) continue;
            String line = (String)this.model.get(i);
            newPoints[j++] = this.getPointValue(line);
        }
        if (index >= newPointCount) {
            --index;
        }
        this.loadList(newPoints, index);
    }

    private void done(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class AdjustOutline
    extends Job {
        GetInfoOutline dialog;

        protected AdjustOutline(GetInfoOutline dialog) {
            super("Adjust Outline", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.dialog = dialog;
            this.startJob();
        }

        public boolean doIt() {
            int newPointCount = this.dialog.model.size();
            Point2D[] points = new Point2D[newPointCount];
            for (int i = 0; i < newPointCount; ++i) {
                String line = (String)this.dialog.model.get(i);
                points[i] = this.dialog.getPointValue(line);
            }
            this.dialog.ni.setTrace(points);
            return true;
        }
    }

    private static class OutlineDocumentListener
    implements DocumentListener {
        GetInfoOutline dialog;

        OutlineDocumentListener(GetInfoOutline dialog) {
            this.dialog = dialog;
        }

        public void changedUpdate(DocumentEvent e) {
            this.dialog.coordinatesChanged();
        }

        public void insertUpdate(DocumentEvent e) {
            this.dialog.coordinatesChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            this.dialog.coordinatesChanged();
        }
    }
}

