/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.HighlightListener;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.ColorPatternPanel;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;

public class ArtworkLook
extends EDialog
implements HighlightListener {
    private ColorPatternPanel.Info li;
    private List artworkObjects;
    private ColorPatternPanel colorPatternPanel;
    private EditWindow wnd;
    private static ArtworkLook dialog;
    private JButton apply;
    private JButton cancel;
    private JButton ok;

    public static void showArtworkLookDialog() {
        List artObjects = ArtworkLook.findSelectedArt();
        if (artObjects.size() == 0) {
            System.out.println("Selected object must be from the Artwork technology");
            return;
        }
        if (dialog == null) {
            dialog = new ArtworkLook((Frame)TopLevel.getCurrentJFrame(), artObjects);
        }
    }

    private static List findSelectedArt() {
        ArrayList<Geometric> artworkObjects = new ArrayList<Geometric>();
        EditWindow wnd = EditWindow.getCurrent();
        if (wnd == null) {
            return artworkObjects;
        }
        List objects = wnd.getHighlighter().getHighlightedEObjs(true, true);
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            ArcInst ai;
            ElectricObject eObj = (ElectricObject)it.next();
            if (eObj instanceof PortInst) {
                eObj = ((PortInst)eObj).getNodeInst();
            }
            if (eObj instanceof NodeInst) {
                NodeInst ni = (NodeInst)eObj;
                if (!(ni.getProto() instanceof PrimitiveNode) || ni.getProto().getTechnology() != Artwork.tech) continue;
                artworkObjects.add(ni);
                continue;
            }
            if (!(eObj instanceof ArcInst) || (ai = (ArcInst)eObj).getProto().getTechnology() != Artwork.tech) continue;
            artworkObjects.add(ai);
        }
        return artworkObjects;
    }

    public ArtworkLook(Frame parent, List artObjects) {
        super(parent, false);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.ok);
        this.colorPatternPanel = new ColorPatternPanel(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.colorPatternPanel, gbc);
        this.pack();
        Technology tech = Technology.getCurrent();
        Color[] map = new Color[tech.getNumTransparentLayers()];
        Color[] fullMap = tech.getColorMap();
        for (int i = 0; i < map.length; ++i) {
            map[i] = fullMap[1 << i];
        }
        this.colorPatternPanel.setColorMap(map);
        this.showArtworkObjects(artObjects);
        this.finishInitialization();
        this.setVisible(true);
    }

    protected void escapePressed() {
        this.cancel(null);
    }

    private void showArtworkObjects(List artObjects) {
        this.artworkObjects = artObjects;
        EditWindow curWnd = EditWindow.getCurrent();
        if (curWnd != null && this.wnd != curWnd) {
            if (this.wnd != null) {
                this.wnd.getHighlighter().removeHighlightListener(this);
            }
            curWnd.getHighlighter().addHighlightListener(this);
            this.wnd = curWnd;
        }
        if (this.artworkObjects.size() == 0) {
            this.li = null;
        } else {
            EGraphics graphics = Artwork.makeGraphics((ElectricObject)this.artworkObjects.get(0));
            if (graphics == null) {
                graphics = new EGraphics(0, 0, 0, 0, 0, 0, 0.8, true, new int[]{65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535});
            }
            this.li = new ColorPatternPanel.Info(graphics);
        }
        this.colorPatternPanel.setColorPattern(this.li);
    }

    public void highlightChanged(Highlighter which) {
        if (!this.isVisible()) {
            return;
        }
        List artObjects = ArtworkLook.findSelectedArt();
        this.showArtworkObjects(artObjects);
    }

    public void highlighterLostFocus(Highlighter highlighterGainedFocus) {
        if (!this.isVisible()) {
            return;
        }
        List artObjects = ArtworkLook.findSelectedArt();
        this.showArtworkObjects(artObjects);
    }

    private void applyDialog() {
        if (this.li == null) {
            return;
        }
        if (this.li.updateGraphics()) {
            new ApplyChanges(this);
        }
    }

    private void initComponents() {
        this.cancel = new JButton();
        this.ok = new JButton();
        this.apply = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Artwork Color and Pattern");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ArtworkLook.this.closeDialog(evt);
            }
        });
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ArtworkLook.this.cancel(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.cancel, gridBagConstraints);
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ArtworkLook.this.ok(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ok, gridBagConstraints);
        this.apply.setText("Apply");
        this.apply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ArtworkLook.this.applyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.apply, gridBagConstraints);
        this.pack();
    }

    private void applyActionPerformed(ActionEvent evt) {
        this.applyDialog();
    }

    private void cancel(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void ok(ActionEvent evt) {
        this.applyDialog();
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
        dialog = null;
    }

    private static class ApplyChanges
    extends Job {
        private ArtworkLook dialog;

        protected ApplyChanges(ArtworkLook dialog) {
            super("Update Edit Options", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.dialog = dialog;
            this.startJob();
        }

        public boolean doIt() {
            Iterator it = this.dialog.artworkObjects.iterator();
            while (it.hasNext()) {
                ElectricObject eObj = (ElectricObject)it.next();
                Artwork.setGraphics(((ArtworkLook)this.dialog).li.graphics, eObj);
            }
            return true;
        }
    }
}

