/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;

public class Gallery {
    static final double PAGE_WIDTH = 1000.0;
    static final double HORIZONTAL_SPACE = 30.0;
    static final double VERTICAL_SPACE = 30.0;
    static final double TEXT_OFFSET_BELOW_CELL = 10.0;
    private PrimitiveNode textPin;
    private StdCellParams stdCell;
    private Library lib;

    private static void error(boolean pred, String msg) {
        LayoutLib.error(pred, msg);
    }

    ArrayList readLayoutCells(Library lib) {
        ArrayList<Cell> cells = new ArrayList<Cell>();
        Iterator it = lib.getCells();
        View layView = View.findView("layout");
        while (it.hasNext()) {
            Cell c = (Cell)it.next();
            if (c.getName().equals("gallery") || c.getName().startsWith("drcRing") || c.getView() != layView) continue;
            cells.add(c);
        }
        return cells;
    }

    void sortCellsByName(ArrayList facets) {
        Collections.sort(facets, new Comparator(){

            public int compare(Object o1, Object o2) {
                String n1 = ((Cell)o1).getName();
                String n2 = ((Cell)o2).getName();
                return n1.compareTo(n2);
            }
        });
    }

    void printCells(ArrayList facets) {
        for (int i = 0; i < facets.size(); ++i) {
            Cell p = (Cell)facets.get(i);
            System.out.println(p.getName());
        }
    }

    ArrayList addOneInstOfEveryCell(ArrayList cells, Cell gallery) {
        ArrayList<NodeInst> insts = new ArrayList<NodeInst>();
        for (int i = 0; i < cells.size(); ++i) {
            Cell c = (Cell)cells.get(i);
            NodeInst ni = LayoutLib.newNodeInst(c, 0.0, 0.0, 0.0, 0.0, 0.0, gallery);
            insts.add(ni);
        }
        return insts;
    }

    double width(NodeInst ni) {
        return LayoutLib.getBounds(ni).getWidth();
    }

    double height(NodeInst ni) {
        return LayoutLib.getBounds(ni).getHeight();
    }

    double[] getRow(ArrayList row, ListIterator it) {
        double x = 0.0;
        double highestAboveCenter = Double.MIN_VALUE;
        double lowestBelowCenter = Double.MIN_VALUE;
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            if (x != 0.0 && x + this.width(ni) > 1000.0) {
                it.previous();
                break;
            }
            row.add(ni);
            Rectangle2D bounds = LayoutLib.getBounds(ni);
            highestAboveCenter = Math.max(highestAboveCenter, bounds.getMaxY());
            lowestBelowCenter = Math.min(lowestBelowCenter, bounds.getMinY());
            x = x + this.width(ni) + 30.0;
        }
        return new double[]{highestAboveCenter, lowestBelowCenter};
    }

    void placeRow(ArrayList row, double centerY, Cell gallery) {
        double curLeftX = 0.0;
        for (int i = 0; i < row.size(); ++i) {
            NodeInst ni = (NodeInst)row.get(i);
            double x = LayoutLib.getBounds(ni).getMinX();
            double y = LayoutLib.getPosition(ni).getY();
            LayoutLib.modNodeInst(ni, curLeftX - x, centerY - y, 0.0, 0.0, false, false, 0.0);
            double defSz = Double.POSITIVE_INFINITY;
            NodeInst ti = LayoutLib.newNodeInst(this.textPin, curLeftX + this.width(ni) / 2.0, centerY - 10.0, defSz, defSz, 0.0, gallery);
            ti.setExpanded();
            curLeftX = curLeftX + this.width(ni) + 30.0;
        }
    }

    void placeInstsOnPage(ArrayList insts, Cell gallery) {
        double topY = 0.0;
        ListIterator it = insts.listIterator();
        while (it.hasNext()) {
            ArrayList row = new ArrayList();
            double[] hiLo = this.getRow(row, it);
            double highestAboveCenter = hiLo[0];
            double lowestBelowCenter = hiLo[1];
            double centerY = topY - highestAboveCenter;
            this.placeRow(row, centerY, gallery);
            topY = centerY + lowestBelowCenter - 30.0;
        }
    }

    Gallery(Library lib) {
        this.lib = lib;
        Technology generic = Technology.findTechnology("generic");
        Gallery.error(generic == null, "No generic technology?");
        this.textPin = generic.findNodeProto("Invisible-Pin");
        this.stdCell = new StdCellParams(lib, "mocmos");
    }

    Cell makeGallery1() {
        ArrayList cells = this.readLayoutCells(this.lib);
        System.out.println("Gallery contains: " + cells.size() + " Cells");
        this.sortCellsByName(cells);
        Cell gallery = Cell.newInstance(this.lib, "gallery{lay}");
        ArrayList insts = this.addOneInstOfEveryCell(cells, gallery);
        this.placeInstsOnPage(insts, gallery);
        return gallery;
    }

    public static Cell makeGallery(Library lib) {
        Gallery galleryMaker = new Gallery(lib);
        return galleryMaker.makeGallery1();
    }

    public static void main(String[] args) {
        Library lib = Library.getCurrent();
        Gallery.error(lib == null, "No currently open library?");
        Gallery.makeGallery(lib);
        System.out.println("Done");
    }
}

