/* rygel-media-export-metadata-extractor.c generated by valac 0.12.0, the Vala compiler
 * generated from rygel-media-export-metadata-extractor.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2009 Jens Georg <mail@jensge.org>.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp-dlna/gupnp-dlna-discoverer.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gst/pbutils/pbutils.h>
#include <rygel.h>
#include <gst/gst.h>
#include <libgupnp-dlna/gupnp-dlna-information.h>
#include <glib/gi18n-lib.h>


#define RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR (rygel_media_export_metadata_extractor_get_type ())
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractor))
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorClass))
#define RYGEL_MEDIA_EXPORT_IS_METADATA_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_IS_METADATA_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorClass))

typedef struct _RygelMediaExportMetadataExtractor RygelMediaExportMetadataExtractor;
typedef struct _RygelMediaExportMetadataExtractorClass RygelMediaExportMetadataExtractorClass;
typedef struct _RygelMediaExportMetadataExtractorPrivate RygelMediaExportMetadataExtractorPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RygelMediaExportMetadataExtractor {
	GObject parent_instance;
	RygelMediaExportMetadataExtractorPrivate * priv;
};

struct _RygelMediaExportMetadataExtractorClass {
	GObjectClass parent_class;
};

struct _RygelMediaExportMetadataExtractorPrivate {
	GUPnPDLNADiscoverer* discoverer;
	GeeHashMap* file_hash;
	guint64 timeout;
	gboolean extract_metadata;
};


static gpointer rygel_media_export_metadata_extractor_parent_class = NULL;

GType rygel_media_export_metadata_extractor_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorPrivate))
enum  {
	RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_DUMMY_PROPERTY
};
RygelMediaExportMetadataExtractor* rygel_media_export_metadata_extractor_new (void);
RygelMediaExportMetadataExtractor* rygel_media_export_metadata_extractor_construct (GType object_type);
static void rygel_media_export_metadata_extractor_on_done (RygelMediaExportMetadataExtractor* self, GUPnPDLNAInformation* dlna, GError* err);
static void _rygel_media_export_metadata_extractor_on_done_gupnp_dlna_discoverer_done (GUPnPDLNADiscoverer* _sender, GUPnPDLNAInformation* dlna, GError* err, gpointer self);
void rygel_media_export_metadata_extractor_extract (RygelMediaExportMetadataExtractor* self, GFile* file);
static void rygel_media_export_metadata_extractor_extract_basic_information (RygelMediaExportMetadataExtractor* self, GFile* file, GUPnPDLNAInformation* dlna);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_STRING_UINT64_UINT64 (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__OBJECT_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void rygel_media_export_metadata_extractor_finalize (GObject* obj);


static void _rygel_media_export_metadata_extractor_on_done_gupnp_dlna_discoverer_done (GUPnPDLNADiscoverer* _sender, GUPnPDLNAInformation* dlna, GError* err, gpointer self) {
	rygel_media_export_metadata_extractor_on_done (self, dlna, err);
}


RygelMediaExportMetadataExtractor* rygel_media_export_metadata_extractor_construct (GType object_type) {
	RygelMediaExportMetadataExtractor * self = NULL;
	GeeHashMap* _tmp0_ = NULL;
	RygelMetaConfig* _tmp1_ = NULL;
	RygelMetaConfig* config;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
	self = (RygelMediaExportMetadataExtractor*) g_object_new (object_type, NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->file_hash);
	self->priv->file_hash = _tmp0_;
	_tmp1_ = rygel_meta_config_get_default ();
	config = _tmp1_;
	_tmp2_ = rygel_configuration_get_bool ((RygelConfiguration*) config, "MediaExport", "extract-metadata", &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		goto __catch20_g_error;
	}
	self->priv->extract_metadata = _tmp3_;
	goto __finally20;
	__catch20_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		self->priv->extract_metadata = TRUE;
		_g_error_free0 (_error_);
	}
	__finally20:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	if (self->priv->extract_metadata) {
		GstClockTime gst_timeout;
		GUPnPDLNADiscoverer* _tmp4_ = NULL;
		gst_timeout = (GstClockTime) (self->priv->timeout * GST_SECOND);
		_tmp4_ = gupnp_dlna_discoverer_new (gst_timeout, TRUE, TRUE);
		_g_object_unref0 (self->priv->discoverer);
		self->priv->discoverer = _tmp4_;
		g_signal_connect_object (self->priv->discoverer, "done", (GCallback) _rygel_media_export_metadata_extractor_on_done_gupnp_dlna_discoverer_done, self, 0);
		gst_discoverer_start ((GstDiscoverer*) self->priv->discoverer);
	}
	_g_object_unref0 (config);
	return self;
}


RygelMediaExportMetadataExtractor* rygel_media_export_metadata_extractor_new (void) {
	return rygel_media_export_metadata_extractor_construct (RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR);
}


void rygel_media_export_metadata_extractor_extract (RygelMediaExportMetadataExtractor* self, GFile* file) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	if (self->priv->extract_metadata) {
		gchar* _tmp0_ = NULL;
		gchar* uri;
		_tmp0_ = g_file_get_uri (file);
		uri = _tmp0_;
		gee_abstract_map_set ((GeeAbstractMap*) self->priv->file_hash, uri, file);
		gupnp_dlna_discoverer_discover_uri (self->priv->discoverer, uri);
		_g_free0 (uri);
	} else {
		rygel_media_export_metadata_extractor_extract_basic_information (self, file, NULL);
	}
}


static void rygel_media_export_metadata_extractor_on_done (RygelMediaExportMetadataExtractor* self, GUPnPDLNAInformation* dlna, GError* err) {
	GstDiscovererInfo* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gpointer _tmp2_ = NULL;
	GFile* file;
	GstDiscovererInfo* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GstDiscovererInfo* _tmp7_ = NULL;
	GstDiscovererResult _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dlna != NULL);
	_tmp0_ = gupnp_dlna_information_get_info (dlna);
	_tmp1_ = gst_discoverer_info_get_uri (_tmp0_);
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->file_hash, _tmp1_);
	file = (GFile*) _tmp2_;
	if (file == NULL) {
		GstDiscovererInfo* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		_tmp3_ = gupnp_dlna_information_get_info (dlna);
		_tmp4_ = gst_discoverer_info_get_uri (_tmp3_);
		g_warning ("rygel-media-export-metadata-extractor.vala:101: File %s already handle" \
"d, ignoring event", _tmp4_);
		_g_object_unref0 (file);
		return;
	}
	_tmp5_ = gupnp_dlna_information_get_info (dlna);
	_tmp6_ = gst_discoverer_info_get_uri (_tmp5_);
	gee_abstract_map_unset ((GeeAbstractMap*) self->priv->file_hash, _tmp6_, NULL);
	_tmp7_ = gupnp_dlna_information_get_info (dlna);
	_tmp8_ = gst_discoverer_info_get_result (_tmp7_);
	if ((_tmp8_ & GST_DISCOVERER_TIMEOUT) != 0) {
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		_tmp9_ = g_file_get_uri (file);
		_tmp10_ = _tmp9_;
		g_debug ("rygel-media-export-metadata-extractor.vala:110: Extraction timed out o" \
"n %s", _tmp10_);
		_g_free0 (_tmp10_);
		dlna = NULL;
	} else {
		GstDiscovererInfo* _tmp11_ = NULL;
		GstDiscovererResult _tmp12_;
		_tmp11_ = gupnp_dlna_information_get_info (dlna);
		_tmp12_ = gst_discoverer_info_get_result (_tmp11_);
		if ((_tmp12_ & GST_DISCOVERER_ERROR) != 0) {
			g_signal_emit_by_name (self, "error", file, err);
			_g_object_unref0 (file);
			return;
		}
	}
	rygel_media_export_metadata_extractor_extract_basic_information (self, file, dlna);
	_g_object_unref0 (file);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static void rygel_media_export_metadata_extractor_extract_basic_information (RygelMediaExportMetadataExtractor* self, GFile* file, GUPnPDLNAInformation* dlna) {
	GFileInfo* file_info = NULL;
	GFileInfo* _tmp0_ = NULL;
	GFileInfo* _tmp1_;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* content_type;
	gchar* _tmp8_ = NULL;
	gchar* mime;
	gint64 _tmp9_;
	gint64 size;
	guint64 _tmp10_;
	guint64 mtime;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = g_file_query_info (file, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE "," G_FILE_ATTRIBUTE_STANDARD_SIZE "," G_FILE_ATTRIBUTE_TIME_MODIFIED, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		goto __catch22_g_error;
	}
	_g_object_unref0 (file_info);
	file_info = _tmp1_;
	goto __finally22;
	__catch22_g_error:
	{
		GError * _error_;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		GError* _tmp5_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _ ("Failed to query content type for '%s'");
		_tmp3_ = g_file_get_uri (file);
		_tmp4_ = _tmp3_;
		g_warning (_tmp2_, _tmp4_);
		_g_free0 (_tmp4_);
		g_signal_emit_by_name (self, "error", file, _error_);
		_tmp5_ = _g_error_copy0 (_error_);
		_inner_error_ = _tmp5_;
		_g_error_free0 (_error_);
		goto __finally22;
	}
	__finally22:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (file_info);
		goto __catch21_g_error;
	}
	_tmp6_ = g_file_info_get_content_type (file_info);
	_tmp7_ = g_strdup (_tmp6_);
	content_type = _tmp7_;
	_tmp8_ = g_content_type_get_mime_type (content_type);
	mime = _tmp8_;
	_tmp9_ = g_file_info_get_size (file_info);
	size = _tmp9_;
	_tmp10_ = g_file_info_get_attribute_uint64 (file_info, G_FILE_ATTRIBUTE_TIME_MODIFIED);
	mtime = _tmp10_;
	g_signal_emit_by_name (self, "extraction-done", file, dlna, mime, (guint64) size, mtime);
	_g_free0 (mime);
	_g_free0 (content_type);
	_g_object_unref0 (file_info);
	goto __finally21;
	__catch21_g_error:
	{
		GError * _error_;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = g_file_get_uri (file);
		_tmp12_ = _tmp11_;
		g_debug ("rygel-media-export-metadata-extractor.vala:159: Failed to extract basi" \
"c metadata from %s: %s", _tmp12_, _error_->message);
		_g_free0 (_tmp12_);
		g_signal_emit_by_name (self, "error", file, _error_);
		_g_error_free0 (_error_);
	}
	__finally21:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_STRING_UINT64_UINT64 (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT_STRING_UINT64_UINT64) (gpointer data1, gpointer arg_1, gpointer arg_2, const char* arg_3, guint64 arg_4, guint64 arg_5, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT_STRING_UINT64_UINT64 callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 6);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT_STRING_UINT64_UINT64) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), g_value_get_string (param_values + 3), g_value_get_uint64 (param_values + 4), g_value_get_uint64 (param_values + 5), data2);
}


static void g_cclosure_user_marshal_VOID__OBJECT_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_POINTER) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_POINTER callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_POINTER) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_pointer (param_values + 2), data2);
}


static void rygel_media_export_metadata_extractor_class_init (RygelMediaExportMetadataExtractorClass * klass) {
	rygel_media_export_metadata_extractor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaExportMetadataExtractorPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_metadata_extractor_finalize;
	g_signal_new ("extraction_done", RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_STRING_UINT64_UINT64, G_TYPE_NONE, 5, G_TYPE_FILE, GUPNP_TYPE_DLNA_INFORMATION, G_TYPE_STRING, G_TYPE_UINT64, G_TYPE_UINT64);
	/**
	     * Signalize that an error occured during metadata extraction
	     */
	g_signal_new ("error", RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_POINTER, G_TYPE_NONE, 2, G_TYPE_FILE, G_TYPE_POINTER);
}


static void rygel_media_export_metadata_extractor_instance_init (RygelMediaExportMetadataExtractor * self) {
	self->priv = RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_GET_PRIVATE (self);
	self->priv->timeout = (guint64) 10;
}


static void rygel_media_export_metadata_extractor_finalize (GObject* obj) {
	RygelMediaExportMetadataExtractor * self;
	self = RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR (obj);
	if (self->priv->extract_metadata) {
		gst_discoverer_stop ((GstDiscoverer*) self->priv->discoverer);
	}
	_g_object_unref0 (self->priv->discoverer);
	_g_object_unref0 (self->priv->file_hash);
	G_OBJECT_CLASS (rygel_media_export_metadata_extractor_parent_class)->finalize (obj);
}


/**
 * Metadata extractor based on Gstreamer. Just set the URI of the media on the
 * uri property, it will extact the metadata for you and emit signal
 * metadata_available for each key/value pair extracted.
 */
GType rygel_media_export_metadata_extractor_get_type (void) {
	static volatile gsize rygel_media_export_metadata_extractor_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_metadata_extractor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportMetadataExtractorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_metadata_extractor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportMetadataExtractor), 0, (GInstanceInitFunc) rygel_media_export_metadata_extractor_instance_init, NULL };
		GType rygel_media_export_metadata_extractor_type_id;
		rygel_media_export_metadata_extractor_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportMetadataExtractor", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_metadata_extractor_type_id__volatile, rygel_media_export_metadata_extractor_type_id);
	}
	return rygel_media_export_metadata_extractor_type_id__volatile;
}



